/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.relast.compiler.options;

public abstract class Option<ValueType>
implements Comparable<Option<?>> {
    public static final String PREFIX = "--";
    private final String name;
    private final String description;

    public Option(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public int compareTo(Option<?> o) {
        return this.name.compareTo(o.name);
    }

    public boolean equals(Object other) {
        if (other instanceof Option) {
            return this.compareTo((Option)other) == 0;
        }
        return false;
    }

    public String toString() {
        return PREFIX + this.name;
    }

    public abstract boolean isSet();

    public abstract ValueType getValue();

    public abstract HasArgument hasArgument();

    public abstract void match(String var1) throws IllegalMatchException;

    public static class IllegalMatchException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public IllegalMatchException(String message) {
            super(message);
        }
    }

    public static enum HasArgument {
        NO,
        OPTIONAL,
        YES;

    }
}

