/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.relast.compiler.options;

import java.util.Collection;
import java.util.TreeSet;
import org.jastadd.relast.compiler.options.Option;

public class EnumOption
extends Option<String> {
    private final TreeSet<String> allowedValues;
    private final String defaultValue;
    private String value;
    private boolean isSet;

    public EnumOption(String name, String description, Collection<String> allowedValues, String defaultValue) {
        super(name, description);
        this.allowedValues = new TreeSet<String>(allowedValues);
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        this.isSet = false;
    }

    public boolean addAllowedValue(String allowedValue) {
        return this.allowedValues.add(allowedValue);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public Option.HasArgument hasArgument() {
        return Option.HasArgument.OPTIONAL;
    }

    @Override
    public void match(String argument) throws Option.IllegalMatchException {
        if (argument == null) {
            this.isSet = true;
            this.value = this.defaultValue;
        } else if (this.allowedValues.contains(argument)) {
            this.isSet = true;
            this.value = argument;
        } else {
            throw new Option.IllegalMatchException(argument + " is not allowed, allowed values are " + this.allowedValues);
        }
    }

    @Override
    public boolean isSet() {
        return this.isSet;
    }

    @Override
    public String getDescription() {
        String allowedValuesStr = this.allowedValues.toString();
        allowedValuesStr = allowedValuesStr.substring(1);
        allowedValuesStr = allowedValuesStr.substring(0, allowedValuesStr.length() - 1);
        return super.getDescription() + " (allowed values: " + allowedValuesStr + ")";
    }
}

