/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.relast.compiler.options;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.jastadd.relast.compiler.options.Option;

public class CommandLine {
    private final Collection<Option<?>> options;
    private final Map<String, Option<?>> mapping;
    private final List<String> arguments;

    public CommandLine(Collection<Option<?>> options) {
        this.options = options;
        this.mapping = new HashMap();
        for (Option<?> option : options) {
            this.mapping.put(option.getName(), option);
        }
        this.arguments = new ArrayList<String>();
    }

    public void parse(String[] args) throws CommandLineException {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("--")) {
                String name;
                int argumentIndex = args[i].indexOf("=");
                String argument = null;
                if (argumentIndex > 0) {
                    name = args[i].substring(2, argumentIndex);
                    argument = args[i].substring(argumentIndex + 1);
                } else {
                    name = args[i].substring(2);
                }
                Option<?> option = this.mapping.get(name);
                if (option == null) {
                    throw new CommandLineException("Option --" + name + " not found");
                }
                this.match(option, argument);
                continue;
            }
            this.arguments.add(args[i]);
        }
    }

    public void match(Option<?> option, String argument) throws CommandLineException {
        try {
            switch (option.hasArgument()) {
                case NO: {
                    if (argument == null) {
                        option.match(null);
                        break;
                    }
                    throw new CommandLineException("Option " + option + " is not allowed to have an argument");
                }
                case OPTIONAL: {
                    option.match(argument);
                    break;
                }
                case YES: {
                    if (argument != null) {
                        option.match(argument);
                        break;
                    }
                    throw new CommandLineException("Option " + option + " requires an argument");
                }
            }
        }
        catch (Option.IllegalMatchException e) {
            throw new CommandLineException("Invalid value for option " + option + ": " + e.getMessage());
        }
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public String printOptionHelp() {
        StringBuilder sb = new StringBuilder();
        int longestOption = 0;
        for (Option<?> option : this.options) {
            if (longestOption >= option.getName().length()) continue;
            longestOption = option.getName().length();
        }
        for (Option<?> option : new TreeSet(this.options)) {
            String s = String.format("  %s%-" + (longestOption + 6) + "s %s%n", "--", option.getName(), option.getDescription());
            sb.append(s);
        }
        return sb.toString();
    }

    public static class CommandLineException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public CommandLineException(String message) {
            super(message);
        }
    }
}

