/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.relast.compiler;

import beaver.Parser;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jastadd.relast.ast.ASTNode;
import org.jastadd.relast.ast.ErrorMessage;
import org.jastadd.relast.ast.Program;
import org.jastadd.relast.ast.Relation;
import org.jastadd.relast.ast.TypeDecl;
import org.jastadd.relast.compiler.options.CommandLine;
import org.jastadd.relast.compiler.options.EnumOption;
import org.jastadd.relast.compiler.options.FlagOption;
import org.jastadd.relast.compiler.options.Option;
import org.jastadd.relast.compiler.options.StringOption;
import org.jastadd.relast.parser.RelAstParser;
import org.jastadd.relast.scanner.RelAstScanner;

public class Compiler {
    private ArrayList<Option<?>> options = new ArrayList();
    private FlagOption optionWriteToFile;
    private FlagOption optionPrintAST;
    private StringOption optionListClass;
    private StringOption optionJastAddList;
    private StringOption optionGrammarName;
    private EnumOption optionSerializer;
    private FlagOption optionResolverHelper;
    private FlagOption optionUseJastaddNames;
    private CommandLine commandLine;

    public Compiler(String[] args) throws CommandLine.CommandLineException {
        this.addOptions();
        this.commandLine = new CommandLine(this.options);
        this.commandLine.parse(args);
        if (this.commandLine.getArguments().size() < 1) {
            this.error("specify at least one input file");
        }
        List<String> filenames = this.commandLine.getArguments();
        Program p = this.parseProgram(filenames);
        if (this.optionJastAddList.isSet()) {
            System.out.println("JastAdd List type is set to " + this.optionJastAddList.getValue());
            ASTNode.jastAddListType = this.optionJastAddList.getValue();
        }
        if (this.optionResolverHelper.isSet() || this.optionSerializer.isSet()) {
            ArrayList<TypeDecl> nonTerminals = new ArrayList<TypeDecl>();
            for (TypeDecl typeDecl : p.getTypeDecls()) {
                nonTerminals.add(typeDecl);
            }
        }
        if (!p.errors().isEmpty()) {
            if (this.optionPrintAST.isSet()) {
                System.out.println(p.dumpTree());
            }
            System.err.println("Errors:");
            for (ErrorMessage e : p.errors()) {
                System.err.println(e);
            }
            System.exit(1);
        } else {
            if (this.optionListClass.isSet()) {
                System.out.println("ListClass is set to " + this.optionListClass.getValue());
                ASTNode.listClass = this.optionListClass.getValue();
            }
            if (this.optionUseJastaddNames.isSet()) {
                ASTNode.useJastAddNames = true;
            }
            String grammarName = "Grammar";
            if (this.optionGrammarName.isSet()) {
                grammarName = this.optionGrammarName.getValue();
            }
            if (this.optionWriteToFile.isSet()) {
                if (this.optionSerializer.isSet()) {
                    ASTNode.serializer = true;
                    switch (this.optionSerializer.getValue()) {
                        case "jackson": {
                            this.writeToFile(grammarName + "Serializer.jadd", p.generateSerializer());
                        }
                    }
                }
                if (this.optionResolverHelper.isSet()) {
                    ASTNode.resolverHelper = true;
                }
                if (this.optionResolverHelper.isSet() || this.optionSerializer.isSet()) {
                    this.writeToFile(grammarName + "ResolverStubs.jrag", p.generateResolverStubs());
                }
                if (this.optionSerializer.isSet() || this.optionResolverHelper.isSet()) {
                    this.writeToFile(grammarName + "RefResolver.jadd", p.generateRewriteToSuperTypeStub());
                }
                this.writeToFile(grammarName + ".ast", p.generateAbstractGrammar());
                this.writeToFile(grammarName + ".jadd", p.generateAspect());
            } else if (this.optionPrintAST.isSet()) {
                System.out.println(p.dumpTree());
            } else {
                System.out.println(p.generateAbstractGrammar());
                System.out.println(p.generateAspect());
            }
        }
    }

    public static void main(String[] args) {
        try {
            new Compiler(args);
        }
        catch (CommandLine.CommandLineException e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
    }

    private void writeToFile(String filename, String str) {
        try {
            PrintWriter writer = new PrintWriter(filename);
            writer.print(str);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void addOptions() {
        this.optionWriteToFile = this.addOption(new FlagOption("file", "write output to files <filename>Gen.ast and <filename>Gen.jadd"));
        this.optionPrintAST = this.addOption(new FlagOption("ast", "print AST"));
        this.optionListClass = this.addOption(new StringOption("listClass", "determine the class name of the nonterminal reference list"));
        this.optionGrammarName = this.addOption(new StringOption("grammarName", "name of the generated grammar and aspect (without file extension)"));
        this.optionResolverHelper = this.addOption(new FlagOption("resolverHelper", "create a subtype for each type containing a string that can be used to resolve the type later"));
        this.optionJastAddList = this.addOption(new StringOption("jastAddList", "set the name of the List type in JastAdd (has to match the option '--List' or its default List)"));
        this.optionUseJastaddNames = this.addOption(new FlagOption("useJastAddNames", "generate names in the form of addX, removeX and setX. If omitted, the default, original naming scheme resulting in addToX, removeFromX and setX will be used."));
        this.optionSerializer = this.addOption(new EnumOption("serializer", "generate a (de-)serializer", Arrays.asList("jackson"), "jackson"));
    }

    private <OptionType extends Option<?>> OptionType addOption(OptionType option) {
        this.options.add(option);
        return option;
    }

    private Program parseProgram(List<String> fileNames) {
        Program program = new Program();
        for (String fileName : fileNames) {
            FileReader reader = null;
            try {
                reader = new FileReader(fileName);
            }
            catch (FileNotFoundException e) {
                System.err.println(e.getMessage());
                System.exit(1);
            }
            this.parse(program, reader, fileName);
        }
        return program;
    }

    private void parse(Program program, Reader reader, String file) {
        RelAstScanner scanner = new RelAstScanner(reader);
        RelAstParser parser = new RelAstParser();
        try {
            Program newProgram = (Program)parser.parse(scanner);
            for (TypeDecl typeDecl : newProgram.getTypeDeclList()) {
                program.addTypeDecl(typeDecl);
            }
            for (Relation relation : newProgram.getRelationList()) {
                program.addRelation(relation);
            }
        }
        catch (IOException e) {
            this.error(e.getMessage());
        }
        catch (Parser.Exception e) {
            System.err.println("Parse error in file " + file);
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    protected void error(String message) {
        System.err.println("Error: " + message);
        System.err.println();
        System.err.println("Usage: java -jar relast.jar [--option1] [--option2=value] ...  <filename1> <filename2> ... ");
        System.err.println("Options:");
        System.err.print(this.commandLine.printOptionHelp());
        System.exit(1);
    }
}

