/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.relast.ast;

import beaver.Symbol;
import org.jastadd.relast.ast.ASTNode;
import org.jastadd.relast.ast.ASTNodeAnnotation;
import org.jastadd.relast.ast.ASTState;
import org.jastadd.relast.ast.Component;
import org.jastadd.relast.ast.TypeUse;

public class TokenComponent
extends Component
implements Cloneable {
    protected boolean isNullable_visited = false;
    protected ASTState.Cycle isNullable_computed = null;
    protected boolean isNullable_value;

    @Override
    public String generateAbstractGrammar() {
        return "<" + this.getID() + ":" + this.getTypeUse() + ">";
    }

    @Override
    public void serialize(StringBuilder sb, int indent) {
        String type;
        switch (type = this.getTypeUse().getID()) {
            case "float": 
            case "Float": 
            case "double": 
            case "Double": 
            case "int": 
            case "Integer": 
            case "short": 
            case "Short": 
            case "long": 
            case "Long": 
            case "byte": 
            case "Byte": {
                sb.append(this.ind(indent) + "g.writeNumberField(\"" + this.getID() + "\", get" + this.getID() + "());\n");
                break;
            }
            case "boolean": 
            case "Boolean": {
                sb.append(this.ind(indent) + "g.writeBooleanField(\"" + this.getID() + "\", get" + this.getID() + "());\n");
                break;
            }
            case "char": 
            case "Character": {
                sb.append(this.ind(indent) + "g.writeStringField(\"" + this.getID() + "\", Character.toString(get" + this.getID() + "()));\n");
                break;
            }
            case "String": {
                sb.append(this.ind(indent) + "g.writeStringField(\"" + this.getID() + "\", get" + this.getID() + "());\n");
                break;
            }
            case "Instant": {
                sb.append(this.ind(indent) + "g.writeStringField(\"" + this.getID() + "\", get" + this.getID() + "().toString());\n");
                break;
            }
            case "Period": {
                sb.append(this.ind(indent) + "g.writeStringField(\"" + this.getID() + "\", get" + this.getID() + "().toString());\n");
                break;
            }
            default: {
                sb.append(this.ind(indent) + "g.writeStringField(\"" + this.getID() + "\", get" + this.getID() + "().name());\n");
            }
        }
    }

    @Override
    public void deserialize(StringBuilder sb, int indent) {
        String type;
        switch (type = this.getTypeUse().getID()) {
            case "float": 
            case "Float": {
                sb.append(this.ind(indent) + "element.set" + this.getID() + "(Float.valueOf(children.get(\"" + this.getID() + "\").asText()));\n");
                break;
            }
            case "double": 
            case "Double": {
                sb.append(this.ind(indent) + "element.set" + this.getID() + "(children.get(\"" + this.getID() + "\").asDouble());\n");
                break;
            }
            case "int": 
            case "Integer": {
                sb.append(this.ind(indent) + "element.set" + this.getID() + "(children.get(\"" + this.getID() + "\").asInt());\n");
                break;
            }
            case "short": 
            case "Short": {
                sb.append(this.ind(indent) + "element.set" + this.getID() + "(Short.valueOf(children.get(\"" + this.getID() + "\").asText()));\n");
                break;
            }
            case "long": 
            case "Long": {
                sb.append(this.ind(indent) + "element.set" + this.getID() + "(children.get(\"" + this.getID() + "\").asLong());\n");
                break;
            }
            case "byte": 
            case "Byte": {
                sb.append(this.ind(indent) + "element.set" + this.getID() + "(Byte.valueOf(children.get(\"" + this.getID() + "\").asText()));\n");
                break;
            }
            case "boolean": 
            case "Boolean": {
                sb.append(this.ind(indent) + "element.set" + this.getID() + "(children.get(\"" + this.getID() + "\").asBoolean());\n");
                break;
            }
            case "char": 
            case "Character": {
                sb.append(this.ind(indent) + "String chars = children.get(\"" + this.getID() + "\").asText();\n");
                sb.append(this.ind(indent) + "if (chars.length() == 1) {\n");
                sb.append(this.ind(indent + 2) + "element.set" + this.getID() + "(chars.charAt(0));\n");
                sb.append(this.ind(indent) + "} else {\n");
                sb.append(this.ind(indent + 2) + "throw new DeserializationException(\"unable to deserialize char '\" + chars + \"'\");\n");
                sb.append(this.ind(indent) + "}\n");
                break;
            }
            case "String": {
                sb.append(this.ind(indent) + "element.set" + this.getID() + "(children.get(\"" + this.getID() + "\").asText());\n");
                break;
            }
            case "Instant": {
                sb.append(this.ind(indent) + "element.set" + this.getID() + "(Instant.parse(children.get(\"" + this.getID() + "\").asText()));\n");
                break;
            }
            case "Period": {
                sb.append(this.ind(indent) + "element.set" + this.getID() + "(Period.parse(children.get(\"" + this.getID() + "\").asText()));\n");
                break;
            }
            default: {
                sb.append(this.ind(indent) + "element.set" + this.getID() + "(Enum.valueOf(" + type + ".class, children.get(\"" + this.getID() + "\").asText()));\n");
            }
        }
    }

    public TokenComponent() {
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[1];
    }

    @ASTNodeAnnotation.Constructor(name={"ID", "TypeUse"}, type={"String", "TypeUse"}, kind={"Token", "Child"})
    public TokenComponent(String p0, TypeUse p1) {
        this.setID(p0);
        this.setChild(p1, 0);
    }

    public TokenComponent(Symbol p0, TypeUse p1) {
        this.setID(p0);
        this.setChild(p1, 0);
    }

    @Override
    protected int numChildren() {
        return 1;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void flushAttrCache() {
        super.flushAttrCache();
        this.isNullable_reset();
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public TokenComponent clone() throws CloneNotSupportedException {
        TokenComponent node = (TokenComponent)super.clone();
        return node;
    }

    public TokenComponent copy() {
        try {
            TokenComponent node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    @Override
    @Deprecated
    public TokenComponent fullCopy() {
        return this.treeCopyNoTransform();
    }

    @Override
    public TokenComponent treeCopyNoTransform() {
        TokenComponent tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = this.children[i];
                if (child == null) continue;
                child = child.treeCopyNoTransform();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    @Override
    public TokenComponent treeCopy() {
        TokenComponent tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                Object child = this.getChild(i);
                if (child == null) continue;
                child = ((ASTNode)child).treeCopy();
                tree.setChild((ASTNode)child, i);
            }
        }
        return tree;
    }

    @Override
    protected boolean is$Equal(ASTNode node) {
        return super.is$Equal(node) && this.tokenString_ID == ((TokenComponent)node).tokenString_ID;
    }

    @Override
    public void setID(String value) {
        this.tokenString_ID = value;
    }

    @Override
    public void setID(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setID is only valid for String lexemes");
        }
        this.tokenString_ID = (String)symbol.value;
        this.IDstart = symbol.getStart();
        this.IDend = symbol.getEnd();
    }

    @Override
    @ASTNodeAnnotation.Token(name="ID")
    public String getID() {
        return this.tokenString_ID != null ? this.tokenString_ID : "";
    }

    public void setTypeUse(TypeUse node) {
        this.setChild(node, 0);
    }

    @Override
    @ASTNodeAnnotation.Child(name="TypeUse")
    public TypeUse getTypeUse() {
        return (TypeUse)this.getChild(0);
    }

    public TypeUse getTypeUseNoTransform() {
        return (TypeUse)this.getChildNoTransform(0);
    }

    private void isNullable_reset() {
        this.isNullable_computed = null;
        this.isNullable_visited = false;
    }

    @Override
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="ComponentAnalysis", declaredAt="/home/jm/work/git/relast/src/main/jastadd/Analysis.jrag:128")
    public boolean isNullable() {
        ASTState state = this.state();
        if (this.isNullable_computed == ASTState.NON_CYCLE || this.isNullable_computed == this.state().cycle()) {
            return this.isNullable_value;
        }
        if (this.isNullable_visited) {
            throw new RuntimeException("Circular definition of attribute Component.isNullable().");
        }
        this.isNullable_visited = true;
        this.isNullable_value = !"float double int short long char byte boolean".contains(this.getTypeUse().getID());
        this.isNullable_computed = this.state().inCircle() ? this.state().cycle() : ASTState.NON_CYCLE;
        this.isNullable_visited = false;
        return this.isNullable_value;
    }

    @Override
    public boolean Define_isToken(ASTNode _callerNode, ASTNode _childNode) {
        if (this.getTypeUseNoTransform() != null && _callerNode == this.getTypeUse()) {
            return true;
        }
        return this.getParent().Define_isToken(this, _callerNode);
    }

    @Override
    protected boolean canDefine_isToken(ASTNode _callerNode, ASTNode _childNode) {
        return true;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    @Override
    public boolean canRewrite() {
        return false;
    }
}

