/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.relast.ast;

import org.jastadd.relast.ast.ASTNode;
import org.jastadd.relast.ast.ASTNodeAnnotation;
import org.jastadd.relast.ast.Direction;
import org.jastadd.relast.ast.RelationComponent;
import org.jastadd.relast.ast.RightDirection;

public class Relation
extends ASTNode<ASTNode>
implements Cloneable {
    public void generateAPI(StringBuilder sb) {
        sb.append(this.ind(1) + "// " + this.prettyPrint() + "\n");
        this.getDirection().generateAPI(sb);
        sb.append("\n");
    }

    public void generateContextDependentNameResolution(StringBuilder sb) {
        sb.append(this.ind(1) + "// " + this.prettyPrint() + "\n");
        this.getDirection().generateContextDependentNameResolution(sb);
        sb.append("\n");
    }

    public String prettyPrint() {
        return "rel " + this.getLeft().prettyPrint() + " " + this.getDirection().prettyPrint() + " " + this.getRight().prettyPrint();
    }

    public Relation() {
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[3];
    }

    @ASTNodeAnnotation.Constructor(name={"Left", "Direction", "Right"}, type={"RelationComponent", "Direction", "RelationComponent"}, kind={"Child", "Child", "Child"})
    public Relation(RelationComponent p0, Direction p1, RelationComponent p2) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
        this.setChild(p2, 2);
    }

    @Override
    protected int numChildren() {
        return 3;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void flushAttrCache() {
        super.flushAttrCache();
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public Relation clone() throws CloneNotSupportedException {
        Relation node = (Relation)super.clone();
        return node;
    }

    public Relation copy() {
        try {
            Relation node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    @Deprecated
    public Relation fullCopy() {
        return this.treeCopyNoTransform();
    }

    public Relation treeCopyNoTransform() {
        Relation tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = this.children[i];
                if (child == null) continue;
                child = child.treeCopyNoTransform();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    public Relation treeCopy() {
        Relation tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                Object child = this.getChild(i);
                if (child == null) continue;
                child = ((ASTNode)child).treeCopy();
                tree.setChild((ASTNode)child, i);
            }
        }
        return tree;
    }

    @Override
    protected boolean is$Equal(ASTNode node) {
        return super.is$Equal(node);
    }

    public void setLeft(RelationComponent node) {
        this.setChild(node, 0);
    }

    @ASTNodeAnnotation.Child(name="Left")
    public RelationComponent getLeft() {
        return (RelationComponent)this.getChild(0);
    }

    public RelationComponent getLeftNoTransform() {
        return (RelationComponent)this.getChildNoTransform(0);
    }

    public void setDirection(Direction node) {
        this.setChild(node, 1);
    }

    @ASTNodeAnnotation.Child(name="Direction")
    public Direction getDirection() {
        return (Direction)this.getChild(1);
    }

    public Direction getDirectionNoTransform() {
        return (Direction)this.getChildNoTransform(1);
    }

    public void setRight(RelationComponent node) {
        this.setChild(node, 2);
    }

    @ASTNodeAnnotation.Child(name="Right")
    public RelationComponent getRight() {
        return (RelationComponent)this.getChild(2);
    }

    public RelationComponent getRightNoTransform() {
        return (RelationComponent)this.getChildNoTransform(2);
    }

    @Override
    public Relation Define_relation(ASTNode _callerNode, ASTNode _childNode) {
        int childIndex = this.getIndexOfChild(_callerNode);
        return this;
    }

    @Override
    protected boolean canDefine_relation(ASTNode _callerNode, ASTNode _childNode) {
        return true;
    }

    @Override
    public boolean Define_isTargetOfRightDirection(ASTNode _callerNode, ASTNode _childNode) {
        if (this.getRightNoTransform() != null && _callerNode == this.getRight()) {
            return this.getDirection() instanceof RightDirection;
        }
        return this.getParent().Define_isTargetOfRightDirection(this, _callerNode);
    }

    @Override
    protected boolean canDefine_isTargetOfRightDirection(ASTNode _callerNode, ASTNode _childNode) {
        return true;
    }

    @Override
    public RelationComponent Define_otherSide(ASTNode _callerNode, ASTNode _childNode) {
        if (this.getRightNoTransform() != null && _callerNode == this.getRight()) {
            return this.getLeft();
        }
        if (this.getLeftNoTransform() != null && _callerNode == this.getLeft()) {
            return this.getRight();
        }
        return this.getParent().Define_otherSide(this, _callerNode);
    }

    @Override
    protected boolean canDefine_otherSide(ASTNode _callerNode, ASTNode _childNode) {
        return true;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    @Override
    public boolean canRewrite() {
        return false;
    }
}

