/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.relast.ast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jastadd.relast.ast.ASTNode;
import org.jastadd.relast.ast.ASTNodeAnnotation;
import org.jastadd.relast.ast.ASTState;
import org.jastadd.relast.ast.Component;
import org.jastadd.relast.ast.ErrorMessage;
import org.jastadd.relast.ast.List;
import org.jastadd.relast.ast.Relation;
import org.jastadd.relast.ast.RelationComponent;
import org.jastadd.relast.ast.TypeDecl;

public class Program
extends ASTNode<ASTNode>
implements Cloneable {
    protected Map<ASTNode, Set<ASTNode>> contributorMap_Program_errors = null;
    protected Map<ASTNode, Set<ASTNode>> contributorMap_TypeDecl_relationComponents = null;
    protected Set lookupComponentSyn_TypeDecl_String_visited;
    protected Map lookupComponentSyn_TypeDecl_String_values;
    protected Map lookupComponentSyn_TypeDecl_String_computed;
    protected boolean Program_errors_visited = false;
    protected ASTState.Cycle Program_errors_computed = null;
    protected Set<ErrorMessage> Program_errors_value;

    public String generateAbstractGrammar() {
        StringBuilder sb = new StringBuilder();
        this.generateAbstractGrammar(sb);
        return sb.toString();
    }

    public void generateAbstractGrammar(StringBuilder sb) {
        for (TypeDecl td : this.getTypeDecls()) {
            td.generateAbstractGrammar(sb);
        }
    }

    public String generateAspect() {
        StringBuilder sb = new StringBuilder();
        this.generateAspect(sb);
        return sb.toString();
    }

    public void generateAspect(StringBuilder sb) {
        sb.append("import java.util.ArrayList;\n");
        sb.append("import java.util.Collections;\n");
        sb.append("import java.time.Instant;\n");
        sb.append("import java.time.Period;\n");
        sb.append("aspect RelAstAPI {\n");
        for (TypeDecl td : this.getTypeDecls()) {
            if (!td.needsConstructor()) continue;
            td.generateConstructor(sb);
        }
        for (Relation r : this.getRelations()) {
            r.generateAPI(sb);
        }
        this.generateLowerBoundCheck(sb);
        sb.append(this.ind(1) + "public static void ASTNode.assertNotNull(Object obj) {\n");
        sb.append(this.ind(2) + "if (obj == null) {\n");
        sb.append(this.ind(3) + "throw new NullPointerException();\n");
        sb.append(this.ind(2) + "}\n");
        sb.append(this.ind(1) + "}\n");
        sb.append("}\n");
    }

    public void generateLowerBoundCheck(StringBuilder sb) {
        sb.append(this.ind(1) + "public boolean ASTNode.violatesLowerBounds() {\n");
        sb.append(this.ind(2) + "return !getLowerBoundsViolations().isEmpty();\n");
        sb.append(this.ind(1) + "}\n");
        sb.append(this.ind(1) + "public java.util.List<Pair<ASTNode, String>> ASTNode.getLowerBoundsViolations() {\n");
        sb.append(this.ind(2) + "ArrayList<Pair<ASTNode, String>> list = new ArrayList<>();\n");
        sb.append(this.ind(2) + "computeLowerBoundsViolations(list);\n");
        sb.append(this.ind(2) + "return list;\n");
        sb.append(this.ind(1) + "}\n");
        sb.append(this.ind(1) + "public void ASTNode.computeLowerBoundsViolations(java.util.List<Pair<ASTNode, String>> list) {\n");
        sb.append(this.ind(2) + "for (int i = 0; i < getNumChildNoTransform(); i++) {\n");
        sb.append(this.ind(3) + "getChildNoTransform(i).computeLowerBoundsViolations(list);\n");
        sb.append(this.ind(2) + "}\n");
        sb.append(this.ind(1) + "}\n");
        for (TypeDecl td : this.getTypeDecls()) {
            td.generateLowerBoundCheck(sb);
        }
        this.generatePairClass(sb);
    }

    public void generatePairClass(StringBuilder sb) {
        sb.append(this.ind(1) + "public class Pair<T1, T2> {\n");
        sb.append(this.ind(2) + "public final T1 _1;\n");
        sb.append(this.ind(2) + "public final T2 _2;\n");
        sb.append(this.ind(2) + "public Pair(T1 _1, T2 _2) {\n");
        sb.append(this.ind(3) + "ASTNode.assertNotNull(_1);\n");
        sb.append(this.ind(3) + "ASTNode.assertNotNull(_2);\n");
        sb.append(this.ind(3) + "this._1 = _1;\n");
        sb.append(this.ind(3) + "this._2 = _2;\n");
        sb.append(this.ind(2) + "}\n");
        sb.append(this.ind(2) + "public boolean equals(Object other) {\n");
        sb.append(this.ind(3) + "if (other instanceof Pair) {\n");
        sb.append(this.ind(4) + "Pair<?,?> p = (Pair<?,?>) other;\n");
        sb.append(this.ind(4) + "return _1.equals(p._1) && _2.equals(p._2);\n");
        sb.append(this.ind(3) + "} else {\n");
        sb.append(this.ind(4) + "return false;\n");
        sb.append(this.ind(3) + "}\n");
        sb.append(this.ind(2) + "}\n");
        sb.append(this.ind(2) + "public int hashCode() {\n");
        sb.append(this.ind(3) + "return 31*_1.hashCode() + _2.hashCode();\n");
        sb.append(this.ind(2) + "}\n");
        sb.append(this.ind(1) + "}\n");
    }

    public String generateRewriteToSuperTypeStub() {
        StringBuilder sb = new StringBuilder();
        this.generateRewriteToSuperTypeStub(sb);
        return sb.toString();
    }

    public String generateResolverStubs() {
        StringBuilder sb = new StringBuilder();
        this.generateResolverStubs(sb);
        return sb.toString();
    }

    public void generateResolverStubs(StringBuilder sb) {
        sb.append("aspect RefResolverStubs {\n\n");
        for (Relation r : this.getRelations()) {
            r.generateContextDependentNameResolution(sb);
        }
        if (resolverHelper) {
            for (TypeDecl decl : this.getTypeDeclList()) {
                decl.generateContextIndependentNameResolution(sb);
                sb.append("\n");
            }
        }
        sb.append("}\n\n");
    }

    public void generateRewriteToSuperTypeStub(StringBuilder sb) {
        sb.append("aspect ReferenceCreation {\n\n");
        for (TypeDecl decl : this.getTypeDeclList()) {
            decl.createReferenceCreator(sb);
        }
        sb.append("}\n\n");
        sb.append("aspect ResolverTrigger {\n\n");
        this.resolveAll(sb);
        for (TypeDecl decl : this.getTypeDeclList()) {
            decl.resolveAll(sb);
        }
        sb.append("}\n\n");
        sb.append("aspect RefResolverHelpers {\n\n");
        sb.append(this.ind(1) + "interface Unresolved$Node {\n");
        sb.append(this.ind(2) + "String getUnresolved$Token();\n");
        sb.append(this.ind(2) + "boolean getUnresolved$ResolveOpposite();\n");
        sb.append(this.ind(1) + "}\n\n");
        for (TypeDecl td : this.getTypeDecls()) {
            if (!td.needUnresolvedClass()) continue;
            td.generateUnresolvedClass(sb);
        }
        sb.append("\n}\n");
    }

    public void resolveAll(StringBuilder sb) {
        sb.append(this.ind(1) + "// enforce resolving of all non-containment relations of the current non-terminal\n");
        sb.append(this.ind(1) + "public void ASTNode.resolveAll() {\n");
        sb.append(this.ind(1) + "}\n\n");
        sb.append(this.ind(1) + "// enforce resolving in the entire subtree\n");
        sb.append(this.ind(1) + "public void ASTNode.treeResolveAll() {\n");
        sb.append(this.ind(2) + "if (children != null) {\n");
        sb.append(this.ind(3) + "for (int i = 0; i < numChildren; ++i) {\n");
        sb.append(this.ind(4) + "ASTNode child = children[i];\n");
        sb.append(this.ind(4) + "if (child != null) {\n");
        sb.append(this.ind(5) + "child.treeResolveAll();\n");
        sb.append(this.ind(4) + "}\n");
        sb.append(this.ind(3) + "}\n");
        sb.append(this.ind(2) + "}\n");
        sb.append(this.ind(2) + "resolveAll();\n");
        sb.append(this.ind(1) + "}\n");
    }

    public String generateSerializer() {
        StringBuilder sb = new StringBuilder();
        this.generateFromJson(sb);
        this.generateToJson(sb);
        this.writeUID(sb);
        return sb.toString();
    }

    public void generateFromJson(StringBuilder sb) {
        sb.append("aspect JsonToModel {\n");
        sb.append(this.ind(1) + "public class DeserializationException extends Exception {\n");
        sb.append(this.ind(2) + "public DeserializationException(String message) {\n");
        sb.append(this.ind(3) + "super(message);\n");
        sb.append(this.ind(2) + "}\n");
        sb.append(this.ind(2) + "public DeserializationException(String message, Exception cause) {\n");
        sb.append(this.ind(3) + "super(message, cause);\n");
        sb.append(this.ind(2) + "}\n");
        sb.append(this.ind(1) + "}\n");
        sb.append(this.ind(1) + "public void ASTNode.serialize(com.fasterxml.jackson.core.JsonGenerator g) throws SerializationException {\n");
        sb.append(this.ind(2) + "serialize(g, null);\n");
        sb.append(this.ind(1) + "}\n");
        sb.append(this.ind(1) + "public void ASTNode.serialize(com.fasterxml.jackson.core.JsonGenerator g, String field) throws SerializationException {\n");
        sb.append(this.ind(2) + "throw new SerializationException(\"unable to serialize class \" + this.getClass().getSimpleName());\n");
        sb.append(this.ind(1) + "}\n");
        sb.append(this.ind(1) + "public void ASTNode.serialize(java.io.File file) throws SerializationException {\n");
        sb.append(this.ind(2) + "serialize(file, false);\n");
        sb.append(this.ind(1) + "}\n");
        sb.append(this.ind(1) + "public void ASTNode.serialize(java.io.File file, boolean humanReadable) throws SerializationException {\n");
        sb.append(this.ind(2) + "try {\n");
        sb.append(this.ind(3) + "com.fasterxml.jackson.core.JsonFactory factory = new com.fasterxml.jackson.core.JsonFactory();\n");
        sb.append(this.ind(3) + "com.fasterxml.jackson.core.JsonGenerator generator = factory.createGenerator(file, com.fasterxml.jackson.core.JsonEncoding.UTF8);\n");
        sb.append(this.ind(3) + "if (humanReadable) {\n");
        sb.append(this.ind(4) + "generator.setPrettyPrinter(new com.fasterxml.jackson.core.util.DefaultPrettyPrinter());\n");
        sb.append(this.ind(3) + "}\n");
        sb.append(this.ind(3) + "serialize(generator);\n");
        sb.append(this.ind(3) + "generator.close();\n");
        sb.append(this.ind(2) + "} catch (java.io.IOException e) {\n");
        sb.append(this.ind(3) + "throw new SerializationException(\"Unable to serialize file \" + file.getAbsolutePath(), e);\n");
        sb.append(this.ind(2) + "}\n");
        sb.append(this.ind(1) + "}\n");
        for (TypeDecl decl : this.getTypeDeclList()) {
            decl.deserialize(sb);
        }
        sb.append("}\n");
    }

    public void generateToJson(StringBuilder sb) {
        sb.append("aspect ModelToJson {\n");
        sb.append(this.ind(1) + "public class SerializationException extends Exception {\n");
        sb.append(this.ind(2) + "public SerializationException(String message) {\n");
        sb.append(this.ind(3) + "super(message);\n");
        sb.append(this.ind(2) + "}\n");
        sb.append(this.ind(2) + "public SerializationException(String message, Exception cause) {\n");
        sb.append(this.ind(3) + "super(message, cause);\n");
        sb.append(this.ind(2) + "}\n");
        sb.append(this.ind(1) + "}\n");
        for (TypeDecl decl : this.getTypeDeclList()) {
            decl.serialize(sb);
        }
        sb.append("}\n");
    }

    public void writeUID(StringBuilder sb) {
        sb.append("aspect UID {\n");
        sb.append(this.ind(1) + "class UIDProvider {\n");
        sb.append(this.ind(2) + "private static long nextUID = 0;\n");
        sb.append(this.ind(2) + "public static String getUID() {\n");
        sb.append(this.ind(3) + "return String.valueOf(nextUID++);\n");
        sb.append(this.ind(2) + "}\n");
        sb.append(this.ind(1) + "}\n");
        sb.append("\n");
        sb.append(this.ind(1) + "protected String ASTNode.unique$Id = null;\n");
        sb.append("\n");
        sb.append(this.ind(1) + "protected String ASTNode.unique$Id() {\n");
        sb.append(this.ind(2) + "String customUID = customID();\n");
        sb.append(this.ind(2) + "if (customUID == null) {\n");
        sb.append(this.ind(3) + "if (unique$Id == null) {\n");
        sb.append(this.ind(4) + "unique$Id = UIDProvider.getUID();\n");
        sb.append(this.ind(3) + "}\n");
        sb.append(this.ind(3) + "return unique$Id;\n");
        sb.append(this.ind(2) + "} else {\n");
        sb.append(this.ind(3) + "return customUID;\n");
        sb.append(this.ind(2) + "}\n");
        sb.append(this.ind(1) + "}\n");
        sb.append("\n");
        sb.append(this.ind(1) + "protected String ASTNode.customID() {\n");
        sb.append(this.ind(1) + "  return null;\n");
        sb.append(this.ind(1) + "}\n");
        sb.append("\n");
        sb.append(this.ind(1) + "ASTNode ASTNode.globallyResolveASTNodeByUID(String uid) {\n");
        sb.append(this.ind(2) + "if (getParent() == null) {\n");
        sb.append(this.ind(3) + "return uid$Map().get(uid).get();\n");
        sb.append(this.ind(2) + "} else {\n");
        sb.append(this.ind(3) + "return getParent().globallyResolveASTNodeByUID(uid);\n");
        sb.append(this.ind(2) + "}\n");
        sb.append(this.ind(1) + "}\n");
        sb.append("\n");
        sb.append(this.ind(1) + "java.util.Map<String, java.lang.ref.WeakReference<ASTNode>> ASTNode.uid$Map;\n");
        sb.append("\n");
        sb.append(this.ind(1) + "java.util.Map<String, java.lang.ref.WeakReference<ASTNode>> ASTNode.uid$Map() {\n");
        sb.append(this.ind(2) + "if (uid$Map == null) {\n");
        sb.append(this.ind(3) + "uid$Map = uid$Map(new java.util.HashMap());\n");
        sb.append(this.ind(2) + "}\n");
        sb.append(this.ind(2) + "return uid$Map;\n");
        sb.append(this.ind(1) + "}\n");
        sb.append(this.ind(1) + "protected java.util.Map<String, java.lang.ref.WeakReference<ASTNode>> ASTNode.uid$Map(java.util.Map<String, java.lang.ref.WeakReference<ASTNode>> map) {\n");
        sb.append(this.ind(2) + "if (!(this instanceof " + jastAddListType + " || this instanceof Opt)) {\n");
        sb.append(this.ind(3) + "if (map.keySet().contains(unique$Id())) {\n");
        sb.append(this.ind(4) + "throw new RuntimeException(new SerializationException(\"UID \" + this.unique$Id() + \" is assigned to both \" + this.getClass().getSimpleName() + \":\" + this.hashCode() + \" and \" + map.get(unique$Id()).getClass().getSimpleName() + \":\" + map.get(unique$Id()).hashCode()));\n");
        sb.append(this.ind(3) + "} else {\n");
        sb.append(this.ind(4) + "map.put(this.unique$Id, new java.lang.ref.WeakReference(this));\n");
        sb.append(this.ind(3) + "}\n");
        sb.append(this.ind(2) + "}\n");
        sb.append(this.ind(2) + "for (ASTNode child : astChildren()) {\n");
        sb.append(this.ind(3) + "child.uid$Map(map);\n");
        sb.append(this.ind(2) + "}\n");
        sb.append(this.ind(2) + "return map;\n");
        sb.append(this.ind(1) + "}\n");
        sb.append("}\n");
    }

    public Program() {
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[2];
        this.setChild(new List(), 0);
        this.setChild(new List(), 1);
    }

    @ASTNodeAnnotation.Constructor(name={"TypeDecl", "Relation"}, type={"List<TypeDecl>", "List<Relation>"}, kind={"List", "List"})
    public Program(List<TypeDecl> p0, List<Relation> p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    @Override
    protected int numChildren() {
        return 2;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void flushAttrCache() {
        super.flushAttrCache();
        this.lookupComponentSyn_TypeDecl_String_reset();
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
        this.Program_errors_visited = false;
        this.Program_errors_computed = null;
        this.Program_errors_value = null;
        this.contributorMap_Program_errors = null;
        this.contributorMap_TypeDecl_relationComponents = null;
    }

    @Override
    public Program clone() throws CloneNotSupportedException {
        Program node = (Program)super.clone();
        return node;
    }

    public Program copy() {
        try {
            Program node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    @Deprecated
    public Program fullCopy() {
        return this.treeCopyNoTransform();
    }

    public Program treeCopyNoTransform() {
        Program tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = this.children[i];
                if (child == null) continue;
                child = child.treeCopyNoTransform();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    public Program treeCopy() {
        Program tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                Object child = this.getChild(i);
                if (child == null) continue;
                child = ((ASTNode)child).treeCopy();
                tree.setChild((ASTNode)child, i);
            }
        }
        return tree;
    }

    @Override
    protected boolean is$Equal(ASTNode node) {
        return super.is$Equal(node);
    }

    public void setTypeDeclList(List<TypeDecl> list) {
        this.setChild(list, 0);
    }

    public int getNumTypeDecl() {
        return this.getTypeDeclList().getNumChild();
    }

    public int getNumTypeDeclNoTransform() {
        return this.getTypeDeclListNoTransform().getNumChildNoTransform();
    }

    public TypeDecl getTypeDecl(int i) {
        return (TypeDecl)this.getTypeDeclList().getChild(i);
    }

    public boolean hasTypeDecl() {
        return this.getTypeDeclList().getNumChild() != 0;
    }

    public void addTypeDecl(TypeDecl node) {
        List<TypeDecl> list = this.parent == null ? this.getTypeDeclListNoTransform() : this.getTypeDeclList();
        list.addChild(node);
    }

    public void addTypeDeclNoTransform(TypeDecl node) {
        List<TypeDecl> list = this.getTypeDeclListNoTransform();
        list.addChild(node);
    }

    public void setTypeDecl(TypeDecl node, int i) {
        List<TypeDecl> list = this.getTypeDeclList();
        list.setChild(node, i);
    }

    @ASTNodeAnnotation.ListChild(name="TypeDecl")
    public List<TypeDecl> getTypeDeclList() {
        List list = (List)this.getChild(0);
        return list;
    }

    public List<TypeDecl> getTypeDeclListNoTransform() {
        return (List)this.getChildNoTransform(0);
    }

    public TypeDecl getTypeDeclNoTransform(int i) {
        return (TypeDecl)this.getTypeDeclListNoTransform().getChildNoTransform(i);
    }

    public List<TypeDecl> getTypeDecls() {
        return this.getTypeDeclList();
    }

    public List<TypeDecl> getTypeDeclsNoTransform() {
        return this.getTypeDeclListNoTransform();
    }

    public void setRelationList(List<Relation> list) {
        this.setChild(list, 1);
    }

    public int getNumRelation() {
        return this.getRelationList().getNumChild();
    }

    public int getNumRelationNoTransform() {
        return this.getRelationListNoTransform().getNumChildNoTransform();
    }

    public Relation getRelation(int i) {
        return (Relation)this.getRelationList().getChild(i);
    }

    public boolean hasRelation() {
        return this.getRelationList().getNumChild() != 0;
    }

    public void addRelation(Relation node) {
        List<Relation> list = this.parent == null ? this.getRelationListNoTransform() : this.getRelationList();
        list.addChild(node);
    }

    public void addRelationNoTransform(Relation node) {
        List<Relation> list = this.getRelationListNoTransform();
        list.addChild(node);
    }

    public void setRelation(Relation node, int i) {
        List<Relation> list = this.getRelationList();
        list.setChild(node, i);
    }

    @ASTNodeAnnotation.ListChild(name="Relation")
    public List<Relation> getRelationList() {
        List list = (List)this.getChild(1);
        return list;
    }

    public List<Relation> getRelationListNoTransform() {
        return (List)this.getChildNoTransform(1);
    }

    public Relation getRelationNoTransform(int i) {
        return (Relation)this.getRelationListNoTransform().getChildNoTransform(i);
    }

    public List<Relation> getRelations() {
        return this.getRelationList();
    }

    public List<Relation> getRelationsNoTransform() {
        return this.getRelationListNoTransform();
    }

    protected void survey_Program_errors() {
        if (this.contributorMap_Program_errors == null) {
            this.contributorMap_Program_errors = new IdentityHashMap<ASTNode, Set<ASTNode>>();
            this.collect_contributors_Program_errors(this, this.contributorMap_Program_errors);
        }
    }

    protected void survey_TypeDecl_relationComponents() {
        if (this.contributorMap_TypeDecl_relationComponents == null) {
            this.contributorMap_TypeDecl_relationComponents = new IdentityHashMap<ASTNode, Set<ASTNode>>();
            this.collect_contributors_TypeDecl_relationComponents(this, this.contributorMap_TypeDecl_relationComponents);
        }
    }

    private void lookupComponentSyn_TypeDecl_String_reset() {
        this.lookupComponentSyn_TypeDecl_String_computed = null;
        this.lookupComponentSyn_TypeDecl_String_values = null;
        this.lookupComponentSyn_TypeDecl_String_visited = null;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="ComponentAnalysis", declaredAt="/home/jm/work/git/relast/src/main/jastadd/Analysis.jrag:60")
    public Component lookupComponentSyn(TypeDecl td, String name) {
        ArrayList<Object> _parameters = new ArrayList<Object>(2);
        _parameters.add(td);
        _parameters.add(name);
        if (this.lookupComponentSyn_TypeDecl_String_visited == null) {
            this.lookupComponentSyn_TypeDecl_String_visited = new HashSet(4);
        }
        if (this.lookupComponentSyn_TypeDecl_String_computed == null) {
            this.lookupComponentSyn_TypeDecl_String_computed = new HashMap(4);
        }
        if (this.lookupComponentSyn_TypeDecl_String_values == null) {
            this.lookupComponentSyn_TypeDecl_String_values = new HashMap(4);
        }
        ASTState state = this.state();
        if (this.lookupComponentSyn_TypeDecl_String_values.containsKey(_parameters) && this.lookupComponentSyn_TypeDecl_String_computed.containsKey(_parameters) && (this.lookupComponentSyn_TypeDecl_String_computed.get(_parameters) == ASTState.NON_CYCLE || this.lookupComponentSyn_TypeDecl_String_computed.get(_parameters) == this.state().cycle())) {
            return (Component)this.lookupComponentSyn_TypeDecl_String_values.get(_parameters);
        }
        if (this.lookupComponentSyn_TypeDecl_String_visited.contains(_parameters)) {
            throw new RuntimeException("Circular definition of attribute Program.lookupComponentSyn(TypeDecl,String).");
        }
        this.lookupComponentSyn_TypeDecl_String_visited.add(_parameters);
        Component lookupComponentSyn_TypeDecl_String_value = this.lookupComponentSyn_compute(td, name);
        if (this.state().inCircle()) {
            this.lookupComponentSyn_TypeDecl_String_values.put(_parameters, lookupComponentSyn_TypeDecl_String_value);
            this.lookupComponentSyn_TypeDecl_String_computed.put(_parameters, this.state().cycle());
        } else {
            this.lookupComponentSyn_TypeDecl_String_values.put(_parameters, lookupComponentSyn_TypeDecl_String_value);
            this.lookupComponentSyn_TypeDecl_String_computed.put(_parameters, ASTState.NON_CYCLE);
        }
        this.lookupComponentSyn_TypeDecl_String_visited.remove(_parameters);
        return lookupComponentSyn_TypeDecl_String_value;
    }

    private Component lookupComponentSyn_compute(TypeDecl td, String name) {
        Component c;
        if (td.hasSuper() && td.getSuper().decl() != null && (c = this.lookupComponentSyn(td.getSuper().decl(), name)) != null) {
            return c;
        }
        for (Component c2 : td.getComponents()) {
            if (!c2.name().equals(name)) continue;
            return c2;
        }
        for (Relation r : this.getRelations()) {
            RelationComponent c3 = r.getLeft().lookup(td, name);
            if (c3 != null) {
                return c3;
            }
            c3 = r.getRight().lookup(td, name);
            if (c3 == null) continue;
            return c3;
        }
        return null;
    }

    @Override
    public Relation Define_relation(ASTNode _callerNode, ASTNode _childNode) {
        int childIndex = this.getIndexOfChild(_callerNode);
        return null;
    }

    @Override
    protected boolean canDefine_relation(ASTNode _callerNode, ASTNode _childNode) {
        return true;
    }

    @Override
    public Program Define_program(ASTNode _callerNode, ASTNode _childNode) {
        if (_callerNode == this.getTypeDeclListNoTransform()) {
            int i = _callerNode.getIndexOfChild(_childNode);
            return this;
        }
        int childIndex = this.getIndexOfChild(_callerNode);
        return this;
    }

    @Override
    protected boolean canDefine_program(ASTNode _callerNode, ASTNode _childNode) {
        return true;
    }

    @Override
    public boolean Define_isToken(ASTNode _callerNode, ASTNode _childNode) {
        int childIndex = this.getIndexOfChild(_callerNode);
        return false;
    }

    @Override
    protected boolean canDefine_isToken(ASTNode _callerNode, ASTNode _childNode) {
        return true;
    }

    @Override
    public TypeDecl Define_lookupType(ASTNode _callerNode, ASTNode _childNode, String name) {
        int childIndex = this.getIndexOfChild(_callerNode);
        for (TypeDecl td : this.getTypeDecls()) {
            if (!td.getID().equals(name)) continue;
            return td;
        }
        return null;
    }

    @Override
    protected boolean canDefine_lookupType(ASTNode _callerNode, ASTNode _childNode, String name) {
        return true;
    }

    @Override
    public boolean Define_isTargetOfRightDirection(ASTNode _callerNode, ASTNode _childNode) {
        int childIndex = this.getIndexOfChild(_callerNode);
        return false;
    }

    @Override
    protected boolean canDefine_isTargetOfRightDirection(ASTNode _callerNode, ASTNode _childNode) {
        return true;
    }

    @Override
    public TypeDecl Define_enclosingTypeDecl(ASTNode _callerNode, ASTNode _childNode) {
        int childIndex = this.getIndexOfChild(_callerNode);
        return null;
    }

    @Override
    protected boolean canDefine_enclosingTypeDecl(ASTNode _callerNode, ASTNode _childNode) {
        return true;
    }

    @Override
    public RelationComponent Define_otherSide(ASTNode _callerNode, ASTNode _childNode) {
        int childIndex = this.getIndexOfChild(_callerNode);
        return null;
    }

    @Override
    protected boolean canDefine_otherSide(ASTNode _callerNode, ASTNode _childNode) {
        return true;
    }

    @Override
    public Component Define_lookupComponent(ASTNode _callerNode, ASTNode _childNode, TypeDecl td, String name) {
        int childIndex = this.getIndexOfChild(_callerNode);
        return this.lookupComponentSyn(td, name);
    }

    @Override
    protected boolean canDefine_lookupComponent(ASTNode _callerNode, ASTNode _childNode, TypeDecl td, String name) {
        return true;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    @Override
    public boolean canRewrite() {
        return false;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.COLL)
    @ASTNodeAnnotation.Source(aspect="Errors", declaredAt="/home/jm/work/git/relast/src/main/jastadd/Errors.jrag:6")
    public Set<ErrorMessage> errors() {
        ASTState state = this.state();
        if (this.Program_errors_computed == ASTState.NON_CYCLE || this.Program_errors_computed == this.state().cycle()) {
            return this.Program_errors_value;
        }
        if (this.Program_errors_visited) {
            throw new RuntimeException("Circular definition of attribute Program.errors().");
        }
        this.Program_errors_visited = true;
        this.Program_errors_value = this.errors_compute();
        this.Program_errors_computed = this.state().inCircle() ? this.state().cycle() : ASTState.NON_CYCLE;
        this.Program_errors_visited = false;
        return this.Program_errors_value;
    }

    private Set<ErrorMessage> errors_compute() {
        ASTNode node;
        for (node = this; node != null && !(node instanceof Program); node = node.getParent()) {
        }
        Program root = node;
        root.survey_Program_errors();
        TreeSet<ErrorMessage> _computedValue = new TreeSet<ErrorMessage>();
        if (root.contributorMap_Program_errors.containsKey(this)) {
            for (ASTNode contributor : root.contributorMap_Program_errors.get(this)) {
                contributor.contributeTo_Program_errors(_computedValue);
            }
        }
        return _computedValue;
    }
}

