/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.relast.ast;

import java.util.Iterator;
import org.jastadd.relast.ast.ASTNode;

public class List<T extends ASTNode>
extends ASTNode<T>
implements Cloneable,
Iterable<T> {
    public List() {
    }

    @Override
    public void init$Children() {
    }

    public List(T ... initialChildren) {
        this.children = new ASTNode[initialChildren.length];
        for (int i = 0; i < this.children.length; ++i) {
            this.addChild(initialChildren[i]);
        }
    }

    public List<T> add(T node) {
        this.addChild(node);
        return this;
    }

    public List<T> addAll(Iterable<? extends T> c) {
        for (ASTNode node : c) {
            this.addChild(node);
        }
        return this;
    }

    @Override
    public void insertChild(ASTNode node, int i) {
        super.insertChild(node, i);
    }

    @Override
    public void addChild(T node) {
        super.addChild(node);
    }

    @Override
    public void removeChild(int i) {
        super.removeChild(i);
    }

    @Override
    public int getNumChild() {
        return this.getNumChildNoTransform();
    }

    @Override
    public Iterator<T> iterator() {
        return this.astChildIterator();
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void flushAttrCache() {
        super.flushAttrCache();
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public List<T> clone() throws CloneNotSupportedException {
        List node = (List)super.clone();
        return node;
    }

    @Override
    public List<T> copy() {
        try {
            ASTNode node = this.clone();
            ((List)node).parent = null;
            if (this.children != null) {
                ((List)node).children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    @Override
    @Deprecated
    public List<T> fullCopy() {
        return this.treeCopyNoTransform();
    }

    @Override
    public List<T> treeCopyNoTransform() {
        ASTNode tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = this.children[i];
                if (child == null) continue;
                child = child.treeCopyNoTransform();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    @Override
    public List<T> treeCopy() {
        ASTNode tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                Object child = this.getChild(i);
                if (child == null) continue;
                child = ((ASTNode)child).treeCopy();
                tree.setChild((ASTNode)child, i);
            }
        }
        return tree;
    }

    @Override
    protected boolean is$Equal(ASTNode node) {
        return super.is$Equal(node);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    @Override
    public boolean canRewrite() {
        return false;
    }
}

