/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.relast.ast;

import org.jastadd.relast.ast.ASTNode;

public class ErrorMessage
implements Comparable<ErrorMessage> {
    private final ASTNode node;
    private final int line;
    private final int col;
    private final String message;

    public ErrorMessage(ASTNode node, String message) {
        this.node = node;
        this.line = node.getStartLine();
        this.col = node.getStartColumn();
        this.message = message;
    }

    public ASTNode getNode() {
        return this.node;
    }

    public int getLine() {
        return this.line;
    }

    public int getCol() {
        return this.col;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return "Line " + this.line + ", column " + this.col + ": " + this.message;
    }

    @Override
    public int compareTo(ErrorMessage err) {
        int n = this.line - err.line;
        if (n != 0) {
            return n;
        }
        n = this.col - err.col;
        if (n != 0) {
            return n;
        }
        return this.message.compareTo(err.message);
    }
}

