/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.relast.ast;

import beaver.Symbol;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jastadd.relast.ast.ASTNodeAnnotation;
import org.jastadd.relast.ast.ASTState;
import org.jastadd.relast.ast.Component;
import org.jastadd.relast.ast.ErrorMessage;
import org.jastadd.relast.ast.List;
import org.jastadd.relast.ast.Opt;
import org.jastadd.relast.ast.Program;
import org.jastadd.relast.ast.Relation;
import org.jastadd.relast.ast.RelationComponent;
import org.jastadd.relast.ast.TypeDecl;

public class ASTNode<T extends ASTNode>
extends Symbol
implements Cloneable {
    public static String listClass = "ArrayList";
    public static String jastAddListType = "List";
    public static boolean resolverHelper = false;
    public static boolean serializer = false;
    public static boolean useJastAddNames = false;
    protected static String jsonTypeKey = "type";
    protected static String jsonNodeType = "com.fasterxml.jackson.databind.JsonNode";
    protected static String jsonNodeTypeAccessor = ".get(\"" + jsonTypeKey + "\").asText()";
    private static final String DUMP_TREE_INDENT = "  ";
    private int childIndex = -1;
    public static final boolean generatedWithCacheCycle = true;
    protected ASTNode parent;
    protected ASTNode[] children;
    private static ASTState state = new ASTState();
    protected int numChildren;
    protected int startLine;
    protected short startColumn;
    protected int endLine;
    protected short endColumn;
    protected boolean program_visited = false;
    protected ASTState.Cycle program_computed = null;
    protected Program program_value;

    public String ind(int n) {
        String s = "";
        for (int i = 0; i < n; ++i) {
            s = s + DUMP_TREE_INDENT;
        }
        return s;
    }

    public String dumpTree() {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        this.dumpTree(new PrintStream(bytes));
        return bytes.toString();
    }

    public void dumpTree(PrintStream out) {
        this.dumpTree(out, "");
        out.flush();
    }

    public void dumpTree(PrintStream out, String indent) {
        out.print(indent + this.getClass().getSimpleName());
        out.print(this.getTokens());
        String extra = this.extraDumpInfo();
        if (!extra.isEmpty()) {
            out.print(" " + extra);
        }
        out.println();
        String childIndent = indent + DUMP_TREE_INDENT;
        for (ASTNode child : this.astChildren()) {
            if (child == null) {
                out.println(childIndent + "null");
                continue;
            }
            child.dumpTree(out, childIndent);
        }
    }

    public String extraDumpInfo() {
        return "";
    }

    public String getTokens() {
        TreeSet<Method> methods = new TreeSet<Method>(new Comparator<Method>(){

            @Override
            public int compare(Method m1, Method m2) {
                return m1.getName().compareTo(m2.getName());
            }
        });
        methods.addAll(Arrays.asList(this.getClass().getMethods()));
        String result = "";
        for (Method method : methods) {
            ASTNodeAnnotation.Token token = method.getAnnotation(ASTNodeAnnotation.Token.class);
            if (token == null) continue;
            try {
                result = result + String.format(" %s=\"%s\"", token.name(), method.invoke((Object)this, new Object[0]));
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        return result;
    }

    protected ErrorMessage error(String message) {
        return new ErrorMessage(this, message);
    }

    public ASTNode() {
        this.init$Children();
    }

    public void init$Children() {
    }

    public int getIndexOfChild(ASTNode node) {
        if (node == null) {
            return -1;
        }
        if (node.childIndex >= 0) {
            return node.childIndex;
        }
        for (int i = 0; this.children != null && i < this.children.length; ++i) {
            if (this.getChild(i) != node) continue;
            node.childIndex = i;
            return i;
        }
        return -1;
    }

    public final ASTState state() {
        return state;
    }

    public static final ASTState resetState() {
        state = new ASTState();
        return state;
    }

    public Iterator<T> astChildIterator() {
        return new Iterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < ASTNode.this.getNumChild();
            }

            @Override
            public T next() {
                return this.hasNext() ? (Object)ASTNode.this.getChild(this.index++) : null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterable<T> astChildren() {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return ASTNode.this.astChildIterator();
            }
        };
    }

    public T getChild(int i) {
        ASTNode rewritten;
        Object node = this.getChildNoTransform(i);
        if (node != null && ((ASTNode)node).mayHaveRewrite() && (rewritten = ((ASTNode)node).rewrittenNode()) != node) {
            rewritten.setParent(this);
            node = rewritten;
        }
        return node;
    }

    public void addChild(T node) {
        this.setChild((ASTNode)node, this.getNumChildNoTransform());
    }

    public T getChildNoTransform(int i) {
        if (this.children == null) {
            return null;
        }
        ASTNode child = this.children[i];
        return (T)child;
    }

    protected int numChildren() {
        return this.numChildren;
    }

    public int getNumChild() {
        return this.numChildren();
    }

    public final int getNumChildNoTransform() {
        return this.numChildren();
    }

    public void setChild(ASTNode node, int i) {
        if (this.children == null) {
            this.children = new ASTNode[i + 1 > 4 || !(this instanceof List) ? i + 1 : 4];
        } else if (i >= this.children.length) {
            ASTNode[] c = new ASTNode[i << 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = node;
        if (i >= this.numChildren) {
            this.numChildren = i + 1;
        }
        if (node != null) {
            node.setParent(this);
            node.childIndex = i;
        }
    }

    public void insertChild(ASTNode node, int i) {
        if (this.children == null) {
            this.children = new ASTNode[i + 1 > 4 || !(this instanceof List) ? i + 1 : 4];
            this.children[i] = node;
        } else {
            ASTNode[] c = new ASTNode[this.children.length + 1];
            System.arraycopy(this.children, 0, c, 0, i);
            c[i] = node;
            if (i < this.children.length) {
                System.arraycopy(this.children, i, c, i + 1, this.children.length - i);
                for (int j = i + 1; j < c.length; ++j) {
                    if (c[j] == null) continue;
                    c[j].childIndex = j;
                }
            }
            this.children = c;
        }
        ++this.numChildren;
        if (node != null) {
            node.setParent(this);
            node.childIndex = i;
        }
    }

    public void removeChild(int i) {
        if (this.children != null) {
            ASTNode child = this.children[i];
            if (child != null) {
                child.parent = null;
                child.childIndex = -1;
            }
            if (this instanceof List || this instanceof Opt) {
                System.arraycopy(this.children, i + 1, this.children, i, this.children.length - i - 1);
                this.children[this.children.length - 1] = null;
                --this.numChildren;
                for (int j = i; j < this.numChildren; ++j) {
                    if (this.children[j] == null) continue;
                    child = this.children[j];
                    child.childIndex = j;
                }
            } else {
                this.children[i] = null;
            }
        }
    }

    public ASTNode getParent() {
        return this.parent;
    }

    public void setParent(ASTNode node) {
        this.parent = node;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public short getStartColumn() {
        return this.startColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public short getEndColumn() {
        return this.endColumn;
    }

    public void setStart(int startLine, short startColumn) {
        this.startLine = startLine;
        this.startColumn = startColumn;
    }

    public void setEnd(int endLine, short endColumn) {
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void flushTreeCache() {
        this.flushCache();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] == null) continue;
                this.children[i].flushTreeCache();
            }
        }
    }

    public void flushCache() {
        this.flushAttrAndCollectionCache();
    }

    public void flushAttrAndCollectionCache() {
        this.flushAttrCache();
        this.flushCollectionCache();
    }

    public void flushAttrCache() {
        this.program_reset();
    }

    public void flushCollectionCache() {
    }

    public ASTNode<T> clone() throws CloneNotSupportedException {
        ASTNode node = (ASTNode)super.clone();
        node.flushAttrAndCollectionCache();
        return node;
    }

    public ASTNode<T> copy() {
        try {
            Object node = this.clone();
            ((ASTNode)node).parent = null;
            if (this.children != null) {
                ((ASTNode)node).children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    @Deprecated
    public ASTNode<T> fullCopy() {
        return this.treeCopyNoTransform();
    }

    public ASTNode<T> treeCopyNoTransform() {
        ASTNode<T> tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode<T> child = this.children[i];
                if (child == null) continue;
                child = child.treeCopyNoTransform();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    public ASTNode<T> treeCopy() {
        ASTNode<T> tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                Object child = this.getChild(i);
                if (child == null) continue;
                child = ((ASTNode)child).treeCopy();
                tree.setChild((ASTNode)child, i);
            }
        }
        return tree;
    }

    public void doFullTraversal() {
        for (int i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).doFullTraversal();
        }
    }

    protected boolean is$Equal(ASTNode n1, ASTNode n2) {
        if (n1 == null && n2 == null) {
            return true;
        }
        if (n1 == null || n2 == null) {
            return false;
        }
        return n1.is$Equal(n2);
    }

    protected boolean is$Equal(ASTNode node) {
        if (this.getClass() != node.getClass()) {
            return false;
        }
        if (this.numChildren != node.numChildren) {
            return false;
        }
        for (int i = 0; i < this.numChildren; ++i) {
            if (this.children[i] == null && node.children[i] != null) {
                return false;
            }
            if (this.children[i].is$Equal(node.children[i])) continue;
            return false;
        }
        return true;
    }

    protected void collect_contributors_Program_errors(Program _root, Map<ASTNode, Set<ASTNode>> _map) {
        for (int i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).collect_contributors_Program_errors(_root, _map);
        }
    }

    protected void contributeTo_Program_errors(Set<ErrorMessage> collection) {
    }

    protected void collect_contributors_TypeDecl_relationComponents(Program _root, Map<ASTNode, Set<ASTNode>> _map) {
        for (int i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).collect_contributors_TypeDecl_relationComponents(_root, _map);
        }
    }

    protected void contributeTo_TypeDecl_relationComponents(Set<RelationComponent> collection) {
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.INH)
    @ASTNodeAnnotation.Source(aspect="HelpAttributes", declaredAt="/home/jm/work/git/relast/src/main/jastadd/Errors.jrag:40")
    public Program program() {
        ASTState state = this.state();
        if (this.program_computed == ASTState.NON_CYCLE || this.program_computed == this.state().cycle()) {
            return this.program_value;
        }
        if (this.program_visited) {
            throw new RuntimeException("Circular definition of attribute ASTNode.program().");
        }
        this.program_visited = true;
        this.program_value = this.getParent().Define_program(this, null);
        this.program_computed = this.state().inCircle() ? this.state().cycle() : ASTState.NON_CYCLE;
        this.program_visited = false;
        return this.program_value;
    }

    private void program_reset() {
        this.program_computed = null;
        this.program_value = null;
        this.program_visited = false;
    }

    public ASTNode rewriteTo() {
        return this;
    }

    public boolean canRewrite() {
        return false;
    }

    public Relation Define_relation(ASTNode _callerNode, ASTNode _childNode) {
        ASTNode self = this;
        ASTNode parent = this.getParent();
        while (parent != null && !parent.canDefine_relation(self, _callerNode)) {
            _callerNode = self;
            self = parent;
            parent = self.getParent();
        }
        return parent.Define_relation(self, _callerNode);
    }

    protected boolean canDefine_relation(ASTNode _callerNode, ASTNode _childNode) {
        return false;
    }

    public Program Define_program(ASTNode _callerNode, ASTNode _childNode) {
        ASTNode self = this;
        ASTNode parent = this.getParent();
        while (parent != null && !parent.canDefine_program(self, _callerNode)) {
            _callerNode = self;
            self = parent;
            parent = self.getParent();
        }
        return parent.Define_program(self, _callerNode);
    }

    protected boolean canDefine_program(ASTNode _callerNode, ASTNode _childNode) {
        return false;
    }

    public boolean Define_isToken(ASTNode _callerNode, ASTNode _childNode) {
        ASTNode self = this;
        ASTNode parent = this.getParent();
        while (parent != null && !parent.canDefine_isToken(self, _callerNode)) {
            _callerNode = self;
            self = parent;
            parent = self.getParent();
        }
        return parent.Define_isToken(self, _callerNode);
    }

    protected boolean canDefine_isToken(ASTNode _callerNode, ASTNode _childNode) {
        return false;
    }

    public TypeDecl Define_lookupType(ASTNode _callerNode, ASTNode _childNode, String name) {
        ASTNode self = this;
        ASTNode parent = this.getParent();
        while (parent != null && !parent.canDefine_lookupType(self, _callerNode, name)) {
            _callerNode = self;
            self = parent;
            parent = self.getParent();
        }
        return parent.Define_lookupType(self, _callerNode, name);
    }

    protected boolean canDefine_lookupType(ASTNode _callerNode, ASTNode _childNode, String name) {
        return false;
    }

    public boolean Define_isTargetOfRightDirection(ASTNode _callerNode, ASTNode _childNode) {
        ASTNode self = this;
        ASTNode parent = this.getParent();
        while (parent != null && !parent.canDefine_isTargetOfRightDirection(self, _callerNode)) {
            _callerNode = self;
            self = parent;
            parent = self.getParent();
        }
        return parent.Define_isTargetOfRightDirection(self, _callerNode);
    }

    protected boolean canDefine_isTargetOfRightDirection(ASTNode _callerNode, ASTNode _childNode) {
        return false;
    }

    public TypeDecl Define_enclosingTypeDecl(ASTNode _callerNode, ASTNode _childNode) {
        ASTNode self = this;
        ASTNode parent = this.getParent();
        while (parent != null && !parent.canDefine_enclosingTypeDecl(self, _callerNode)) {
            _callerNode = self;
            self = parent;
            parent = self.getParent();
        }
        return parent.Define_enclosingTypeDecl(self, _callerNode);
    }

    protected boolean canDefine_enclosingTypeDecl(ASTNode _callerNode, ASTNode _childNode) {
        return false;
    }

    public RelationComponent Define_otherSide(ASTNode _callerNode, ASTNode _childNode) {
        ASTNode self = this;
        ASTNode parent = this.getParent();
        while (parent != null && !parent.canDefine_otherSide(self, _callerNode)) {
            _callerNode = self;
            self = parent;
            parent = self.getParent();
        }
        return parent.Define_otherSide(self, _callerNode);
    }

    protected boolean canDefine_otherSide(ASTNode _callerNode, ASTNode _childNode) {
        return false;
    }

    public Component Define_lookupComponent(ASTNode _callerNode, ASTNode _childNode, TypeDecl td, String name) {
        ASTNode self = this;
        ASTNode parent = this.getParent();
        while (parent != null && !parent.canDefine_lookupComponent(self, _callerNode, td, name)) {
            _callerNode = self;
            self = parent;
            parent = self.getParent();
        }
        return parent.Define_lookupComponent(self, _callerNode, td, name);
    }

    protected boolean canDefine_lookupComponent(ASTNode _callerNode, ASTNode _childNode, TypeDecl td, String name) {
        return false;
    }

    public ASTNode rewrittenNode() {
        throw new Error("rewrittenNode is undefined for ASTNode");
    }
}

