/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.tinytemplate.fragment;

import java.io.PrintStream;
import org.jastadd.tinytemplate.EmptyTemplate;
import org.jastadd.tinytemplate.Indentation;
import org.jastadd.tinytemplate.Template;
import org.jastadd.tinytemplate.TemplateContext;
import org.jastadd.tinytemplate.TemplateParser;
import org.jastadd.tinytemplate.fragment.AbstractFragment;

public class Conditional
extends AbstractFragment {
    private String condition;
    private final Template thenPart;
    private final Template elsePart;
    private final boolean negated;
    private final boolean isAttribute;

    public Conditional(String condition, Template thenPart) throws TemplateParser.SyntaxError {
        this(condition, thenPart, EmptyTemplate.INSTANCE);
    }

    public Conditional(String cond, Template thenPart, Template elsePart) throws TemplateParser.SyntaxError {
        if (cond.startsWith("!")) {
            this.negated = true;
            cond = cond.substring(1).trim();
        } else {
            this.negated = false;
        }
        if (cond.startsWith("#")) {
            this.isAttribute = true;
            this.condition = cond.substring(1);
        } else if (cond.startsWith("$")) {
            this.isAttribute = false;
            this.condition = cond.substring(1);
        } else {
            this.isAttribute = false;
            this.condition = cond;
        }
        if (cond.isEmpty()) {
            throw new TemplateParser.SyntaxError("empty if condition");
        }
        if (this.isAttribute) {
            TemplateParser.acceptAttributeName(-1, this.condition);
        } else {
            TemplateParser.acceptVariableName(-1, this.condition);
        }
        this.thenPart = thenPart;
        this.thenPart.trimTrailingEmptyLine();
        this.elsePart = elsePart;
        this.elsePart.trimTrailingEmptyLine();
    }

    private boolean evalCondition(TemplateContext context) {
        Object value = this.isAttribute ? context.evalAttribute(this.condition) : context.evalVariable(this.condition);
        boolean result = value.toString().equals("true");
        return this.negated ? !result : result;
    }

    @Override
    public void expand(TemplateContext context, StringBuilder out) {
        if (this.evalCondition(context)) {
            this.thenPart.expand(context, out);
        } else {
            this.elsePart.expand(context, out);
        }
    }

    @Override
    public boolean isConditional() {
        return true;
    }

    @Override
    public boolean isExpansion() {
        return true;
    }

    @Override
    public void printAspectCode(Indentation ind, int lvl, PrintStream out) {
        out.print(ind.get(lvl) + "if (");
        if (this.negated) {
            out.print("!");
        }
        if (this.isAttribute) {
            out.print(this.condition + "()");
        } else {
            out.print("get" + this.condition + "()");
        }
        out.println(") {");
        this.thenPart.printITD(ind, lvl + 1, out);
        if (!this.elsePart.isEmpty()) {
            out.println(ind.get(lvl) + "} else {");
            this.elsePart.printITD(ind, lvl + 1, out);
        }
        out.println(ind.get(lvl) + "}");
    }
}

