/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.tinytemplate;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jastadd.tinytemplate.Indentation;
import org.jastadd.tinytemplate.Template;
import org.jastadd.tinytemplate.TemplateContext;
import org.jastadd.tinytemplate.TemplateExpansionWarning;
import org.jastadd.tinytemplate.TemplateParser;

public class TinyTemplate
extends TemplateContext {
    private Indentation indentation = new Indentation("  ");
    private final Map<String, Template> templates = new HashMap<String, Template>();
    private static boolean throwExceptions = false;
    private static boolean printWarnings = true;

    public TinyTemplate() {
    }

    public TinyTemplate(InputStream in) throws TemplateParser.SyntaxError {
        this.loadTemplates(in);
    }

    public TinyTemplate(String string) throws TemplateParser.SyntaxError {
        this.loadTemplates(string);
    }

    public static void throwExceptions(boolean b) {
        throwExceptions = b;
    }

    public static void printWarnings(boolean b) {
        printWarnings = b;
    }

    @Override
    public void expand(TemplateContext tc, String templateName, PrintStream out) {
        Template temp = this.lookupTemplate(templateName);
        if (temp != null) {
            try {
                temp.expand(tc, out);
            }
            catch (TemplateExpansionWarning e) {
                TinyTemplate.templateExpansionProblem(templateName, e);
            }
        }
    }

    @Override
    public void expand(TemplateContext tc, String templateName, PrintWriter out) {
        Template temp = this.lookupTemplate(templateName);
        if (temp != null) {
            try {
                temp.expand(tc, out);
            }
            catch (TemplateExpansionWarning e) {
                TinyTemplate.templateExpansionProblem(templateName, e);
            }
        }
    }

    @Override
    public void expand(TemplateContext tc, String templateName, StringBuffer out) {
        Template temp = this.lookupTemplate(templateName);
        if (temp != null) {
            try {
                temp.expand(tc, out);
            }
            catch (TemplateExpansionWarning e) {
                TinyTemplate.templateExpansionProblem(templateName, e);
            }
        }
    }

    @Override
    public void expand(TemplateContext tc, String templateName, StringBuilder out) {
        Template temp = this.lookupTemplate(templateName);
        if (temp != null) {
            try {
                temp.expand(tc, out);
            }
            catch (TemplateExpansionWarning e) {
                TinyTemplate.templateExpansionProblem(templateName, e);
            }
        }
    }

    private static void templateExpansionProblem(String template, TemplateExpansionWarning e) {
        throw new TemplateExpansionWarning("while expanding template '" + template + "': " + e.getProblem());
    }

    private Template lookupTemplate(String name) {
        Template temp = this.templates.get(name);
        if (temp == null) {
            TinyTemplate.expansionWarning("unknown template '" + name + "'");
        }
        return temp;
    }

    @Override
    public void flushVariables() {
    }

    @Override
    public void bind(String varName, Object value) {
        throw new UnsupportedOperationException("Can not bind variable on root template context");
    }

    @Override
    public void bind(String varName, boolean value) {
        throw new UnsupportedOperationException("Can not bind variable on root template context");
    }

    @Override
    public Object evalVariable(String varName) {
        String msg = "unbound variable '" + varName + "'";
        return TinyTemplate.expansionWarning(msg);
    }

    public void loadTemplates(InputStream in) throws TemplateParser.SyntaxError {
        TemplateParser parser = new TemplateParser(this, in);
        parser.parse();
    }

    public void loadTemplates(String str) throws TemplateParser.SyntaxError {
        TemplateParser parser = new TemplateParser(this, new ByteArrayInputStream(str.getBytes()));
        parser.parse();
    }

    public void addTemplate(String templateName, Template template) {
        this.templates.put(templateName, template);
    }

    @Override
    public Object evalAttribute(String attribute) {
        return TinyTemplate.evalAttribute(attribute, null);
    }

    public static Object evalAttribute(String attribute, Object context) {
        try {
            if (context == null) {
                String msg = "failed to eval " + attribute + "; reason: no context";
                return TinyTemplate.expansionWarning(msg);
            }
            Method method = context.getClass().getMethod(attribute, new Class[0]);
            return method.invoke(context, new Object[0]);
        }
        catch (SecurityException e) {
            String msg = "failed to eval attribute '" + attribute + "'; reason: security exception";
            return TinyTemplate.expansionWarning(msg);
        }
        catch (NoSuchMethodException e) {
            String msg = "failed to eval attribute '" + attribute + "'; reason: no such method";
            return TinyTemplate.expansionWarning(msg);
        }
        catch (IllegalArgumentException e) {
            String msg = "failed to eval attribute '" + attribute + "'; reason: illegal argument exception";
            return TinyTemplate.expansionWarning(msg);
        }
        catch (IllegalAccessException e) {
            String msg = "failed to eval attribute '" + attribute + "'; reason: illegal access exception";
            return TinyTemplate.expansionWarning(msg);
        }
        catch (InvocationTargetException e) {
            String msg = "failed to eval attribute '" + attribute + "'; reason: invocation target exception (" + e.getTargetException().getMessage() + ")";
            return TinyTemplate.expansionWarning(msg);
        }
    }

    private static String expansionWarning(String msg) {
        if (throwExceptions) {
            throw new TemplateExpansionWarning(msg);
        }
        if (printWarnings) {
            System.err.println("Template expansion warning: " + msg);
        }
        return "<" + msg + ">";
    }

    @Override
    public String evalIndentation(int levels) {
        return this.indentation.get(levels);
    }

    public void setIndentation(String indent) {
        this.indentation = new Indentation(indent);
    }

    public void printTemplateAspect(PrintStream out) {
        Indentation ind = new Indentation("\t");
        out.println("aspect TemplateAspect {");
        for (Map.Entry<String, Template> entry : this.templates.entrySet()) {
            String name = entry.getKey();
            Template template = entry.getValue();
            out.println(ind.get(1) + "public void " + name + ".prettyPrint(PrettyPrinter out) {");
            template.printITD(ind, 2, out);
            out.println(ind.get(1) + "}");
        }
        out.println("}");
    }
}

