/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.tinytemplate;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import org.jastadd.io.LookaheadReader;
import org.jastadd.tinytemplate.Indentation;
import org.jastadd.tinytemplate.Template;
import org.jastadd.tinytemplate.TinyTemplate;
import org.jastadd.tinytemplate.fragment.AttributeReference;
import org.jastadd.tinytemplate.fragment.Concat;
import org.jastadd.tinytemplate.fragment.Conditional;
import org.jastadd.tinytemplate.fragment.EmptyFragment;
import org.jastadd.tinytemplate.fragment.Fragment;
import org.jastadd.tinytemplate.fragment.Include;
import org.jastadd.tinytemplate.fragment.NewlineFragment;
import org.jastadd.tinytemplate.fragment.StringFragment;
import org.jastadd.tinytemplate.fragment.VariableReference;

public class TemplateParser {
    private final TinyTemplate templates;
    private final LookaheadReader in;
    private int line = 1;

    public TemplateParser(TinyTemplate tt, InputStream is) {
        this.templates = tt;
        this.in = new LookaheadReader(is, 8);
    }

    public void parse() throws SyntaxError {
        try {
            while (this.in.peek() != -1) {
                this.parseTemplates();
            }
        }
        catch (IOException e) {
            throw new SyntaxError("IO error during template parsing: " + e.getMessage());
        }
    }

    private void parseTemplates() throws IOException, SyntaxError {
        LinkedList<String> names = new LinkedList<String>();
        while (true) {
            this.skipWhitespace();
            if (this.isEOF()) {
                if (names.isEmpty()) break;
                throw new SyntaxError(this.line, "missing template body at end of file");
            }
            if (this.isNewline()) {
                this.skipNewline();
                continue;
            }
            if (this.isLineComment()) {
                this.skipLinecomment();
                continue;
            }
            if (this.isAssign()) {
                if (names.isEmpty()) {
                    throw new SyntaxError(this.line, "misplaced '='");
                }
                this.in.pop();
                continue;
            }
            if (this.isTemplateStart()) {
                if (names.isEmpty()) {
                    throw new SyntaxError(this.line, "missing template name");
                }
                Template template = this.parseTemplate();
                for (String name : names) {
                    this.templates.addTemplate(name, template);
                }
                names.clear();
                continue;
            }
            if (this.in.peek() == 91 || this.in.peek() == 93) {
                throw new SyntaxError(this.line, "found bracket outside template body: '" + (char)this.in.peek() + "'");
            }
            names.add(this.nextName());
        }
    }

    private void skipLinecomment() throws IOException {
        this.in.pop();
        while (!this.isNewline() && !this.isEOF()) {
            this.in.pop();
        }
    }

    private void skipWhitespace() throws IOException {
        while (this.isWhitespace()) {
            this.in.pop();
        }
    }

    private void skipIndentation() throws IOException {
        this.in.pop();
        this.in.pop();
    }

    private boolean isTemplateStart() throws IOException, SyntaxError {
        return this.in.peek() == 91 && this.in.peek(1) == 91;
    }

    private boolean isIndentation() throws IOException {
        return this.in.peek() == 32 && this.in.peek(1) == 32;
    }

    private boolean isTemplateEnd() throws IOException {
        return this.in.peek() == 93 && this.in.peek(1) == 93 && this.in.peek(2) != 93;
    }

    private boolean isAssign() throws IOException {
        return this.in.peek() == 61;
    }

    private boolean isLineComment() throws IOException {
        return this.in.peek() == 35;
    }

    private boolean isWhitespace() throws IOException {
        return Character.isWhitespace(this.in.peek()) && !this.isNewline();
    }

    private boolean isNewline() throws IOException {
        return this.isNewline(this.in.peek());
    }

    private boolean isNewline(int ch) throws IOException {
        return ch == 10 || ch == 13;
    }

    private boolean isEOF() throws IOException {
        return this.in.peek() == -1;
    }

    private void skipNewline() throws IOException {
        if (this.in.peek() == 92) {
            this.in.pop();
        }
        if (this.in.peek() == 13 && this.in.peek(1) == 10) {
            this.in.pop();
        }
        this.in.pop();
        ++this.line;
    }

    private String nextName() throws IOException, SyntaxError {
        StringBuilder name = new StringBuilder();
        while (!(this.isWhitespace() || this.isAssign() || this.isTemplateStart() || this.isEOF())) {
            name.append((char)this.in.pop());
        }
        return name.toString();
    }

    private Template parseTemplate() throws IOException, SyntaxError {
        Fragment nextFragment;
        this.in.consume(2);
        Template template = new Template();
        boolean newLine = true;
        while (!(nextFragment = this.nextFragment(template, newLine)).isEmpty()) {
            if (nextFragment.isKeyword("else")) {
                throw new SyntaxError(this.line, "stray $else");
            }
            if (nextFragment.isKeyword("endif")) {
                throw new SyntaxError(this.line, "stray $endif");
            }
            newLine = nextFragment.isNewline();
            template.addFragment(nextFragment);
        }
        this.in.consume(2);
        template.trim();
        return template;
    }

    private Fragment nextFragment(Template template, boolean newLine) throws IOException, SyntaxError {
        if (this.isEOF()) {
            throw new SyntaxError(this.line, "unexpected end of file while parsing template body");
        }
        if (newLine) {
            int levels = 0;
            while (this.isIndentation()) {
                this.skipIndentation();
                ++levels;
            }
            if (levels > 0) {
                return Indentation.getFragment(levels);
            }
        }
        if (this.isKeyword("if")) {
            return this.parseIfStmt();
        }
        if (this.isKeyword("include")) {
            Include include = this.parseIncludeStmt();
            template.addIndentation(include);
            return include;
        }
        if (this.isKeyword("cat")) {
            Concat cat = this.parseConcatStmt();
            template.addIndentation(cat);
            return cat;
        }
        if (this.isVariable()) {
            String var = this.nextReference();
            if (var.isEmpty()) {
                throw new SyntaxError(this.line, "empty variable name");
            }
            TemplateParser.acceptVariableName(this.line, var);
            VariableReference ref = new VariableReference(var);
            template.addIndentation(ref);
            return ref;
        }
        if (this.isAttribute()) {
            String attr = this.nextReference();
            if (attr.isEmpty()) {
                throw new SyntaxError(this.line, "empty attribute name");
            }
            TemplateParser.acceptAttributeName(this.line, attr);
            AttributeReference ref = new AttributeReference(attr);
            template.addIndentation(ref);
            return ref;
        }
        if (this.isNewline()) {
            this.skipNewline();
            return NewlineFragment.INSTANCE;
        }
        if (this.isTemplateEnd()) {
            return EmptyFragment.INSTANCE;
        }
        return new StringFragment(this.nextString());
    }

    private boolean isKeyword(String keyword) throws IOException {
        if (this.in.peek() != 36 && this.in.peek() != 35) {
            return false;
        }
        for (int i = 0; i < keyword.length(); ++i) {
            if (this.in.peek(i + 1) == keyword.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private Conditional parseIfStmt() throws IOException, SyntaxError {
        Template elsePart;
        Template thenPart;
        String condition;
        block4: {
            Fragment nextFragment;
            this.in.consume(3);
            condition = this.parseCondition();
            thenPart = new Template();
            elsePart = new Template();
            Template part = thenPart;
            boolean newLine = true;
            boolean haveElse = false;
            while (!(nextFragment = this.nextFragment(part, newLine)).isEmpty()) {
                if (nextFragment.isKeyword("else")) {
                    if (haveElse) {
                        throw new SyntaxError(this.line, "too many $else");
                    }
                    haveElse = true;
                    part = elsePart;
                    continue;
                }
                if (!nextFragment.isKeyword("endif")) {
                    newLine = nextFragment.isNewline();
                    part.addFragment(nextFragment);
                    continue;
                }
                break block4;
            }
            throw new SyntaxError(this.line, "missing $endif");
        }
        thenPart.trim();
        elsePart.trim();
        return new Conditional(condition, thenPart, elsePart);
    }

    private Concat parseConcatStmt() throws IOException, SyntaxError {
        this.in.consume(4);
        this.skipWhitespace();
        if (this.in.peek() != 40) {
            throw new SyntaxError(this.line, "missing cat parameters");
        }
        this.in.pop();
        char c = this.acceptAlternatives('$', '#');
        String iterable = c + this.parseSimpleReference().trim();
        this.skipWhitespace();
        String sep = "";
        if (this.in.peek() == 44) {
            this.in.pop();
            this.skipWhitespace();
            sep = this.parseStringLiteral();
        }
        this.accept(')');
        return new Concat(iterable, sep);
    }

    private char accept(char c) throws SyntaxError, IOException {
        return this.acceptAlternatives(c);
    }

    private char acceptAlternatives(char ... cs) throws IOException, SyntaxError {
        for (char c : cs) {
            if (this.in.peek() != c) continue;
            this.in.pop();
            return c;
        }
        throw new SyntaxError(this.line, "wanted: " + Arrays.toString(cs) + ", got: " + (char)this.in.peek());
    }

    private Include parseIncludeStmt() throws IOException, SyntaxError {
        this.in.consume(8);
        this.skipWhitespace();
        if (this.in.peek() != 40) {
            throw new SyntaxError(this.line, "missing template name");
        }
        String template = this.parseParenthesizedReference().trim();
        return new Include(template);
    }

    private String parseCondition() throws IOException, SyntaxError {
        this.skipWhitespace();
        if (this.in.peek() != 40) {
            throw new SyntaxError(this.line, "missing if condition");
        }
        return this.parseParenthesizedReference().trim();
    }

    private String parseStringLiteral() throws IOException, SyntaxError {
        StringBuilder sb = new StringBuilder();
        this.accept('\"');
        boolean escaped = false;
        while (!this.isStringLiteralEnd(escaped)) {
            escaped = this.in.peek() == 92 && this.in.peek(1) == 34;
            sb.append((char)this.in.pop());
        }
        this.accept('\"');
        return sb.toString();
    }

    private boolean isStringLiteralEnd(boolean escaped) throws IOException {
        return this.isEOF() || this.in.peek() == 34 && !escaped;
    }

    private String nextString() throws IOException, SyntaxError {
        StringBuilder buf = new StringBuilder(512);
        while (!(this.isEOF() || this.isVariable() || this.isAttribute() || this.isNewline() || this.isTemplateEnd())) {
            if (this.in.peek() == 35 || this.in.peek() == 36) {
                this.in.pop();
            }
            buf.append((char)this.in.pop());
        }
        return buf.toString();
    }

    private String nextReference() throws IOException, SyntaxError {
        this.in.pop();
        if (this.in.peek() == 40) {
            return this.parseParenthesizedReference();
        }
        return this.parseSimpleReference();
    }

    private String parseSimpleReference() throws IOException, SyntaxError {
        StringBuilder buf = new StringBuilder(128);
        while (!this.isSimpleReferenceEnd()) {
            buf.append((char)this.in.pop());
        }
        return buf.toString();
    }

    private boolean isSimpleReferenceEnd() throws IOException {
        return this.isEOF() || this.in.peek() == 36 || !Character.isJavaIdentifierPart(this.in.peek());
    }

    private boolean isParenthesizedReferenceEnd() throws IOException {
        return this.isEOF() || this.isNewline() || this.in.peek() == 91 || this.in.peek() == 93;
    }

    private String parseParenthesizedReference() throws IOException, SyntaxError {
        this.in.pop();
        StringBuilder buf = new StringBuilder(128);
        int depth = 1;
        while (true) {
            if (this.isParenthesizedReferenceEnd()) {
                throw new SyntaxError(this.line, "missing right parenthesis");
            }
            int c = this.in.pop();
            if (c == 40) {
                ++depth;
            } else if (c == 41 && --depth == 0) break;
            buf.append((char)c);
        }
        return buf.toString();
    }

    private boolean isVariable() throws IOException {
        return this.in.peek() == 36 && !this.isEscapable(this.in.peek(1));
    }

    private boolean isAttribute() throws IOException {
        return this.in.peek() == 35 && this.in.peek(1) != 35;
    }

    private boolean isEscapable(int chr) {
        return chr == 36 || chr == 93;
    }

    public static void acceptVariableName(int line, String var) throws SyntaxError {
        for (int i = 0; i < var.length(); ++i) {
            char ch = var.charAt(i);
            if (Character.isJavaIdentifierPart(ch) || ch == '.') continue;
            String msg = "illegal characters in variable name '" + var + "'";
            if (line == -1) {
                throw new SyntaxError(msg);
            }
            throw new SyntaxError(line, msg);
        }
    }

    public static void acceptAttributeName(int line, String attr) throws SyntaxError {
        for (int i = 0; i < attr.length(); ++i) {
            char ch = attr.charAt(i);
            if ((i != 0 || Character.isJavaIdentifierStart(ch)) && Character.isJavaIdentifierPart(ch)) continue;
            String msg = "the attribute name '" + attr + "' is not a valid Java identifier";
            if (line == -1) {
                throw new SyntaxError(msg);
            }
            throw new SyntaxError(line, msg);
        }
    }

    public static class SyntaxError
    extends Exception {
        public SyntaxError(int line, String msg) {
            super("Syntax error at line " + line + ": " + msg);
        }

        public SyntaxError(String msg) {
            super(msg);
        }
    }
}

