/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.tinytemplate;

import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.jastadd.tinytemplate.DumbContext;
import org.jastadd.tinytemplate.Indentation;
import org.jastadd.tinytemplate.TemplateContext;
import org.jastadd.tinytemplate.fragment.Fragment;
import org.jastadd.tinytemplate.fragment.NestedIndentationFragment;

public class Template {
    private final List<List<Fragment>> lines = new ArrayList<List<Fragment>>();

    public Template() {
        this.lines.add(new ArrayList());
    }

    public void expand(TemplateContext context, PrintStream out) {
        StringBuilder buf = new StringBuilder();
        for (List<Fragment> line : this.lines) {
            this.expandLine(context, line, buf);
            out.print(buf.toString());
        }
    }

    public void expand(TemplateContext context, PrintWriter out) {
        StringBuilder buf = new StringBuilder();
        for (List<Fragment> line : this.lines) {
            this.expandLine(context, line, buf);
            out.print(buf.toString());
        }
    }

    public void expand(TemplateContext context, StringBuffer out) {
        StringBuilder buf = new StringBuilder();
        for (List<Fragment> line : this.lines) {
            this.expandLine(context, line, buf);
            out.append(buf.toString());
        }
    }

    public void expand(TemplateContext context, StringBuilder out) {
        StringBuilder buf = new StringBuilder();
        for (List<Fragment> line : this.lines) {
            this.expandLine(context, line, buf);
            out.append(buf.toString());
        }
    }

    private void expandLine(TemplateContext context, List<Fragment> line, StringBuilder buf) {
        buf.setLength(0);
        boolean expanded = false;
        for (Fragment fragment : line) {
            expanded |= fragment.isExpansion();
            fragment.expand(context, buf);
        }
        if (expanded && this.isEmptyLine(buf)) {
            buf.setLength(0);
        }
    }

    private boolean isEmptyLine(StringBuilder buf) {
        for (int i = 0; i < buf.length(); ++i) {
            if (Character.isWhitespace(buf.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static void load(InputStream in) {
    }

    public void addIndentation(NestedIndentationFragment fragment) {
        List<Fragment> lastLine = this.lines.get(this.lines.size() - 1);
        if (!lastLine.isEmpty() && lastLine.get(0).isIndentation()) {
            fragment.setIndentation((Indentation.IndentationFragment)lastLine.get(0));
        }
    }

    public void addFragment(Fragment fragment) {
        this.lines.get(this.lines.size() - 1).add(fragment);
        if (fragment.isNewline()) {
            this.lines.add(new ArrayList());
        }
    }

    public void trim() {
        this.trimLeadingEmptyLine();
        this.trimConditionalWhitespace();
    }

    private void trimLeadingEmptyLine() {
        this.trimLineIfEmpty(0);
    }

    public void trimTrailingEmptyLine() {
        this.trimLineIfEmpty(this.lines.size() - 1);
    }

    private void trimLineIfEmpty(int line) {
        List<Fragment> prevLine;
        int last;
        for (Fragment fragment : this.lines.get(line)) {
            if (fragment.isWhitespace()) continue;
            return;
        }
        this.lines.remove(line);
        if (line > 0 && (last = (prevLine = this.lines.get(line - 1)).size() - 1) >= 0 && prevLine.get(last).isNewline()) {
            prevLine.remove(last);
            if (last == 0) {
                this.lines.remove(line - 1);
            }
        }
        if (this.lines.isEmpty()) {
            this.lines.add(new ArrayList());
        }
    }

    private void trimConditionalWhitespace() {
        for (int i = 0; i < this.lines.size(); ++i) {
            boolean trimmable = true;
            boolean hasCond = false;
            for (Fragment fragment : this.lines.get(i)) {
                if (!fragment.isWhitespace() && !fragment.isConditional() || fragment.isConditional() && hasCond) {
                    trimmable = false;
                    break;
                }
                hasCond |= fragment.isConditional();
            }
            List<Fragment> line = this.trimLine(this.lines.get(i), trimmable && hasCond);
            this.lines.set(i, line);
        }
    }

    private List<Fragment> trimLine(List<Fragment> line, boolean trimmable) {
        ArrayList<Fragment> tmp = new ArrayList<Fragment>(this.lines.size());
        for (Fragment frag : line) {
            if (trimmable && frag.isWhitespace() && !frag.isNewline()) continue;
            tmp.add(frag);
        }
        return tmp;
    }

    public void printITD(Indentation ind, int lvl, PrintStream out) {
        for (List<Fragment> line : this.lines) {
            for (Fragment fragment : line) {
                fragment.printAspectCode(ind, lvl, out);
            }
        }
    }

    public boolean isEmpty() {
        return this.lines.size() == 1 && this.lines.get(0).size() == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.expand((TemplateContext)new DumbContext(), sb);
        return sb.toString();
    }
}

