/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.option;

import java.io.PrintStream;
import org.jastadd.option.Option;

public class BooleanOption
extends Option<Boolean> {
    private boolean defaultValue;
    private boolean value;

    public BooleanOption(String optionName, String description) {
        super(optionName, description);
        this.value = this.defaultValue = false;
    }

    public BooleanOption defaultValue(boolean newDefault) {
        this.value = this.defaultValue = newDefault;
        return this;
    }

    @Override
    public void matchWithoutArg(PrintStream err) {
        this.onMatch(err);
    }

    @Override
    public void matchWithArg(PrintStream err, String arg) {
        this.onMatch(err, arg);
    }

    @Override
    protected void onMatch(PrintStream out) {
        this.reportWarnings(out);
        this.isMatched = true;
        this.value = true;
    }

    protected final void onMatch(PrintStream out, String arg) {
        this.reportWarnings(out);
        String lc = arg.toLowerCase();
        if (lc.equals("true") || lc.equals("on") || lc.equals("yes") || lc.equals("enable") || lc.equals("enabled")) {
            this.value = true;
        } else if (lc.equals("false") || lc.equals("off") || lc.equals("no") || lc.equals("disable") || lc.equals("disabled")) {
            this.value = false;
        } else {
            out.println("Warning: unknown value for option '" + this.name + "' - the argument '" + arg + "' is not a boolean value.");
        }
        this.isMatched = true;
    }

    @Override
    protected String description() {
        return this.description + " (default='" + this.defaultValue + "')";
    }

    @Override
    public Boolean value() {
        return this.value;
    }
}

