/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.jrag;

import java.io.File;
import org.jastadd.jrag.AST.SimpleNode;
import org.jastadd.jrag.SignatureUnparser;
import org.jastadd.jrag.Unparser;

public class ClassBodyObject {
    public String fileName;
    public int line;
    public SimpleNode node;
    public String refinesAspect;
    public String replaceAspect;
    public String comments;
    public String modifiers = "";
    public String aspectName;

    public ClassBodyObject(SimpleNode node, String fileName, int line, String comments, String aspectName) {
        this.fileName = fileName;
        this.line = line;
        this.node = node;
        this.comments = comments;
        this.aspectName = aspectName;
    }

    public ClassBodyObject(SimpleNode node, String fileName, int line, String aspectName) {
        this(node, fileName, line, Unparser.unparseComment(node), aspectName);
    }

    public String signature() {
        String signature = (String)this.node.jjtAccept(new SignatureUnparser(), null);
        String s = signature.replace('.', '_');
        s = s.replace('<', '_');
        s = s.replace('>', '_');
        return s;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getStartLine() {
        return this.line;
    }

    public String getAspectName() {
        return this.aspectName;
    }

    public String legacyAspectName() {
        String pattern;
        String name = this.fileName;
        if (name.endsWith(".jrag")) {
            name = name.substring(0, name.length() - 5);
        } else if (name.endsWith(".jadd")) {
            name = name.substring(0, name.length() - 5);
        } else if (name.endsWith(".ast")) {
            name = name.substring(0, name.length() - 4);
        }
        pattern = File.separator.equals("\\") ? (pattern = "\\\\") : File.separator;
        String[] names = name.split(pattern);
        return names[names.length - 1];
    }

    public String aspectName() {
        return this.getAspectName();
    }

    public String modifiers() {
        if (this.modifiers.isEmpty()) {
            return "";
        }
        return this.modifiers + " ";
    }
}

