/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.ast.AST;

import org.jastadd.ast.AST.Ast;
import org.jastadd.ast.AST.AstTreeConstants;
import org.jastadd.ast.AST.AstVisitor;
import org.jastadd.ast.AST.Node;
import org.jastadd.ast.AST.Token;

class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected Ast parser;
    public Token firstToken;
    public Token lastToken;

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(Ast p, int i) {
        this(i);
        this.parser = p;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    @Override
    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    @Override
    public Object jjtAccept(AstVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object childrenAccept(AstVisitor visitor, Object data) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].jjtAccept(visitor, data);
            }
        }
        return data;
    }

    public String toString() {
        return AstTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n == null) continue;
                n.dump(prefix + " ");
            }
        }
    }

    public void unparseComment(StringBuffer buf) {
        Token tt = this.firstToken.specialToken;
        if (tt != null) {
            while (tt.specialToken != null) {
                tt = tt.specialToken;
            }
            while (tt != null) {
                buf.append(this.addUnicodeEscapes(tt.image));
                tt = tt.next;
            }
        }
    }

    public String unparseComment() {
        StringBuffer buf = new StringBuffer();
        this.unparseComment(buf);
        return buf.toString();
    }

    private String addUnicodeEscapes(String str) {
        String retval = "";
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if ((ch < ' ' || ch > '~') && ch != '\t' && ch != '\n' && ch != '\r' && ch != '\f') {
                String s = "0000" + Integer.toString(ch, 16);
                retval = retval + "\\u" + s.substring(s.length() - 4, s.length());
                continue;
            }
            retval = retval + ch;
        }
        return retval;
    }
}

