/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.ast.AST;

import java.io.PrintStream;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jastadd.Problem;
import org.jastadd.ast.AST.ASTNode;
import org.jastadd.ast.AST.ASTNodeAnnotation;
import org.jastadd.ast.AST.Ast;
import org.jastadd.ast.AST.AstVisitor;
import org.jastadd.ast.AST.Node;
import org.jastadd.ast.AST.Rewrite;
import org.jastadd.ast.AST.TypeDecl;
import org.jastadd.jrag.AST.ASTBlock;
import org.jastadd.jrag.Unparser;
import org.jastadd.tinytemplate.TemplateContext;

public class RewriteList
extends Rewrite
implements Cloneable {
    public String parentName;
    public String childName;

    public String getParentName() {
        return this.parentName;
    }

    public void setParentName(String name) {
        this.parentName = name;
    }

    public String getChildName() {
        return this.childName;
    }

    public void setChildName(String name) {
        this.childName = name;
    }

    @Override
    public boolean genRewrite(PrintStream out, int index) {
        TemplateContext tt = this.templateContext();
        tt.expand("Rewrite.declaredat", out);
        if (this.getCondition() != null) {
            tt.bind("Condition", " && " + Unparser.unparse(this.getCondition()));
        } else {
            tt.bind("Condition", "");
        }
        tt.expand("RewriteList.genRewrite", out);
        return false;
    }

    @Override
    public void genRewritesExtra(PrintStream out, int index) {
        String ind = this.config().indent;
        String ind2 = this.config().ind(2);
        if (this.getResult() instanceof ASTBlock) {
            this.templateContext().expand("Rewrite.javaDoc:internal", out);
            out.println(ind + "private " + this.getReturnType() + " rewrite" + this.getParentName() + "_" + this.getChildName() + "() {");
            out.print(Unparser.unparse(this.getResult()));
            out.println(ind + "}");
        } else {
            this.templateContext().expand("Rewrite.javaDoc:internal", out);
            out.println(ind + "private " + this.getReturnType() + " rewrite" + this.getParentName() + "_" + this.getChildName() + "() {");
            out.println(ind2 + "return " + Unparser.unparse(this.getResult()) + ";");
            out.println(ind + "}");
        }
    }

    public RewriteList(int i) {
        super(i);
    }

    public RewriteList(Ast p, int i) {
        this(i);
        this.parser = p;
    }

    public RewriteList() {
        this(0);
    }

    @Override
    public void init$Children() {
    }

    public RewriteList(String p0, int p1, int p2, String p3) {
        this.setFileName(p0);
        this.setStartLine(p1);
        this.setEndLine(p2);
        this.setAspectName(p3);
    }

    @Override
    public void dumpTree(String indent, PrintStream out) {
        out.print(indent + "RewriteList");
        out.print("\"" + this.getFileName() + "\"");
        out.print("\"" + this.getStartLine() + "\"");
        out.print("\"" + this.getEndLine() + "\"");
        out.print("\"" + this.getAspectName() + "\"");
        String childIndent = indent + "  ";
        for (int i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).dumpTree(childIndent, out);
        }
    }

    @Override
    public Object jjtAccept(AstVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        this.checkChild(n, i);
        super.jjtAddChild(n, i);
    }

    @Override
    public void checkChild(Node n, int i) {
    }

    @Override
    public int getNumChild() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void flushAttrCache() {
        super.flushAttrCache();
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public RewriteList clone() throws CloneNotSupportedException {
        RewriteList node = (RewriteList)super.clone();
        return node;
    }

    @Override
    public RewriteList copy() {
        try {
            RewriteList node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    @Override
    @Deprecated
    public RewriteList fullCopy() {
        return this.treeCopyNoTransform();
    }

    @Override
    public RewriteList treeCopyNoTransform() {
        RewriteList tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = (ASTNode)this.children[i];
                if (child == null) continue;
                child = child.treeCopyNoTransform();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    @Override
    public RewriteList treeCopy() {
        this.doFullTraversal();
        return this.treeCopyNoTransform();
    }

    @Override
    protected boolean is$Equal(ASTNode node) {
        return super.is$Equal(node) && this.tokenString_FileName == ((RewriteList)node).tokenString_FileName && this.tokenint_StartLine == ((RewriteList)node).tokenint_StartLine && this.tokenint_EndLine == ((RewriteList)node).tokenint_EndLine && this.tokenString_AspectName == ((RewriteList)node).tokenString_AspectName;
    }

    @Override
    public void setFileName(String value) {
        this.tokenString_FileName = value;
    }

    @Override
    @ASTNodeAnnotation.Token(name="FileName")
    public String getFileName() {
        return this.tokenString_FileName != null ? this.tokenString_FileName : "";
    }

    @Override
    public void setStartLine(int value) {
        this.tokenint_StartLine = value;
    }

    @Override
    @ASTNodeAnnotation.Token(name="StartLine")
    public int getStartLine() {
        return this.tokenint_StartLine;
    }

    @Override
    public void setEndLine(int value) {
        this.tokenint_EndLine = value;
    }

    @Override
    @ASTNodeAnnotation.Token(name="EndLine")
    public int getEndLine() {
        return this.tokenint_EndLine;
    }

    @Override
    public void setAspectName(String value) {
        this.tokenString_AspectName = value;
    }

    @Override
    @ASTNodeAnnotation.Token(name="AspectName")
    public String getAspectName() {
        return this.tokenString_AspectName != null ? this.tokenString_AspectName : "";
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    @Override
    protected void collect_contributors_TypeDecl_attributeProblems(TypeDecl _root, Map<ASTNode, Set<ASTNode>> _map) {
        Set<ASTNode> contributors;
        TypeDecl target;
        if (this.config().rewriteCircularNTA()) {
            target = this.hostClass();
            contributors = _map.get(target);
            if (contributors == null) {
                contributors = new LinkedHashSet<ASTNode>();
                _map.put(target, contributors);
            }
            contributors.add(this);
        }
        if (this.config().legacyRewrite()) {
            target = this.hostClass();
            contributors = _map.get(target);
            if (contributors == null) {
                contributors = new LinkedHashSet<ASTNode>();
                _map.put(target, contributors);
            }
            contributors.add(this);
        }
        super.collect_contributors_TypeDecl_attributeProblems(_root, _map);
    }

    @Override
    protected void contributeTo_TypeDecl_attributeProblems(Collection<Problem> collection) {
        super.contributeTo_TypeDecl_attributeProblems(collection);
        if (this.config().rewriteCircularNTA()) {
            collection.add(this.error("list rewrites are not supported when using cnta rewrites"));
        }
        if (this.config().legacyRewrite()) {
            collection.add(this.warning("list rewrites are deprecated and will be removed in a future version of JastAdd"));
        }
    }
}

