/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.ast.AST;

import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jastadd.Configuration;
import org.jastadd.Problem;
import org.jastadd.ast.AST.ASTDecl;
import org.jastadd.ast.AST.ASTNode$State;
import org.jastadd.ast.AST.ASTNodeAnnotation;
import org.jastadd.ast.AST.Ast;
import org.jastadd.ast.AST.AstVisitor;
import org.jastadd.ast.AST.Grammar;
import org.jastadd.ast.AST.List;
import org.jastadd.ast.AST.Node;
import org.jastadd.ast.AST.Opt;
import org.jastadd.ast.AST.RegionDecl;
import org.jastadd.ast.AST.SimpleNode;
import org.jastadd.ast.AST.TypeDecl;
import org.jastadd.tinytemplate.SimpleContext;
import org.jastadd.tinytemplate.TemplateContext;

public class ASTNode<T extends ASTNode>
extends SimpleNode
implements Cloneable {
    private int childIndex = -1;
    public static final boolean generatedWithCacheCycle = true;
    public static final boolean generatedWithComponentCheck = false;
    private static ASTNode$State state = new ASTNode$State();
    public boolean in$Circle = false;
    public boolean is$Final = false;
    protected int numChildren;
    protected int templateContext_visited = -1;
    protected boolean templateContext_computed = false;
    protected TemplateContext templateContext_value;
    protected int grammar_visited = -1;
    protected boolean grammar_computed = false;
    protected Grammar grammar_value;
    protected int config_visited = -1;
    protected boolean config_computed = false;
    protected Configuration config_value;
    protected int parentContext_visited = -1;
    protected boolean parentContext_computed = false;
    protected TemplateContext parentContext_value;

    public void refineError(String what, String file, int line) {
        this.grammar().error("can not find " + what + " to refine\nWarning: implicitly generated methods and equations must be refined without an explicit aspect name", file, line);
    }

    public static String escapedFileName(String fileName) {
        return fileName.replace("\\u", "\\u0075").replace("\\", "\\\\").replace("\"", "\\\"");
    }

    public static String declaredat(String fileName, int line) {
        if ((fileName = fileName.trim()).length() == 0) {
            return "";
        }
        return "@declaredat " + ASTNode.sourceLocation(fileName, line);
    }

    protected static String sourceLocation(String fileName, int line) {
        return String.format("%s:%d", ASTNode.escapedFileName(fileName), line);
    }

    public static String boxedType(String type) {
        if (type.equals("int")) {
            return "Integer";
        }
        if (type.equals("short")) {
            return "Short";
        }
        if (type.equals("long")) {
            return "Long";
        }
        if (type.equals("float")) {
            return "Float";
        }
        if (type.equals("double")) {
            return "Double";
        }
        if (type.equals("boolean")) {
            return "Boolean";
        }
        if (type.equals("char")) {
            return "Character";
        }
        if (type.equals("byte")) {
            return "Byte";
        }
        return type;
    }

    public String fromReferenceType(String value, String type) {
        return "((" + ASTNode.boxedType(type) + ")" + value + ")";
    }

    public static String convTypeNameToSignature(String s) {
        s = s.replace('.', '_');
        s = s.replace(' ', '_');
        s = s.replace(',', '_');
        s = s.replace('<', '_');
        s = s.replace('>', '_');
        s = s.replace('[', '_');
        s = s.replace('?', '_');
        s = s.replace(']', 'a');
        return s;
    }

    public ASTNode(int i) {
        super(i);
        this.init$Children();
    }

    public ASTNode(Ast p, int i) {
        this(i);
        this.parser = p;
    }

    public ASTNode() {
        this(0);
    }

    public void init$Children() {
    }

    public void dumpTree(String indent, PrintStream out) {
        out.print(indent + "ASTNode");
        String childIndent = indent + "  ";
        for (int i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).dumpTree(childIndent, out);
        }
    }

    @Override
    public Object jjtAccept(AstVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        this.checkChild(n, i);
        if (i >= this.numChildren) {
            this.numChildren = i + 1;
        }
        super.jjtAddChild(n, i);
    }

    public void checkChild(Node n, int i) {
    }

    public int getIndexOfChild(ASTNode node) {
        if (node == null) {
            return -1;
        }
        if (node.childIndex >= 0 && node.childIndex < this.numChildren && node == this.children[node.childIndex]) {
            return node.childIndex;
        }
        for (int i = 0; this.children != null && i < this.children.length; ++i) {
            if (this.children[i] != node) continue;
            node.childIndex = i;
            return i;
        }
        return -1;
    }

    public final ASTNode$State state() {
        return state;
    }

    public boolean in$Circle() {
        return this.in$Circle;
    }

    public void in$Circle(boolean b) {
        this.in$Circle = b;
    }

    public boolean is$Final() {
        return this.is$Final;
    }

    public void is$Final(boolean b) {
        this.is$Final = b;
    }

    public Iterator<T> astChildIterator() {
        return new Iterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < ASTNode.this.getNumChild();
            }

            @Override
            public T next() {
                return this.hasNext() ? (Object)ASTNode.this.getChild(this.index++) : null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterable<T> astChildren() {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return ASTNode.this.astChildIterator();
            }
        };
    }

    public T getChild(int i) {
        Object node = this.getChildNoTransform(i);
        if (node == null) {
            return null;
        }
        if (((ASTNode)node).is$Final()) {
            return node;
        }
        if (!((ASTNode)node).mayHaveRewrite()) {
            ((ASTNode)node).is$Final(this.is$Final());
            return node;
        }
        if (!((ASTNode)node).in$Circle()) {
            int rewriteState;
            int _boundaries = this.state().boundariesCrossed;
            do {
                this.state().push(1);
                T oldNode = node;
                ((ASTNode)oldNode).in$Circle(true);
                node = ((ASTNode)node).rewriteTo();
                if (node != oldNode) {
                    this.setChild((ASTNode)node, i);
                }
                ((ASTNode)oldNode).in$Circle(false);
            } while ((rewriteState = this.state().pop()) == 1);
            if (rewriteState == 2 && this.is$Final()) {
                ((ASTNode)node).is$Final(true);
                this.state().boundariesCrossed = _boundaries;
            }
        } else if (this.is$Final() != ((ASTNode)node).is$Final()) {
            ++this.state().boundariesCrossed;
        }
        return node;
    }

    public void addChild(T node) {
        this.setChild((ASTNode)node, this.getNumChildNoTransform());
    }

    public final T getChildNoTransform(int i) {
        if (this.children == null) {
            return null;
        }
        ASTNode child = (ASTNode)this.children[i];
        return (T)child;
    }

    protected int numChildren() {
        return this.numChildren;
    }

    public int getNumChild() {
        return this.numChildren();
    }

    public final int getNumChildNoTransform() {
        return this.numChildren();
    }

    public void setChild(ASTNode node, int i) {
        if (this.children == null) {
            this.children = new ASTNode[i + 1 > 4 || !(this instanceof List) ? i + 1 : 4];
        } else if (i >= this.children.length) {
            ASTNode[] c = new ASTNode[i << 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = node;
        if (i >= this.numChildren) {
            this.numChildren = i + 1;
        }
        if (node != null) {
            node.setParent(this);
            node.childIndex = i;
        }
    }

    public void insertChild(ASTNode node, int i) {
        if (this.children == null) {
            this.children = new ASTNode[i + 1 > 4 || !(this instanceof List) ? i + 1 : 4];
            this.children[i] = node;
        } else {
            ASTNode[] c = new ASTNode[this.children.length + 1];
            System.arraycopy(this.children, 0, c, 0, i);
            c[i] = node;
            if (i < this.children.length) {
                System.arraycopy(this.children, i, c, i + 1, this.children.length - i);
                for (int j = i + 1; j < c.length; ++j) {
                    if (c[j] == null) continue;
                    c[j].childIndex = j;
                }
            }
            this.children = c;
        }
        ++this.numChildren;
        if (node != null) {
            node.setParent(this);
            node.childIndex = i;
        }
    }

    public void removeChild(int i) {
        if (this.children != null) {
            ASTNode child = (ASTNode)this.children[i];
            if (child != null) {
                child.parent = null;
                child.childIndex = -1;
            }
            if (this instanceof List || this instanceof Opt) {
                System.arraycopy(this.children, i + 1, this.children, i, this.children.length - i - 1);
                this.children[this.children.length - 1] = null;
                --this.numChildren;
                for (int j = i; j < this.numChildren; ++j) {
                    if (this.children[j] == null) continue;
                    child = (ASTNode)this.children[j];
                    child.childIndex = j;
                }
            } else {
                this.children[i] = null;
            }
        }
    }

    public ASTNode getParent() {
        if (this.parent != null && ((ASTNode)this.parent).is$Final() != this.is$Final()) {
            ++this.state().boundariesCrossed;
        }
        return (ASTNode)this.parent;
    }

    public void setParent(ASTNode node) {
        this.parent = node;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void flushTreeCache() {
        this.flushCache();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] == null || !((ASTNode)this.children[i]).is$Final) continue;
                ((ASTNode)this.children[i]).flushTreeCache();
            }
        }
    }

    public void flushCache() {
        this.flushAttrAndCollectionCache();
    }

    public void flushAttrAndCollectionCache() {
        this.flushAttrCache();
        this.flushCollectionCache();
    }

    public void flushAttrCache() {
        this.templateContext_reset();
        this.grammar_reset();
        this.config_reset();
        this.parentContext_reset();
    }

    public void flushCollectionCache() {
    }

    public ASTNode<T> clone() throws CloneNotSupportedException {
        ASTNode node = (ASTNode)super.clone();
        if (node.is$Final()) {
            node.flushAttrAndCollectionCache();
        }
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ASTNode<T> copy() {
        try {
            Object node = this.clone();
            ((ASTNode)node).parent = null;
            if (this.children != null) {
                ((ASTNode)node).children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    @Deprecated
    public ASTNode<T> fullCopy() {
        return this.treeCopyNoTransform();
    }

    public ASTNode<T> treeCopyNoTransform() {
        ASTNode<T> tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode<T> child = (ASTNode<T>)this.children[i];
                if (child == null) continue;
                child = child.treeCopyNoTransform();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    public ASTNode<T> treeCopy() {
        this.doFullTraversal();
        return this.treeCopyNoTransform();
    }

    public void doFullTraversal() {
        for (int i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).doFullTraversal();
        }
    }

    protected boolean is$Equal(ASTNode n1, ASTNode n2) {
        if (n1 == null && n2 == null) {
            return true;
        }
        if (n1 == null || n2 == null) {
            return false;
        }
        return n1.is$Equal(n2);
    }

    protected boolean is$Equal(ASTNode node) {
        if (this.getClass() != node.getClass()) {
            return false;
        }
        if (this.numChildren != node.numChildren) {
            return false;
        }
        for (int i = 0; i < this.numChildren; ++i) {
            if (this.children[i] == null && node.children[i] != null) {
                return false;
            }
            if (((ASTNode)this.children[i]).is$Equal((ASTNode)node.children[i])) continue;
            return false;
        }
        return true;
    }

    protected void collect_contributors_Grammar_problems(Grammar _root, Map<ASTNode, Set<ASTNode>> _map) {
        for (int i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).collect_contributors_Grammar_problems(_root, _map);
        }
    }

    protected void contributeTo_Grammar_problems(Collection<Problem> collection) {
    }

    protected void collect_contributors_TypeDecl_attributeProblems(TypeDecl _root, Map<ASTNode, Set<ASTNode>> _map) {
        for (int i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).collect_contributors_TypeDecl_attributeProblems(_root, _map);
        }
    }

    protected void contributeTo_TypeDecl_attributeProblems(Collection<Problem> collection) {
    }

    protected void collect_contributors_CollDecl_uses(Grammar _root, Map<ASTNode, Set<ASTNode>> _map) {
        for (int i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).collect_contributors_CollDecl_uses(_root, _map);
        }
    }

    protected void contributeTo_CollDecl_uses(HashSet collection) {
    }

    private void templateContext_reset() {
        this.templateContext_computed = false;
        this.templateContext_value = null;
        this.templateContext_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="TemplateUtil", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/core/TemplateUtil.jrag:36")
    public TemplateContext templateContext() {
        ASTNode$State state = this.state();
        if (this.templateContext_computed) {
            return this.templateContext_value;
        }
        if (this.templateContext_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTNode.templateContext().");
        }
        this.templateContext_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.templateContext_value = this.templateContext_compute();
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.templateContext_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.templateContext_visited = -1;
        return this.templateContext_value;
    }

    private TemplateContext templateContext_compute() {
        return new SimpleContext(this.parentContext(), this);
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.INH)
    @ASTNodeAnnotation.Source(aspect="Configuration", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/core/Options.jrag:42")
    public Grammar grammar() {
        ASTNode$State state = this.state();
        if (this.grammar_computed) {
            return this.grammar_value;
        }
        if (this.grammar_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTNode.grammar().");
        }
        this.grammar_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.grammar_value = this.getParent().Define_grammar(this, null);
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.grammar_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.grammar_visited = -1;
        return this.grammar_value;
    }

    private void grammar_reset() {
        this.grammar_computed = false;
        this.grammar_value = null;
        this.grammar_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.INH)
    @ASTNodeAnnotation.Source(aspect="Configuration", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/core/Options.jrag:56")
    public Configuration config() {
        ASTNode$State state = this.state();
        if (this.config_computed) {
            return this.config_value;
        }
        if (this.config_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTNode.config().");
        }
        this.config_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.config_value = this.getParent().Define_config(this, null);
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.config_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.config_visited = -1;
        return this.config_value;
    }

    private void config_reset() {
        this.config_computed = false;
        this.config_value = null;
        this.config_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.INH)
    @ASTNodeAnnotation.Source(aspect="TemplateUtil", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/core/TemplateUtil.jrag:32")
    public TemplateContext parentContext() {
        ASTNode$State state = this.state();
        if (this.parentContext_computed) {
            return this.parentContext_value;
        }
        if (this.parentContext_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTNode.parentContext().");
        }
        this.parentContext_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.parentContext_value = this.getParent().Define_parentContext(this, null);
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.parentContext_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.parentContext_visited = -1;
        return this.parentContext_value;
    }

    private void parentContext_reset() {
        this.parentContext_computed = false;
        this.parentContext_value = null;
        this.parentContext_visited = -1;
    }

    public ASTNode rewriteTo() {
        if (this.state().peek() == 1) {
            this.state().pop();
            this.state().push(2);
        }
        return this;
    }

    public Grammar Define_grammar(ASTNode _callerNode, ASTNode _childNode) {
        ASTNode self = this;
        ASTNode parent = this.getParent();
        while (parent != null && !parent.canDefine_grammar(self, _callerNode)) {
            _callerNode = self;
            self = parent;
            parent = self.getParent();
        }
        return parent.Define_grammar(self, _callerNode);
    }

    protected boolean canDefine_grammar(ASTNode _callerNode, ASTNode _childNode) {
        return false;
    }

    public Configuration Define_config(ASTNode _callerNode, ASTNode _childNode) {
        ASTNode self = this;
        ASTNode parent = this.getParent();
        while (parent != null && !parent.canDefine_config(self, _callerNode)) {
            _callerNode = self;
            self = parent;
            parent = self.getParent();
        }
        return parent.Define_config(self, _callerNode);
    }

    protected boolean canDefine_config(ASTNode _callerNode, ASTNode _childNode) {
        return false;
    }

    public TemplateContext Define_parentContext(ASTNode _callerNode, ASTNode _childNode) {
        ASTNode self = this;
        ASTNode parent = this.getParent();
        while (parent != null && !parent.canDefine_parentContext(self, _callerNode)) {
            _callerNode = self;
            self = parent;
            parent = self.getParent();
        }
        return parent.Define_parentContext(self, _callerNode);
    }

    protected boolean canDefine_parentContext(ASTNode _callerNode, ASTNode _childNode) {
        return false;
    }

    public Collection<ASTDecl> Define_findSubclasses(ASTNode _callerNode, ASTNode _childNode, ASTDecl target) {
        ASTNode self = this;
        ASTNode parent = this.getParent();
        while (parent != null && !parent.canDefine_findSubclasses(self, _callerNode, target)) {
            _callerNode = self;
            self = parent;
            parent = self.getParent();
        }
        return parent.Define_findSubclasses(self, _callerNode, target);
    }

    protected boolean canDefine_findSubclasses(ASTNode _callerNode, ASTNode _childNode, ASTDecl target) {
        return false;
    }

    public RegionDecl Define_lookupRegionDecl(ASTNode _callerNode, ASTNode _childNode, String name) {
        ASTNode self = this;
        ASTNode parent = this.getParent();
        while (parent != null && !parent.canDefine_lookupRegionDecl(self, _callerNode, name)) {
            _callerNode = self;
            self = parent;
            parent = self.getParent();
        }
        return parent.Define_lookupRegionDecl(self, _callerNode, name);
    }

    protected boolean canDefine_lookupRegionDecl(ASTNode _callerNode, ASTNode _childNode, String name) {
        return false;
    }

    public TypeDecl Define_hostClass(ASTNode _callerNode, ASTNode _childNode) {
        ASTNode self = this;
        ASTNode parent = this.getParent();
        while (parent != null && !parent.canDefine_hostClass(self, _callerNode)) {
            _callerNode = self;
            self = parent;
            parent = self.getParent();
        }
        return parent.Define_hostClass(self, _callerNode);
    }

    protected boolean canDefine_hostClass(ASTNode _callerNode, ASTNode _childNode) {
        return false;
    }

    public ASTNode rewrittenNode() {
        throw new Error("rewrittenNode is undefined for ASTNode");
    }
}

