/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.ast.AST;

public class ASTNode$State {
    public static final Cycle NON_CYCLE = new Cycle();
    private static final CircleState CIRCLE_BOTTOM = new CircleState(null);
    private CircleState circle = CIRCLE_BOTTOM;
    public static final int REWRITE_CHANGE = 1;
    public static final int REWRITE_NOCHANGE = 2;
    public static final int REWRITE_INTERRUPT = 3;
    public int boundariesCrossed = 0;
    private int[] stack = new int[64];
    private int pos = 0;

    protected boolean inCircle() {
        return this.circle.inCircle;
    }

    protected boolean calledByLazyAttribute() {
        return this.circle.lazyAttribute > 0;
    }

    protected void enterLazyAttribute() {
        ++this.circle.lazyAttribute;
    }

    protected void leaveLazyAttribute() {
        --this.circle.lazyAttribute;
    }

    protected void enterCircle() {
        CircleState next = new CircleState(this.circle);
        next.inCircle = true;
        this.circle = next;
    }

    protected void leaveCircle() {
        this.circle = this.circle.next;
    }

    protected Cycle nextCycle() {
        Cycle cycle;
        this.circle.cycle = cycle = new Cycle();
        return cycle;
    }

    protected Cycle cycle() {
        return this.circle.cycle;
    }

    protected CircleState currentCircle() {
        return this.circle;
    }

    protected void setChangeInCycle() {
        this.circle.change = true;
    }

    protected boolean testAndClearChangeInCycle() {
        boolean change = this.circle.change;
        this.circle.change = false;
        return change;
    }

    protected boolean changeInCycle() {
        return this.circle.change;
    }

    protected boolean lastCycle() {
        return this.circle.lastCycle;
    }

    protected void startLastCycle() {
        this.circle.lastCycle = true;
    }

    protected void startResetCycle() {
        this.circle.resetCycle = true;
    }

    protected boolean resetCycle() {
        return this.circle.resetCycle;
    }

    protected ASTNode$State() {
    }

    private void ensureSize(int size) {
        if (size < this.stack.length) {
            return;
        }
        int[] newStack = new int[this.stack.length * 2];
        System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
        this.stack = newStack;
    }

    public void push(int i) {
        this.ensureSize(this.pos + 1);
        this.stack[this.pos++] = i;
    }

    public int pop() {
        return this.stack[--this.pos];
    }

    public int peek() {
        return this.stack[this.pos - 1];
    }

    public void reset() {
        this.circle = CIRCLE_BOTTOM;
        this.boundariesCrossed = 0;
    }

    protected static class CircleState {
        final CircleState next;
        boolean inCircle = false;
        boolean resetCycle = false;
        boolean change = false;
        int lazyAttribute = 0;
        boolean lastCycle = false;
        Cycle cycle = NON_CYCLE;

        protected CircleState(CircleState next) {
            this.next = next;
        }
    }

    protected static class Cycle {
        protected Cycle() {
        }
    }

    protected static class CircularValue {
        Object value;
        Cycle cycle;

        protected CircularValue() {
        }
    }
}

