/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd.ast.AST;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jastadd.JastAdd;
import org.jastadd.Problem;
import org.jastadd.ast.AST.ASTNode;
import org.jastadd.ast.AST.ASTNode$State;
import org.jastadd.ast.AST.ASTNodeAnnotation;
import org.jastadd.ast.AST.Abstract;
import org.jastadd.ast.AST.AggregateComponent;
import org.jastadd.ast.AST.AggregateComponentNTA;
import org.jastadd.ast.AST.Annotation;
import org.jastadd.ast.AST.Ast;
import org.jastadd.ast.AST.AstVisitor;
import org.jastadd.ast.AST.AttrDecl;
import org.jastadd.ast.AST.AttrEq;
import org.jastadd.ast.AST.BlockSurveyContribution;
import org.jastadd.ast.AST.CacheMode;
import org.jastadd.ast.AST.CircularRewriteDecl;
import org.jastadd.ast.AST.ClassBodyDecl;
import org.jastadd.ast.AST.CollDecl;
import org.jastadd.ast.AST.CollEq;
import org.jastadd.ast.AST.Component;
import org.jastadd.ast.AST.CustomSurveyContribution;
import org.jastadd.ast.AST.EqSurveyContribution;
import org.jastadd.ast.AST.Grammar;
import org.jastadd.ast.AST.IdDecl;
import org.jastadd.ast.AST.IdUse;
import org.jastadd.ast.AST.InhDecl;
import org.jastadd.ast.AST.InhEq;
import org.jastadd.ast.AST.JavaDocParser;
import org.jastadd.ast.AST.List;
import org.jastadd.ast.AST.ListComponent;
import org.jastadd.ast.AST.ListComponentNTA;
import org.jastadd.ast.AST.Node;
import org.jastadd.ast.AST.Opt;
import org.jastadd.ast.AST.OptionalComponent;
import org.jastadd.ast.AST.OptionalComponentNTA;
import org.jastadd.ast.AST.Parameter;
import org.jastadd.ast.AST.RegionDecl;
import org.jastadd.ast.AST.Rewrite;
import org.jastadd.ast.AST.SurveyContribution;
import org.jastadd.ast.AST.SynDecl;
import org.jastadd.ast.AST.SynEq;
import org.jastadd.ast.AST.SynthesizedNta;
import org.jastadd.ast.AST.TokenComponent;
import org.jastadd.ast.AST.TypeDecl;
import org.jastadd.jrag.AST.ASTBlock;
import org.jastadd.jrag.AST.SimpleNode;
import org.jastadd.jrag.ClassBodyDeclUnparser;
import org.jastadd.jrag.ClassBodyObject;
import org.jastadd.jrag.Unparser;
import org.jastadd.tinytemplate.TemplateContext;

public class ASTDecl
extends TypeDecl
implements Cloneable {
    private Collection<InhDecl> missingInhEqs = null;
    public final Collection<CustomSurveyContribution> surveyContributions = new LinkedList<CustomSurveyContribution>();
    protected int copyReturnType_visited = -1;
    protected Map lookupComponent_String_visited = new HashMap(4);
    protected Map lookupComponent_String_values = new HashMap(4);
    protected int annotations_visited = -1;
    protected Map testCircular_String_visited = new HashMap(4);
    protected int isCircular_visited = -1;
    protected int superClass_visited = -1;
    protected boolean superClass_computed = false;
    protected ASTDecl superClass_value;
    protected int getSuperClassName_visited = -1;
    protected boolean getSuperClassName_computed = false;
    protected String getSuperClassName_value;
    protected int supertypes_visited = -1;
    protected boolean supertypes_computed = false;
    protected Collection<ASTDecl> supertypes_value;
    protected Map instanceOf_TypeDecl_visited = new HashMap(4);
    protected int subclasses_visited = -1;
    protected boolean subclasses_computed = false;
    protected Collection<ASTDecl> subclasses_value;
    protected int subclassesTransitive_visited = -1;
    protected boolean subclassesTransitive_computed = false;
    protected Set<ASTDecl> subclassesTransitive_value;
    protected int parents_visited = -1;
    protected boolean parents_computed = false;
    protected Collection<ASTDecl> parents_value;
    protected int typeDeclKind_visited = -1;
    protected int components_visited = -1;
    protected Map redefinesTokenComponent_TokenComponent_visited = new HashMap(4);
    protected int isRegionRoot_visited = -1;
    protected boolean isRegionRoot_computed = false;
    protected boolean isRegionRoot_value;
    protected int hasRegionRootAsSuperClass_visited = -1;
    protected boolean hasRegionRootAsSuperClass_computed = false;
    protected boolean hasRegionRootAsSuperClass_value;
    protected int isRegionLeaf_visited = -1;
    protected boolean isRegionLeaf_computed = false;
    protected boolean isRegionLeaf_value;
    protected Map lookupInhDecl_String_visited = new HashMap(4);
    protected Map lookupInhDecl_String_values = new HashMap(4);
    protected int defaultInhEqs_visited = -1;
    protected boolean defaultInhEqs_computed = false;
    protected Collection<String> defaultInhEqs_value;
    protected int componentInhEqs_visited = -1;
    protected boolean componentInhEqs_computed = false;
    protected Map<String, Collection<String>> componentInhEqs_value;
    protected Map hasInhEqForDecl_String_String_visited = new HashMap(4);
    protected int numNonNTAComponent_visited = -1;
    protected int childCount_visited = -1;
    protected int numRegularChildren_visited = -1;
    protected Map hasSynEq_String_visited = new HashMap(4);
    protected int initialChildArraySize_visited = -1;
    protected int debugASTNodeState_visited = -1;
    protected int needsListTouched_visited = -1;
    protected int isASTNodeDecl_visited = -1;
    protected int isOptDecl_visited = -1;
    protected int isListDecl_visited = -1;
    protected int isOptSubtype_visited = -1;
    protected int isListSubtype_visited = -1;
    protected int checkRegularNodeStructure_visited = -1;
    protected int jjtGenPrintChildren_visited = -1;
    protected Map hasInhEq_String_visited = new HashMap(4);
    protected Map lookupSynDeclPrefix_String_visited = new HashMap(4);
    protected Map lookupInhDeclPrefix_String_visited = new HashMap(4);
    protected Map lookupSynDecl_String_visited = new HashMap(4);
    protected Map lookupSynDecl_String_values = new HashMap(4);
    protected Map lookupSynEq_String_visited = new HashMap(4);
    protected Map lookupSynEq_String_values = new HashMap(4);
    protected Map lookupInhEq_String_String_visited = new HashMap(4);
    protected Map lookupInhEq_String_String_values = new HashMap(4);
    protected int hasRewrites_visited = -1;
    protected boolean hasRewrites_computed = false;
    protected boolean hasRewrites_value;
    protected int hasRewriteAttribute_visited = -1;
    protected boolean hasRewriteAttribute_computed = false;
    protected boolean hasRewriteAttribute_value;
    protected int getCircularRewriteDecl_visited = -1;
    protected boolean getCircularRewriteDecl_computed = false;
    protected CircularRewriteDecl getCircularRewriteDecl_value;
    protected Map missingSynEqs_String_visited = new HashMap(4);
    protected Map hasCollEq_CollDecl_visited = new HashMap(4);
    protected int isRootNode_visited = -1;
    protected int isPotentialRootNode_visited = -1;
    protected Map lookupRegionDecl_String_visited = new HashMap(4);

    public void emitCloneNode(PrintWriter stream) {
        this.templateContext().expand("ASTDecl.emitCloneNode", stream);
    }

    public void emitCopyNode(PrintWriter stream) {
        if (!this.hasAbstract()) {
            this.templateContext().expand("ASTDecl.emitCopyNode", stream);
        }
    }

    public void emitFullCopy(PrintWriter stream) {
        LinkedList<Integer> ntaAggregateIndices = new LinkedList<Integer>();
        LinkedList<Integer> ntaOptIndices = new LinkedList<Integer>();
        LinkedList<Integer> ntaListIndices = new LinkedList<Integer>();
        int i = 0;
        for (Component c : this.components()) {
            if (c.isNTA()) {
                if (c instanceof ListComponentNTA) {
                    ntaListIndices.add(i);
                } else if (c instanceof OptionalComponentNTA) {
                    ntaOptIndices.add(i);
                } else if (c instanceof AggregateComponentNTA) {
                    ntaAggregateIndices.add(i);
                }
            }
            if (c instanceof TokenComponent) continue;
            ++i;
        }
        String skipNTAs = "";
        String ind = this.config().indent;
        if (!(ntaAggregateIndices.isEmpty() && ntaOptIndices.isEmpty() && ntaListIndices.isEmpty())) {
            Iterator iter;
            skipNTAs = "switch (i) {\n";
            if (!ntaAggregateIndices.isEmpty()) {
                iter = ntaAggregateIndices.iterator();
                while (iter.hasNext()) {
                    skipNTAs = skipNTAs + "case " + iter.next() + ":\n";
                }
                skipNTAs = skipNTAs + ind + "tree.children[i] = null;\n";
                skipNTAs = skipNTAs + ind + "continue;\n";
            }
            if (!ntaOptIndices.isEmpty()) {
                iter = ntaOptIndices.iterator();
                while (iter.hasNext()) {
                    skipNTAs = skipNTAs + "case " + iter.next() + ":\n";
                }
                skipNTAs = this.config().emptyContainerSingletons() ? skipNTAs + ind + "tree.children[i] = " + this.config().optType() + ".EMPTY;\n" : skipNTAs + ind + "tree.children[i] = new " + this.config().optType() + "();\n";
                skipNTAs = skipNTAs + ind + "continue;\n";
            }
            if (!ntaListIndices.isEmpty()) {
                iter = ntaListIndices.iterator();
                while (iter.hasNext()) {
                    skipNTAs = skipNTAs + "case " + iter.next() + ":\n";
                }
                skipNTAs = this.config().emptyContainerSingletons() ? skipNTAs + ind + "tree.children[i] = " + this.config().listType() + ".EMPTY;\n" : skipNTAs + ind + "tree.children[i] = new " + this.config().listType() + "();\n";
                skipNTAs = skipNTAs + ind + "continue;\n";
            }
            skipNTAs = skipNTAs + "}\n";
        }
        TemplateContext tt = this.templateContext();
        tt.bind("SkipNTAs", skipNTAs);
        tt.expand("ASTDecl.emitFullCopy", stream);
        tt.expand("ASTDecl.emitTreeCopyNoTransform", stream);
        tt.expand("ASTDecl.emitTreeCopy", stream);
        if (this.isASTNodeDecl()) {
            tt.expand("ASTNode.emitDoFullTraversal", stream);
        }
    }

    public String docComment(ClassBodyObject obj) {
        JavaDocParser parser = new JavaDocParser();
        TemplateContext tt = this.templateContext();
        tt.bind("SourceComment", parser.parse(obj.comments));
        tt.bind("HasAspectName", obj.aspectName() != null && obj.aspectName().length() > 0);
        tt.bind("AspectName", obj.aspectName());
        String declaredat = ASTNode.declaredat(obj.getFileName(), obj.getStartLine());
        tt.bind("HasDeclaredAt", declaredat.length() > 0);
        tt.bind("DeclaredAt", declaredat);
        return tt.expand("ASTDecl.docComment");
    }

    public String componentString() {
        StringBuffer components = new StringBuffer();
        for (Component comp : this.components()) {
            components.append(" ");
            components.append(comp.componentString());
        }
        return components.toString();
    }

    public String componentHtml() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.getNumComponent(); ++i) {
            buf.append(" ");
            buf.append("<span class=\"component\">");
            buf.append(this.getComponent(i).componentHtml());
            buf.append("</span>");
        }
        return buf.toString();
    }

    @Override
    public String extraDocCommentLines() {
        StringBuilder productionHtml = new StringBuilder();
        productionHtml.append(this.getIdDecl().getID());
        if (this.hasSuperClass()) {
            productionHtml.append(String.format(" : {@link %s}", this.getSuperClass().getID()));
        }
        if (this.getNumComponent() > 0) {
            productionHtml.append(" ::=").append(this.componentHtml());
        }
        StringBuilder production = new StringBuilder();
        production.append(this.getIdDecl().getID());
        if (this.hasSuperClass()) {
            production.append(" : ").append(this.getSuperClass().getID());
        }
        if (!this.components().isEmpty()) {
            production.append(" ::=").append(this.componentString());
        }
        return String.format(" * @astdecl %s;%n * @production %s;%n", production, productionHtml);
    }

    @Override
    public String toString() {
        return this.name();
    }

    public void emitFlushCache(PrintWriter out) {
        TemplateContext tt = this.templateContext();
        tt.expand("ASTNode.flushTreeCacheMethod", out);
        tt.expand("ASTDecl.flushCacheMethod", out);
        tt.expand("ASTDecl.flushAttrAndCollectionCacheMethod", out);
        if (this.config().concurrentEval()) {
            StringBuilder fresh = new StringBuilder();
            for (AttrDecl attr : this.listOfCachedAttributes()) {
                fresh.append(attr.signature() + "_fresh();\n");
            }
            for (CollDecl decl : this.interfaceCollDecls()) {
                fresh.append(decl.signature() + "_value = new AtomicReference<Object>(AttributeValue.NONE);\n");
                if (decl.root() != this) continue;
                fresh.append(decl.templateContext().expand("Collection.makeFresh"));
            }
            for (CollDecl decl : this.getCollDeclList()) {
                fresh.append(decl.signature() + "_value = new AtomicReference<Object>(AttributeValue.NONE);\n");
                if (decl.root() != this) continue;
                fresh.append(decl.templateContext().expand("Collection.makeFresh"));
            }
            tt.bind("MakeFreshNodeBody", fresh.toString());
            tt.expand("ASTDecl.makeFreshNode", out);
        }
        StringBuilder sb = new StringBuilder();
        for (AttrDecl attr : this.listOfCachedAttributes()) {
            sb.append(attr.signature() + "_reset();\n");
        }
        tt.bind("FlushAttrCacheBody", sb.toString());
        tt.expand("ASTDecl.flushAttrCacheMethod", out);
        tt.expand("ASTDecl.flushCollectionCacheMethod", out);
    }

    public String emitFlushNTACacheString() {
        StringBuffer res = new StringBuffer();
        TemplateContext tt = this.templateContext();
        for (int c = 0; c < this.getNumComponent(); ++c) {
            Component comp = this.getComponent(c);
            if (!(comp instanceof TokenComponent)) continue;
            TokenComponent tokenComp = (TokenComponent)comp;
            String type = tokenComp.type();
            tt.bind("IsStringToken", type.equals("String") || type.equals("java.lang.String"));
            tt.bind("IsPrimitive", tokenComp.isPrimitive());
            tt.bind("Id", tokenComp.name());
            tt.bind("TypeSign", ASTNode.convTypeNameToSignature(type));
            res.append(tt.expand("TokenComponent.flushNTACache"));
        }
        return res.toString();
    }

    public String flushCollectionCacheCode() {
        StringBuffer res = new StringBuffer();
        for (CollDecl decl : this.interfaceCollDecls()) {
            res.append(decl.resetVisit());
            res.append(decl.resetCache());
        }
        for (CollDecl decl : this.getCollDeclList()) {
            res.append(decl.resetVisit());
            res.append(decl.resetCache());
        }
        res.append(this.collectionReset());
        return res.toString();
    }

    public boolean implementsInterface(String name) {
        for (SimpleNode n : this.implementsList) {
            StringBuffer s = new StringBuffer();
            n.jjtAccept(new Unparser(), s);
            String i = s.toString();
            int index = i.indexOf(name);
            if (index == -1 || index > 0 && Character.isJavaIdentifierPart(i.charAt(index - 1)) || index + name.length() < i.length() && Character.isJavaIdentifierPart(i.charAt(index + name.length()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeDuplicateInhDecls() {
        for (int i = 0; i < this.getNumInhDecl(); ++i) {
            InhDecl decl = this.getInhDecl(i);
            if (!((AttrDecl)decl).isDuplicateInhDecl()) continue;
            this.getInhDeclList().removeChild(i);
        }
    }

    public Collection<InhDecl> missingInhEqs() {
        String childName;
        TypeDecl type;
        if (this.missingInhEqs != null) {
            return this.missingInhEqs;
        }
        this.missingInhEqs = Collections.emptyList();
        HashSet<InhDecl> missing = new HashSet<InhDecl>();
        for (Component component : this.components()) {
            if (component instanceof TokenComponent || !((type = component.typeDecl()) instanceof ASTDecl)) continue;
            ASTDecl aSTDecl = (ASTDecl)type;
            childName = component.name();
            this.addMissingChildInhEqs(missing, childName, aSTDecl.missingInhEqs());
            for (ASTDecl subtype : aSTDecl.subclassesTransitive()) {
                this.addMissingChildInhEqs(missing, childName, subtype.missingInhEqs());
            }
        }
        for (SynthesizedNta synthesizedNta : this.synNtaDecls()) {
            type = this.grammar().lookup(synthesizedNta.getType());
            if (!(type instanceof ASTDecl)) continue;
            ASTDecl aSTDecl = (ASTDecl)type;
            childName = synthesizedNta.getName();
            this.addMissingChildInhEqs(missing, childName, aSTDecl.missingInhEqs());
            for (ASTDecl subtype : aSTDecl.subclassesTransitive()) {
                this.addMissingChildInhEqs(missing, childName, subtype.missingInhEqs());
            }
        }
        if (!this.isRootNode()) {
            for (InhDecl inhDecl : this.getInhDeclList()) {
                missing.add(inhDecl);
            }
            for (ASTDecl aSTDecl : this.supertypes()) {
                for (InhDecl inhDecl : aSTDecl.getInhDeclList()) {
                    missing.add(inhDecl);
                }
            }
        }
        this.missingInhEqs = missing;
        return this.missingInhEqs;
    }

    private void addMissingChildInhEqs(Collection<InhDecl> missing, String childName, Collection<InhDecl> childMissing) {
        for (InhDecl decl : childMissing) {
            if (this.hasInhEqForDecl(childName, decl.signature())) continue;
            missing.add(decl);
        }
    }

    protected Map<ASTDecl, String> missingInhEqs(String signature, Collection<ASTDecl> parentSet, Map<ASTDecl, Set<ASTDecl>> visited) {
        LinkedHashMap<ASTDecl, String> missing = new LinkedHashMap<ASTDecl, String>();
        for (ASTDecl parent : parentSet) {
            String path;
            if (parent.hasInhEq(this, signature) || (path = parent.missingInhEqPath(signature, visited)) == null) continue;
            missing.put(parent, path + "->" + this.name());
        }
        return missing;
    }

    protected String missingInhEqPath(String signature, Map<ASTDecl, Set<ASTDecl>> visited) {
        if (this.parents().isEmpty()) {
            return this.name();
        }
        for (ASTDecl parent : this.parents()) {
            String path;
            Set<ASTDecl> visitedChildren = visited.get(parent);
            if (visitedChildren == null) {
                visitedChildren = new HashSet<ASTDecl>();
                visited.put(parent, visitedChildren);
            } else if (visitedChildren.contains(this)) break;
            visitedChildren.add(this);
            if (parent.hasInhEq(this, signature) || (path = parent.missingInhEqPath(signature, visited)) == null) continue;
            return path + "->" + this.name();
        }
        return null;
    }

    protected boolean hasInhEq(ASTDecl child, String signature) {
        for (Component component : this.components()) {
            if (!child.instanceOf(component.typeDecl()) || this.lookupInhEq(signature, component.name()) != null) continue;
            return false;
        }
        for (SynthesizedNta synthesizedNta : this.synNtaDecls()) {
            if (!child.instanceOf(this.grammar().lookup(synthesizedNta.getType())) || this.lookupInhEq(signature, synthesizedNta.getName()) != null) continue;
            return false;
        }
        return true;
    }

    public void emitInhEquations(PrintStream out) {
        for (String attrId : this.inhAttrSet()) {
            this.emitDefineInhMethod(out, attrId);
            this.emitCanDefineInhMethod(out, attrId);
        }
    }

    public void emitDefineInhMethod(PrintStream out, String attrId) {
        Collection<InhEq> inhEqs = this.inhAttrEqs(attrId);
        assert (inhEqs.iterator().hasNext());
        InhDecl decl = (InhDecl)inhEqs.iterator().next().decl();
        TemplateContext tc = decl.templateContext();
        tc.bind("InhEqClauses", this.inhEqClauses(decl, inhEqs));
        tc.expand("InhDecl.DefineInhMethod", out);
    }

    private String inhEqClauses(InhDecl decl, Collection<InhEq> inhEqs) {
        StringBuffer sb = new StringBuffer();
        boolean hasComponentEq = false;
        for (InhEq equ : inhEqs) {
            if (hasComponentEq) {
                sb.append("else ");
            }
            String rhs = Unparser.unparse(equ.getRHS());
            TemplateContext tc = equ.templateContext();
            if (equ.getRHS() instanceof ASTBlock) {
                tc.bind("EvalStmt", rhs);
            } else {
                tc.bind("EvalStmt", "return " + rhs + ";");
            }
            Component c = equ.getComponent();
            if (c != null) {
                if (c instanceof ListComponent) {
                    tc.bind("ChildIndexVar", equ.hasIndex() ? equ.getIndex().getName() : "childIndex");
                    tc.expand("InhEq.emitListClause", sb);
                } else if (c instanceof OptionalComponent) {
                    tc.expand("InhEq.emitOptClause", sb);
                } else {
                    tc.expand("InhEq.emitChildClause", sb);
                }
            } else {
                if (equ.getChildName().equals("getChild")) {
                    tc.bind("ChildIndexVar", equ.hasIndex() ? equ.getIndex().getName() : "childIndex");
                    tc.bind("HasComponentEq", hasComponentEq);
                    tc.expand("InhEq.emitDefaultClause", sb);
                    return sb.toString();
                }
                AttrDecl attrDecl = equ.getChildAttrDecl();
                tc.bind("IsParameterized", attrDecl.isParameterized());
                if (attrDecl.isParameterized()) {
                    tc.bind("ChildIndexVar", equ.hasIndex() ? equ.getIndex().getName() : "childIndex");
                    tc.bind("AttrSignature", attrDecl.signature());
                }
                tc.expand("InhEq.emitNTAClause", sb);
            }
            hasComponentEq = true;
        }
        TemplateContext tc = decl.templateContext();
        tc.bind("HasComponentEq", hasComponentEq);
        tc.bind("HasEqInSupertype", this.superClass() != null && this.superClass().hasInhEq(decl.name()));
        tc.expand("InhDecl.fallthrough", sb);
        return sb.toString();
    }

    public void emitCanDefineInhMethod(PrintStream out, String attrId) {
        Collection<InhEq> inhEqs = this.inhAttrEqs(attrId);
        assert (inhEqs.iterator().hasNext());
        InhDecl decl = (InhDecl)inhEqs.iterator().next().decl();
        TemplateContext tc = decl.templateContext();
        tc.expand("InhDecl.canDefineMethod", out);
    }

    public void emitConcurrentGetChild(PrintWriter out) {
        String getNta = "";
        int numNta = 0;
        int i = 0;
        for (Component c : this.components()) {
            if (c instanceof TokenComponent) continue;
            String attrName = null;
            if (c instanceof ListComponentNTA) {
                attrName = "get" + c.name() + "List";
            } else if (c instanceof OptionalComponentNTA) {
                attrName = "get" + c.name() + "Opt";
            } else if (c instanceof AggregateComponentNTA) {
                attrName = "get" + c.name();
            }
            if (attrName != null && this.hasSynEq(attrName)) {
                getNta = getNta + "case " + i + ":\n";
                getNta = getNta + "  _value = " + attrName + "_value.get();\n";
                getNta = getNta + "  break;\n";
                ++numNta;
            }
            ++i;
        }
        TemplateContext tt = this.templateContext();
        if (numNta > 0) {
            tt.bind("GetNTAs", getNta);
            tt.expand("ASTDecl.getChildNoTransform:concurrent", out);
        } else {
            tt.expand("ASTDecl.getChildNoTransform:concurrent:empty", out);
        }
    }

    public void emitDefaultConstructor(PrintWriter out) {
        TemplateContext tt = this.templateContext();
        String finalInit = "";
        if (this.config().legacyRewrite() && this.isRootNode()) {
            finalInit = "is$Final(true);";
        }
        tt.bind("FinalInit", finalInit);
        tt.expand("ASTDecl.emitDefaultConstructor", out);
    }

    public void emitChildInitMethod(PrintWriter out) {
        TemplateContext tt = this.templateContext();
        String initChildArray = "";
        if (this.childCount() > 0) {
            initChildArray = "children = new " + this.config().astNodeType() + "[" + this.childCount() + "];";
            initChildArray = initChildArray + this.genIncrementalInitChildHandlers();
        }
        tt.bind("InitChildArray", initChildArray);
        StringBuffer childInit = new StringBuffer();
        childInit.append(tt.expand("State.incHookConstructionStart"));
        int i = 0;
        for (Component c : this.components()) {
            if (c instanceof ListComponent) {
                if (this.config().emptyContainerSingletons()) {
                    childInit.append("setChild(" + this.config().listType() + ".EMPTY, " + i + ");\n");
                } else {
                    childInit.append("setChild(new " + this.config().listType() + "(), " + i + ");\n");
                }
                ++i;
                continue;
            }
            if (c instanceof OptionalComponent) {
                if (this.config().emptyContainerSingletons()) {
                    childInit.append("setChild(" + this.config().optType() + ".EMPTY, " + i + ");\n");
                } else {
                    childInit.append("setChild(new " + this.config().optType() + "(), " + i + ");\n");
                }
                ++i;
                continue;
            }
            if (!(c instanceof AggregateComponent)) continue;
            ++i;
        }
        childInit.append(tt.expand("State.incHookConstructionEnd"));
        tt.bind("ChildInit", childInit.toString());
        tt.expand("ASTDecl.emitChildInitMethod", out);
    }

    public void emitBuildingConstructorBody(PrintWriter out) {
        TemplateContext tt = this.templateContext();
        tt.expand("State.incHookConstructionStart", out);
        int param = 0;
        int childIndex = 0;
        for (Component c : this.components()) {
            if (!c.isNTA()) {
                if (c instanceof TokenComponent) {
                    TokenComponent t = (TokenComponent)c;
                    out.format("%sset%s(p%d);%n", this.config().ind(2), t.name(), param);
                } else {
                    out.format("%ssetChild(p%d, %d);%n", this.config().ind(2), param, childIndex);
                    ++childIndex;
                }
                ++param;
                continue;
            }
            if (!(c instanceof ListComponent) && !(c instanceof OptionalComponent) && !(c instanceof AggregateComponent)) continue;
            ++childIndex;
        }
        if (this.config().legacyRewrite() && this.isRootNode()) {
            out.println(this.config().ind(2) + "is$Final(true);");
        }
        tt.expand("State.incHookConstructionEnd", out);
    }

    private void emitConstructorAnnotation(PrintWriter out) {
        out.println(this.config().indent + "@ASTNodeAnnotation.Constructor(");
        out.print(this.config().ind(2) + "name = {");
        int paramIndex = 0;
        for (Component c : this.components()) {
            if (c.isNTA()) continue;
            if (paramIndex != 0) {
                out.print(", ");
            }
            out.print("\"");
            out.print(c.name());
            out.print("\"");
            ++paramIndex;
        }
        out.println("},");
        out.print(this.config().ind(2) + "type = {");
        paramIndex = 0;
        for (Component c : this.components()) {
            if (c.isNTA()) continue;
            if (paramIndex != 0) {
                out.print(", ");
            }
            out.print("\"");
            out.print(c.constrParmType());
            out.print("\"");
            ++paramIndex;
        }
        out.println("},");
        out.print(this.config().ind(2) + "kind = {");
        paramIndex = 0;
        for (Component c : this.components()) {
            if (c.isNTA()) continue;
            if (paramIndex != 0) {
                out.print(", ");
            }
            out.print("\"");
            out.print(c.kind());
            out.print("\"");
            ++paramIndex;
        }
        out.println("}");
        out.println(this.config().indent + ")");
    }

    public void emitBuildingConstructor(PrintWriter out) {
        if (this.components().isEmpty()) {
            return;
        }
        if (this.config().generateAnnotations()) {
            this.emitConstructorAnnotation(out);
        }
        out.print(this.config().indent + "public " + this.name() + "." + this.name() + "(");
        int paramIndex = 0;
        for (Component c : this.components()) {
            if (c.isNTA()) continue;
            if (paramIndex != 0) {
                out.print(", ");
            }
            out.print(c.constrParmType() + " p" + paramIndex);
            ++paramIndex;
        }
        out.println(") {");
        this.emitBuildingConstructorBody(out);
        out.println(this.config().indent + "}");
    }

    public void emitSymbolConstructor(PrintWriter out) {
        if (this.components().isEmpty()) {
            return;
        }
        boolean stringArg = false;
        for (Component c : this.components()) {
            if ((c.isNTA() || !(c instanceof TokenComponent) || !c.constrParmType().equals("String")) && !c.constrParmType().equals("java.lang.String")) continue;
            stringArg = true;
        }
        if (!stringArg) {
            return;
        }
        out.format("%spublic %s.%s(", this.config().indent, this.name(), this.name());
        int paramIndex = 0;
        for (Component c : this.components()) {
            if (c.isNTA()) continue;
            if (paramIndex != 0) {
                out.print(", ");
            }
            if (c instanceof TokenComponent && c.constrParmType().equals("String") || c.constrParmType().equals("java.lang.String")) {
                out.format("beaver.Symbol p%d", paramIndex);
            } else {
                out.format("%s p%d", c.constrParmType(), paramIndex);
            }
            ++paramIndex;
        }
        out.println(") {");
        this.emitBuildingConstructorBody(out);
        out.println(this.config().indent + "}");
    }

    public void emitImplicitASTNodeDecls(PrintWriter out) {
        TemplateContext tt = this.templateContext();
        tt.expand("ASTNode.declarations", out);
        tt.expand("ASTNode.getChild", out);
        tt.expand("ASTNode.addChild", out);
        tt.expand("ASTNode.getChildNoTransform", out);
        tt.expand("ASTNode.numChildren", out);
        tt.expand("ASTNode.setChild", out);
        tt.expand("ASTNode.insertChild", out);
        tt.expand("ASTNode.removeChild", out);
        tt.expand("ASTNode.getParent", out);
        tt.expand("ASTNode.setParent", out);
        tt.expand("ASTNodeAnnotation", out);
        tt.expand("ASTNode.debugDecls", out);
        if (this.config().lineColumnNumbers()) {
            tt.expand("ASTNode.lineColumnNumbers", out);
        }
    }

    public void emitImplicitListDecls(PrintWriter out) {
        TemplateContext tt = this.templateContext();
        tt.expand("List.implicitAspectDecls", out);
    }

    public void emitImplicitRegularNodeDecls(PrintWriter out) {
        TemplateContext tt = this.templateContext();
        tt.expand("RegularNodeType.getNumChild", out);
        if (this.config().debugMode() && this.isRootNode()) {
            tt.expand("RegularNodeType.debugNodeAttachmentIsRoot", out);
        }
    }

    public void emitConstructor(PrintWriter out) {
        TemplateContext tt;
        this.emitDefaultConstructor(out);
        this.emitChildInitMethod(out);
        if (this.numNonNTAComponent() != 0) {
            this.emitBuildingConstructor(out);
            if (this.config().useBeaverSymbol()) {
                this.emitSymbolConstructor(out);
            }
        }
        if (this.isOptDecl()) {
            tt = this.templateContext();
            tt.expand("OptDecl.constructor", out);
        }
        if (this.isListDecl()) {
            tt = this.templateContext();
            tt.expand("ListDecl.constructor", out);
        }
    }

    public void emitMayHaveRewrite(PrintWriter out) {
        String ind = this.config().indent;
        String ind2 = this.config().ind(2);
        out.println(ind + "/**");
        out.println(ind + " * @apilevel internal");
        out.println(ind + " */");
        out.println(ind + "public boolean " + this.name() + ".mayHaveRewrite() {");
        if (this.config().legacyRewrite() && this.name().equals(this.config().listType())) {
            out.println(ind2 + "return true;");
        } else if (this.hasRewrites()) {
            out.println(ind2 + "return true;");
        } else {
            out.println(ind2 + "return false;");
        }
        out.println(ind + "}");
    }

    public void emitImplicitDeclarations(PrintWriter out) {
        this.emitConstructor(out);
        if (this.config().jjtree()) {
            TemplateContext tt = this.templateContext();
            tt.expand("JJTree.dumpTree", out);
            tt.expand("JJTree.jjtAccept", out);
            tt.expand("JJTree.jjtAddChild", out);
            tt.expand("JJTree.checkChild", out);
        }
        if (this.isASTNodeDecl()) {
            this.emitImplicitASTNodeDecls(out);
            this.grammar().genReset(out);
        } else if (this.isListDecl()) {
            this.emitImplicitListDecls(out);
            this.templateContext().expand("List.additionalDeclarations", out);
        } else if (this.isOptDecl()) {
            this.templateContext().expand("Opt.additionalDeclarations", out);
        } else {
            this.emitImplicitRegularNodeDecls(out);
        }
        if (this.config().rewriteEnabled()) {
            this.emitMayHaveRewrite(out);
        }
        this.emitFlushCache(out);
        this.emitCloneNode(out);
        this.emitCopyNode(out);
        this.emitFullCopy(out);
        if (this.config().concurrentEval() && !this.isASTNodeDecl() && !this.isOptDecl() && !this.isListDecl()) {
            this.emitConcurrentGetChild(out);
        }
        this.genIncremental(out);
    }

    public boolean hasClassBodyDecl(String signature) {
        for (ClassBodyObject o : this.classBodyDecls) {
            if (!o.signature().equals(signature)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeStatistics(PrintStream out) {
        out.format("%s,TRUE,%d,%d,%d,%d,%d,%d,%d,%d,%d%n", this.name(), this.synDecls().getNumChild(), this.getNumSynEq(), this.getNumInhDecl(), this.inhAttrSet().size(), this.getNumCollDecl(), this.getNumCollEq(), this.numRefinedSynEqs, this.numRefinedInhEqs, this.numRefinedCBDecls);
    }

    @Override
    public void jastAddGen(boolean publicModifier) {
        File file = this.grammar().targetJavaFile(this.name());
        try {
            String superType;
            PrintStream stream = new PrintStream(new FileOutputStream(file));
            stream.format("/* This file was generated with %s */%n", JastAdd.getLongVersionString());
            if (!this.config().license.isEmpty()) {
                stream.println(this.config().license);
            }
            if (!this.config().packageName().isEmpty()) {
                stream.format("package %s;%n", this.config().packageName());
            }
            stream.print(this.grammar().genImportsList());
            stream.println(this.docComment());
            stream.print("public ");
            if (this.hasAbstract()) {
                stream.print("abstract ");
            }
            stream.format("class %s", this.name());
            if (this.isOptDecl() || this.isListDecl() || this.isASTNodeDecl()) {
                stream.format("<T extends %s>", this.config().astNodeType());
            }
            if (this.hasSuperClass()) {
                String name = this.getSuperClass().name();
                if (this.isListDecl() || this.isOptDecl()) {
                    name = name + "<T>";
                } else if (name.equals(this.config().astNodeType())) {
                    name = name + "<" + this.config().astNodeType() + ">";
                }
                stream.format(" extends %s", name);
            } else if (this.isASTNodeDecl() && !(superType = this.config().astNodeSuperType()).equals("")) {
                stream.format(" extends %s", superType);
            }
            stream.print(this.jastAddImplementsList());
            stream.println(" {");
            this.jastAddAttributes(stream);
            stream.println("}");
            stream.close();
        }
        catch (FileNotFoundException f) {
            System.err.format("Could not create file %s in %s%n", file.getName(), file.getParent());
            System.exit(1);
        }
    }

    public String jastAddImplementsList() {
        StringBuffer buf = new StringBuffer();
        buf.append(" implements Cloneable");
        Iterator iter = this.implementsList.iterator();
        while (iter.hasNext()) {
            buf.append(", " + Unparser.unparse((SimpleNode)iter.next()));
        }
        if (this.isListDecl()) {
            buf.append(", Iterable<T>");
        }
        return buf.toString();
    }

    public void jastAddAttributes(PrintStream out) {
        this.emitMembers(out);
        this.emitAbstractSyns(out);
        this.emitSynEquations(out);
        this.emitInhDeclarations(out);
        this.emitInhEquations(out);
        if (this.config().rewriteEnabled()) {
            this.emitRewrites(out);
        }
        this.emitCollDecls(out);
        this.emitCollContributions(out);
        this.emitInhEqSignatures(out);
        this.emitRewriteAttribute(out);
    }

    @Override
    public void emitMembers(PrintStream out) {
        for (ClassBodyObject obj : this.classBodyDecls) {
            SimpleNode node = obj.node;
            out.print(obj.modifiers());
            out.println(this.docComment(obj));
            out.print(this.config().indent);
            StringBuffer buf = new StringBuffer();
            node.jjtAccept(new ClassBodyDeclUnparser(), buf);
            out.print(buf.toString());
            out.println();
        }
    }

    @Override
    public void emitAbstractSyns(PrintStream out) {
        for (AttrDecl attrDecl : this.synDecls()) {
            boolean equ = false;
            for (int j = 0; j < this.getNumSynEq(); ++j) {
                if (!this.getSynEq(j).signature().equals(attrDecl.signature())) continue;
                equ = true;
            }
            if (equ) continue;
            attrDecl.emitAbstractSynDecl(out);
        }
    }

    public void emitCacheDeclarations(PrintStream out, AttrDecl attr) {
        attr.emitVisitedDeclarations(out);
        if (!attr.isCircular()) {
            attr.emitResetMethod(out);
            if (attr.isMemoized()) {
                attr.emitCacheDeclarations(out);
            }
        } else if (attr.getNumParameter() == 0) {
            attr.emitResetMethod(out);
            attr.emitCacheDeclarations(out);
        } else {
            attr.emitResetMethod(out);
            if (attr.declaredNTA() || this.config().concurrentEval() && attr.isCircular()) {
                attr.emitCacheDeclarations(out);
            } else if (this.config().lazyMaps()) {
                out.format("%sprotected %s %s_values;%n", this.config().indent, this.config().typeDefaultMap(), attr.signature());
            } else {
                out.format("%sprotected %s %s_values = %s;%n", this.config().indent, this.config().typeDefaultMap(), attr.signature(), this.config().createDefaultMap());
            }
        }
    }

    public void emitSynEquations(PrintStream out) {
        for (int i = 0; i < this.getNumSynEq(); ++i) {
            SynEq equ = this.getSynEq(i);
            AttrDecl attr = ((AttrEq)equ).decl();
            this.emitCacheDeclarations(out, attr);
            attr.emitSynEquation(out, equ);
        }
    }

    @Override
    public void emitInhDeclarations(PrintStream out) {
        for (int i = 0; i < this.getNumInhDecl(); ++i) {
            InhDecl attr = this.getInhDecl(i);
            attr.emitAttrEquation(out);
            this.emitCacheDeclarations(out, attr);
        }
    }

    public void emitInhEqSignatures(PrintStream out) {
        if (this.name().equals(this.config().astNodeType())) {
            for (Map.Entry entry : this.grammar().inhEqMap().entrySet()) {
                String attrId = (String)entry.getKey();
                AttrEq attr = (AttrEq)((LinkedList)entry.getValue()).get(0);
                if (this.hasInhEq(attr.decl().name())) continue;
                attr.emitDefaultInhMethod(out);
            }
        }
    }

    public void emitRewrites(PrintStream out) {
        Rewrite r;
        int i;
        TemplateContext tt = this.templateContext();
        boolean unconditional = false;
        tt.expand("ASTDecl.rewriteTo:begin", out);
        if (this.config().legacyRewrite() && this.name().equals(this.config().listType())) {
            tt.expand("ASTDecl.emitRewrites.touch_list", out);
        }
        for (i = 0; i < this.getNumRewrite(); ++i) {
            r = this.getRewrite(i);
            if (!r.genRewrite(out, i)) continue;
            unconditional = true;
        }
        if (this.name().equals(this.config().astNodeType())) {
            tt.expand("ASTDecl.rewriteTo:end:ASTNode", out);
        } else if (!unconditional) {
            tt.expand("ASTDecl.rewriteTo:end:conditional", out);
        } else {
            tt.expand("ASTDecl.rewriteTo:end:unconditional", out);
        }
        for (i = 0; i < this.getNumRewrite(); ++i) {
            r = this.getRewrite(i);
            r.genRewritesExtra(out, i);
        }
        if (this.config().rewriteCircularNTA()) {
            tt.expand("ASTDecl.canRewrite:begin", out);
            if (unconditional) {
                tt.expand("ASTDecl.canRewrite:end:unconditional", out);
            } else {
                for (i = 0; i < this.getNumRewrite(); ++i) {
                    r = this.getRewrite(i);
                    r.genRewriteCondition(out, i);
                }
                tt.expand("ASTDecl.canRewrite:end", out);
            }
        }
    }

    public void emitRewriteAttribute(PrintStream out) {
        if (this.hasRewriteAttribute()) {
            String oldValue;
            String newValue;
            CircularRewriteDecl decl = this.getCircularRewriteDecl();
            TemplateContext tt = decl.templateContext();
            if (this.config().concurrentEval()) {
                newValue = "_next";
                oldValue = "_previous.value";
                tt.bind("CircularComputeRhs", "((" + this.config().astNodeType() + ") " + decl.signature() + "_value.get()).rewriteTo()");
            } else {
                newValue = "new_" + decl.signature() + "_value";
                oldValue = decl.signature() + "_value";
                tt.bind("CircularComputeRhs", oldValue + ".rewriteTo()");
            }
            tt.bind("ChangeCondition", String.format("%s != %s || %s.canRewrite()", newValue, oldValue, newValue));
            tt.bind("BottomValue", "this");
            tt.bind("TracePrintReturnNewValue", decl.tracePrintReturnNewValue(decl.signature() + "_value"));
            tt.bind("TracePrintReturnPreviousValue", decl.tracePrintReturnPreviousValue(decl.signature() + "_value"));
            tt.expand("AttrDecl.resetMethod", out);
            if (this.config().concurrentEval()) {
                tt.expand("AttrDecl.makeFresh", out);
            }
            tt.expand("AttrDecl.cycleDeclaration", out);
            tt.expand("AttrDecl.cacheDeclarations", out);
            tt.expand("AttrDecl.circularEquation:unparameterized", out);
        } else if (this.isASTNodeDecl()) {
            out.format("public %s rewrittenNode() { throw new Error(\"rewrittenNode is undefined for ASTNode\"); }%n", this.config().astNodeType());
        }
    }

    public void emitCollDecls(PrintStream out) {
        for (CollDecl decl : this.interfaceCollDecls()) {
            this.emitCollDecl(out, decl);
        }
        for (CollDecl decl : this.getCollDeclList()) {
            this.emitCollDecl(out, decl);
        }
    }

    public void emitCollDecl(PrintStream out, CollDecl attr) {
        if (attr.circularCollection()) {
            attr.emitVisitedDeclarations(out);
            attr.emitCircularCollectionEval(out);
            attr.emitComputeMethod(out);
            attr.emitCacheDeclarations(out);
        } else {
            attr.emitVisitedDeclarations(out);
            attr.emitAttrEquation(out);
            attr.emitComputeMethod(out);
            attr.emitCacheDeclarations(out);
        }
    }

    public void emitCollContributions(PrintStream out) {
        this.collectContributors(out);
        this.contributeTo(out);
    }

    private void collectContributors(PrintStream out) {
        Collection equations;
        CollDecl decl;
        LinkedHashMap<CollDecl, ArrayList<SurveyContribution>> map = new LinkedHashMap<CollDecl, ArrayList<SurveyContribution>>();
        for (CollEq collEq : this.getCollEqList()) {
            decl = collEq.decl();
            equations = (ArrayList<EqSurveyContribution>)((HashMap)map).get(decl);
            if (equations == null) {
                equations = new ArrayList<EqSurveyContribution>();
                map.put(decl, (ArrayList<SurveyContribution>)equations);
            }
            equations.add(new EqSurveyContribution(collEq));
        }
        for (CustomSurveyContribution customSurveyContribution : this.surveyContributions) {
            decl = customSurveyContribution.lookupCollDecl(this.grammar());
            ArrayList<CustomSurveyContribution> contributions = (ArrayList<CustomSurveyContribution>)((HashMap)map).get(decl);
            if (contributions == null) {
                contributions = new ArrayList<CustomSurveyContribution>();
                map.put(decl, contributions);
            }
            contributions.add(customSurveyContribution);
        }
        for (Map.Entry entry : ((HashMap)map).entrySet()) {
            decl = (CollDecl)entry.getKey();
            equations = (Collection)entry.getValue();
            decl.templateContext().expand("CollDecl.collectContributors:header", out);
            boolean skipSuperCall = false;
            for (SurveyContribution contribution : equations) {
                contribution.emitSurveyCode(decl, out);
                skipSuperCall |= contribution instanceof BlockSurveyContribution;
            }
            if (skipSuperCall) {
                out.println(this.config().indent + "}");
                continue;
            }
            if (this.isASTNodeDecl() && !decl.parallelSurvey()) {
                decl.templateContext().expand("CollDecl.collectContributors:default", out);
                continue;
            }
            if (this.isASTNodeDecl()) {
                decl.templateContext().expand("CollDecl.collectContributors:default", out);
                continue;
            }
            decl.templateContext().expand("CollDecl.collectContributors:end", out);
        }
    }

    private void contributeTo(PrintStream out) {
        ArrayList<CollEq> equations;
        CollDecl decl;
        LinkedHashMap<CollDecl, ArrayList<CollEq>> map = new LinkedHashMap<CollDecl, ArrayList<CollEq>>();
        for (CollEq collEq : this.getCollEqList()) {
            if (collEq.onePhase()) continue;
            decl = collEq.decl();
            equations = (ArrayList<CollEq>)((HashMap)map).get(decl);
            if (equations == null) {
                equations = new ArrayList<CollEq>();
                map.put(decl, equations);
            }
            equations.add(collEq);
        }
        for (Map.Entry entry : ((HashMap)map).entrySet()) {
            decl = (CollDecl)entry.getKey();
            equations = (Collection)entry.getValue();
            decl.templateContext().bind("IsAstNode", this.isASTNodeDecl());
            decl.templateContext().expand("CollDecl.contributeTo:header", out);
            for (CollEq equation : equations) {
                TemplateContext tt = equation.templateContext();
                tt.bind("CombOp", decl.getCombOp());
                tt.expand("CollEq.contributeStatement", out);
            }
            out.println(this.config().indent + "}");
        }
    }

    @Override
    public void weaveCollectionAttributes() {
        for (CollDecl decl : this.interfaceCollDecls()) {
            decl.weaveCollectionAttribute();
        }
        for (CollDecl decl : this.getCollDeclList()) {
            decl.weaveCollectionAttribute();
        }
    }

    public void genIncrementalDebug(PrintWriter out) {
        if (!this.config().incrementalDebug()) {
            return;
        }
        TemplateContext tt = this.templateContext();
        tt.expand("ASTDecl.relativeNodeIDMethod", out);
        tt.expand("ASTDecl.printParamListMethod", out);
        tt.expand("ASTDecl.printValueMethod", out);
        tt.bind("DumpAttributeValues", this.genDumpAttributeValuesString());
        tt.bind("DumpCollAttributeValues", this.genDumpCollAttributeValuesString());
        tt.expand("ASTDecl.dumpCachedValuesMethod", out);
        tt.bind("DumpTokenDeps", this.genDumpTokenDepsString());
        tt.bind("DumpAttributeDeps", this.genDumpAttributeDepsString());
        tt.bind("DumpCollAttributeDeps", this.genDumpCollAttributeDepsString());
        tt.expand("ASTDecl.dumpDependenciesMethod", out);
        tt.bind("DumpDepsInNTAs", this.genDumpDepsInNTAsString());
        tt.expand("ASTDecl.dumpDepsInTreeMethod", out);
    }

    public String genDumpDepsInNTAsString() {
        StringBuffer res = new StringBuffer();
        TemplateContext tt = this.templateContext();
        for (AttrDecl attr : this.listOfCachedAttributes()) {
            if (!attr.isNTA() && !attr.getNTA() || attr.isPrimitive() || attr.type().equals("String") || attr.type().equals("java.lang.String")) continue;
            tt.bind("IsParameterized", attr.getNumParameter() > 0);
            tt.bind("AttrSign", attr.signature());
            res.append(tt.expand("ASTDecl.checkAndDumpNTADeps"));
        }
        return res.toString();
    }

    public String genDumpCollAttributeDepsString() {
        StringBuffer res = new StringBuffer();
        TemplateContext tt = this.templateContext();
        for (int k = 0; k < this.getNumCollDecl(); ++k) {
            CollDecl attr = this.getCollDecl(k);
            tt.bind("AttrSign", attr.signature());
            res.append(tt.expand("ASTDecl.checkAndDumpCollAttributeDeps"));
        }
        return res.toString();
    }

    public String genDumpAttributeDepsString() {
        StringBuffer res = new StringBuffer();
        TemplateContext tt = this.templateContext();
        for (AttrDecl attr : this.listOfCachedAttributes()) {
            tt.bind("IsParameterized", attr.getNumParameter() > 0);
            tt.bind("IsNTA", (attr.isNTA() || attr.getNTA()) && !attr.isPrimitive() && !attr.type().equals("String") && !attr.type().equals("java.lang.String"));
            tt.bind("AttrSign", attr.signature());
            res.append(tt.expand("ASTDecl.checkAndDumpAttributeDeps"));
        }
        return res.toString();
    }

    public String genDumpTokenDepsString() {
        StringBuffer res = new StringBuffer();
        TemplateContext tt = this.templateContext();
        if (this.config().incrementalLevelParam() || this.config().incrementalLevelAttr()) {
            for (Component c : this.components()) {
                if (!(c instanceof TokenComponent) || c.isNTA()) continue;
                tt.bind("Id", ((TokenComponent)c).name());
                res.append(tt.expand("ASTDecl.checkAndDumpTokenDeps"));
            }
        }
        return res.toString();
    }

    public String genDumpAttributeValuesString() {
        StringBuffer res = new StringBuffer();
        TemplateContext tt = this.templateContext();
        for (AttrDecl attr : this.listOfCachedAttributes()) {
            tt.bind("IsParameterized", attr.getNumParameter() > 0);
            tt.bind("PrintAsObject", attr.isPrimitive() || attr.getType().equals("String"));
            tt.bind("AttrSign", attr.signature());
            res.append(tt.expand("ASTDecl.dumpCachedAttributeValue"));
        }
        return res.toString();
    }

    public String genDumpCollAttributeValuesString() {
        StringBuffer res = new StringBuffer();
        TemplateContext tt = this.templateContext();
        for (int k = 0; k < this.getNumCollDecl(); ++k) {
            CollDecl attr = this.getCollDecl(k);
            tt.bind("AttrSign", attr.signature());
            res.append(tt.expand("ASTDecl.dumpCollAttributeValue"));
        }
        return res.toString();
    }

    public void genIncremental(PrintWriter out) {
        if (!this.config().incremental()) {
            return;
        }
        TemplateContext tt = this.templateContext();
        tt.expand("ASTDecl.relativeNodeIDMethodWithRewrite", out);
        tt.bind("NtaIndexCheck", this.emitNtaIndexCheckString());
        tt.expand("ASTDecl.childIsNtaMethod", out);
        this.genIncrementalHandlers(out);
        this.genIncrementalCopyHandlers(out);
        this.genIncrementalNotification(out);
        this.genIncrementalState(out);
        this.genIncrementalRegions(out);
        this.genIncrementalCleanup(out);
        this.genIncrementalDebug(out);
    }

    public ArrayList<AttrDecl> listOfCachedAttributes() {
        AttrDecl attr;
        int k;
        ArrayList<AttrDecl> list = new ArrayList<AttrDecl>();
        if (this.config().rewriteCircularNTA() && this.hasRewriteAttribute()) {
            list.add(this.getCircularRewriteDecl());
        }
        for (k = 0; k < this.getNumSynEq(); ++k) {
            attr = this.getSynEq(k).decl();
            if (attr == null || !attr.isMemoized()) continue;
            list.add(attr);
        }
        for (k = 0; k < this.getNumInhDecl(); ++k) {
            attr = this.getInhDecl(k);
            if (!attr.isMemoized()) continue;
            list.add(attr);
        }
        return list;
    }

    public ArrayList listOfNtaAttributes() {
        ArrayList<AttrDecl> list = new ArrayList<AttrDecl>();
        for (AttrDecl attrDecl : this.synDecls()) {
            if (!attrDecl.isNTA()) continue;
            list.add(attrDecl);
        }
        for (int k = 0; k < this.getNumInhDecl(); ++k) {
            InhDecl inhDecl = this.getInhDecl(k);
            if (!inhDecl.isNTA()) continue;
            list.add(inhDecl);
        }
        return list;
    }

    public String emitNtaIndexCheckString() {
        StringBuffer res = new StringBuffer();
        boolean firstAttr = true;
        for (AttrDecl attr : this.listOfNtaAttributes()) {
            if (firstAttr) {
                res.append("if (");
                firstAttr = false;
            } else {
                res.append(" || ");
            }
            res.append("index == " + attr.indexNTAchild());
        }
        if (!firstAttr) {
            res.append(") return true;");
        }
        return res.toString();
    }

    public void genIncrementalNotification(PrintWriter out) {
        if (!this.config().incremental()) {
            return;
        }
        TemplateContext tt = this.templateContext();
        tt.bind("AttrAffectedChecks", this.emitAttrAffectedChecksString());
        tt.expand("ASTDecl.incValueAffectedMethod", out);
        tt.bind("AttrFlushChecks", this.emitAttrFlushChecksString());
        tt.bind("CollAttrFlushChecks", this.emitCollAttrFlushChecksString());
        tt.expand("ASTDecl.incReactToDepChangeMethod", out);
        tt.bind("FlushAttrs", this.emitFlushAttrsString());
        tt.expand("ASTDecl.incFlushMethod", out);
        tt.expand("ASTNode.incFlushChildMethod", out);
        tt.bind("FlushNTAs", this.emitFlushNTAsString());
        tt.expand("ASTDecl.incFlushNTAMethod", out);
        tt.expand("ASTDecl.incFlushRegionRootMethod", out);
        tt.expand("ASTNode.incCheckRegionForInnerRewriteMethod", out);
        tt.bind("FlushNTAsInRegion", this.emitFlushNTAsInRegionString());
        tt.expand("ASTDecl.incFlushRegionMethod", out);
        tt.expand("ASTNode.incFlushRegionRewritesMethod", out);
        tt.bind("FlushNtaSubTrees", this.emitFlushNtaSubTreesString());
        tt.bind("TransferSetsFromAttrTokenHandlers", this.emitTransferSetsFromAttrTokenHandlersString());
        tt.expand("ASTDecl.incFlushSubTreeMethod", out);
        tt.expand("ASTNode.incNotifyForRemoveMethod", out);
    }

    public String emitFlushNtaSubTreesString() {
        StringBuffer res = new StringBuffer();
        TemplateContext tt = this.templateContext();
        for (AttrDecl attr : this.listOfCachedAttributes()) {
            tt.bind("IsNTA", (attr.isNTA() || attr.getNTA()) && !attr.isPrimitive() && !attr.type().equals("String") && !attr.type().equals("java.lang.String"));
            tt.bind("IsParameterized", attr.isParameterized());
            Component comp = attr.findCorrespondingNTA();
            tt.bind("IsNtaWithTree", comp == null || !(comp instanceof OptionalComponentNTA) && !(comp instanceof ListComponentNTA));
            tt.bind("AttrSign", attr.signature());
            res.append(tt.expand("ASTDecl.flushNtaSubtree"));
        }
        return res.toString();
    }

    public String emitTransferSetsFromAttrTokenHandlersString() {
        StringBuffer res = new StringBuffer();
        TemplateContext tt = this.templateContext();
        for (AttrDecl attr : this.listOfCachedAttributes()) {
            tt.bind("IsParameterized", attr.isParameterized());
            tt.bind("AttrSign", attr.signature());
            res.append(tt.expand("ASTDecl.transferSetsFromAttributeHandler"));
        }
        for (int c = 0; c < this.getNumComponent(); ++c) {
            Component comp = this.getComponent(c);
            if (!(comp instanceof TokenComponent)) continue;
            tt.bind("Id", ((TokenComponent)comp).name());
            res.append(tt.expand("ASTDecl.transferSetsFromTokenHandler"));
        }
        return res.toString();
    }

    public String emitFlushNTAsInRegionString() {
        StringBuffer res = new StringBuffer();
        TemplateContext tt = this.templateContext();
        for (AttrDecl attr : this.listOfCachedAttributes()) {
            tt.bind("IsNTA", (attr.isNTA() || attr.getNTA()) && !attr.isPrimitive() && !attr.type().equals("String") && !attr.type().equals("java.lang.String"));
            tt.bind("IsParameterized", attr.getNumParameter() > 0);
            tt.bind("AttrSign", attr.signature());
            Component comp = attr.findCorrespondingNTA();
            tt.bind("IsNtaWithTree", comp == null || comp instanceof OptionalComponentNTA || comp instanceof ListComponentNTA);
            tt.bind("AttrResetVisit", attr.resetVisit());
            tt.bind("AttrResetCache", attr.resetCache());
            res.append(tt.expand("ASTDecl.flushNTAsInRegion"));
        }
        return res.toString();
    }

    public String emitFlushNTAsString() {
        StringBuffer res = new StringBuffer();
        TemplateContext tt = this.templateContext();
        for (AttrDecl attr : this.listOfCachedAttributes()) {
            Component comp;
            if (!attr.isNTA() && !attr.getNTA() || attr.isPrimitive() || attr.type().equals("String") || attr.type().equals("java.lang.String") || attr.getNumParameter() != 0 || (comp = attr.findCorrespondingNTA()) != null && !(comp instanceof OptionalComponentNTA) && !(comp instanceof ListComponentNTA)) continue;
            tt.bind("AttrSign", attr.signature());
            tt.bind("AttrResetVisit", attr.resetVisit());
            tt.bind("AttrResetCache", attr.resetCache());
            res.append(tt.expand("ASTDecl.ntaFlush"));
        }
        return res.toString();
    }

    public String emitAttrAffectedChecksString() {
        StringBuffer res = new StringBuffer();
        TemplateContext tt = this.templateContext();
        boolean firstAttr = true;
        for (AttrDecl attr : this.listOfCachedAttributes()) {
            res.append(firstAttr ? "" : "else ");
            tt.bind("AttrResetVisit", attr.resetVisit());
            tt.bind("AttrResetCache", attr.resetCache());
            tt.bind("IsNTA", attr.getNTA() || attr.isNTA());
            tt.bind("IsParameterized", attr.getNumParameter() > 0);
            tt.bind("IsAttrWithOneParam", attr.getNumParameter() == 1);
            tt.bind("IsPrimitiveAttr", attr.isPrimitive());
            tt.bind("AttrSign", attr.signature());
            tt.bind("AttrName", attr.getName());
            tt.bind("AttrType", attr.type());
            String attrObjectType = attr.type();
            attrObjectType = attrObjectType.substring(0, 1).toUpperCase() + attrObjectType.substring(1);
            tt.bind("AttrObjectType", attrObjectType);
            tt.bind("ParamTypeSignature", attr.getNumParameter() > 0 ? attr.getParameter(0).getTypeInSignature() : "");
            res.append(tt.expand("ASTDecl.checkAttrValueAffected"));
            firstAttr = false;
        }
        return res.toString();
    }

    public String emitAttrFlushChecksString() {
        if (this.config().incrementalLevelNode() || this.config().incrementalLevelRegion()) {
            return "";
        }
        StringBuffer res = new StringBuffer();
        TemplateContext tt = this.templateContext();
        boolean firstAttr = true;
        for (AttrDecl attr : this.listOfCachedAttributes()) {
            res.append(firstAttr ? "" : "else ");
            tt.bind("IsParameterized", attr.getNumParameter() > 0);
            tt.bind("AttrSign", attr.signature());
            tt.bind("AttrType", attr.type());
            tt.bind("AttrResetVisit", attr.resetVisit());
            tt.bind("AttrResetCache", attr.resetCache());
            tt.bind("IsNTA", (attr.isNTA() || attr.getNTA()) && !attr.isPrimitive() && !attr.type().equals("String") && !attr.type().equals("java.lang.String"));
            res.append(tt.expand("ASTDecl.attrFlushCheck"));
            firstAttr = false;
        }
        return res.toString();
    }

    public String emitCollAttrFlushChecksString() {
        if (this.config().incrementalLevelNode() || this.config().incrementalLevelRegion()) {
            return "";
        }
        StringBuffer res = new StringBuffer();
        TemplateContext tt = this.templateContext();
        boolean firstAttr = true;
        for (int k = 0; k < this.getNumCollDecl(); ++k) {
            CollDecl attr = this.getCollDecl(k);
            res.append(firstAttr ? "" : "else ");
            tt.bind("AttrSign", attr.signature());
            tt.bind("AttrType", attr.type());
            tt.bind("AttrResetVisit", attr.resetVisit());
            tt.bind("AttrResetCache", attr.resetCache());
            tt.bind("CollectionReset", this.collectionReset());
            tt.bind("RootType", attr.rootType());
            res.append(tt.expand("ASTDecl.collAttrFlushCheck"));
            firstAttr = false;
        }
        return res.toString();
    }

    public String emitFlushAttrsString() {
        StringBuffer res = new StringBuffer();
        TemplateContext tt = this.templateContext();
        for (AttrDecl attr : this.listOfCachedAttributes()) {
            tt.bind("IsParameterized", attr.getNumParameter() > 0);
            tt.bind("AttrSign", attr.signature());
            tt.bind("AttrResetVisit", attr.resetVisit());
            tt.bind("AttrResetCache", attr.resetCache());
            tt.bind("IsNTA", (attr.isNTA() || attr.getNTA()) && !attr.isPrimitive() && !attr.type().equals("String") && !attr.type().equals("java.lang.String"));
            res.append(tt.expand("ASTDecl.attrFlush"));
        }
        return res.toString();
    }

    public void genIncrementalState(PrintWriter out) {
        TemplateContext tt = this.templateContext();
        tt.expand("ASTDecl.incStateFields", out);
        tt.bind("ThrowAwayTokens", this.emitThrowAwayTokensString());
        tt.bind("ThrowAwayAttributes", this.emitThrowAwayAttributesString());
        tt.expand("ASTDecl.incThrowAwayMethod", out);
    }

    public String emitThrowAwayTokensString() {
        StringBuffer res = new StringBuffer();
        TemplateContext tt = this.templateContext();
        for (int c = 0; c < this.getNumComponent(); ++c) {
            Component comp = this.getComponent(c);
            if (!(comp instanceof TokenComponent)) continue;
            tt.bind("Id", ((TokenComponent)comp).name());
            res.append(tt.expand("ASTDecl.throwAwayTokenHandler"));
        }
        return res.toString();
    }

    public String emitThrowAwayAttributesString() {
        StringBuffer res = new StringBuffer();
        TemplateContext tt = this.templateContext();
        for (AttrDecl attr : this.listOfCachedAttributes()) {
            tt.bind("IsParameterized", attr.isParameterized());
            tt.bind("AttrSign", attr.signature());
            tt.bind("ThrowAwayValue", (attr.isNTA() || attr.getNTA()) && !attr.isPrimitive() && !attr.type().equals("String") && !attr.type().equals("java.lang.String"));
            res.append(tt.expand("ASTDecl.throwAwayAttributeHandler"));
        }
        return res.toString();
    }

    public void genIncrementalCleanup(PrintWriter out) {
        if (!this.config().incremental()) {
            return;
        }
        TemplateContext tt = this.templateContext();
        tt.bind("CleanupTokenListeners", this.genCleanupTokenListenersString());
        tt.bind("CleanupAttributeListeners", this.genCleanupAttributeListenersString());
        tt.expand("ASTDecl.cleanupListenersMethod", out);
        tt.bind("CleanupListenersInNTAs", this.genCleanupListenersInNTAsString());
        tt.expand("ASTDecl.cleanupListenersInTreeMethod", out);
    }

    public void genIncrementalHandlers(PrintWriter out) {
        if (!this.config().incremental()) {
            return;
        }
        TemplateContext tt = this.templateContext();
        if (this.config().incrementalLevelRegion() && this.isRegionRoot() && !this.hasRegionRootAsSuperClass()) {
            tt.expand("ASTDecl.createNodeHandler", out);
        }
        if (this.config().incrementalLevelNode() && this.name().equals(this.config().astNodeType())) {
            tt.expand("ASTDecl.createNodeHandler", out);
        }
        if (this.config().incrementalLevelParam() || this.config().incrementalLevelAttr()) {
            if (this.name().equals(this.config().astNodeType())) {
                tt.expand("ASTDecl.createASTHandlers", out);
            }
            if (this.hasRewriteAttribute()) {
                tt.expand("ASTDecl.createRewriteAttributeHandler", out);
            }
            ArrayList<AttrDecl> decls = new ArrayList<AttrDecl>();
            for (AttrDecl attrDecl : this.synDecls()) {
                if (!attrDecl.isMemoized()) continue;
                decls.add(attrDecl);
            }
            for (AttrDecl attrDecl : this.getInhDeclList()) {
                if (!attrDecl.isMemoized()) continue;
                decls.add(attrDecl);
            }
            for (CollDecl collDecl : this.interfaceCollDecls()) {
                decls.add(collDecl);
            }
            for (CollDecl collDecl : this.getCollDeclList()) {
                decls.add(collDecl);
            }
            for (AttrDecl attrDecl : decls) {
                tt.bind("AttributeName", attrDecl.signature());
                tt.bind("IsParameterized", attrDecl.isParameterized());
                tt.expand("ASTDecl.createAttributeHandler", out);
            }
        }
    }

    public String genIncrementalInitChildHandlers() {
        if (!this.config().incremental()) {
            return "";
        }
        TemplateContext tt = this.templateContext();
        return tt.expand("ASTDecl.incrementalInitChildHandlers");
    }

    public void genIncrementalCopyHandlers(PrintWriter out) {
        if (!this.config().incremental()) {
            return;
        }
        TemplateContext tt = this.templateContext();
        tt.bind("IsRegionRoot", this.isRegionRoot());
        tt.bind("CopyTokenHandlers", this.emitCopyTokenHandlersString());
        tt.bind("CopyAttributeHandlers", this.emitCopyAttributeHandlersString());
        tt.expand("ASTDecl.incrementalCopyHandlerMethod", out);
    }

    public String genCleanupListenersInNTAsString() {
        StringBuffer res = new StringBuffer();
        TemplateContext tt = this.templateContext();
        for (AttrDecl attr : this.listOfCachedAttributes()) {
            if (!attr.isNTA() && !attr.getNTA() || attr.isPrimitive() || attr.type().equals("String") || attr.type().equals("java.lang.String")) continue;
            tt.bind("IsParameterized", attr.isParameterized());
            tt.bind("AttrSign", attr.signature());
            res.append(tt.expand("ASTDecl.checkAndCleanupNTAListeners"));
        }
        return res.toString();
    }

    public String genCleanupAttributeListenersString() {
        StringBuffer res = new StringBuffer();
        TemplateContext tt = this.templateContext();
        for (AttrDecl attr : this.listOfCachedAttributes()) {
            tt.bind("IsParameterized", attr.isParameterized());
            tt.bind("IsNTA", (attr.isNTA() || attr.getNTA()) && !attr.isPrimitive() && !attr.type().equals("String") && !attr.type().equals("java.lang.String"));
            tt.bind("AttrSign", attr.signature());
            res.append(tt.expand("ASTDecl.checkAndCleanupAttributeListeners"));
        }
        return res.toString();
    }

    public String genCleanupTokenListenersString() {
        StringBuffer res = new StringBuffer();
        TemplateContext tt = this.templateContext();
        if (this.config().incrementalLevelParam() || this.config().incrementalLevelAttr()) {
            for (Component c : this.components()) {
                if (!(c instanceof TokenComponent) || c.isNTA()) continue;
                tt.bind("Id", ((TokenComponent)c).name());
                res.append(tt.expand("ASTDecl.checkAndCleanupTokenListeners"));
            }
        }
        return res.toString();
    }

    public String emitCopyTokenHandlersString() {
        StringBuilder res = new StringBuilder();
        if (this.config().incrementalLevelParam() || this.config().incrementalLevelAttr()) {
            TemplateContext tt = this.templateContext();
            for (int c = 0; c < this.getNumComponent(); ++c) {
                Component comp = this.getComponent(c);
                if (!(comp instanceof TokenComponent)) continue;
                tt.bind("Id", ((TokenComponent)comp).name());
                res.append(tt.expand("TokenComponent.copyTokenHandler"));
            }
        }
        return res.toString();
    }

    public String emitCopyAttributeHandlersString() {
        StringBuilder res = new StringBuilder();
        if (this.config().incrementalLevelParam() || this.config().incrementalLevelAttr()) {
            ArrayList<AttrDecl> decls = new ArrayList<AttrDecl>();
            for (AttrDecl attrDecl : this.synDecls()) {
                if (attrDecl == null || !attrDecl.isMemoized()) continue;
                decls.add(attrDecl);
            }
            for (AttrDecl attrDecl : this.getInhDeclList()) {
                if (attrDecl == null || !attrDecl.isMemoized()) continue;
                decls.add(attrDecl);
            }
            TemplateContext tt = this.templateContext();
            for (AttrDecl attr : decls) {
                tt.bind("AttributeName", attr.signature());
                tt.bind("IsParameterized", attr.isParameterized());
                res.append(tt.expand("ASTDecl.copyAttributeHandler"));
            }
        }
        return res.toString();
    }

    public void genIncrementalRegions(PrintWriter out) {
        if (!this.config().incremental()) {
            return;
        }
        TemplateContext tt = this.templateContext();
        tt.bind("IsRegionRoot", this.isRegionRoot());
        if (this.config().incrementalLevelNode()) {
            tt.expand("ASTDecl.createIsRegionRootMethod", out);
            if (this.name().equals(this.config().astNodeType())) {
                tt.expand("ASTDecl.createRegionHandlerMethod", out);
            }
        }
        if (this.config().incrementalLevelRegion()) {
            tt.expand("ASTDecl.createIsRegionRootMethod", out);
            tt.expand("ASTDecl.createRegionHandlerMethod", out);
            tt.expand("ASTDecl.createRegionRootMethod", out);
            if (this.isRegionRoot() && !this.name().equals(this.config().astNodeType())) {
                tt.expand("ASTDecl.trackGetParentForRegionMethod", out);
            }
            if (this.isRegionLeaf() && (this.isListDecl() || this.isOptDecl() || !this.isASTNodeDecl())) {
                tt.bind("IsListOrOpt", this.isListDecl() || this.isOptDecl());
                tt.expand("ASTDecl.trackGetChildForRegionMethod", out);
                tt.expand("ASTDecl.trackGetChildNoTranForRegionMethod", out);
            }
        }
    }

    public ASTDecl(int i) {
        super(i);
    }

    public ASTDecl(Ast p, int i) {
        this(i);
        this.parser = p;
    }

    public ASTDecl() {
        this(0);
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[13];
        this.setChild(new Opt(), 0);
        this.setChild(new Opt(), 2);
        this.setChild(new List(), 3);
        this.setChild(new List(), 4);
        this.setChild(new List(), 5);
        this.setChild(new List(), 6);
        this.setChild(new List(), 7);
        this.setChild(new List(), 8);
        this.setChild(new List(), 9);
        this.setChild(new List(), 10);
        this.setChild(new List(), 11);
    }

    public ASTDecl(String p0, Opt<Abstract> p1, IdDecl p2, Opt<IdUse> p3, List<Component> p4, List<SynDecl> p5, List<SynEq> p6, List<InhDecl> p7, List<InhEq> p8, List<ClassBodyDecl> p9, List<Rewrite> p10, List<CollDecl> p11, List<CollEq> p12, String p13, int p14, int p15, String p16) {
        this.setAspectName(p0);
        this.setChild(p1, 0);
        this.setChild(p2, 1);
        this.setChild(p3, 2);
        this.setChild(p4, 3);
        this.setChild(p5, 4);
        this.setChild(p6, 5);
        this.setChild(p7, 6);
        this.setChild(p8, 7);
        this.setChild(p9, 8);
        this.setChild(p10, 9);
        this.setChild(p11, 10);
        this.setChild(p12, 11);
        this.setFileName(p13);
        this.setStartLine(p14);
        this.setEndLine(p15);
        this.setComment(p16);
    }

    @Override
    public void dumpTree(String indent, PrintStream out) {
        out.print(indent + "ASTDecl");
        out.print("\"" + this.getAspectName() + "\"");
        out.print("\"" + this.getFileName() + "\"");
        out.print("\"" + this.getStartLine() + "\"");
        out.print("\"" + this.getEndLine() + "\"");
        out.print("\"" + this.getComment() + "\"");
        String childIndent = indent + "  ";
        for (int i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).dumpTree(childIndent, out);
        }
    }

    @Override
    public Object jjtAccept(AstVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        this.checkChild(n, i);
        super.jjtAddChild(n, i);
    }

    @Override
    public void checkChild(Node n, int i) {
        int k;
        if (i == 0) {
            if (!(n instanceof Opt)) {
                throw new Error("Child number 0 of ASTDecl has the type " + n.getClass().getName() + " which is not an instance of Opt");
            }
            if (((Opt)n).getNumChildNoTransform() != 0 && !(((Opt)n).getChildNoTransform(0) instanceof Abstract)) {
                throw new Error("Optional name() has the type " + ((Opt)n).getChildNoTransform(0).getClass().getName() + " which is not an instance of Abstract");
            }
        }
        if (i == 1 && !(n instanceof IdDecl)) {
            throw new Error("Child number 1 of ASTDecl has the type " + n.getClass().getName() + " which is not an instance of IdDecl");
        }
        if (i == 2) {
            if (!(n instanceof Opt)) {
                throw new Error("Child number 2 of ASTDecl has the type " + n.getClass().getName() + " which is not an instance of Opt");
            }
            if (((Opt)n).getNumChildNoTransform() != 0 && !(((Opt)n).getChildNoTransform(0) instanceof IdUse)) {
                throw new Error("Optional name() has the type " + ((Opt)n).getChildNoTransform(0).getClass().getName() + " which is not an instance of IdUse");
            }
        }
        if (i == 3) {
            if (!(n instanceof List)) {
                throw new Error("Child number 3 of ASTDecl has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            for (k = 0; k < ((List)n).getNumChildNoTransform(); ++k) {
                if (((List)n).getChildNoTransform(k) instanceof Component) continue;
                throw new Error("Child number " + k + " in ComponentList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of Component");
            }
        }
        if (i == 4) {
            if (!(n instanceof List)) {
                throw new Error("Child number 4 of ASTDecl has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            for (k = 0; k < ((List)n).getNumChildNoTransform(); ++k) {
                if (((List)n).getChildNoTransform(k) instanceof SynDecl) continue;
                throw new Error("Child number " + k + " in SynDeclList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of SynDecl");
            }
        }
        if (i == 5) {
            if (!(n instanceof List)) {
                throw new Error("Child number 5 of ASTDecl has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            for (k = 0; k < ((List)n).getNumChildNoTransform(); ++k) {
                if (((List)n).getChildNoTransform(k) instanceof SynEq) continue;
                throw new Error("Child number " + k + " in SynEqList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of SynEq");
            }
        }
        if (i == 6) {
            if (!(n instanceof List)) {
                throw new Error("Child number 6 of ASTDecl has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            for (k = 0; k < ((List)n).getNumChildNoTransform(); ++k) {
                if (((List)n).getChildNoTransform(k) instanceof InhDecl) continue;
                throw new Error("Child number " + k + " in InhDeclList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of InhDecl");
            }
        }
        if (i == 7) {
            if (!(n instanceof List)) {
                throw new Error("Child number 7 of ASTDecl has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            for (k = 0; k < ((List)n).getNumChildNoTransform(); ++k) {
                if (((List)n).getChildNoTransform(k) instanceof InhEq) continue;
                throw new Error("Child number " + k + " in InhEqList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of InhEq");
            }
        }
        if (i == 8) {
            if (!(n instanceof List)) {
                throw new Error("Child number 8 of ASTDecl has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            for (k = 0; k < ((List)n).getNumChildNoTransform(); ++k) {
                if (((List)n).getChildNoTransform(k) instanceof ClassBodyDecl) continue;
                throw new Error("Child number " + k + " in ClassBodyDeclList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of ClassBodyDecl");
            }
        }
        if (i == 9) {
            if (!(n instanceof List)) {
                throw new Error("Child number 9 of ASTDecl has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            for (k = 0; k < ((List)n).getNumChildNoTransform(); ++k) {
                if (((List)n).getChildNoTransform(k) instanceof Rewrite) continue;
                throw new Error("Child number " + k + " in RewriteList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of Rewrite");
            }
        }
        if (i == 10) {
            if (!(n instanceof List)) {
                throw new Error("Child number 10 of ASTDecl has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            for (k = 0; k < ((List)n).getNumChildNoTransform(); ++k) {
                if (((List)n).getChildNoTransform(k) instanceof CollDecl) continue;
                throw new Error("Child number " + k + " in CollDeclList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of CollDecl");
            }
        }
        if (i == 11) {
            if (!(n instanceof List)) {
                throw new Error("Child number 11 of ASTDecl has the type " + n.getClass().getName() + " which is not an instance of List");
            }
            for (k = 0; k < ((List)n).getNumChildNoTransform(); ++k) {
                if (((List)n).getChildNoTransform(k) instanceof CollEq) continue;
                throw new Error("Child number " + k + " in CollEqList has the type " + ((List)n).getChildNoTransform(k).getClass().getName() + " which is not an instance of CollEq");
            }
        }
        if (i == 12 && !(n instanceof CircularRewriteDecl)) {
            throw new Error("Child number 12 of ASTDecl has the type " + n.getClass().getName() + " which is not an instance of CircularRewriteDecl");
        }
    }

    @Override
    public int getNumChild() {
        return 12;
    }

    @Override
    public boolean mayHaveRewrite() {
        return true;
    }

    @Override
    public void flushAttrCache() {
        super.flushAttrCache();
        this.lookupComponent_String_reset();
        this.superClass_reset();
        this.getSuperClassName_reset();
        this.supertypes_reset();
        this.subclasses_reset();
        this.subclassesTransitive_reset();
        this.parents_reset();
        this.isRegionRoot_reset();
        this.hasRegionRootAsSuperClass_reset();
        this.isRegionLeaf_reset();
        this.lookupInhDecl_String_reset();
        this.defaultInhEqs_reset();
        this.componentInhEqs_reset();
        this.lookupSynDecl_String_reset();
        this.lookupSynEq_String_reset();
        this.lookupInhEq_String_String_reset();
        this.hasRewrites_reset();
        this.hasRewriteAttribute_reset();
        this.getCircularRewriteDecl_reset();
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public ASTDecl clone() throws CloneNotSupportedException {
        ASTDecl node = (ASTDecl)super.clone();
        return node;
    }

    public ASTDecl copy() {
        try {
            ASTDecl node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    @Override
    @Deprecated
    public ASTDecl fullCopy() {
        return this.treeCopyNoTransform();
    }

    @Override
    public ASTDecl treeCopyNoTransform() {
        ASTDecl tree = this.copy();
        if (this.children != null) {
            block3: for (int i = 0; i < this.children.length; ++i) {
                switch (i) {
                    case 12: {
                        tree.children[i] = null;
                        continue block3;
                    }
                    default: {
                        ASTNode child = (ASTNode)this.children[i];
                        if (child == null) continue block3;
                        child = child.treeCopyNoTransform();
                        tree.setChild(child, i);
                    }
                }
            }
        }
        return tree;
    }

    @Override
    public ASTDecl treeCopy() {
        this.doFullTraversal();
        return this.treeCopyNoTransform();
    }

    @Override
    protected boolean is$Equal(ASTNode node) {
        return super.is$Equal(node) && this.tokenString_AspectName == ((ASTDecl)node).tokenString_AspectName && this.tokenString_FileName == ((ASTDecl)node).tokenString_FileName && this.tokenint_StartLine == ((ASTDecl)node).tokenint_StartLine && this.tokenint_EndLine == ((ASTDecl)node).tokenint_EndLine && this.tokenString_Comment == ((ASTDecl)node).tokenString_Comment;
    }

    @Override
    public void setAspectName(String value) {
        this.tokenString_AspectName = value;
    }

    @Override
    @ASTNodeAnnotation.Token(name="AspectName")
    public String getAspectName() {
        return this.tokenString_AspectName != null ? this.tokenString_AspectName : "";
    }

    public void setAbstractOpt(Opt<Abstract> opt) {
        this.setChild(opt, 0);
    }

    public void setAbstract(Abstract node) {
        this.getAbstractOpt().setChild(node, 0);
    }

    public boolean hasAbstract() {
        return this.getAbstractOpt().getNumChild() != 0;
    }

    public Abstract getAbstract() {
        return (Abstract)this.getAbstractOpt().getChild(0);
    }

    @ASTNodeAnnotation.OptChild(name="Abstract")
    public Opt<Abstract> getAbstractOpt() {
        return (Opt)this.getChild(0);
    }

    public Opt<Abstract> getAbstractOptNoTransform() {
        return (Opt)this.getChildNoTransform(0);
    }

    @Override
    public void setIdDecl(IdDecl node) {
        this.setChild(node, 1);
    }

    @Override
    @ASTNodeAnnotation.Child(name="IdDecl")
    public IdDecl getIdDecl() {
        return (IdDecl)this.getChild(1);
    }

    @Override
    public IdDecl getIdDeclNoTransform() {
        return (IdDecl)this.getChildNoTransform(1);
    }

    public void setSuperClassOpt(Opt<IdUse> opt) {
        this.setChild(opt, 2);
    }

    public void setSuperClass(IdUse node) {
        this.getSuperClassOpt().setChild(node, 0);
    }

    public boolean hasSuperClass() {
        return this.getSuperClassOpt().getNumChild() != 0;
    }

    public IdUse getSuperClass() {
        return (IdUse)this.getSuperClassOpt().getChild(0);
    }

    @ASTNodeAnnotation.OptChild(name="SuperClass")
    public Opt<IdUse> getSuperClassOpt() {
        return (Opt)this.getChild(2);
    }

    public Opt<IdUse> getSuperClassOptNoTransform() {
        return (Opt)this.getChildNoTransform(2);
    }

    @Override
    public void setComponentList(List<Component> list) {
        this.setChild(list, 3);
    }

    @Override
    public int getNumComponent() {
        return this.getComponentList().getNumChild();
    }

    @Override
    public int getNumComponentNoTransform() {
        return this.getComponentListNoTransform().getNumChildNoTransform();
    }

    @Override
    public Component getComponent(int i) {
        return (Component)this.getComponentList().getChild(i);
    }

    @Override
    public boolean hasComponent() {
        return this.getComponentList().getNumChild() != 0;
    }

    @Override
    public void addComponent(Component node) {
        List<Component> list = this.parent == null ? this.getComponentListNoTransform() : this.getComponentList();
        list.addChild(node);
    }

    @Override
    public void addComponentNoTransform(Component node) {
        List<Component> list = this.getComponentListNoTransform();
        list.addChild(node);
    }

    @Override
    public void setComponent(Component node, int i) {
        List<Component> list = this.getComponentList();
        list.setChild(node, i);
    }

    @Override
    @ASTNodeAnnotation.ListChild(name="Component")
    public List<Component> getComponentList() {
        List list = (List)this.getChild(3);
        return list;
    }

    @Override
    public List<Component> getComponentListNoTransform() {
        return (List)this.getChildNoTransform(3);
    }

    @Override
    public Component getComponentNoTransform(int i) {
        return (Component)this.getComponentListNoTransform().getChildNoTransform(i);
    }

    @Override
    public List<Component> getComponents() {
        return this.getComponentList();
    }

    @Override
    public List<Component> getComponentsNoTransform() {
        return this.getComponentListNoTransform();
    }

    public void setSynDeclList(List<SynDecl> list) {
        this.setChild(list, 4);
    }

    public int getNumSynDecl() {
        return this.getSynDeclList().getNumChild();
    }

    public int getNumSynDeclNoTransform() {
        return this.getSynDeclListNoTransform().getNumChildNoTransform();
    }

    public SynDecl getSynDecl(int i) {
        return (SynDecl)this.getSynDeclList().getChild(i);
    }

    public boolean hasSynDecl() {
        return this.getSynDeclList().getNumChild() != 0;
    }

    public void addSynDecl(SynDecl node) {
        List<SynDecl> list = this.parent == null ? this.getSynDeclListNoTransform() : this.getSynDeclList();
        list.addChild(node);
    }

    public void addSynDeclNoTransform(SynDecl node) {
        List<SynDecl> list = this.getSynDeclListNoTransform();
        list.addChild(node);
    }

    public void setSynDecl(SynDecl node, int i) {
        List<SynDecl> list = this.getSynDeclList();
        list.setChild(node, i);
    }

    @ASTNodeAnnotation.ListChild(name="SynDecl")
    public List<SynDecl> getSynDeclList() {
        List list = (List)this.getChild(4);
        return list;
    }

    public List<SynDecl> getSynDeclListNoTransform() {
        return (List)this.getChildNoTransform(4);
    }

    public SynDecl getSynDeclNoTransform(int i) {
        return (SynDecl)this.getSynDeclListNoTransform().getChildNoTransform(i);
    }

    public List<SynDecl> getSynDecls() {
        return this.getSynDeclList();
    }

    public List<SynDecl> getSynDeclsNoTransform() {
        return this.getSynDeclListNoTransform();
    }

    @Override
    public void setSynEqList(List<SynEq> list) {
        this.setChild(list, 5);
    }

    @Override
    public int getNumSynEq() {
        return this.getSynEqList().getNumChild();
    }

    @Override
    public int getNumSynEqNoTransform() {
        return this.getSynEqListNoTransform().getNumChildNoTransform();
    }

    @Override
    public SynEq getSynEq(int i) {
        return (SynEq)this.getSynEqList().getChild(i);
    }

    @Override
    public boolean hasSynEq() {
        return this.getSynEqList().getNumChild() != 0;
    }

    @Override
    public void addSynEq(SynEq node) {
        List<SynEq> list = this.parent == null ? this.getSynEqListNoTransform() : this.getSynEqList();
        list.addChild(node);
    }

    @Override
    public void addSynEqNoTransform(SynEq node) {
        List<SynEq> list = this.getSynEqListNoTransform();
        list.addChild(node);
    }

    @Override
    public void setSynEq(SynEq node, int i) {
        List<SynEq> list = this.getSynEqList();
        list.setChild(node, i);
    }

    @Override
    @ASTNodeAnnotation.ListChild(name="SynEq")
    public List<SynEq> getSynEqList() {
        List list = (List)this.getChild(5);
        return list;
    }

    @Override
    public List<SynEq> getSynEqListNoTransform() {
        return (List)this.getChildNoTransform(5);
    }

    @Override
    public SynEq getSynEqNoTransform(int i) {
        return (SynEq)this.getSynEqListNoTransform().getChildNoTransform(i);
    }

    @Override
    public List<SynEq> getSynEqs() {
        return this.getSynEqList();
    }

    @Override
    public List<SynEq> getSynEqsNoTransform() {
        return this.getSynEqListNoTransform();
    }

    @Override
    public void setInhDeclList(List<InhDecl> list) {
        this.setChild(list, 6);
    }

    @Override
    public int getNumInhDecl() {
        return this.getInhDeclList().getNumChild();
    }

    @Override
    public int getNumInhDeclNoTransform() {
        return this.getInhDeclListNoTransform().getNumChildNoTransform();
    }

    @Override
    public InhDecl getInhDecl(int i) {
        return (InhDecl)this.getInhDeclList().getChild(i);
    }

    @Override
    public boolean hasInhDecl() {
        return this.getInhDeclList().getNumChild() != 0;
    }

    @Override
    public void addInhDecl(InhDecl node) {
        List<InhDecl> list = this.parent == null ? this.getInhDeclListNoTransform() : this.getInhDeclList();
        list.addChild(node);
    }

    @Override
    public void addInhDeclNoTransform(InhDecl node) {
        List<InhDecl> list = this.getInhDeclListNoTransform();
        list.addChild(node);
    }

    @Override
    public void setInhDecl(InhDecl node, int i) {
        List<InhDecl> list = this.getInhDeclList();
        list.setChild(node, i);
    }

    @Override
    @ASTNodeAnnotation.ListChild(name="InhDecl")
    public List<InhDecl> getInhDeclList() {
        List list = (List)this.getChild(6);
        return list;
    }

    @Override
    public List<InhDecl> getInhDeclListNoTransform() {
        return (List)this.getChildNoTransform(6);
    }

    @Override
    public InhDecl getInhDeclNoTransform(int i) {
        return (InhDecl)this.getInhDeclListNoTransform().getChildNoTransform(i);
    }

    @Override
    public List<InhDecl> getInhDecls() {
        return this.getInhDeclList();
    }

    @Override
    public List<InhDecl> getInhDeclsNoTransform() {
        return this.getInhDeclListNoTransform();
    }

    @Override
    public void setInhEqList(List<InhEq> list) {
        this.setChild(list, 7);
    }

    @Override
    public int getNumInhEq() {
        return this.getInhEqList().getNumChild();
    }

    @Override
    public int getNumInhEqNoTransform() {
        return this.getInhEqListNoTransform().getNumChildNoTransform();
    }

    @Override
    public InhEq getInhEq(int i) {
        return (InhEq)this.getInhEqList().getChild(i);
    }

    @Override
    public boolean hasInhEq() {
        return this.getInhEqList().getNumChild() != 0;
    }

    @Override
    public void addInhEq(InhEq node) {
        List<InhEq> list = this.parent == null ? this.getInhEqListNoTransform() : this.getInhEqList();
        list.addChild(node);
    }

    @Override
    public void addInhEqNoTransform(InhEq node) {
        List<InhEq> list = this.getInhEqListNoTransform();
        list.addChild(node);
    }

    @Override
    public void setInhEq(InhEq node, int i) {
        List<InhEq> list = this.getInhEqList();
        list.setChild(node, i);
    }

    @Override
    @ASTNodeAnnotation.ListChild(name="InhEq")
    public List<InhEq> getInhEqList() {
        List list = (List)this.getChild(7);
        return list;
    }

    @Override
    public List<InhEq> getInhEqListNoTransform() {
        return (List)this.getChildNoTransform(7);
    }

    @Override
    public InhEq getInhEqNoTransform(int i) {
        return (InhEq)this.getInhEqListNoTransform().getChildNoTransform(i);
    }

    @Override
    public List<InhEq> getInhEqs() {
        return this.getInhEqList();
    }

    @Override
    public List<InhEq> getInhEqsNoTransform() {
        return this.getInhEqListNoTransform();
    }

    @Override
    public void setClassBodyDeclList(List<ClassBodyDecl> list) {
        this.setChild(list, 8);
    }

    @Override
    public int getNumClassBodyDecl() {
        return this.getClassBodyDeclList().getNumChild();
    }

    @Override
    public int getNumClassBodyDeclNoTransform() {
        return this.getClassBodyDeclListNoTransform().getNumChildNoTransform();
    }

    @Override
    public ClassBodyDecl getClassBodyDecl(int i) {
        return (ClassBodyDecl)this.getClassBodyDeclList().getChild(i);
    }

    @Override
    public boolean hasClassBodyDecl() {
        return this.getClassBodyDeclList().getNumChild() != 0;
    }

    @Override
    public void addClassBodyDecl(ClassBodyDecl node) {
        List<ClassBodyDecl> list = this.parent == null ? this.getClassBodyDeclListNoTransform() : this.getClassBodyDeclList();
        list.addChild(node);
    }

    @Override
    public void addClassBodyDeclNoTransform(ClassBodyDecl node) {
        List<ClassBodyDecl> list = this.getClassBodyDeclListNoTransform();
        list.addChild(node);
    }

    @Override
    public void setClassBodyDecl(ClassBodyDecl node, int i) {
        List<ClassBodyDecl> list = this.getClassBodyDeclList();
        list.setChild(node, i);
    }

    @Override
    @ASTNodeAnnotation.ListChild(name="ClassBodyDecl")
    public List<ClassBodyDecl> getClassBodyDeclList() {
        List list = (List)this.getChild(8);
        return list;
    }

    @Override
    public List<ClassBodyDecl> getClassBodyDeclListNoTransform() {
        return (List)this.getChildNoTransform(8);
    }

    @Override
    public ClassBodyDecl getClassBodyDeclNoTransform(int i) {
        return (ClassBodyDecl)this.getClassBodyDeclListNoTransform().getChildNoTransform(i);
    }

    @Override
    public List<ClassBodyDecl> getClassBodyDecls() {
        return this.getClassBodyDeclList();
    }

    @Override
    public List<ClassBodyDecl> getClassBodyDeclsNoTransform() {
        return this.getClassBodyDeclListNoTransform();
    }

    public void setRewriteList(List<Rewrite> list) {
        this.setChild(list, 9);
    }

    public int getNumRewrite() {
        return this.getRewriteList().getNumChild();
    }

    public int getNumRewriteNoTransform() {
        return this.getRewriteListNoTransform().getNumChildNoTransform();
    }

    public Rewrite getRewrite(int i) {
        return (Rewrite)this.getRewriteList().getChild(i);
    }

    public boolean hasRewrite() {
        return this.getRewriteList().getNumChild() != 0;
    }

    public void addRewrite(Rewrite node) {
        List<Rewrite> list = this.parent == null ? this.getRewriteListNoTransform() : this.getRewriteList();
        list.addChild(node);
    }

    public void addRewriteNoTransform(Rewrite node) {
        List<Rewrite> list = this.getRewriteListNoTransform();
        list.addChild(node);
    }

    public void setRewrite(Rewrite node, int i) {
        List<Rewrite> list = this.getRewriteList();
        list.setChild(node, i);
    }

    @ASTNodeAnnotation.ListChild(name="Rewrite")
    public List<Rewrite> getRewriteList() {
        List list = (List)this.getChild(9);
        return list;
    }

    public List<Rewrite> getRewriteListNoTransform() {
        return (List)this.getChildNoTransform(9);
    }

    public Rewrite getRewriteNoTransform(int i) {
        return (Rewrite)this.getRewriteListNoTransform().getChildNoTransform(i);
    }

    public List<Rewrite> getRewrites() {
        return this.getRewriteList();
    }

    public List<Rewrite> getRewritesNoTransform() {
        return this.getRewriteListNoTransform();
    }

    @Override
    public void setCollDeclList(List<CollDecl> list) {
        this.setChild(list, 10);
    }

    @Override
    public int getNumCollDecl() {
        return this.getCollDeclList().getNumChild();
    }

    @Override
    public int getNumCollDeclNoTransform() {
        return this.getCollDeclListNoTransform().getNumChildNoTransform();
    }

    @Override
    public CollDecl getCollDecl(int i) {
        return (CollDecl)this.getCollDeclList().getChild(i);
    }

    @Override
    public boolean hasCollDecl() {
        return this.getCollDeclList().getNumChild() != 0;
    }

    @Override
    public void addCollDecl(CollDecl node) {
        List<CollDecl> list = this.parent == null ? this.getCollDeclListNoTransform() : this.getCollDeclList();
        list.addChild(node);
    }

    @Override
    public void addCollDeclNoTransform(CollDecl node) {
        List<CollDecl> list = this.getCollDeclListNoTransform();
        list.addChild(node);
    }

    @Override
    public void setCollDecl(CollDecl node, int i) {
        List<CollDecl> list = this.getCollDeclList();
        list.setChild(node, i);
    }

    @Override
    @ASTNodeAnnotation.ListChild(name="CollDecl")
    public List<CollDecl> getCollDeclList() {
        List list = (List)this.getChild(10);
        return list;
    }

    @Override
    public List<CollDecl> getCollDeclListNoTransform() {
        return (List)this.getChildNoTransform(10);
    }

    @Override
    public CollDecl getCollDeclNoTransform(int i) {
        return (CollDecl)this.getCollDeclListNoTransform().getChildNoTransform(i);
    }

    @Override
    public List<CollDecl> getCollDecls() {
        return this.getCollDeclList();
    }

    @Override
    public List<CollDecl> getCollDeclsNoTransform() {
        return this.getCollDeclListNoTransform();
    }

    public void setCollEqList(List<CollEq> list) {
        this.setChild(list, 11);
    }

    public int getNumCollEq() {
        return this.getCollEqList().getNumChild();
    }

    public int getNumCollEqNoTransform() {
        return this.getCollEqListNoTransform().getNumChildNoTransform();
    }

    public CollEq getCollEq(int i) {
        return (CollEq)this.getCollEqList().getChild(i);
    }

    public boolean hasCollEq() {
        return this.getCollEqList().getNumChild() != 0;
    }

    public void addCollEq(CollEq node) {
        List<CollEq> list = this.parent == null ? this.getCollEqListNoTransform() : this.getCollEqList();
        list.addChild(node);
    }

    public void addCollEqNoTransform(CollEq node) {
        List<CollEq> list = this.getCollEqListNoTransform();
        list.addChild(node);
    }

    public void setCollEq(CollEq node, int i) {
        List<CollEq> list = this.getCollEqList();
        list.setChild(node, i);
    }

    @ASTNodeAnnotation.ListChild(name="CollEq")
    public List<CollEq> getCollEqList() {
        List list = (List)this.getChild(11);
        return list;
    }

    public List<CollEq> getCollEqListNoTransform() {
        return (List)this.getChildNoTransform(11);
    }

    public CollEq getCollEqNoTransform(int i) {
        return (CollEq)this.getCollEqListNoTransform().getChildNoTransform(i);
    }

    public List<CollEq> getCollEqs() {
        return this.getCollEqList();
    }

    public List<CollEq> getCollEqsNoTransform() {
        return this.getCollEqListNoTransform();
    }

    @Override
    public void setFileName(String value) {
        this.tokenString_FileName = value;
    }

    @Override
    @ASTNodeAnnotation.Token(name="FileName")
    public String getFileName() {
        return this.tokenString_FileName != null ? this.tokenString_FileName : "";
    }

    @Override
    public void setStartLine(int value) {
        this.tokenint_StartLine = value;
    }

    @Override
    @ASTNodeAnnotation.Token(name="StartLine")
    public int getStartLine() {
        return this.tokenint_StartLine;
    }

    @Override
    public void setEndLine(int value) {
        this.tokenint_EndLine = value;
    }

    @Override
    @ASTNodeAnnotation.Token(name="EndLine")
    public int getEndLine() {
        return this.tokenint_EndLine;
    }

    @Override
    public void setComment(String value) {
        this.tokenString_Comment = value;
    }

    @Override
    @ASTNodeAnnotation.Token(name="Comment")
    public String getComment() {
        return this.tokenString_Comment != null ? this.tokenString_Comment : "";
    }

    public CircularRewriteDecl getCircularRewriteDeclNoTransform() {
        return (CircularRewriteDecl)this.getChildNoTransform(12);
    }

    protected int getCircularRewriteDeclChildPosition() {
        return 12;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="ASTCloneNode", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/ASTCopyNode.jadd:31")
    public String copyReturnType() {
        if (this.copyReturnType_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.copyReturnType().");
        }
        this.copyReturnType_visited = this.state().boundariesCrossed;
        try {
            if (this.isOptDecl() || this.isListDecl() || this.isASTNodeDecl()) {
                String string = this.name() + "<T>";
                return string;
            }
            String string = this.name();
            return string;
        }
        finally {
            this.copyReturnType_visited = -1;
        }
    }

    private void lookupComponent_String_reset() {
        this.lookupComponent_String_values = new HashMap(4);
        this.lookupComponent_String_visited = new HashMap(4);
    }

    @Override
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Lookup", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/ASTNameBinding.jrag:90")
    public Component lookupComponent(String name) {
        String _parameters = name;
        ASTNode$State state = this.state();
        if (this.lookupComponent_String_values.containsKey(_parameters)) {
            return (Component)this.lookupComponent_String_values.get(_parameters);
        }
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.lookupComponent_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.lookupComponent(String).");
        }
        this.lookupComponent_String_visited.put(_parameters, this.state().boundariesCrossed);
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        Component lookupComponent_String_value = this.lookupComponent_compute(name);
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.lookupComponent_String_values.put(_parameters, lookupComponent_String_value);
        }
        this.state().leaveLazyAttribute();
        this.lookupComponent_String_visited.remove(_parameters);
        return lookupComponent_String_value;
    }

    private Component lookupComponent_compute(String name) {
        for (Component c : this.components()) {
            if (!c.name().equals(name)) continue;
            return c;
        }
        return null;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Annotations", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/Annotations.jrag:89")
    public String annotations() {
        if (this.annotations_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.annotations().");
        }
        this.annotations_visited = this.state().boundariesCrossed;
        String annotations_value = "";
        this.annotations_visited = -1;
        return annotations_value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Superclass", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/ClassRelations.jrag:40")
    public boolean testCircular(String name) {
        String _parameters = name;
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.testCircular_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.testCircular(String).");
        }
        this.testCircular_String_visited.put(_parameters, this.state().boundariesCrossed);
        try {
            if (!this.hasSuperClass()) {
                boolean bl = false;
                return bl;
            }
            if (this.getSuperClassName().equals(name)) {
                boolean bl = true;
                return bl;
            }
            ASTDecl superClass = (ASTDecl)this.grammar().lookup(this.getSuperClassName());
            boolean bl = superClass != null ? superClass.testCircular(name) : false;
            return bl;
        }
        finally {
            this.testCircular_String_visited.remove(_parameters);
        }
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Superclass", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/ClassRelations.jrag:51")
    public boolean isCircular() {
        if (this.isCircular_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.isCircular().");
        }
        this.isCircular_visited = this.state().boundariesCrossed;
        boolean isCircular_value = this.testCircular(this.name());
        this.isCircular_visited = -1;
        return isCircular_value;
    }

    private void superClass_reset() {
        this.superClass_computed = false;
        this.superClass_value = null;
        this.superClass_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Superclass", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/ClassRelations.jrag:53")
    public ASTDecl superClass() {
        ASTNode$State state = this.state();
        if (this.superClass_computed) {
            return this.superClass_value;
        }
        if (this.superClass_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.superClass().");
        }
        this.superClass_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        ASTDecl aSTDecl = this.superClass_value = this.hasSuperClass() && !this.isCircular() ? (ASTDecl)this.grammar().lookup(this.getSuperClassName()) : null;
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.superClass_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.superClass_visited = -1;
        return this.superClass_value;
    }

    private void getSuperClassName_reset() {
        this.getSuperClassName_computed = false;
        this.getSuperClassName_value = null;
        this.getSuperClassName_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Superclass", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/ClassRelations.jrag:58")
    public String getSuperClassName() {
        ASTNode$State state = this.state();
        if (this.getSuperClassName_computed) {
            return this.getSuperClassName_value;
        }
        if (this.getSuperClassName_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.getSuperClassName().");
        }
        this.getSuperClassName_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        String string = this.getSuperClassName_value = this.hasSuperClass() ? this.getSuperClass().name() : null;
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.getSuperClassName_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.getSuperClassName_visited = -1;
        return this.getSuperClassName_value;
    }

    private void supertypes_reset() {
        this.supertypes_computed = false;
        this.supertypes_value = null;
        this.supertypes_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Superclass", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/ClassRelations.jrag:64")
    public Collection<ASTDecl> supertypes() {
        ASTNode$State state = this.state();
        if (this.supertypes_computed) {
            return this.supertypes_value;
        }
        if (this.supertypes_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.supertypes().");
        }
        this.supertypes_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.supertypes_value = this.supertypes_compute();
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.supertypes_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.supertypes_visited = -1;
        return this.supertypes_value;
    }

    private Collection<ASTDecl> supertypes_compute() {
        if (this.superClass() != null) {
            LinkedList<ASTDecl> types = new LinkedList<ASTDecl>();
            types.addAll(this.superClass().supertypes());
            types.add(this.superClass());
            return types;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="InstanceOf", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/ClassRelations.jrag:77")
    public boolean instanceOf(TypeDecl c) {
        TypeDecl _parameters = c;
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.instanceOf_TypeDecl_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.instanceOf(TypeDecl).");
        }
        this.instanceOf_TypeDecl_visited.put(_parameters, this.state().boundariesCrossed);
        try {
            if (c == this) {
                boolean bl = true;
                return bl;
            }
            ASTDecl superClass = this.superClass();
            boolean bl = superClass != null ? ((TypeDecl)superClass).instanceOf(c) : false;
            return bl;
        }
        finally {
            this.instanceOf_TypeDecl_visited.remove(_parameters);
        }
    }

    private void subclasses_reset() {
        this.subclasses_computed = false;
        this.subclasses_value = null;
        this.subclasses_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Subclasses", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/ClassRelations.jrag:110")
    public Collection<ASTDecl> subclasses() {
        ASTNode$State state = this.state();
        if (this.subclasses_computed) {
            return this.subclasses_value;
        }
        if (this.subclasses_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.subclasses().");
        }
        this.subclasses_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.subclasses_value = this.findSubclasses(this);
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.subclasses_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.subclasses_visited = -1;
        return this.subclasses_value;
    }

    private void subclassesTransitive_reset() {
        this.subclassesTransitive_computed = false;
        this.subclassesTransitive_value = null;
        this.subclassesTransitive_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Subclasses", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/ClassRelations.jrag:116")
    public Set<ASTDecl> subclassesTransitive() {
        ASTNode$State state = this.state();
        if (this.subclassesTransitive_computed) {
            return this.subclassesTransitive_value;
        }
        if (this.subclassesTransitive_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.subclassesTransitive().");
        }
        this.subclassesTransitive_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.subclassesTransitive_value = this.subclassesTransitive_compute();
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.subclassesTransitive_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.subclassesTransitive_visited = -1;
        return this.subclassesTransitive_value;
    }

    private Set<ASTDecl> subclassesTransitive_compute() {
        LinkedHashSet<ASTDecl> set = new LinkedHashSet<ASTDecl>(this.subclasses());
        for (ASTDecl decl : this.subclasses()) {
            set.addAll(decl.subclassesTransitive());
        }
        return set;
    }

    private void parents_reset() {
        this.parents_computed = false;
        this.parents_value = null;
        this.parents_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Parents", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/ClassRelations.jrag:158")
    public Collection<ASTDecl> parents() {
        ASTNode$State state = this.state();
        if (this.parents_computed) {
            return this.parents_value;
        }
        if (this.parents_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.parents().");
        }
        this.parents_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.parents_value = this.parents_compute();
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.parents_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.parents_visited = -1;
        return this.parents_value;
    }

    private Collection<ASTDecl> parents_compute() {
        HashMap<TypeDecl, Collection<ASTDecl>> map = this.grammar().parentMap();
        LinkedHashSet<ASTDecl> parents = new LinkedHashSet<ASTDecl>();
        for (ASTDecl node = this; node != null; node = node.superClass()) {
            parents.addAll(map.get(node));
        }
        return parents;
    }

    @Override
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Comments", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/Comments.jrag:169")
    public String typeDeclKind() {
        if (this.typeDeclKind_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.typeDeclKind().");
        }
        this.typeDeclKind_visited = this.state().boundariesCrossed;
        String typeDeclKind_value = "node";
        this.typeDeclKind_visited = -1;
        return typeDeclKind_value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="ASTDecl", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/ComponentsUtil.jrag:32")
    public Collection<Component> components() {
        if (this.components_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.components().");
        }
        this.components_visited = this.state().boundariesCrossed;
        try {
            LinkedList<Component> list = new LinkedList<Component>();
            if (this.superClass() != null) {
                list.addAll(this.superClass().components());
            }
            for (int i = 0; i < this.getNumComponent(); ++i) {
                int j;
                boolean done = false;
                ListIterator iter = list.listIterator();
                while (!done && iter.hasNext()) {
                    Component c = (Component)iter.next();
                    if (!c.name().equals(this.getComponent(i).name()) || !c.type().equals(this.getComponent(i).type())) continue;
                    iter.remove();
                    done = true;
                }
                if (this.getComponent(i).isNTA()) {
                    list.add(this.getComponent(i));
                    continue;
                }
                for (j = 0; j < list.size() && !list.get(j).isNTA(); ++j) {
                }
                list.add(j, this.getComponent(i));
            }
            LinkedList<Component> linkedList = list;
            return linkedList;
        }
        finally {
            this.components_visited = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="ASTDecl", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/ComponentsUtil.jrag:59")
    public boolean redefinesTokenComponent(TokenComponent c) {
        TokenComponent _parameters = c;
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.redefinesTokenComponent_TokenComponent_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.redefinesTokenComponent(TokenComponent).");
        }
        this.redefinesTokenComponent_TokenComponent_visited.put(_parameters, this.state().boundariesCrossed);
        try {
            if (c.hostClass() != this) {
                boolean bl = false;
                return bl;
            }
            if (this.superClass() == null) {
                boolean bl = true;
                return bl;
            }
            for (Component d : this.superClass().components()) {
                if (!d.name().equals(c.name()) || !(d instanceof TokenComponent) || c.isNTA() != d.isNTA()) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.redefinesTokenComponent_TokenComponent_visited.remove(_parameters);
        }
    }

    private void isRegionRoot_reset() {
        this.isRegionRoot_computed = false;
        this.isRegionRoot_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="CoarseIncremental", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/ComponentsUtil.jrag:135")
    public boolean isRegionRoot() {
        ASTNode$State state = this.state();
        if (this.isRegionRoot_computed) {
            return this.isRegionRoot_value;
        }
        if (this.isRegionRoot_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.isRegionRoot().");
        }
        this.isRegionRoot_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        boolean bl = this.isRegionRoot_value = this.isRootNode() || this.lookupRegionDecl(this.name()) != null;
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.isRegionRoot_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.isRegionRoot_visited = -1;
        return this.isRegionRoot_value;
    }

    private void hasRegionRootAsSuperClass_reset() {
        this.hasRegionRootAsSuperClass_computed = false;
        this.hasRegionRootAsSuperClass_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="CoarseIncremental", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/ComponentsUtil.jrag:148")
    public boolean hasRegionRootAsSuperClass() {
        ASTNode$State state = this.state();
        if (this.hasRegionRootAsSuperClass_computed) {
            return this.hasRegionRootAsSuperClass_value;
        }
        if (this.hasRegionRootAsSuperClass_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.hasRegionRootAsSuperClass().");
        }
        this.hasRegionRootAsSuperClass_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.hasRegionRootAsSuperClass_value = this.hasRegionRootAsSuperClass_compute();
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.hasRegionRootAsSuperClass_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.hasRegionRootAsSuperClass_visited = -1;
        return this.hasRegionRootAsSuperClass_value;
    }

    private boolean hasRegionRootAsSuperClass_compute() {
        ASTDecl superDecl = this.superClass();
        if (superDecl != null) {
            if (superDecl.isRegionRoot()) {
                return true;
            }
            return superDecl.hasRegionRootAsSuperClass();
        }
        return false;
    }

    private void isRegionLeaf_reset() {
        this.isRegionLeaf_computed = false;
        this.isRegionLeaf_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="CoarseIncremental", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/ComponentsUtil.jrag:159")
    public boolean isRegionLeaf() {
        ASTNode$State state = this.state();
        if (this.isRegionLeaf_computed) {
            return this.isRegionLeaf_value;
        }
        if (this.isRegionLeaf_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.isRegionLeaf().");
        }
        this.isRegionLeaf_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.isRegionLeaf_value = this.isRegionLeaf_compute();
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.isRegionLeaf_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.isRegionLeaf_visited = -1;
        return this.isRegionLeaf_value;
    }

    private boolean isRegionLeaf_compute() {
        if (this.name().equals(this.config().listType()) || this.name().equals(this.config().optType())) {
            TypeDecl type = this.grammar().lookup(this.config().astNodeType());
            return type == null || !(type instanceof ASTDecl) || !((ASTDecl)type).isRegionRoot();
        }
        for (int i = 0; i < this.getNumComponent(); ++i) {
            Component comp = this.getComponent(i);
            TypeDecl type = this.grammar().lookup(comp.type());
            if (type == null || !(type instanceof ASTDecl) || !((ASTDecl)type).isRegionRoot()) continue;
            return true;
        }
        return false;
    }

    private void lookupInhDecl_String_reset() {
        this.lookupInhDecl_String_values = new HashMap(4);
        this.lookupInhDecl_String_visited = new HashMap(4);
    }

    @Override
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="InheritedAttributes", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/InheritedAttributes.jrag:86")
    public InhDecl lookupInhDecl(String signature) {
        String _parameters = signature;
        ASTNode$State state = this.state();
        if (this.lookupInhDecl_String_values.containsKey(_parameters)) {
            return (InhDecl)this.lookupInhDecl_String_values.get(_parameters);
        }
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.lookupInhDecl_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.lookupInhDecl(String).");
        }
        this.lookupInhDecl_String_visited.put(_parameters, this.state().boundariesCrossed);
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        InhDecl lookupInhDecl_String_value = this.lookupInhDecl_compute(signature);
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.lookupInhDecl_String_values.put(_parameters, lookupInhDecl_String_value);
        }
        this.state().leaveLazyAttribute();
        this.lookupInhDecl_String_visited.remove(_parameters);
        return lookupInhDecl_String_value;
    }

    private InhDecl lookupInhDecl_compute(String signature) {
        InhDecl decl = super.lookupInhDecl(signature);
        if (decl != null || this.superClass() == null) {
            return decl;
        }
        return this.superClass().lookupInhDecl(signature);
    }

    private void defaultInhEqs_reset() {
        this.defaultInhEqs_computed = false;
        this.defaultInhEqs_value = null;
        this.defaultInhEqs_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="FindInheritedEquations", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/InheritedAttributes.jrag:135")
    public Collection<String> defaultInhEqs() {
        ASTNode$State state = this.state();
        if (this.defaultInhEqs_computed) {
            return this.defaultInhEqs_value;
        }
        if (this.defaultInhEqs_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.defaultInhEqs().");
        }
        this.defaultInhEqs_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.defaultInhEqs_value = this.defaultInhEqs_compute();
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.defaultInhEqs_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.defaultInhEqs_visited = -1;
        return this.defaultInhEqs_value;
    }

    private Collection<String> defaultInhEqs_compute() {
        HashSet<String> defaultEqs = new HashSet<String>();
        for (InhEq equ : this.getInhEqList()) {
            String childName = equ.childName();
            String signature = equ.signature();
            if (!childName.equals("Child")) continue;
            defaultEqs.add(signature);
        }
        if (this.superClass() != null) {
            defaultEqs.addAll(this.superClass().defaultInhEqs());
        }
        return defaultEqs;
    }

    private void componentInhEqs_reset() {
        this.componentInhEqs_computed = false;
        this.componentInhEqs_value = null;
        this.componentInhEqs_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="FindInheritedEquations", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/InheritedAttributes.jrag:150")
    public Map<String, Collection<String>> componentInhEqs() {
        ASTNode$State state = this.state();
        if (this.componentInhEqs_computed) {
            return this.componentInhEqs_value;
        }
        if (this.componentInhEqs_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.componentInhEqs().");
        }
        this.componentInhEqs_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.componentInhEqs_value = this.componentInhEqs_compute();
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.componentInhEqs_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.componentInhEqs_visited = -1;
        return this.componentInhEqs_value;
    }

    private Map<String, Collection<String>> componentInhEqs_compute() {
        HashMap<String, Collection<String>> componentEqs = new HashMap<String, Collection<String>>();
        for (InhEq equ : this.getInhEqList()) {
            String childName = equ.childName();
            String signature = equ.signature();
            if (childName.equals("Child")) continue;
            HashSet<String> eqs = (HashSet<String>)componentEqs.get(childName);
            if (eqs == null) {
                eqs = new HashSet<String>();
                componentEqs.put(childName, eqs);
            }
            eqs.add(signature);
        }
        if (this.superClass() != null) {
            componentEqs.putAll(this.superClass().componentInhEqs());
        }
        return componentEqs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="FindInheritedEquations", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/InheritedAttributes.jrag:254")
    public boolean hasInhEqForDecl(String childName, String signature) {
        ArrayList<String> _parameters = new ArrayList<String>(2);
        _parameters.add(childName);
        _parameters.add(signature);
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.hasInhEqForDecl_String_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.hasInhEqForDecl(String,String).");
        }
        this.hasInhEqForDecl_String_String_visited.put(_parameters, this.state().boundariesCrossed);
        try {
            if (this.defaultInhEqs().contains(signature)) {
                boolean bl = true;
                return bl;
            }
            Collection<String> componentEqs = this.componentInhEqs().get(childName);
            boolean bl = componentEqs != null && componentEqs.contains(signature);
            return bl;
        }
        finally {
            this.hasInhEqForDecl_String_String_visited.remove(_parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="JaddCodeGen", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/JaddCodeGen.jrag:72")
    public int numNonNTAComponent() {
        if (this.numNonNTAComponent_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.numNonNTAComponent().");
        }
        this.numNonNTAComponent_visited = this.state().boundariesCrossed;
        try {
            int num = 0;
            for (Component c : this.components()) {
                if (c.isNTA()) continue;
                ++num;
            }
            int n = num;
            return n;
        }
        finally {
            this.numNonNTAComponent_visited = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="JaddCodeGen", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/JaddCodeGen.jrag:85")
    public int childCount() {
        if (this.childCount_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.childCount().");
        }
        this.childCount_visited = this.state().boundariesCrossed;
        try {
            int i = 0;
            for (Component c : this.components()) {
                if (c instanceof TokenComponent) continue;
                ++i;
            }
            int n = i;
            return n;
        }
        finally {
            this.childCount_visited = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="JaddCodeGen", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/JaddCodeGen.jrag:98")
    public int numRegularChildren() {
        if (this.numRegularChildren_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.numRegularChildren().");
        }
        this.numRegularChildren_visited = this.state().boundariesCrossed;
        try {
            int i = 0;
            for (Component c : this.components()) {
                if (c.isNTA() || c instanceof TokenComponent) continue;
                ++i;
            }
            int n = i;
            return n;
        }
        finally {
            this.numRegularChildren_visited = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="JaddCodeGen", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/JaddCodeGen.jrag:108")
    public boolean hasSynEq(String name) {
        String _parameters = name;
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.hasSynEq_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.hasSynEq(String).");
        }
        this.hasSynEq_String_visited.put(_parameters, this.state().boundariesCrossed);
        try {
            for (SynEq eq : this.getSynEqList()) {
                if (!eq.name().equals(name)) continue;
                boolean bl = true;
                return bl;
            }
            if (this.superClass() != null) {
                boolean bl = this.superClass().hasSynEq(name);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.hasSynEq_String_visited.remove(_parameters);
        }
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="JaddCodeGen", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/JaddCodeGen.jrag:384")
    public String initialChildArraySize() {
        if (this.initialChildArraySize_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.initialChildArraySize().");
        }
        this.initialChildArraySize_visited = this.state().boundariesCrossed;
        String initialChildArraySize_value = String.format("(i + 1 > %d || !(this instanceof %s)) ? i + 1 : %d", this.config().minListSize(), this.config().listType(), this.config().minListSize());
        this.initialChildArraySize_visited = -1;
        return initialChildArraySize_value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="JaddCodeGen", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/JaddCodeGen.jrag:391")
    public String debugASTNodeState() {
        if (this.debugASTNodeState_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.debugASTNodeState().");
        }
        this.debugASTNodeState_visited = this.state().boundariesCrossed;
        try {
            if (this.config().debugMode() && !this.grammar().roots().isEmpty()) {
                StringBuilder buf = new StringBuilder();
                buf.append("if (");
                boolean first = true;
                for (ASTDecl root : this.grammar().roots()) {
                    if (!first) {
                        buf.append(" && ");
                    }
                    first = false;
                    buf.append("!(this instanceof " + root.name() + ")");
                }
                buf.append(")\n");
                buf.append(this.config().indent + "throw new RuntimeException(\"Trying to evaluate state in a node which is not attached to the main tree\");");
                String string = buf.toString();
                return string;
            }
            String string = "";
            return string;
        }
        finally {
            this.debugASTNodeState_visited = -1;
        }
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="JaddCodeGen", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/JaddCodeGen.jrag:442")
    public boolean needsListTouched() {
        if (this.needsListTouched_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.needsListTouched().");
        }
        this.needsListTouched_visited = this.state().boundariesCrossed;
        boolean needsListTouched_value = this.config().legacyRewrite();
        this.needsListTouched_visited = -1;
        return needsListTouched_value;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="JaddCodeGen", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/JaddCodeGen.jrag:468")
    public boolean isASTNodeDecl() {
        if (this.isASTNodeDecl_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.isASTNodeDecl().");
        }
        this.isASTNodeDecl_visited = this.state().boundariesCrossed;
        boolean isASTNodeDecl_value = this.name().equals(this.config().astNodeType());
        this.isASTNodeDecl_visited = -1;
        return isASTNodeDecl_value;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="JaddCodeGen", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/JaddCodeGen.jrag:470")
    public boolean isOptDecl() {
        if (this.isOptDecl_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.isOptDecl().");
        }
        this.isOptDecl_visited = this.state().boundariesCrossed;
        boolean isOptDecl_value = this.name().equals(this.config().optType());
        this.isOptDecl_visited = -1;
        return isOptDecl_value;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="JaddCodeGen", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/JaddCodeGen.jrag:472")
    public boolean isListDecl() {
        if (this.isListDecl_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.isListDecl().");
        }
        this.isListDecl_visited = this.state().boundariesCrossed;
        boolean isListDecl_value = this.name().equals(this.config().listType());
        this.isListDecl_visited = -1;
        return isListDecl_value;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="JaddCodeGen", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/JaddCodeGen.jrag:474")
    public boolean isOptSubtype() {
        if (this.isOptSubtype_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.isOptSubtype().");
        }
        this.isOptSubtype_visited = this.state().boundariesCrossed;
        boolean isOptSubtype_value = this.isOptDecl() || this.superClass() != null && this.superClass().isOptSubtype();
        this.isOptSubtype_visited = -1;
        return isOptSubtype_value;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="JaddCodeGen", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/JaddCodeGen.jrag:477")
    public boolean isListSubtype() {
        if (this.isListSubtype_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.isListSubtype().");
        }
        this.isListSubtype_visited = this.state().boundariesCrossed;
        boolean isListSubtype_value = this.isListDecl() || this.superClass() != null && this.superClass().isListSubtype();
        this.isListSubtype_visited = -1;
        return isListSubtype_value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="JaddCodeGen", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/JaddCodeGen.jrag:484")
    public String checkRegularNodeStructure() {
        if (this.checkRegularNodeStructure_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.checkRegularNodeStructure().");
        }
        this.checkRegularNodeStructure_visited = this.state().boundariesCrossed;
        try {
            StringBuilder buf = new StringBuilder();
            int j = 0;
            for (Component c : this.components()) {
                buf.append(c.checkComponentStructure(j));
                if (c instanceof TokenComponent) continue;
                ++j;
            }
            String string = buf.toString();
            return string;
        }
        finally {
            this.checkRegularNodeStructure_visited = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="JaddCodeGen", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/JaddCodeGen.jrag:522")
    public String jjtGenPrintChildren() {
        if (this.jjtGenPrintChildren_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.jjtGenPrintChildren().");
        }
        this.jjtGenPrintChildren_visited = this.state().boundariesCrossed;
        try {
            StringBuilder buf = new StringBuilder();
            for (Component c : this.components()) {
                if (!(c instanceof TokenComponent)) continue;
                TokenComponent t = (TokenComponent)c;
                buf.append("out.print(\"\\\"\" + get" + t.name() + "() + \"\\\"\");\n");
            }
            String string = buf.toString();
            return string;
        }
        finally {
            this.jjtGenPrintChildren_visited = -1;
        }
    }

    @Override
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="JragCodeGen", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/JragCodeGen.jrag:771")
    public boolean hasInhEq(String attrName) {
        String _parameters = attrName;
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.hasInhEq_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.hasInhEq(String).");
        }
        this.hasInhEq_String_visited.put(_parameters, this.state().boundariesCrossed);
        boolean hasInhEq_String_value = super.hasInhEq(attrName) || this.superClass() != null && this.superClass().hasInhEq(attrName);
        this.hasInhEq_String_visited.remove(_parameters);
        return hasInhEq_String_value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="JragCodeGen", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/JragCodeGen.jrag:806")
    public SynDecl lookupSynDeclPrefix(String signature) {
        String _parameters = signature;
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.lookupSynDeclPrefix_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.lookupSynDeclPrefix(String).");
        }
        this.lookupSynDeclPrefix_String_visited.put(_parameters, this.state().boundariesCrossed);
        try {
            SynDecl decl = super.lookupSynDeclPrefix(signature);
            if (decl != null || this.superClass() == null) {
                SynDecl synDecl = decl;
                return synDecl;
            }
            SynDecl synDecl = this.superClass().lookupSynDeclPrefix(signature);
            return synDecl;
        }
        finally {
            this.lookupSynDeclPrefix_String_visited.remove(_parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="JragCodeGen", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/JragCodeGen.jrag:834")
    public InhDecl lookupInhDeclPrefix(String signature) {
        String _parameters = signature;
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.lookupInhDeclPrefix_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.lookupInhDeclPrefix(String).");
        }
        this.lookupInhDeclPrefix_String_visited.put(_parameters, this.state().boundariesCrossed);
        try {
            InhDecl decl = super.lookupInhDeclPrefix(signature);
            if (decl != null || this.superClass() == null) {
                InhDecl inhDecl = decl;
                return inhDecl;
            }
            InhDecl inhDecl = this.superClass().lookupInhDeclPrefix(signature);
            return inhDecl;
        }
        finally {
            this.lookupInhDeclPrefix_String_visited.remove(_parameters);
        }
    }

    private void lookupSynDecl_String_reset() {
        this.lookupSynDecl_String_values = new HashMap(4);
        this.lookupSynDecl_String_visited = new HashMap(4);
    }

    @Override
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="BindSynEquations", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/NameBinding.jrag:105")
    public SynDecl lookupSynDecl(String signature) {
        String _parameters = signature;
        ASTNode$State state = this.state();
        if (this.lookupSynDecl_String_values.containsKey(_parameters)) {
            return (SynDecl)this.lookupSynDecl_String_values.get(_parameters);
        }
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.lookupSynDecl_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.lookupSynDecl(String).");
        }
        this.lookupSynDecl_String_visited.put(_parameters, this.state().boundariesCrossed);
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        SynDecl lookupSynDecl_String_value = this.lookupSynDecl_compute(signature);
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.lookupSynDecl_String_values.put(_parameters, lookupSynDecl_String_value);
        }
        this.state().leaveLazyAttribute();
        this.lookupSynDecl_String_visited.remove(_parameters);
        return lookupSynDecl_String_value;
    }

    private SynDecl lookupSynDecl_compute(String signature) {
        SynDecl decl = super.lookupSynDecl(signature);
        if (decl != null || this.superClass() == null) {
            return decl;
        }
        return this.superClass().lookupSynDecl(signature);
    }

    private void lookupSynEq_String_reset() {
        this.lookupSynEq_String_values = new HashMap(4);
        this.lookupSynEq_String_visited = new HashMap(4);
    }

    @Override
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="BindSynEquations", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/NameBinding.jrag:122")
    public SynEq lookupSynEq(String signature) {
        String _parameters = signature;
        ASTNode$State state = this.state();
        if (this.lookupSynEq_String_values.containsKey(_parameters)) {
            return (SynEq)this.lookupSynEq_String_values.get(_parameters);
        }
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.lookupSynEq_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.lookupSynEq(String).");
        }
        this.lookupSynEq_String_visited.put(_parameters, this.state().boundariesCrossed);
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        SynEq lookupSynEq_String_value = this.lookupSynEq_compute(signature);
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.lookupSynEq_String_values.put(_parameters, lookupSynEq_String_value);
        }
        this.state().leaveLazyAttribute();
        this.lookupSynEq_String_visited.remove(_parameters);
        return lookupSynEq_String_value;
    }

    private SynEq lookupSynEq_compute(String signature) {
        SynEq equations = super.lookupSynEq(signature);
        if (equations != null || this.superClass() == null) {
            return equations;
        }
        return this.superClass().lookupSynEq(signature);
    }

    private void lookupInhEq_String_String_reset() {
        this.lookupInhEq_String_String_values = new HashMap(4);
        this.lookupInhEq_String_String_visited = new HashMap(4);
    }

    @Override
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="BindSynEquations", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/NameBinding.jrag:142")
    public InhEq lookupInhEq(String signature, String childName) {
        ArrayList<String> _parameters = new ArrayList<String>(2);
        _parameters.add(signature);
        _parameters.add(childName);
        ASTNode$State state = this.state();
        if (this.lookupInhEq_String_String_values.containsKey(_parameters)) {
            return (InhEq)this.lookupInhEq_String_String_values.get(_parameters);
        }
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.lookupInhEq_String_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.lookupInhEq(String,String).");
        }
        this.lookupInhEq_String_String_visited.put(_parameters, this.state().boundariesCrossed);
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        InhEq lookupInhEq_String_String_value = this.lookupInhEq_compute(signature, childName);
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.lookupInhEq_String_String_values.put(_parameters, lookupInhEq_String_String_value);
        }
        this.state().leaveLazyAttribute();
        this.lookupInhEq_String_String_visited.remove(_parameters);
        return lookupInhEq_String_String_value;
    }

    private InhEq lookupInhEq_compute(String signature, String childName) {
        InhEq equation = super.lookupInhEq(signature, childName);
        if (equation != null || this.superClass() == null) {
            return equation;
        }
        return this.superClass().lookupInhEq(signature, childName);
    }

    private void hasRewrites_reset() {
        this.hasRewrites_computed = false;
        this.hasRewrites_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Rewrites", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/Rewrites.jrag:149")
    public boolean hasRewrites() {
        ASTNode$State state = this.state();
        if (this.hasRewrites_computed) {
            return this.hasRewrites_value;
        }
        if (this.hasRewrites_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.hasRewrites().");
        }
        this.hasRewrites_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        boolean bl = this.hasRewrites_value = this.getNumRewrite() > 0 || this.superClass() != null && this.superClass().hasRewrites();
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.hasRewrites_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.hasRewrites_visited = -1;
        return this.hasRewrites_value;
    }

    private void hasRewriteAttribute_reset() {
        this.hasRewriteAttribute_computed = false;
        this.hasRewriteAttribute_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Rewrites", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/Rewrites.jrag:156")
    public boolean hasRewriteAttribute() {
        ASTNode$State state = this.state();
        if (this.hasRewriteAttribute_computed) {
            return this.hasRewriteAttribute_value;
        }
        if (this.hasRewriteAttribute_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.hasRewriteAttribute().");
        }
        this.hasRewriteAttribute_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        boolean bl = this.hasRewriteAttribute_value = this.config().rewriteCircularNTA() && this.getNumRewrite() > 0 && (this.superClass() == null || !this.superClass().hasRewrites());
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.hasRewriteAttribute_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.hasRewriteAttribute_visited = -1;
        return this.hasRewriteAttribute_value;
    }

    private void getCircularRewriteDecl_reset() {
        this.getCircularRewriteDecl_computed = false;
        this.getCircularRewriteDecl_value = null;
        this.getCircularRewriteDecl_visited = -1;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN, isNTA=true)
    @ASTNodeAnnotation.Source(aspect="Rewrites", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/Rewrites.jrag:206")
    public CircularRewriteDecl getCircularRewriteDecl() {
        ASTNode$State state = this.state();
        if (this.getCircularRewriteDecl_computed) {
            return (CircularRewriteDecl)this.getChild(this.getCircularRewriteDeclChildPosition());
        }
        if (this.getCircularRewriteDecl_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.getCircularRewriteDecl().");
        }
        this.getCircularRewriteDecl_visited = this.state().boundariesCrossed;
        int _boundaries = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.state().enterLazyAttribute();
        this.getCircularRewriteDecl_value = new CircularRewriteDecl(new List<Parameter>(), "rewrittenNode", "ASTNode", CacheMode.DEFAULT, "", 0, 0, false, true, "", "", new List<Annotation>());
        this.setChild(this.getCircularRewriteDecl_value, this.getCircularRewriteDeclChildPosition());
        if (isFinal && _boundaries == this.state().boundariesCrossed) {
            this.getCircularRewriteDecl_computed = true;
        }
        this.state().leaveLazyAttribute();
        this.getCircularRewriteDecl_visited = -1;
        CircularRewriteDecl node = (CircularRewriteDecl)this.getChild(this.getCircularRewriteDeclChildPosition());
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="AttributeProblems", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/AttributeProblems.jrag:253")
    public Collection<? extends TypeDecl> missingSynEqs(String signature) {
        String _parameters = signature;
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.missingSynEqs_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.missingSynEqs(String).");
        }
        this.missingSynEqs_String_visited.put(_parameters, this.state().boundariesCrossed);
        try {
            if (this.lookupSynEq(signature) != null) {
                java.util.List list = Collections.emptyList();
                return list;
            }
            if (!this.hasAbstract()) {
                java.util.List<ASTDecl> list = Collections.singletonList(this);
                return list;
            }
            LinkedList<? extends TypeDecl> missing = new LinkedList<TypeDecl>();
            for (ASTDecl subclass : this.subclasses()) {
                missing.addAll(subclass.missingSynEqs(signature));
            }
            LinkedList<? extends TypeDecl> linkedList = missing;
            return linkedList;
        }
        finally {
            this.missingSynEqs_String_visited.remove(_parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="CollectionAttributes", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/CollectionAttributes.jrag:177")
    public boolean hasCollEq(CollDecl decl) {
        CollDecl _parameters = decl;
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.hasCollEq_CollDecl_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.hasCollEq(CollDecl).");
        }
        this.hasCollEq_CollDecl_visited.put(_parameters, this.state().boundariesCrossed);
        try {
            for (int i = 0; i < this.getNumCollEq(); ++i) {
                if (this.getCollEq(i).decl() != decl) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.hasCollEq_CollDecl_visited.remove(_parameters);
        }
    }

    @Override
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="CollectionAttributes", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/CollectionAttributes.jrag:461")
    public boolean isRootNode() {
        if (this.isRootNode_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.isRootNode().");
        }
        this.isRootNode_visited = this.state().boundariesCrossed;
        boolean isRootNode_value = this.isPotentialRootNode() && this.parents().isEmpty();
        this.isRootNode_visited = -1;
        return isRootNode_value;
    }

    @Override
    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="CollectionAttributes", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/CollectionAttributes.jrag:465")
    public boolean isPotentialRootNode() {
        if (this.isPotentialRootNode_visited == this.state().boundariesCrossed) {
            throw new RuntimeException("Circular definition of attribute TypeDecl.isPotentialRootNode().");
        }
        this.isPotentialRootNode_visited = this.state().boundariesCrossed;
        boolean isPotentialRootNode_value = !this.hasAbstract() && !this.isASTNodeDecl() && !this.isOptSubtype() && !this.isListSubtype();
        this.isPotentialRootNode_visited = -1;
        return isPotentialRootNode_value;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.INH)
    @ASTNodeAnnotation.Source(aspect="CoarseIncremental", declaredAt="/var/jenkins_home/workspace/JastAdd2/src/jastadd/ast/ComponentsUtil.jrag:137")
    public RegionDecl lookupRegionDecl(String name) {
        String _parameters = name;
        if (Integer.valueOf(this.state().boundariesCrossed).equals(this.lookupRegionDecl_String_visited.get(_parameters))) {
            throw new RuntimeException("Circular definition of attribute ASTDecl.lookupRegionDecl(String).");
        }
        this.lookupRegionDecl_String_visited.put(_parameters, this.state().boundariesCrossed);
        RegionDecl lookupRegionDecl_String_value = this.getParent().Define_lookupRegionDecl(this, null, name);
        this.lookupRegionDecl_String_visited.remove(_parameters);
        return lookupRegionDecl_String_value;
    }

    @Override
    public TypeDecl Define_hostClass(ASTNode _callerNode, ASTNode _childNode) {
        if (_callerNode == this.getCollEqListNoTransform()) {
            int childIndex = _callerNode.getIndexOfChild(_childNode);
            return this;
        }
        if (_callerNode == this.getCollDeclListNoTransform()) {
            int childIndex = _callerNode.getIndexOfChild(_childNode);
            return this;
        }
        return super.Define_hostClass(_callerNode, _childNode);
    }

    @Override
    protected boolean canDefine_hostClass(ASTNode _callerNode, ASTNode _childNode) {
        return true;
    }

    @Override
    public ASTNode rewriteTo() {
        if (!this.hasSuperClass() && !this.isASTNodeDecl()) {
            return this.rewriteRule0();
        }
        return super.rewriteTo();
    }

    private ASTDecl rewriteRule0() {
        this.setSuperClass(new IdUse(this.config().astNodeType()));
        return this;
    }

    @Override
    protected void collect_contributors_Grammar_problems(Grammar _root, Map<ASTNode, Set<ASTNode>> _map) {
        Set<ASTNode> contributors;
        Grammar target;
        if (this.grammar().lookup(this.name()) != this) {
            target = this.grammar();
            contributors = _map.get(target);
            if (contributors == null) {
                contributors = new LinkedHashSet<ASTNode>();
                _map.put(target, contributors);
            }
            contributors.add(this);
        }
        if (this.isCircular()) {
            target = this.grammar();
            contributors = _map.get(target);
            if (contributors == null) {
                contributors = new LinkedHashSet<ASTNode>();
                _map.put(target, contributors);
            }
            contributors.add(this);
        }
        if (this.hasSuperClass() && this.superClass() == null) {
            target = this.grammar();
            contributors = _map.get(target);
            if (contributors == null) {
                contributors = new LinkedHashSet<ASTNode>();
                _map.put(target, contributors);
            }
            contributors.add(this);
        }
        super.collect_contributors_Grammar_problems(_root, _map);
    }

    @Override
    protected void contributeTo_Grammar_problems(Collection<Problem> collection) {
        super.contributeTo_Grammar_problems(collection);
        if (this.grammar().lookup(this.name()) != this) {
            collection.add(Problem.builder().message("multiple production rule for non-terminal %s", this.name()).sourceFile(this.getFileName()).sourceLine(this.getStartLine()).buildError());
        }
        if (this.isCircular()) {
            collection.add(Problem.builder().message("%s causes circular inheritance", this.name()).sourceFile(this.getFileName()).sourceLine(this.getStartLine()).buildError());
        }
        if (this.hasSuperClass() && this.superClass() == null) {
            collection.add(Problem.builder().message("%s inherits from undeclared class %s", this.name(), this.getSuperClass().name()).sourceFile(this.getFileName()).sourceLine(this.getStartLine()).buildError());
        }
    }
}

