/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.LinkedList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Scanner;
import org.jastadd.Configuration;
import org.jastadd.Problem;
import org.jastadd.ast.AST.ASTDecl;
import org.jastadd.ast.AST.Ast;
import org.jastadd.ast.AST.CacheDecl;
import org.jastadd.ast.AST.Component;
import org.jastadd.ast.AST.Grammar;
import org.jastadd.ast.AST.InhDecl;
import org.jastadd.ast.AST.InhEq;
import org.jastadd.ast.AST.InterTypeObject;
import org.jastadd.ast.AST.List;
import org.jastadd.ast.AST.SynDecl;
import org.jastadd.ast.AST.SynEq;
import org.jastadd.ast.AST.TokenComponent;
import org.jastadd.ast.AST.TypeDecl;
import org.jastadd.jrag.AST.ASTCompilationUnit;
import org.jastadd.jrag.AST.JragParser;
import org.jastadd.jrag.AST.ParseException;
import org.jastadd.jrag.AST.TokenMgrError;

public class JastAdd {
    private static final String version;
    private static final String timestamp;
    private final Configuration config;

    public static String getVersionString() {
        return "JastAdd2 " + version;
    }

    public static String getBuildTimestamp() {
        return "built at " + timestamp;
    }

    public static String getLongVersionString() {
        return "JastAdd2 (http://jastadd.org) version " + version;
    }

    public JastAdd(Configuration configuration) {
        this.config = configuration;
    }

    public static void main(String[] args) {
        int exitVal = JastAdd.compile(args, System.out, System.err);
        if (exitVal != 0) {
            System.exit(exitVal);
        }
    }

    public static int compile(String[] args, PrintStream out, PrintStream err) {
        JastAdd jastadd = new JastAdd(new Configuration(args, err));
        return jastadd.compile(out, err);
    }

    public int compile(PrintStream out, PrintStream err) {
        if (this.config.shouldPrintVersion()) {
            out.println(JastAdd.getVersionString());
            out.println(JastAdd.getBuildTimestamp());
            out.println("Copyright (c) 2005-2015, The JastAdd Team. All rights reserved.");
            out.println("This software is covered by the modified BSD license.");
            return 0;
        }
        if (this.config.shouldPrintHelp()) {
            out.println(JastAdd.getVersionString());
            out.println(JastAdd.getBuildTimestamp());
            out.println();
            this.config.printHelp(out);
            return 0;
        }
        if (this.config.shouldPrintNonStandardOptions()) {
            this.config.printNonStandardOptions(out);
            return 0;
        }
        if (this.config.checkProblems(err)) {
            out.println("Run JastAdd2 again with the --help option to view help.");
            return 1;
        }
        try {
            Grammar grammar = this.config.buildRoot();
            if (this.config.generateImplicits()) {
                grammar.addImplicitNodeTypes();
            }
            if (this.checkErrors(JastAdd.readAstFiles(grammar, this.config.getFiles()), err)) {
                return 1;
            }
            if (this.config.shouldGenerateDotGraph()) {
                grammar.genDotGraph(out);
                return 0;
            }
            if (this.checkErrors("State class generation", this.genStateClass(grammar), err)) {
                return 1;
            }
            if (this.checkErrors("incremental DDG node generation", this.genIncrementalDDGNode(grammar), err)) {
                return 1;
            }
            if (this.checkErrors("JRAG parsing", JastAdd.readJragFiles(grammar, this.config.getFiles()), err)) {
                return 1;
            }
            if (this.checkErrors("attribute weaving", JastAdd.weaveAttributes(grammar), err)) {
                return 1;
            }
            if (this.checkErrors("cache configuration", JastAdd.applyCacheConfiguration(grammar), err)) {
                return 1;
            }
            grammar.processInterfaceRefinements();
            grammar.weaveInterfaceIntroductions();
            if (this.checkErrors("weaveAspects", this.weaveAspects(grammar), err)) {
                return 1;
            }
            if (this.checkErrors("inter-type object weaving", JastAdd.weaveInterTypeObjects(grammar), err)) {
                return 1;
            }
            if (this.checkErrors("attribute weaving", JastAdd.weaveAttributes(grammar), err)) {
                return 1;
            }
            if (this.checkErrors(grammar.problems(), err)) {
                return 1;
            }
            if (this.checkErrors(grammar.attributeProblems(), err)) {
                return 1;
            }
            grammar.processRefinements();
            grammar.weaveCollectionAttributes();
            if (this.checkErrors(grammar.weavingProblems(), err)) {
                return 1;
            }
            grammar.removeDuplicateInhDecls();
            grammar.jastAddGen(this.config.getPublicModifier());
            if (this.config.shouldWriteStatistics()) {
                grammar.writeStatistics(this.config.statisticsFile());
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    private boolean checkErrors(Collection<Problem> problems, PrintStream err) {
        return this.checkErrors("", problems, err);
    }

    private boolean checkErrors(String description, Collection<Problem> problems, PrintStream err) {
        boolean hasError = false;
        boolean first = true;
        for (Problem problem : problems) {
            if (first && !description.isEmpty()) {
                err.println("Problems during " + description + ":");
            }
            first = false;
            problem.print(err);
            hasError |= problem.isError();
        }
        return hasError;
    }

    private static Collection<Problem> readAstFiles(Grammar grammar, Collection<String> fileNames) {
        LinkedList<Problem> problems = new LinkedList<Problem>();
        for (String fileName : fileNames) {
            if (!fileName.endsWith(".ast")) continue;
            File source = new File(fileName);
            JastAdd.parseAbstractGrammar(source, grammar, problems);
        }
        return problems;
    }

    private static Collection<Problem> readJragFiles(Grammar grammar, Collection<String> fileNames) {
        LinkedList<Problem> problems = new LinkedList<Problem>();
        for (String fileName : fileNames) {
            if (!fileName.endsWith(".jrag") && !fileName.endsWith(".jadd")) continue;
            File source = new File(fileName);
            JastAdd.parseAspect(source, grammar, problems);
        }
        problems.addAll(JastAdd.weaveInterTypeObjects(grammar));
        return problems;
    }

    protected static Collection<Problem> weaveInterTypeObjects(Grammar grammar) {
        LinkedList<Problem> problems = new LinkedList<Problem>();
        for (InterTypeObject object : grammar.interTypeObjects) {
            TypeDecl clazz = grammar.lookup(object.className);
            if (clazz != null) {
                clazz.classBodyDecls.add(object.classBodyObject);
                continue;
            }
            problems.add(Problem.builder().message("can not add member to unknown class %s", object.className).sourceFile(object.classBodyObject.fileName).sourceLine(object.classBodyObject.line).buildError());
        }
        grammar.interTypeObjects.clear();
        return problems;
    }

    protected static Collection<Problem> weaveAttributes(Grammar grammar) {
        TypeDecl clazz;
        String className;
        LinkedList<Problem> problems = new LinkedList<Problem>();
        for (SynDecl synDecl : grammar.synDecls) {
            className = synDecl.hostName;
            clazz = grammar.lookup(className);
            if (clazz != null) continue;
            problems.add(synDecl.errorf("can not add synthesized attribute %s %s to unknown class %s", synDecl.getType(), synDecl.getName(), className));
        }
        for (SynEq synEq : grammar.synEqs) {
            className = synEq.hostName;
            clazz = grammar.lookup(className);
            if (clazz != null) {
                clazz.addSynEq(synEq);
                continue;
            }
            problems.add(synEq.errorf("can not add equation for synthesized attribute %s to unknown class %s", synEq.getName(), className));
        }
        grammar.synEqs.clear();
        for (InhDecl inhDecl : grammar.inhDecls) {
            className = inhDecl.hostName;
            clazz = grammar.lookup(className);
            if (clazz != null) {
                clazz.addInhDecl(inhDecl);
                continue;
            }
            problems.add(inhDecl.errorf("can not add inherited attribute %s %s to unknown class %s", inhDecl.getType(), inhDecl.getName(), className));
        }
        grammar.inhDecls.clear();
        for (InhEq inhEq : grammar.inhEqs) {
            className = inhEq.hostName;
            clazz = grammar.lookup(className);
            if (clazz != null) {
                clazz.addInhEq(inhEq);
                continue;
            }
            problems.add(inhEq.errorf("can not add equation for inhertied attribute %s to unknown class %s", inhEq.getName(), className));
        }
        grammar.inhEqs.clear();
        return problems;
    }

    protected static Collection<Problem> applyCacheConfiguration(Grammar grammar) {
        LinkedList<Problem> problems = new LinkedList<Problem>();
        for (int i = 0; i < grammar.cacheDecls.size(); ++i) {
            CacheDecl decl = grammar.cacheDecls.get(i);
            for (int j = 0; j < i; ++j) {
                CacheDecl prev = grammar.cacheDecls.get(j);
                if (!decl.signature.equals(prev.signature) || decl.mode.equals(prev.mode)) continue;
                problems.add(Problem.builder().message("conflicting cache declaration for attribute %s.%s, previous declaration is at %s:%d", decl.hostName, decl.attrName, prev.fileName, prev.startLine).sourceFile(decl.fileName).sourceLine(decl.startLine).buildError());
                break;
            }
            grammar.applyCacheMode(decl, problems);
        }
        grammar.cacheDecls.clear();
        return problems;
    }

    private Collection<Problem> weaveAspects(Grammar grammar) {
        LinkedList<Problem> allProblems = new LinkedList<Problem>();
        for (int i = 0; i < grammar.getNumTypeDecl(); ++i) {
            if (!(grammar.getTypeDecl(i) instanceof ASTDecl)) continue;
            ASTDecl decl = (ASTDecl)grammar.getTypeDecl(i);
            StringWriter writer = new StringWriter();
            decl.emitImplicitDeclarations(new PrintWriter(writer));
            Collection<Problem> problems = JastAdd.parseAspectBodyDeclarations(writer.toString(), this.config.astNodeType(), grammar);
            allProblems.addAll(problems);
            int j = 0;
            for (Component c : decl.components()) {
                if (c instanceof TokenComponent) {
                    c.jaddGen(j, this.config.getPublicModifier(), decl);
                    continue;
                }
                c.jaddGen(j, this.config.getPublicModifier(), decl);
                ++j;
            }
        }
        return allProblems;
    }

    private Collection<Problem> genIncrementalDDGNode(Grammar grammar) {
        if (this.config.incremental()) {
            StringWriter writer = new StringWriter();
            grammar.genIncrementalDDGNode(new PrintWriter(writer));
            return JastAdd.parseAspectBodyDeclarations(writer.toString(), this.config.astNodeType(), grammar);
        }
        return new LinkedList<Problem>();
    }

    private Collection<Problem> genStateClass(Grammar grammar) {
        StringWriter writer = new StringWriter();
        grammar.emitStateClass(new PrintWriter(writer));
        return JastAdd.parseAspectBodyDeclarations(writer.toString(), this.config.stateClassName(), grammar);
    }

    private void checkMem(PrintStream out) {
        Runtime runtime = Runtime.getRuntime();
        long total = runtime.totalMemory();
        long free = runtime.freeMemory();
        long use = total - free;
        out.println("Before GC: Total " + total + ", use " + use);
        runtime.gc();
        total = runtime.totalMemory();
        free = runtime.freeMemory();
        use = total - free;
        out.println("After GC: Total " + total + ", use " + use);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void parseAbstractGrammar(File source, Grammar grammar, Collection<Problem> problems) {
        FileReader inStream = null;
        String fileName = source.getPath();
        try {
            inStream = new FileReader(source);
            Ast parser = new Ast(inStream);
            parser.fileName = fileName;
            Grammar astGrammar = parser.Grammar();
            problems.addAll(parser.parseProblems());
            if (astGrammar != null) {
                int i;
                List<TypeDecl> typeDecls = astGrammar.getTypeDeclListNoTransform();
                for (i = 0; i < typeDecls.getNumChildNoTransform(); ++i) {
                    grammar.addTypeDecl((TypeDecl)typeDecls.getChildNoTransform(i));
                }
                for (i = 0; i < astGrammar.getNumRegionDecl(); ++i) {
                    grammar.addRegionDecl(astGrammar.getRegionDecl(i));
                }
            }
        }
        catch (org.jastadd.ast.AST.TokenMgrError e) {
            problems.add(Problem.builder().message(e.getMessage()).sourceFile(fileName).buildError());
        }
        catch (org.jastadd.ast.AST.ParseException e) {
            int startLine = e.currentToken.next.beginLine;
            int startColumn = e.currentToken.next.beginColumn;
            int endColumn = e.currentToken.next.endColumn;
            String offendingToken = e.currentToken.next.image;
            String context = JastAdd.syntaxErrorContext(fileName, startLine, startColumn, endColumn);
            problems.add(Problem.builder().message("unexpected token \"%s\":\n%s", offendingToken, context).sourceFile(fileName).sourceLine(startLine).sourceColumn(startColumn).buildError());
        }
        catch (FileNotFoundException e) {
            problems.add(Problem.builder().message("could not find abstract syntax file '%s'", fileName).buildError());
        }
        finally {
            if (inStream != null) {
                try {
                    ((Reader)inStream).close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void parseAspect(File source, Grammar grammar, Collection<Problem> problems) {
        FileReader inStream = null;
        String fileName = source.getPath();
        try {
            inStream = new FileReader(source);
            JragParser parser = new JragParser(inStream);
            parser.setFileName(fileName);
            parser.root = grammar;
            ASTCompilationUnit cu = parser.CompilationUnit();
            grammar.addCompUnit(cu);
        }
        catch (ParseException e) {
            int startLine = e.currentToken.next.beginLine;
            int startColumn = e.currentToken.next.beginColumn;
            int endColumn = e.currentToken.next.endColumn;
            String offendingToken = e.currentToken.next.image;
            String context = JastAdd.syntaxErrorContext(fileName, startLine, startColumn, endColumn);
            problems.add(Problem.builder().message("unexpected token \"%s\":\n%s", offendingToken, context).sourceFile(fileName).sourceLine(startLine).sourceColumn(startColumn).buildError());
        }
        catch (TokenMgrError e) {
            problems.add(Problem.builder().message(e.getMessage()).sourceFile(fileName).buildError());
        }
        catch (FileNotFoundException e) {
            problems.add(Problem.builder().message("could not find aspect file '%s'", fileName).buildError());
        }
        finally {
            if (inStream != null) {
                try {
                    ((Reader)inStream).close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected static Collection<Problem> parseAspectBodyDeclarations(String source, String sourceName, Grammar grammar) {
        LinkedList<Problem> problems = new LinkedList<Problem>();
        JragParser jp = new JragParser(new StringReader(source));
        jp.root = grammar;
        jp.setFileName(sourceName);
        jp.className = sourceName;
        jp.pushTopLevelOrAspect("aspect");
        try {
            jp.AspectBodyDeclarationsEOF();
            problems.addAll(JastAdd.weaveInterTypeObjects(grammar));
        }
        catch (ParseException e) {
            problems.add(Problem.builder().message("Internal Error in %s: %s", sourceName, e.getMessage()).buildError());
        }
        jp.popTopLevelOrAspect();
        return problems;
    }

    private static String syntaxErrorContext(String fileName, int startLine, int startColumn, int endColumn) {
        try {
            int i;
            StringBuilder buf = new StringBuilder();
            FileInputStream sourceInput = new FileInputStream(fileName);
            Scanner scanner = new Scanner(sourceInput);
            for (i = 1; i < startLine && scanner.hasNextLine(); ++i) {
                scanner.nextLine();
            }
            if (scanner.hasNextLine()) {
                buf.append(scanner.nextLine()).append("\n");
                for (i = 1; i < startColumn; ++i) {
                    buf.append(" ");
                }
                for (i = startColumn; i <= endColumn; ++i) {
                    buf.append("^");
                }
            }
            return buf.toString();
        }
        catch (IOException e) {
            return "";
        }
    }

    static {
        try {
            ResourceBundle resources = ResourceBundle.getBundle("Version");
            version = resources.getString("version");
            timestamp = resources.getString("timestamp");
        }
        catch (MissingResourceException e) {
            throw new Error("Could load version info: " + e.getMessage());
        }
    }
}

