/*
 * Decompiled with CFR 0.152.
 */
package org.jastadd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jastadd.ast.AST.Grammar;
import org.jastadd.option.ArgumentParser;
import org.jastadd.option.BooleanOption;
import org.jastadd.option.FlagOption;
import org.jastadd.option.Option;
import org.jastadd.option.ValueOption;
import org.jastadd.tinytemplate.TemplateContext;

public class Configuration {
    protected List<String> indList = new ArrayList<String>(32);
    public String indent = "  ";
    public String license = "";
    Option<String> ASTNodeOption = new ValueOption("ASTNode", "set the name of the ASTNode type").acceptAnyValue().defaultValue("ASTNode").templateVariable("ASTNode");
    Option<String> ListOption = new ValueOption("List", "set the name of the List type").acceptAnyValue().defaultValue("List").templateVariable("List");
    Option<String> OptOption = new ValueOption("Opt", "set the name of the Opt type").acceptAnyValue().defaultValue("Opt").templateVariable("Opt");
    Option<String> stateClassNameOption = new ValueOption("stateClassName", "set the name of the AST state class").acceptAnyValue().defaultValue("ASTState").templateVariable("StateClass");
    Option<String> ASTNodeSuperOption = new ValueOption("ASTNodeSuper", "set the ASTNode supertype").acceptAnyValue().templateVariable("ASTNodeSuper");
    Option<Boolean> generateImplicitsOption = new BooleanOption("generateImplicits", "generate implicit node types").defaultValue(true).nonStandard();
    Option<Boolean> generateAnnotations = new BooleanOption("generateAnnotations", "generate Java annotations, e.g., describing attribute properties").defaultValue(true).templateVariable("generateAnnotations");
    Option<Boolean> jjtreeOption = new FlagOption("jjtree", "use jjtree base node, this requires --grammar to be set").templateVariable("JJTree");
    Option<String> grammarOption = new ValueOption("grammar", "the name of the grammar's parser, required when using --jjtree").templateVariable("ParserName");
    Option<String> defaultMapOption = new ValueOption("defaultMap", "use this expression to construct maps for attribute caches").acceptAnyValue().defaultValue("new java.util.HashMap(4)").nonStandard().templateVariable("CreateDefaultMap");
    Option<String> defaultSetOption = new ValueOption("defaultSet", "use this expression to construct sets for attribute caches").acceptAnyValue().defaultValue("new java.util.HashSet(4)").nonStandard().templateVariable("CreateDefaultSet");
    Option<Boolean> lazyMapsOption = new BooleanOption("lazyMaps", "use lazy maps").defaultValue(true).templateVariable("LazyMaps").nonStandard();
    Option<Boolean> privateOption = new FlagOption("private", "generated methods will use the private modifier").templateVariable("PrivateModifier").nonStandard();
    ValueOption rewriteOption = new ValueOption("rewrite", "enable and select rewrite mode (ReRAGs)").needsValue(false).acceptMultipleValues(false).addDefaultValue("none", "rewrites are disabled").addAcceptedValue("true", "enable rewrites").addAcceptedValue("regular", "enable rewrites using the default implementation (not using CNTAs)").addAcceptedValue("cnta", "evaluate rewrites with circular NTAs");
    Option<Boolean> beaverOption = new FlagOption("beaver", "use beaver.Symbol as ASTNode supertype").templateVariable("Beaver");
    Option<Boolean> lineColumnNumbersOption = new FlagOption("lineColumnNumbers", "generate interface for storing line and column numbers");
    Option<Boolean> visitCheckOption = new BooleanOption("visitCheck", "enable circularity check for attributes").defaultValue(true).templateVariable("VisitCheckEnabled");
    Option<Boolean> traceVisitCheckOption = new BooleanOption("traceVisitCheck", "just print an error rather than throwing a circularity check exception").nonStandard().templateVariable("TraceVisitCheck");
    Option<Boolean> cacheCycleOption = new BooleanOption("cacheCycle", "Circular attributes run one last cycle to cache all\nattributes on the cycle.").defaultValue(true).templateVariable("CacheCycle").nonStandard();
    Option<Boolean> componentCheckOption = new BooleanOption("componentCheck", "Throw an exception if mutually circular attributes separated\nby non-circular attribute is detected.").templateVariable("ComponentCheck");
    Option<Boolean> inhEqCheckOption = new BooleanOption("inhEqCheck", "enalbe check for inherited equations").defaultValue(true).nonStandard();
    Option<Boolean> suppressWarningsOption = new FlagOption("suppressWarnings", "attempt to suppress Java warnings").deprecated("2.1.2").nonStandard();
    Option<Boolean> refineLegacyOption = new BooleanOption("refineLegacy", "enable the legacy refine syntax").defaultValue(true);
    Option<Boolean> stagedRewritesOption = new FlagOption("stagedRewrites", "").deprecated("2.2.1", "this option currently does nothing");
    Option<Boolean> doxygenOption = new FlagOption("doxygen", "").deprecated("2.1.5", "this option currently does nothing");
    Option<Boolean> cacheAllOption = new FlagOption("cacheAll", "").deprecated("2.1.5", "this option currently does nothing");
    Option<Boolean> noCachingOption = new FlagOption("noCaching", "").deprecated("2.1.5", "this option currently does nothing");
    Option<Boolean> cacheNoneOption = new FlagOption("cacheNone", "").deprecated("2.1.5", "this option currently does nothing");
    Option<Boolean> cacheImplicitOption = new FlagOption("cacheImplicit", "").deprecated("2.1.5", "this option currently does nothing");
    Option<Boolean> ignoreLazyOption = new FlagOption("ignoreLazy", "").deprecated("2.1.5", "this option currently does nothing");
    Option<Boolean> fullFlushOption = new FlagOption("fullFlush", "").deprecated("2.1.5", "this option currently does nothing");
    Option<Boolean> docOption = new FlagOption("doc", "").deprecated("2.1.9", "this option currently does nothing");
    Option<Boolean> java1_4Option = new FlagOption("java1.4", "").deprecated("2.1.9", "this option currently does nothing");
    Option<Boolean> noLazyMapsOption = new FlagOption("noLazyMaps", "").deprecated("2.1.9", "replaced by --lazyMaps=false");
    Option<Boolean> noVisitCheckOption = new FlagOption("noVisitCheck", "").deprecated("2.1.9", "replaced by --visitCheck=false");
    Option<Boolean> noCacheCycleOption = new FlagOption("noCacheCycle", "").deprecated("2.1.9", "replaced by --cacheCycle=false");
    Option<Boolean> noRefineLegacyOption = new FlagOption("noRefineLegacy", "").deprecated("2.1.9", "replaced by --refineLegacy=false");
    Option<Boolean> noComponentCheckOption = new FlagOption("noComponentCheck", "").deprecated("2.1.9", "currently has no effect");
    Option<Boolean> noInhEqCheckOption = new FlagOption("noInhEqCheck", "").deprecated("2.1.9", "replaced by --inhEqCheck=false");
    Option<Boolean> noStaticOption = new FlagOption("noStatic", "the generated state field is non-static").deprecated("2.1.9", "replaced by --staticState=false").nonStandard();
    Option<Boolean> deterministicOption = new FlagOption("deterministic", "ensure deterministic collection attribute iteration order").deprecated("2.1.9");
    Option<String> licenseOption = new ValueOption("license", "include the given file as a header in each generated file"){

        @Override
        public void reportWarnings(PrintStream out, String filename) {
            super.reportWarnings(out, filename);
            if (filename.isEmpty()) {
                out.println("Warning: empty license file name");
            } else {
                try {
                    Configuration.readFile(filename);
                }
                catch (IOException e) {
                    out.println("Warning: could not read license file " + filename);
                }
            }
        }
    };
    Option<Boolean> debugOption = new FlagOption("debug", "generate run-time checks for debugging").templateVariable("DebugMode");
    Option<Boolean> staticStateOption = new BooleanOption("staticState", "the generated state field is static").defaultValue(true).templateVariable("StaticState").nonStandard();
    ValueOption outputDirOption = new ValueOption("o", "optional base output directory, default is current directory").acceptAnyValue().defaultValue(System.getProperty("user.dir"));
    ValueOption tracingOption = new ValueOption("tracing", "weaves in code collecting evaluation events").acceptMultipleValues(true).needsValue(false).addDefaultValue("none", "tracing is disabled").addDefaultValue("api", "tracing is disabled, but generate Trace class").addAcceptedValue("all", "trace all events").addAcceptedValue("compute", "trace begin and end of attribute computation").addAcceptedValue("cache", "trace value cached, read cache, and cache aborted").addAcceptedValue("rewrite", "trace rewrite evaluation").addAcceptedValue("circular", "trace circular attribute evaluation").addAcceptedValue("circularNTA", "trace circular attribute evaluation").addAcceptedValue("copy", "trace node copy operations").addAcceptedValue("flush", "trace flush operations").additionalDescription("all events are collected by default\nthe result is available via the API in org.jastadd.Tracer");
    ValueOption flushOption = new ValueOption("flush", "adds flushing of cached values").acceptMultipleValues(true).needsValue(false).addAcceptedValue("full", "flushing of all computed values (combines attr, coll, and rewrite)").addDefaultValue("attr", "adds flushing of attributes (syn,inh)").addDefaultValue("coll", "adds flushing of collection attributes").addAcceptedValue("rewrite", "adds flushing of rewrites");
    ValueOption packageNameOption = new ValueOption("package", "optional package name for generated classes");
    FlagOption versionOption = new FlagOption("version", "print version info");
    FlagOption helpOption = new FlagOption("help", "print command-line usage info");
    FlagOption printNonStandardOptionsOption = new FlagOption("X", "print list of non-standard options and halt");
    Option<String> statisticsOption = new ValueOption("statistics", "write attribute statistics to a CSV file").acceptAnyValue().nonStandard();
    ValueOption indentOption = new ValueOption("indent", "indentation used in generated code").addDefaultValue("2space", "two spaces").addAcceptedValue("4space", "four spaces").addAcceptedValue("8space", "eight spaces").addAcceptedValue("tab", "use tabs");
    ValueOption minListSizeOption = new ValueOption("minListSize", "minimum (non-empty) list size"){
        {
            this.acceptAnyValue();
            this.defaultValue("4");
            this.templateVariable("MinListSize");
            this.nonStandard();
        }

        @Override
        public void reportWarnings(PrintStream out, String arg) {
            super.reportWarnings(out, arg);
            try {
                int size = Integer.parseInt(arg);
                if (size < 0) {
                    out.println("Warning: minimum list size option must have a positive integer value!");
                }
            }
            catch (NumberFormatException e) {
                out.println("Warning: minimum list size option must be an integer!");
            }
        }
    };
    ValueOption cacheOption = new ValueOption("cache", "global cache configuration overriding 'lazy' keyword").acceptMultipleValues(false).addAcceptedValue("none", "disable attribute caching").addAcceptedValue("all", "cache all attributes");
    ValueOption incrementalOption = new ValueOption("incremental", "incremental evaluation").acceptMultipleValues(true).addDefaultValue("none", "incremental evaluation disabled").addAcceptedValue("param", "dependency tracking on parameter level").addAcceptedValue("region", "dependency tracking on region level").addAcceptedValue("flush", "invalidate with flush").addAcceptedValue("full", "full change propagation").addAcceptedValue("debug", "generate code for debugging and dumping of dependencies");
    Option<Boolean> dotOption = new FlagOption("dot", "generate a Dot graph from the grammar").nonStandard();
    Option<Boolean> safeLazyOption = new FlagOption("safeLazy", "safe in-cycle caching of non-circular attributes").nonStandard();
    Option<Boolean> concurrentOption = new BooleanOption("concurrent", "generate concurrent attribute evaluation code").templateVariable("Concurrent");
    Option<String> numThreadsOption = new ValueOption("num_threads", "number of parallel threads to use for parallelized attributes").acceptAnyValue().defaultValue("4").templateVariable("NumThreads");
    Option<String> concurrentMap = new ValueOption("concurrentmap", "concurrent map implementation for concurrent parameterized memoization").acceptAnyValue().defaultValue("ConcurrentHashMap").templateVariable("ConcurrentMap");
    Collection<String> filenames = new LinkedList<String>();
    Option<Boolean> emptyContainerSingletons = new FlagOption("emptyContainerSingletons", "singleton optimization for empty container nodes").templateVariable("EmptyContainerSingletons").nonStandard();
    final boolean unknownOptions;

    public final String ind(int level) {
        while (this.indList.size() <= level) {
            if (this.indList.size() == 0) {
                this.indList.add("");
                continue;
            }
            this.indList.add(this.indList.get(this.indList.size() - 1) + this.indent);
        }
        return this.indList.get(level);
    }

    public Configuration(String[] args, PrintStream err) {
        ArgumentParser argParser = this.argParser();
        this.unknownOptions = !argParser.parseArgs(args, err);
        this.filenames = argParser.getFilenames();
    }

    public Configuration() {
        this.unknownOptions = false;
    }

    private ArgumentParser argParser() {
        ArgumentParser parser = new ArgumentParser();
        parser.addOptions(this.allOptions());
        return parser;
    }

    private Collection<Option<?>> allOptions() {
        LinkedList allOptions = new LinkedList();
        allOptions.add(this.ASTNodeOption);
        allOptions.add(this.ListOption);
        allOptions.add(this.OptOption);
        allOptions.add(this.jjtreeOption);
        allOptions.add(this.grammarOption);
        allOptions.add(this.generateAnnotations);
        allOptions.add(this.defaultMapOption);
        allOptions.add(this.defaultSetOption);
        allOptions.add(this.lazyMapsOption);
        allOptions.add(this.privateOption);
        allOptions.add(this.rewriteOption);
        allOptions.add(this.beaverOption);
        allOptions.add(this.lineColumnNumbersOption);
        allOptions.add(this.visitCheckOption);
        allOptions.add(this.traceVisitCheckOption);
        allOptions.add(this.cacheCycleOption);
        allOptions.add(this.componentCheckOption);
        allOptions.add(this.inhEqCheckOption);
        allOptions.add(this.suppressWarningsOption);
        allOptions.add(this.refineLegacyOption);
        allOptions.add(this.licenseOption);
        allOptions.add(this.debugOption);
        allOptions.add(this.outputDirOption);
        allOptions.add(this.staticStateOption);
        allOptions.add(this.tracingOption);
        allOptions.add(this.flushOption);
        allOptions.add(this.packageNameOption);
        allOptions.add(this.versionOption);
        allOptions.add(this.helpOption);
        allOptions.add(this.printNonStandardOptionsOption);
        allOptions.add(this.indentOption);
        allOptions.add(this.minListSizeOption);
        allOptions.add(this.cacheOption);
        allOptions.add(this.incrementalOption);
        allOptions.add(this.dotOption);
        allOptions.add(this.ASTNodeSuperOption);
        allOptions.add(this.generateImplicitsOption);
        allOptions.add(this.stateClassNameOption);
        allOptions.add(this.safeLazyOption);
        allOptions.add(this.statisticsOption);
        allOptions.add(this.emptyContainerSingletons);
        allOptions.add(this.concurrentOption);
        allOptions.add(this.numThreadsOption);
        allOptions.add(this.concurrentMap);
        allOptions.add(this.doxygenOption);
        allOptions.add(this.cacheAllOption);
        allOptions.add(this.noCachingOption);
        allOptions.add(this.cacheNoneOption);
        allOptions.add(this.cacheImplicitOption);
        allOptions.add(this.ignoreLazyOption);
        allOptions.add(this.fullFlushOption);
        allOptions.add(this.docOption);
        allOptions.add(this.java1_4Option);
        allOptions.add(this.noLazyMapsOption);
        allOptions.add(this.noVisitCheckOption);
        allOptions.add(this.noCacheCycleOption);
        allOptions.add(this.noRefineLegacyOption);
        allOptions.add(this.noComponentCheckOption);
        allOptions.add(this.noInhEqCheckOption);
        allOptions.add(this.noStaticOption);
        allOptions.add(this.deterministicOption);
        return allOptions;
    }

    public File outputDir() {
        return new File(this.outputDirOption.value());
    }

    public boolean getPublicModifier() {
        return this.privateOption.value() == false;
    }

    public Grammar buildRoot() {
        Grammar root = new Grammar();
        root.setConfiguration(this);
        this.indent = this.indent();
        this.license = this.license();
        TemplateContext tt = root.templateContext();
        for (Option<?> option : this.allOptions()) {
            option.bind(tt);
        }
        String packageName = this.packageName();
        if (packageName.isEmpty()) {
            tt.bind("PackageDecl", "");
        } else {
            tt.bind("PackageDecl", "package " + packageName + ";");
        }
        tt.bind("DefaultMapType", this.typeDefaultMap());
        tt.bind("DefaultSetType", this.typeDefaultSet());
        tt.bind("RewriteEnabled", this.rewriteEnabled());
        tt.bind("RewriteCircularNTA", this.rewriteCircularNTA());
        tt.bind("LegacyRewrite", this.legacyRewrite());
        tt.bind("FlushEnabled", this.flushEnabled());
        tt.bind("FlushAttr", this.flushAttr());
        tt.bind("FlushColl", this.flushColl());
        tt.bind("IncrementalEnabled", this.incremental());
        tt.bind("IncrementalLevelParam", this.incrementalLevelParam());
        tt.bind("IncrementalLevelAttr", this.incrementalLevelAttr());
        tt.bind("IncrementalLevelNode", this.incrementalLevelNode());
        tt.bind("IncrementalLevelRegion", this.incrementalLevelRegion());
        tt.bind("IncrementalChangeFlush", this.incrementalChangeFlush());
        tt.bind("IncrementalChangeMark", this.incrementalChangeMark());
        tt.bind("IncrementalPropFull", this.incrementalPropFull());
        tt.bind("IncrementalPropLimit", this.incrementalPropLimit());
        tt.bind("IncrementalDebug", this.incrementalDebug());
        tt.bind("IncrementalTrack", this.incrementalTrack());
        tt.bind("DDGNodeName", this.astNodeType() + "$DepGraphNode");
        tt.bind("TracingEnabled", this.tracingEnabled());
        tt.bind("TraceCompute", this.traceCompute());
        tt.bind("TraceCache", this.traceCache());
        tt.bind("TraceRewrite", this.traceRewrite());
        tt.bind("TraceCircularNTA", this.traceCircularNTA());
        tt.bind("TraceCircular", this.traceCircular());
        tt.bind("TraceCopy", this.traceCopy());
        tt.bind("TraceFlush", this.traceFlush());
        tt.bind("VisitCheckEnabled", this.visitCheckEnabled());
        tt.bind("CacheCycle", this.cacheCycle());
        tt.bind("StaticState", this.staticState());
        tt.bind("LazyMaps", this.lazyMaps());
        return root;
    }

    public boolean checkProblems(PrintStream out) {
        if (this.unknownOptions) {
            return true;
        }
        if (this.jjtreeOption.value().booleanValue() && this.grammarOption.value().isEmpty()) {
            out.println("Error: No grammar name given. A grammar name is required in JJTree-mode!");
            return true;
        }
        LinkedList<String> grammarFiles = new LinkedList<String>();
        for (String filename : this.filenames) {
            if (!filename.endsWith(".ast")) continue;
            grammarFiles.add(filename);
        }
        if (grammarFiles.isEmpty()) {
            out.println("Error: No grammar files specified.");
            return true;
        }
        for (String filename : this.filenames) {
            if (filename.endsWith(".ast") || filename.endsWith(".jrag") || filename.endsWith(".jadd")) continue;
            out.format("Error: Unrecognized file extension: %s%n", filename);
            return true;
        }
        File outputDir = this.outputDir();
        if (!outputDir.exists()) {
            out.format("Error: Output directory %s does not exist%n", outputDir.getAbsolutePath());
            return true;
        }
        if (!outputDir.isDirectory()) {
            out.format("Error: Output directory %s is not a directory%n", outputDir.getAbsolutePath());
            return true;
        }
        if (!outputDir.canWrite()) {
            out.format("Error: Output directory %s is write protected%n", outputDir.getAbsolutePath());
            return true;
        }
        if (!this.checkIncrementalConfig(out)) {
            return true;
        }
        if (!this.checkCacheConfig(out)) {
            return true;
        }
        if (this.jjtreeOption.value().booleanValue() && !this.ASTNodeSuperOption.value().isEmpty()) {
            out.println("Error: Cannot use --jjtree and --ASTNodeSuper at the same time!");
            return true;
        }
        if (this.beaverOption.value().booleanValue() && !this.ASTNodeSuperOption.value().isEmpty()) {
            out.println("Error: Cannot use --beaver and --ASTNodeSuper at the same time!");
            return true;
        }
        if (this.beaverOption.value().booleanValue() && this.jjtreeOption.value().booleanValue()) {
            out.println("Error: Cannot use --beaver and --jjtree at the same time!");
            return true;
        }
        return false;
    }

    private boolean checkCacheConfig(PrintStream out) {
        if (this.cacheOption.numValues() > 1) {
            out.println("Error: only one cache option may be enabled");
            return false;
        }
        return true;
    }

    private boolean checkIncrementalConfig(PrintStream out) {
        if (this.incrementalLevelAttr() && this.incrementalLevelNode() || this.incrementalLevelAttr() && this.incrementalLevelParam() || this.incrementalLevelNode() && this.incrementalLevelParam() || this.incrementalLevelParam() && this.incrementalLevelRegion() || this.incrementalLevelAttr() && this.incrementalLevelRegion() || this.incrementalLevelNode() && this.incrementalLevelRegion()) {
            out.println("error: Conflict in incremental evaluation configuration. Cannot combine \"param\", \"attr\", \"node\" and \"region\".");
            return false;
        }
        if (this.incrementalChangeFlush() && this.incrementalChangeMark()) {
            out.println("error: Conflict in incremental evaluation configuration. Cannot combine \"flush\" and \"mark\".");
            return false;
        }
        if (this.incrementalChangeMark()) {
            out.println("error: Unsupported incremental evaluation configuration: \"mark\".");
            return false;
        }
        if (this.incrementalPropFull() && this.incrementalPropLimit()) {
            out.println("error: Conflict in incremental evaluation configuration. Cannot combine \"full\" and \"limit\".");
            return false;
        }
        return true;
    }

    private static String readFile(String name) throws IOException {
        int i;
        StringBuilder buf = new StringBuilder();
        BufferedReader reader = new BufferedReader(new FileReader(name));
        char[] cbuf = new char[1024];
        while ((i = reader.read(cbuf)) != -1) {
            buf.append(String.valueOf(cbuf, 0, i));
        }
        ((Reader)reader).close();
        return buf.toString();
    }

    public Collection<String> getFiles() {
        ArrayList<String> files = new ArrayList<String>();
        for (String filename : this.filenames) {
            if (!filename.endsWith(".ast") && !filename.endsWith(".jrag") && !filename.endsWith(".jadd")) continue;
            files.add(filename);
        }
        return files;
    }

    public void printHelp(PrintStream out) {
        out.println("This program reads a number of .jrag, .jadd, and .ast files");
        out.println("and generates the Java classes for the abstract syntax tree.");
        out.println();
        out.println("Source files contain declarations of synthesized ");
        out.println("and inherited attributes and their corresponding equations,");
        out.println("as well as ordinary Java methods and fields.");
        out.println("Source file syntax is documented at http://jastadd.org");
        out.println();
        out.println("Options:");
        this.argParser().printHelp(out);
        out.println();
        out.println("Arguments:");
        out.println("  Names of abstract grammr (.ast) and aspect (.jrag and .jadd) files.");
        out.println();
        out.println("Example: The following command reads and translates NameAnalysis.jrag,");
        out.println("and weaves PrettyPrint.jadd into the abstract syntax classes");
        out.println("defined in the grammar file Toy.ast.");
        out.println("The result is the generated classes for the nodes in the AST that are placed");
        out.println("in the package ast.");
        out.println();
        out.println("java -jar jastadd2.jar --package=ast Toy.ast NameAnalysis.jrag PrettyPrint.jadd");
    }

    public void printNonStandardOptions(PrintStream out) {
        out.println("Non-standard options:");
        this.argParser().printNonStandardOptions(out);
    }

    public boolean shouldPrintVersion() {
        return this.versionOption.value();
    }

    public boolean shouldPrintHelp() {
        return this.helpOption.value();
    }

    public boolean shouldPrintNonStandardOptions() {
        return this.printNonStandardOptionsOption.value();
    }

    public boolean shouldWriteStatistics() {
        return !this.statisticsOption.value().isEmpty();
    }

    public String statisticsFile() {
        return this.statisticsOption.value();
    }

    public boolean tracingEnabled() {
        return !this.tracingOption.hasValue("none");
    }

    public boolean traceAll() {
        return this.tracingOption.hasValue("all") || this.tracingOption.value().isEmpty();
    }

    public boolean traceCompute() {
        return this.traceAll() || this.tracingOption.hasValue("compute");
    }

    public boolean traceCache() {
        return this.traceAll() || this.tracingOption.hasValue("cache");
    }

    public boolean traceRewrite() {
        return this.traceAll() || this.tracingOption.hasValue("rewrite");
    }

    public boolean traceCircularNTA() {
        return this.traceAll() || this.tracingOption.hasValue("circularNTA");
    }

    public boolean traceCircular() {
        return this.traceAll() || this.tracingOption.hasValue("circular");
    }

    public boolean traceCopy() {
        return this.traceAll() || this.tracingOption.hasValue("copy");
    }

    public boolean traceFlush() {
        return this.traceAll() || this.tracingOption.hasValue("flush");
    }

    public String astNodeType() {
        return this.ASTNodeOption.value();
    }

    public String listType() {
        return this.ListOption.value();
    }

    public String optType() {
        return this.OptOption.value();
    }

    public String stateClassName() {
        return this.stateClassNameOption.value();
    }

    public String astNodeSuperType() {
        if (this.ASTNodeSuperOption.value().isEmpty()) {
            if (this.beaverOption.value().booleanValue()) {
                return "beaver.Symbol";
            }
            if (this.jjtree()) {
                return "SimpleNode";
            }
            return "";
        }
        return this.ASTNodeSuperOption.value();
    }

    public String indent() {
        String arg = this.indentOption.value();
        if (arg.equals("2space")) {
            return "  ";
        }
        if (arg.equals("4space")) {
            return "    ";
        }
        if (arg.equals("8space")) {
            return "        ";
        }
        if (arg.equals("tab")) {
            return "\t";
        }
        return "  ";
    }

    public String license() {
        String filename = this.licenseOption.value();
        if (!filename.isEmpty()) {
            try {
                return Configuration.readFile(filename);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return "";
    }

    public boolean visitCheckEnabled() {
        if (this.debugOption.value().booleanValue()) {
            return true;
        }
        if (this.visitCheckOption.isMatched()) {
            return this.visitCheckOption.value();
        }
        return this.noVisitCheckOption.value() == false;
    }

    public boolean cacheAll() {
        return this.cacheOption.hasValue("all");
    }

    public boolean cacheNone() {
        return this.cacheOption.hasValue("none");
    }

    public boolean incremental() {
        return !this.incrementalOption.hasValue("none");
    }

    public boolean incrementalLevelParam() {
        return this.incrementalOption.hasValue("param");
    }

    public boolean incrementalLevelAttr() {
        return this.incrementalOption.hasValue("attr") || !this.incrementalLevelNode() && !this.incrementalLevelParam() && !this.incrementalLevelRegion();
    }

    public boolean incrementalLevelNode() {
        return this.incrementalOption.hasValue("node");
    }

    public boolean incrementalLevelRegion() {
        return this.incrementalOption.hasValue("region");
    }

    public boolean incrementalChangeFlush() {
        return this.incrementalOption.hasValue("flush") || !this.incrementalChangeMark();
    }

    public boolean incrementalChangeMark() {
        return this.incrementalOption.hasValue("mark");
    }

    public boolean incrementalPropFull() {
        return this.incrementalOption.hasValue("full") || !this.incrementalPropLimit();
    }

    public boolean incrementalPropLimit() {
        return this.incrementalOption.hasValue("limit");
    }

    public boolean incrementalDebug() {
        return this.incrementalOption.hasValue("debug");
    }

    public boolean incrementalTrack() {
        return this.incrementalOption.hasValue("track");
    }

    public boolean lazyMaps() {
        if (this.lazyMapsOption.isMatched()) {
            return this.lazyMapsOption.value();
        }
        return this.noLazyMapsOption.value() == false;
    }

    public String packageName() {
        return this.packageNameOption.value();
    }

    public boolean refineLegacy() {
        if (this.refineLegacyOption.isMatched()) {
            return this.refineLegacyOption.value();
        }
        return this.noRefineLegacyOption.value() == false;
    }

    public boolean rewriteCircularNTA() {
        return this.rewriteOption.hasValue("cnta");
    }

    public boolean legacyRewrite() {
        return this.rewriteEnabled() && !this.rewriteCircularNTA();
    }

    public boolean rewriteEnabled() {
        return !this.rewriteOption.hasValue("none");
    }

    public String typeDefaultMap() {
        return "java.util.Map";
    }

    public String typeDefaultSet() {
        return "java.util.Set";
    }

    public boolean debugMode() {
        return this.debugOption.value();
    }

    public boolean jjtree() {
        return this.jjtreeOption.value();
    }

    public boolean flushEnabled() {
        return !this.flushOption.hasValue("none");
    }

    public boolean flushAttr() {
        return this.flushOption.hasValue("attr") || this.flushOption.value().isEmpty() || this.flushOption.hasValue("full");
    }

    public boolean flushColl() {
        return this.flushOption.hasValue("coll") || this.flushOption.value().isEmpty() || this.flushOption.hasValue("full");
    }

    public String createDefaultMap() {
        return this.defaultMapOption.value();
    }

    public String createDefaultSet() {
        return this.defaultSetOption.value();
    }

    public boolean inhEqCheck() {
        if (this.inhEqCheckOption.isMatched()) {
            return this.inhEqCheckOption.value();
        }
        return this.noInhEqCheckOption.value() == false;
    }

    public boolean useBeaverSymbol() {
        return this.beaverOption.value();
    }

    public boolean componentCheck() {
        return this.componentCheckOption.value();
    }

    public boolean lineColumnNumbers() {
        return this.lineColumnNumbersOption.value();
    }

    public boolean cacheCycle() {
        if (this.cacheCycleOption.isMatched()) {
            return this.cacheCycleOption.value();
        }
        return this.noCacheCycleOption.value() == false;
    }

    public boolean staticState() {
        if (this.staticStateOption.isMatched()) {
            return this.staticStateOption.value();
        }
        return this.noStaticOption.value() == false;
    }

    public int minListSize() {
        try {
            int size = Integer.parseInt(this.minListSizeOption.value());
            if (size < 0) {
                return 0;
            }
            return size;
        }
        catch (NumberFormatException e) {
            return 4;
        }
    }

    public boolean shouldGenerateDotGraph() {
        return this.dotOption.value();
    }

    public boolean generateImplicits() {
        return this.generateImplicitsOption.value();
    }

    public boolean safeLazy() {
        return this.safeLazyOption.value();
    }

    public boolean generateAnnotations() {
        return this.generateAnnotations.value();
    }

    public boolean emptyContainerSingletons() {
        return this.emptyContainerSingletons.value();
    }

    public boolean concurrentEval() {
        return this.concurrentOption.value();
    }
}

