package org.extendj;

import org.extendj.ast.AbstractFinding;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

import java.util.Set;

public class SimpleScopeTest extends ScopeAnalysisTest {

  @Test
  void test() {

    ScopeAnalysis scopeAnalysis = new ScopeAnalysis();
    Set<AbstractFinding> findings = scopeAnalysis.analyze("src/test/resources/simple", true, false);

    assertShadow(findings, "localVarA", 19, 11);
    assertShadow(findings, "localVarB", 33, 12);
    assertShadow(findings, "localVarC", 24, 13);
    assertShadow(findings, "fieldA", 29, 3);
    assertShadow(findings, "fieldB", 36, 4);

    Assertions.assertEquals(5, findings.size());
  }

}
