package org.extendj;

import org.extendj.ast.AbstractFinding;
import org.extendj.ast.Declaration;
import org.extendj.ast.MultipleDeclarationFinding;
import org.extendj.ast.VariableShadowFinding;
import org.junit.jupiter.api.Assertions;

import java.util.Set;

public abstract class ScopeAnalysisTest {
  static void assertShadow(Set<AbstractFinding> findings, String name, int shadowerLine, int shadowedLine) {
    for (AbstractFinding finding : findings) {
      if (finding instanceof VariableShadowFinding) {
        Declaration shadower = ((VariableShadowFinding)finding).getShadower();
        Declaration shadowed = ((VariableShadowFinding)finding).getShadowed();
        if (shadowed.getName().equals(name) && shadowed.lineNumber() == shadowedLine && shadower.lineNumber() == shadowerLine) {
          return;
        }
      }
    }
    Assertions.fail("No shadow finding found for name '" + name + "' in lines " + shadowerLine + " > " + shadowedLine);
  }

  static void assertRedefinition(Set<AbstractFinding> findings, String name, int declLine) {
    for (AbstractFinding finding : findings) {
      if (finding instanceof MultipleDeclarationFinding) {
        Declaration declaration = ((MultipleDeclarationFinding)finding).getDeclaration();
        if (declaration.getName().equals(name) && declaration.lineNumber() == declLine) {
          return;
        }
      }
    }
    Assertions.fail("No multi-decl finding found for name '" + name + "' in line " + declLine);
  }
}
