package org.extendj;

import org.extendj.ast.AbstractFinding;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

import java.util.Set;

public class InnerTest extends ScopeAnalysisTest {

  @Test
  void test() {

    ScopeAnalysis scopeAnalysis = new ScopeAnalysis();
    Set<AbstractFinding> findings = scopeAnalysis.analyze("src/test/resources/inner", true, true);

    System.out.println(findings);

    // anonymous class
    assertShadow(findings, "fieldA", 11, 13);
    assertShadow(findings, "fieldA", 13, 3);

    // local inner class
    assertShadow(findings, "fieldA", 27, 29);
    assertShadow(findings, "fieldA", 29, 3);
    assertShadow(findings, "changingVar", 25, 19);

    // static member class
    assertShadow(findings, "fieldA", 37, 35);
    assertShadow(findings, "fieldA", 35, 3);

    // member class
    assertShadow(findings, "fieldA", 44, 42);
    assertShadow(findings, "fieldA", 42, 3);

    // anonymous class defined in other class
    assertShadow(findings, "fieldB", 5, 10);
    // this finding is currently not found
//    assertShadow(findings, "fieldB", 10, 4);

    Assertions.assertEquals(10, findings.size());
  }

}
