# Single List

Idea: send and receive single values for lists of subtrees.
Once without incremental evaluation (i.e., using manual dependencies), and the other time with incremental evaluation

## Execution-Model

```
SenderRoot                         ReceiverRoot
|- A1 --( a/1 ) --\                          |
|- A2 --( a/2 ) --+=\  /--> A* --------------|
|- A3 --( a/3 ) ----+==+--> WithAdd:A* ------|
|- A4 --( a/4 ) --+=/                        |
|- IO --( a/5 ) --/                          |
                       /--> UsingWc:A* ------|
              ( a/# ) -+--> UsingWcWithA:A* -|
```

## Computation

A _n_ = Input _n_ + _n_, e.g., A1 = Input1 + 1 and A3 = Input3 + 3

## Execution-Trace (SendInitialValue)

| Input | [A1,A2,A3,A4,IO] | #   | A*          | UsingWcA    | WithAddA            | UsingWcWithAddA:A   |
|-------|------------------|-----|-------------|-------------|---------------------|---------------------|
| *     | [1,2,3,4,0]      | 5   | [1,2,3,4,0] | [1,2,3,4,0] | [1,2,3,4,0]         | [1,2,3,4,0]         |
| I1:1  | [2,2,3,4,0]      | 6   | [2,2,3,4,0] | [2,2,3,4,0] | [1,2,3,4,0,2]       | [1,2,3,4,0,2]       |
| I1:1  | [2,2,3,4,0]      | 6   | [2,2,3,4,0] | [2,2,3,4,0] | [1,2,3,4,0,2]       | [1,2,3,4,0,2]       |
| I1:2  | [3,2,3,4,0]      | 7   | [3,2,3,4,0] | [3,2,3,4,0] | [1,2,3,4,0,2,3]     | [1,2,3,4,0,2,3]     |
| IO:5  | [3,2,3,4,5]      | 8   | [3,2,3,4,5] | [3,2,3,4,5] | [1,2,3,4,0,2,3,5]   | [1,2,3,4,0,2,3,5]   |
| I3:4  | [3,2,7,4,5]      | 9   | [3,2,7,4,5] | [3,2,7,4,5] | [1,2,3,4,0,2,3,5,7] | [1,2,3,4,0,2,3,5,7] |

*: (1:0, 2:0, 3:0, 4:0, 5:0)

## Execution-Trace (OnlyUpdate)

| Input | [A1,A2,A3,A4,IO] | #   | A*          | UsingWcA | WithAddA  | UsingWcWithAddA:A |
|-------|------------------|-----|-------------|----------|-----------|-------------------|
| *     | [-,-,-,-,-]      | 0   | [0,0,0,0,0] | []       | []        | []                |
| I1:1  | [2,-,-,-,-]      | 1   | [2,0,0,0,0] | [2]      | [2]       | [2]               |
| I1:1  | [2,-,-,-,-]      | 1   | [2,0,0,0,0] | [2]      | [2]       | [2]               |
| I1:2  | [3,-,-,-,-]      | 2   | [3,0,0,0,0] | [3]      | [2,3]     | [2,3]             |
| IO:5  | [2,-,-,-,5]      | 3   | [3,0,0,0,5] | [3,5]    | [2,3,5]   | [2,3,5]           |
| I3:4  | [2,-,7,-,5]      | 4   | [3,0,7,0,5] | [3,5,7]  | [2,3,5,7] | [2,3,5,7]         |

*: (1:0, 2:0, 3:0, 4:0, 5:0)
