package ipos.project.iposextension.orderpicker.eca;

import ipos.models.OFBizOrderpicker;
import ipos.project.devkit.eca.zseq.StageChangeAction;
import ipos.project.devkit.utility.ExternalPubServiceImpl;
import ipos.project.devkit.utility.ProtoJsonMap;
import ipos.project.iposextension.orderpicker.OFBizOrderPicker;
import ipos.project.iposextension.orderpicker.frontend.FETransformer;
import ipos.project.iposextension.orderpicker.frontend.FEUpdateInventoryItem;
import ipos.project.iposextension.orderpicker.frontend.FEUpdateShipmentBin;
import org.apache.logging.log4j.LogManager;
import org.springframework.beans.factory.annotation.Autowired;

public class UpdateFrontendAction extends StageChangeAction {
    private static org.apache.logging.log4j.Logger LOG = LogManager.getLogger();
    private final int index;
    private final boolean isCorrect;
    private final String itemId;

   // @Autowired
   // public static ExternalPubServiceImpl mqttService;

    public UpdateFrontendAction(int index, boolean isCorrect, String itemId) {
        super();
        this.index = index;
        this.isCorrect = isCorrect;
        this.itemId = itemId;
    }

    @Override
    public void execute() {
        if (isInventoryItem(this.itemId)){
            FEUpdateInventoryItem feUpdInvItem = new FEUpdateInventoryItem(index, isCorrect, itemId);
            OFBizOrderpicker.FEndUpdateInventoryItem proto_invItem = FETransformer.transformIntoProto(feUpdInvItem);
            OFBizOrderpicker.FEndWrapper proto_invItemWrapper = FETransformer.putIntoWrapper(proto_invItem);
            String jsonString = ProtoJsonMap.toJson(proto_invItemWrapper);
            OFBizOrderPicker.mqttService.publish(OFBizOrderPicker.TOPIC_FRONTEND, jsonString, 0, false);
            LOG.info("OP: publishing JSON-InventoryItem mqtt update-message to OP-Frontend-app:" + jsonString + " on topic: " + OFBizOrderPicker.TOPIC_FRONTEND + ". isCorrect (proto): " + proto_invItem.getIsCorrect());
        }else if(isShipmentBin(this.itemId)) {
            int shipmentBinNr = extractShipmentBinNr(this.itemId);
            FEUpdateShipmentBin feUpdShipBinNr = new FEUpdateShipmentBin(index, isCorrect, shipmentBinNr);
            OFBizOrderpicker.FEndUpdateShipmentBin proto_shipBin = FETransformer.transformIntoProto(feUpdShipBinNr);
            OFBizOrderpicker.FEndWrapper proto_shipBinWrapper = FETransformer.putIntoWrapper(proto_shipBin);
            String jsonString = ProtoJsonMap.toJson(proto_shipBinWrapper);
            OFBizOrderPicker.mqttService.publish(OFBizOrderPicker.TOPIC_FRONTEND, jsonString, 0, false);
            LOG.info("OP: publishing JSON-ShipmentBin mqtt update-message to OP-Frontend-app:" + jsonString + " on topic: " + OFBizOrderPicker.TOPIC_FRONTEND+ ". isCorrect (proto): " + proto_shipBin.getIsCorrect());
        } else {
            LOG.info("OP: Warning: Could not react to StageChange, as vessel-type could not be determined");
            return;
        }
    }

    private int extractShipmentBinNr(String itemId) {
        return Integer.parseInt(itemId.split("_")[1]);
    }

    private boolean isShipmentBin(String itemId) {
        return itemId.startsWith(OFBizOrderPicker.PREFIX_SHIPMENTBIN);
    }

    private boolean isInventoryItem(String itemId) {
        return itemId.startsWith(OFBizOrderPicker.PREFIX_INVENTORYITEM);
    }
}
