package ipos.project.devkit.iposext;

import ipos.models.SimpleScene;
import ipos.project.DataModellntegration.iPos_Datamodel.IPosDevKit.IposPositionEvent;
import ipos.project.UseCaseController.PositionMonitoring;
import ipos.project.devkit.utility.ExternalPubServiceImpl;
import ipos.project.devkit.utility.ProtoJsonMap;
import ipos.project.iposextension.orderpicker.OFBizOrderPicker;

abstract public class IPosExtension {

    public ExternalPubServiceImpl mqttService;

    public void setMqttService(ExternalPubServiceImpl mqttService_){
        mqttService = mqttService_;
    }

    public void configureIpos(IPosArguments.IPosConfigData iposConfigData) {
        SimpleScene.IposConfigWrapper configWrapper = prepareConfigWrapper(iposConfigData);
        sendConfigWrapperToIpos(configWrapper);
    }

    private void sendConfigWrapperToIpos(SimpleScene.IposConfigWrapper proto_configWrapper) {
        String json_configWrapper = ProtoJsonMap.toJson(proto_configWrapper);
        if (mqttService == null){
            throw new RuntimeException("Could not send configuration data to IPos-Framework as MQTT-service was not properly initialized.");
        }
        mqttService.publish(PositionMonitoring.TOPIC_ConfigWrapper, json_configWrapper, 0, false);
    }

    public abstract void handlePositionEvent(IposPositionEvent posEvent);
    public abstract void handlePositionEvent(IposPositionEvent posEvent, IPosArguments.HandlePosEventConf posEventConf);

    public abstract SimpleScene.IposConfigWrapper prepareConfigWrapper(IPosArguments.IPosConfigData iposConfigData);

    /*
    private void useTransformer(){
        ...
        IPosTransformer.MonReqTransformer<SimpleScene.IposMonitoringRequest> monReq2protoTransformer = new IPos2protoTransformer.MonReq2ProtoTransformer();
        //monReq2protoTransformer.transformMonReq();
    }
    */
}
