package ipos.project.devkit.eca;

import ipos.project.DataModellntegration.iPos_Datamodel.IPosDevKit.IposPositionEvent;
import ipos.project.DataModellntegration.iPos_Datamodel.PositionEvent;
import ipos.project.devkit.iposext.IPosArguments;

public abstract class ECARule {

    protected Condition condition;

    public void apply(IposPositionEvent posEvent){
        if (isApplicable(posEvent)){
            Action action = condition.evaluate(posEvent);
            action.execute();
        }
    }

    public abstract boolean isApplicable(IposPositionEvent posEvent);

    public abstract void configure(IPosArguments.IPosEcaConfig ecaConfig);
}
