package ipos.project.UseCaseController;

import ipos.project.DataModellntegration.iPos_Datamodel.Agent;
import ipos.project.DataModellntegration.iPos_Datamodel.POI;
import ipos.project.DataModellntegration.iPos_Datamodel.ReferenceSystem;
import ipos.project.DataModellntegration.iPos_Datamodel.Zone;
import ipos.project.Functionality.DataServices;
import org.apache.logging.log4j.LogManager;
import org.springframework.stereotype.Component;


@Component
public class Administration {
    private static org.apache.logging.log4j.Logger LOG = LogManager.getLogger();

    public Administration(){}

    public static void initialize(){
        LOG.info("Application initialized");
        DataServices.clearWorldModel();
    }

    public static void handleZone(Zone zone){
        LOG.info("handling zone-object: " + zone.toString());
        DataServices.addZone(zone);
    }

    public static void handleAgent(Agent agent) {
        LOG.info("handling agent-object: " + agent.toString());
        DataServices.addAgent(agent);
    }

    public static void handleRefSystem(ReferenceSystem refSystem) {
        // muss checken, ob das RefSystem auf das ggf. verwiesen wird - tatsächlich existiert. Falls nicht: Speicherung ablehnen
        LOG.info("handling refSystem-object: " + refSystem.toString());
        DataServices.addRefSystem(refSystem);
    }

    public static void handlePoi(POI poi) {
        // muss checken, ob das RefSystem auf das verwiesen wird - tatsächlich existiert. Falls nicht: Speicherung ablehnen
        LOG.info("handling poi-object: " + poi.toString());
        DataServices.addPoi(poi);
    }
}
