package ipos.project.SensorValueIntegration.Service;

import com.google.protobuf.ProtocolStringList;
import ipos.models.GenericSensor;
import ipos.models.SimpleScene;
import ipos.project.DataModellntegration.iPos_Datamodel.*;
import ipos.project.devkit.trans.IPos2protoTransformer;
import org.apache.logging.log4j.LogManager;
import org.eclipse.emf.ecore.EObject;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GenericSensorTransformer {

    private static IPos_DatamodelFactory modelFactory = IPos_DatamodelFactory.eINSTANCE;

   private static List<String> toJavaStringList(ProtocolStringList protoList){
        List<String> javaList = new ArrayList<String>();
        for(int i = 0; i < protoList.size(); i++ ){
            javaList.set(i, protoList.get(i));
        }
        return javaList;
    }

    public static SimpleScene.IposMonitoringRequest monReq_Internal2SScene(){
        return null;
    }

    public static PositionEvent posEvent_GSensor2Internal(GenericSensor.SensorPositionEvent protoSensPosEvent) {
        PositionEvent positionEvent = modelFactory.createPositionEvent();
        positionEvent.setTimeStamp(protoSensPosEvent.getLastPosUpdate());
        positionEvent.setLObjectId(protoSensPosEvent.getSensorId());

        // TODO: Zugriff auf Weltmodell ermöglichen um Bezugssystem-Objekt beschaffen zu können
        positionEvent.setPlacing(
                createPlacing(
                        IPos2protoTransformer.createPosition(
                                IPos2protoTransformer.createPoint3D(
                                        protoSensPosEvent.getPosition().getPoint().getX(),
                                        protoSensPosEvent.getPosition().getPoint().getY(),
                                        protoSensPosEvent.getPosition().getPoint().getZ()
                                ),
                                protoSensPosEvent.getPosition().getAccuracy(),
                                IPos2protoTransformer.createReferenceSystem("ROOT", "ROOT", null)
                        ),
                        IPos2protoTransformer.createOrientation(
                                protoSensPosEvent.getOrientation().getX(),
                                protoSensPosEvent.getOrientation().getY(),
                                protoSensPosEvent.getOrientation().getZ(),
                                protoSensPosEvent.getOrientation().getW()
                        )
                ));
        return positionEvent;
    }

    private static Placing createPlacing(Position position, Orientation orientation){
        Placing placing = modelFactory.createPlacing();
        placing.setPosition(position);
        placing.setOrientation(orientation);
        return placing;
    }

    public static NFC nfc_GSensor2Internal(GenericSensor.NFCRawDataEvent proto_nfcRawdataEvent) {
        NFC internal_nfcRawdataEvent = modelFactory.createNFC();
        // internal_nfcRawdataEvent.setTimeStamp(proto_nfcRawdataEvent.getTimestamp());

        // fake nfc-timestamp (queube could not provide millisecond-accuracy as it relies on time server)
       internal_nfcRawdataEvent.setTimeStamp(LocalDateTime.now() + "+00:00"); // suffix necessary to be parsable by DateTimeFormatter.ISO_OFFSET_DATE_TIME
       internal_nfcRawdataEvent.setTagId(proto_nfcRawdataEvent.getTagId());
        internal_nfcRawdataEvent.setScannerId(proto_nfcRawdataEvent.getScannerId());
        internal_nfcRawdataEvent.setType(proto_nfcRawdataEvent.getType());
        internal_nfcRawdataEvent.setTagData(convertToStringToObjectMap(proto_nfcRawdataEvent.getTagDataMap()));
        return internal_nfcRawdataEvent;
   }

    private static Map<String, Object> convertToStringToObjectMap(Map<String, String> inputMap) {
        Map<String,Object> outputMap =new HashMap<String,Object>();
        for (Map.Entry<String, String> entry : inputMap.entrySet()) {
            if(entry.getValue() != null){
                outputMap.put(entry.getKey(), (Object) entry.getValue());
            }
        }
        return outputMap;
    }

    public static IMU imu_GSensor2Internal(GenericSensor.IMURawDataEvent proto_imuRawDataEvent) {
       IMU internal_imuRawDataEvent = modelFactory.createIMU();
       internal_imuRawDataEvent.setTimeStamp(proto_imuRawDataEvent.getTimestamp());
       internal_imuRawDataEvent.setSensorId(proto_imuRawDataEvent.getSensorId());
       Acceleration internal_acceleration = modelFactory.createAcceleration();
       internal_acceleration.setX(proto_imuRawDataEvent.getX());
       internal_acceleration.setY(proto_imuRawDataEvent.getY());
       internal_acceleration.setZ(proto_imuRawDataEvent.getZ());
       internal_imuRawDataEvent.setAcceleration(internal_acceleration);
       Quaternion orientation = IPos2protoTransformer.createOrientation(proto_imuRawDataEvent.getOrientation().getX(),
               proto_imuRawDataEvent.getOrientation().getY(),
               proto_imuRawDataEvent.getOrientation().getZ(),
               proto_imuRawDataEvent.getOrientation().getW());
       internal_imuRawDataEvent.setAngularrate(orientation);
       return internal_imuRawDataEvent;
    }

    public static UWB uwb_GSensor2Internal(GenericSensor.UWBRawDataEvent proto_uwbRawDataEvent) {
        UWB internal_uwbRawDataEvent = modelFactory.createUWB();
        internal_uwbRawDataEvent.setTimeStamp(proto_uwbRawDataEvent.getTimestamp());
        internal_uwbRawDataEvent.setDistances(convertToStringToDoubleMap(proto_uwbRawDataEvent.getDistancesMap()));
        internal_uwbRawDataEvent.setType(proto_uwbRawDataEvent.getType());
        internal_uwbRawDataEvent.setSensorId(proto_uwbRawDataEvent.getSensorId());
        return internal_uwbRawDataEvent;
    }

    private static Map<String, Double> convertToStringToDoubleMap(Map<String, String> distancesMap) throws NumberFormatException {
        Map<String,Double> outputMap =new HashMap<String,Double>();
        for (Map.Entry<String, String> entry : distancesMap.entrySet()) {
            if(entry.getValue() != null){
                outputMap.put(entry.getKey(), Double.parseDouble(entry.getValue()));
            }
        }
        return outputMap;

   }
}


