package ipos.project.SensorValueIntegration;

import com.google.protobuf.InvalidProtocolBufferException;
import ipos.models.GenericSensor;
import ipos.models.SimpleScene.IposPosition;
import ipos.project.devkit.utility.ExternalPubServiceImpl;
import ipos.project.SensorValueIntegration.api.MqttPositionHandler;
import ipos.project.devkit.utility.OtherUtility;
import ipos.project.devkit.utility.ProtoJsonMap;
import org.apache.logging.log4j.LogManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Component;

import java.io.File;

@Component
public class GenericSensorValueProcessor {
    private static org.apache.logging.log4j.Logger LOG = LogManager.getLogger();

    @Autowired
    private ExternalPubServiceImpl mqttService;

    @JmsListener(destination = "/positions", containerFactory = "jmsListenFactory")
    public void receiveMessage(IposPosition pos) {
        LOG.trace("Data integration get: " + pos);
        // we can translate a class into a string using several methods: 1) `.toString()` 2) `JsonFormat` in `ProtoJsonMap`
        String jsonPos = ProtoJsonMap.toJson(pos);
        if (jsonPos != null) {
            this.mqttService.publish("test51/subscribe/positions", jsonPos, 0, false);
        }
    }

    public static void processTestData(String path_to_test_data_file){
        File testDataFile = new File(path_to_test_data_file);
        try {
            for (String line : OtherUtility.readLines(testDataFile)) {
                GenericSensor.SensorEventWrapper sensorEventWrapper = ProtoJsonMap.fromJson(line, GenericSensor.SensorEventWrapper.class);
                MqttPositionHandler.handleSensorEventWrapper(sensorEventWrapper);
            }
        }catch (InvalidProtocolBufferException e) {
            LOG.error("Error trying to read JSON into protobuf-objects: ");
            e.printStackTrace();
        }
    }

}
