package ipos.project.Functionality.eventfilter;

import ipos.project.DataModellntegration.iPos_Datamodel.PositionEvent;

import java.util.List;

public class FilteringResult {

    public FilteringResult(String monitoringTaskId, PositionEvent posEvent, boolean isBlocking, List<String> matchingPositionConditionCells, List<String> allPositionConditionCells){
        this.monitoringTaskId = monitoringTaskId;
        this.posEvent = posEvent;
        this.isBlocking = isBlocking;
        this.matchingPositionConditionCells = matchingPositionConditionCells;
        this.nonMatchingPositionConditionCells = allPositionConditionCells;
        this.nonMatchingPositionConditionCells.removeAll(matchingPositionConditionCells);
    }

    public String getMonitoringTaskId() {
        return monitoringTaskId;
    }

    private String monitoringTaskId;
    private boolean isBlocking;
    private List<String> matchingPositionConditionCells;
    private List<String> nonMatchingPositionConditionCells;


    public PositionEvent getPosEvent() {
        return posEvent;
    }

    private PositionEvent posEvent;

    public boolean hasBlockedEvent(){
        return this.isBlocking;
    }

    public List<String> getMatchingPositionConditionCellIds() {
        return this.matchingPositionConditionCells;
    }

    public List<String> getNonMatchingPositionConditionCellIds(){
        return this.nonMatchingPositionConditionCells;
    }
}
