/*
 * Copyright (C) 2014 Sebastian Ebert.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package de.tudresden.inf.st.rosjava_rag_connector.signal_test;

import de.tudresden.inf.st.pnml.jastadd.model.JavaHandler;
import de.tudresden.inf.st.pnml.jastadd.model.Marking;
import de.tudresden.inf.st.service.PetriNetInitService;
import de.tudresden.inf.st.service.PetriNetLoggingService;
import org.ros.concurrent.CancellableLoop;
import org.ros.namespace.GraphName;
import org.ros.node.AbstractNodeMain;
import org.ros.node.ConnectedNode;
import org.ros.node.NodeMain;
import org.ros.node.topic.Publisher;

import java.util.List;
import java.util.function.Consumer;

// rosrun rosjava_rag_connector signal_connector_module de.tudresden.inf.st.rosjava_rag_connector.signal_connector_module.Talker
/**
 * A simple {@link Publisher} {@link NodeMain}.
 */
public class Talker extends AbstractNodeMain {

  @Override
  public GraphName getDefaultNodeName() {
    return GraphName.of("rosjava/talker");
  }

  @Override
  public void onStart(final ConnectedNode connectedNode) {
    final Publisher<std_msgs.String> publisher =
        connectedNode.newPublisher("chatter", std_msgs.String._TYPE);
    JavaHandler jh = JavaHandler.getInstance();

    jh.registerCallback("/outputsignal/os1", new Consumer<byte[]>() {
      @Override
      public void accept(byte[] bytes) {
        System.out.println("TEST OS1 CALLBACK");
        std_msgs.String str = publisher.newMessage();
        str.setData("TEST OS1 CALLBACK ROS");
        publisher.publish(str);
      }
    });
    jh.registerCallback("/outputsignal/os2", new Consumer<byte[]>() {
      @Override
      public void accept(byte[] bytes) {
        System.out.println("TEST OS2 CALLBACK");
        std_msgs.String str = publisher.newMessage();
        str.setData("TEST OS1 CALLBACK ROS");
        publisher.publish(str);
      }
    });

    List<Marking> markedGraphs = PetriNetInitService.initMarkedGraphs("src/rosjava_catkin_package_a/my_pub_sub_tutorial/src/main/resources/minimal.pnml");
    //PetriNetLoggingService.printInputSignals(markedGraphs.get(0));
    PetriNetLoggingService.printOutputSignals(markedGraphs.get(0));
    //markedGraphs.get(0).print();

    // This CancellableLoop will be canceled automatically when the node shuts
    // down.
    /*connectedNode.executeCancellableLoop(new CancellableLoop() {
      private int sequenceNumber;

      @Override
      protected void setup() {
        sequenceNumber = 0;
      }

      @Override
      protected void loop() throws InterruptedException {
        std_msgs.String str = publisher.newMessage();
        str.setData("Hello world! " + sequenceNumber);
        publisher.publish(str);
        sequenceNumber++;
        Thread.sleep(1000);
      }
    });*/
  }
}
