/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.st.service;

import de.tudresden.inf.st.pnml.PnmlParseException;
import de.tudresden.inf.st.pnml.PnmlParser;
import de.tudresden.inf.st.pnml.jastadd.model.InputSignalBinding;
import de.tudresden.inf.st.pnml.jastadd.model.InputSignalTransition;
import de.tudresden.inf.st.pnml.jastadd.model.Marking;
import de.tudresden.inf.st.pnml.jastadd.model.OutputSignalBinding;
import de.tudresden.inf.st.pnml.jastadd.model.OutputSignalPlace;
import de.tudresden.inf.st.pnml.jastadd.model.Place;
import de.tudresden.inf.st.pnml.jastadd.model.Transition;
import de.tudresden.inf.st.service.PetriNetLoggingService;
import fr.lip6.move.pnml.framework.general.PNType;
import fr.lip6.move.pnml.framework.hlapi.HLAPIRootClass;
import fr.lip6.move.pnml.framework.utils.ModelRepository;
import fr.lip6.move.pnml.framework.utils.PNMLUtils;
import fr.lip6.move.pnml.framework.utils.exception.ImportException;
import fr.lip6.move.pnml.framework.utils.exception.InvalidIDException;
import fr.lip6.move.pnml.ptnet.PetriNet;
import fr.lip6.move.pnml.ptnet.hlapi.PetriNetDocHLAPI;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PetriNetInitService {
    private static final Logger logger = LoggerFactory.getLogger(PetriNetLoggingService.class);

    public static List<Marking> initMarkedGraphs(String fileName) {
        logger.info("[GRAPH_INIT] Setting up initial graph configurations");
        List<de.tudresden.inf.st.pnml.jastadd.model.PetriNet> petriNets = PetriNetInitService.parsePnml(fileName);
        ArrayList<Marking> markedGraphs = new ArrayList<Marking>();
        for (de.tudresden.inf.st.pnml.jastadd.model.PetriNet petriNet : petriNets) {
            Marking setupMarking = petriNet.setupMarking(petriNet);
            setupMarking.setPetriNet(petriNet);
            PetriNetInitService.setupOutputDependencies(petriNet, setupMarking);
            PetriNetInitService.setupInputDependencies(petriNet);
            for (Place p : petriNet.allPlaces()) {
                if (!p.hasInitialMarking() || p.getInitialMarking().getText() == null) continue;
                setupMarking.resolvePlace(p).setMarking(p.getInitialMarking().getText());
            }
            markedGraphs.add(setupMarking);
        }
        return markedGraphs;
    }

    private static void setupInputDependencies(de.tudresden.inf.st.pnml.jastadd.model.PetriNet petriNet) {
        for (Transition t : petriNet.allTransitions()) {
            if (t.asInputSignalTransition() == null) continue;
            InputSignalTransition ist = t.asInputSignalTransition();
            for (InputSignalBinding isb : ist.getInputSignalBindingList()) {
                try {
                    String uri = "java://localhost/inputsignal/" + isb.getInputSignalID();
                    isb.connectInputSignalValue(uri);
                }
                catch (IOException e) {
                    logger.error("[GRAPH_INIT] Error while setting up dependencies: " + e.getStackTrace());
                }
            }
        }
    }

    private static void setupOutputDependencies(de.tudresden.inf.st.pnml.jastadd.model.PetriNet petriNet, Marking setupMarking) {
        for (Place p : petriNet.allPlaces()) {
            if (p.asOutputSignalPlace() == null) continue;
            OutputSignalPlace osp = p.asOutputSignalPlace();
            for (OutputSignalBinding osb : osp.getOutputSignalBindingList()) {
                if (setupMarking.resolvePlace(p) == null) continue;
                try {
                    osb.addMarkingDependency(setupMarking.resolvePlace(p));
                    String uri = "java://localhost/outputsignal/" + osb.getOutputSignalID();
                    osb.connectOutputSignalValue(uri, true);
                }
                catch (IOException e) {
                    logger.error("[GRAPH_INIT] Error while setting up dependencies: " + e.getStackTrace());
                }
            }
        }
    }

    private static List<de.tudresden.inf.st.pnml.jastadd.model.PetriNet> parsePnml(String fileName) {
        Path file = Paths.get(fileName, new String[0]);
        HLAPIRootClass document = null;
        try {
            document = PNMLUtils.importPnmlDocument((File)file.toFile(), (boolean)false);
            logger.info(document.toPNML());
        }
        catch (ImportException | InvalidIDException e) {
            logger.error("Unable to import PNML document from file '{}'", (Object)fileName);
            logger.error("Exception was thrown!", e);
            System.exit(-1);
        }
        logger.info("Imported document workspace ID: {}", (Object)ModelRepository.getInstance().getCurrentDocWSId());
        ArrayList<de.tudresden.inf.st.pnml.jastadd.model.PetriNet> petriNets = new ArrayList<de.tudresden.inf.st.pnml.jastadd.model.PetriNet>();
        PNType type = PNMLUtils.determinePNType((HLAPIRootClass)document);
        switch (type) {
            case PTNET: {
                PetriNetDocHLAPI ptDoc = (PetriNetDocHLAPI)document;
                for (PetriNet pmnlNet : ptDoc.getNets()) {
                    try {
                        PnmlParser parser = new PnmlParser(pmnlNet);
                        petriNets.add(parser.getPetriNet());
                    }
                    catch (PnmlParseException e) {
                        logger.error("Parsing the Petri net using the PNML framawork failed.", (Throwable)e);
                    }
                }
                break;
            }
            default: {
                logger.error("Petri net is of unsupported type {}.", (Object)type.getLiteral());
                System.exit(-1);
            }
        }
        return petriNets;
    }
}

