/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.st.service;

import de.tudresden.inf.st.pnml.jastadd.model.InputSignalBinding;
import de.tudresden.inf.st.pnml.jastadd.model.Marking;
import de.tudresden.inf.st.pnml.jastadd.model.Place;
import de.tudresden.inf.st.pnml.jastadd.model.Transition;
import de.tudresden.inf.st.service.TransitionCallbackTupel;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PetriNetExecutionService {
    public static PetriNetExecutionService SERVICE_INSTANCE = null;
    private final Logger logger = LogManager.getLogger(PetriNetExecutionService.class);
    private List<TransitionCallbackTupel> transitionSuccessCallbackTupelList = new ArrayList<TransitionCallbackTupel>();
    private List<TransitionCallbackTupel> transitionFailureCallbackTupelList = new ArrayList<TransitionCallbackTupel>();

    private PetriNetExecutionService() {
    }

    public static synchronized PetriNetExecutionService getInstance() {
        if (SERVICE_INSTANCE == null) {
            SERVICE_INSTANCE = new PetriNetExecutionService();
        }
        return SERVICE_INSTANCE;
    }

    public String addSuccessCallbackToTransitionFiring(Transition transition, Consumer<Transition> callback) {
        String id = UUID.randomUUID().toString();
        this.transitionSuccessCallbackTupelList.add(new TransitionCallbackTupel(id, transition.getId(), callback));
        return id;
    }

    public String addFailureCallbackToTransitionFiring(Transition transition, Consumer<Transition> callback) {
        String id = UUID.randomUUID().toString();
        this.transitionFailureCallbackTupelList.add(new TransitionCallbackTupel(id, transition.getId(), callback));
        return id;
    }

    public void removeSuccessCallbackToTransitionFiring(String callbackId) {
        for (int i = 0; i < this.transitionSuccessCallbackTupelList.size(); ++i) {
            if (!this.transitionSuccessCallbackTupelList.get((int)i).id.equals(callbackId)) continue;
            this.transitionSuccessCallbackTupelList.remove(i);
            return;
        }
    }

    public void removeFailureCallbackToTransitionFiring(String callbackId) {
        for (int i = 0; i < this.transitionFailureCallbackTupelList.size(); ++i) {
            if (!this.transitionFailureCallbackTupelList.get((int)i).id.equals(callbackId)) continue;
            this.transitionFailureCallbackTupelList.remove(i);
            return;
        }
    }

    private void callSuccessCallbacksForTransition(Transition transition) {
        for (int i = 0; i < this.transitionSuccessCallbackTupelList.size(); ++i) {
            if (!this.transitionSuccessCallbackTupelList.get((int)i).transitionId.equals(transition.getId())) continue;
            this.transitionSuccessCallbackTupelList.get(i).getCallback().accept(transition);
        }
    }

    private void callFailureCallbacksForTransition(Transition transition) {
        for (int i = 0; i < this.transitionFailureCallbackTupelList.size(); ++i) {
            if (!this.transitionFailureCallbackTupelList.get((int)i).transitionId.equals(transition.getId())) continue;
            this.transitionFailureCallbackTupelList.get(i).getCallback().accept(transition);
        }
    }

    public boolean fireLocalTransition(Transition transition, Marking markedGraph) {
        if (transition.asInputSignalTransition().type().equals("discreteTransitionType")) {
            this.logger.info("[PetriNetExecutionService] Firing transition " + transition.getId());
            for (Transition t : markedGraph.getPetriNet().allTransitions()) {
                if (t.getId() != transition.getId()) continue;
                int placeCount = 0;
                int markingCount = 0;
                for (Place p : markedGraph.collectIncomingPlace(t)) {
                    ++placeCount;
                    if (markedGraph.resolvePlace(p).getMarking() <= 0) continue;
                    ++markingCount;
                }
                if (placeCount != markingCount || transition.asInputSignalTransition().getNumInputSignalBinding() <= 0) continue;
                int activeSignalCount = 0;
                for (InputSignalBinding isb : transition.asInputSignalTransition().getInputSignalBindingList()) {
                    if (isb.getInputSignalValue() != 1) continue;
                    ++activeSignalCount;
                }
                if (activeSignalCount == transition.asInputSignalTransition().getNumInputSignalBinding()) {
                    markedGraph.fireTransition(t, true);
                    this.callSuccessCallbacksForTransition(transition);
                    return true;
                }
                this.logger.error("[PetriNetExecutionService] Could not fire transition " + transition.getId() + ". Reason: Transition is disabled by signals.");
            }
        } else {
            this.logger.error("[PetriNetExecutionService] Could not fire transition " + transition.getId() + ". Reason: Tried to fire not local transition as local transition.");
        }
        this.logger.error("[PetriNetExecutionService] Could not fire transition " + transition.getId() + ". Reason: Transition is not enabled.");
        this.callFailureCallbacksForTransition(transition);
        return false;
    }
}

