/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.st.pnml.jastadd.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JavaHandler {
    public static JavaHandler JAVA_HANDLER_INSTANCE = null;
    private final Logger logger = LogManager.getLogger(JavaHandler.class);
    private Map<String, List<Pair<String, Consumer<byte[]>>>> callbackList = new ConcurrentHashMap<String, List<Pair<String, Consumer<byte[]>>>>();

    private JavaHandler() {
    }

    public static synchronized JavaHandler getInstance() {
        if (JAVA_HANDLER_INSTANCE == null) {
            JAVA_HANDLER_INSTANCE = new JavaHandler();
        }
        return JAVA_HANDLER_INSTANCE;
    }

    public String registerCallback(String topic, Consumer<byte[]> callback) {
        this.logger.error("[JAVA_HANDLER] Registering new callback.");
        String callbackUUID = UUID.randomUUID().toString();
        List<Pair<String, Consumer<byte[]>>> registeredCallbacks = this.getAllCallbacks().get(topic);
        if (registeredCallbacks == null) {
            List<MutablePair> newCallbackList = Collections.synchronizedList(new ArrayList());
            newCallbackList.add(new MutablePair((Object)callbackUUID, callback));
            this.callbackList.put(topic, newCallbackList);
        } else {
            registeredCallbacks.add((Pair<String, Consumer<byte[]>>)new MutablePair((Object)callbackUUID, callback));
        }
        return callbackUUID;
    }

    public boolean unregisterCallback(String path, String uuid) {
        this.logger.debug("[JAVA_HANDLER] Unregistering callback with uuid: " + uuid + " on path: " + path);
        List<Pair<String, Consumer<byte[]>>> callbacks = this.getAllCallbacks().get(path);
        int count = 0;
        if (callbacks != null) {
            for (Pair<String, Consumer<byte[]>> callbackPair : callbacks) {
                if (((String)callbackPair.getLeft()).equals(uuid)) {
                    callbacks.remove(count);
                    return true;
                }
                ++count;
            }
        }
        return false;
    }

    public void close() {
    }

    public boolean push(String topic, byte[] data) {
        this.logger.error("[JAVA_HANDLER] Pushing a message.");
        String dataString = new String(data);
        this.logger.error("[JAVA_HANDLER] Data: " + dataString);
        List<Pair<String, Consumer<byte[]>>> callbacks = this.getAllCallbacks().get(topic);
        if (callbacks == null) {
            this.logger.error("[JAVA_HANDLER] Could not publish message. No callback registered for topic " + topic);
            return false;
        }
        for (Pair<String, Consumer<byte[]>> callbackPair : callbacks) {
            this.logger.error("[JAVA_HANDLER] Calling callback: " + (String)callbackPair.getLeft());
            ((Consumer)callbackPair.getRight()).accept(data);
        }
        return true;
    }

    public Map<String, List<Pair<String, Consumer<byte[]>>>> getAllCallbacks() {
        return this.callbackList;
    }
}

