/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.st.pnml;

import de.tudresden.inf.st.pnml.jastadd.model.JastAddList;
import de.tudresden.inf.st.pnml.jastadd.model.ToolInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ToolSpecificsParser {
    private static final Logger logger = LoggerFactory.getLogger(ToolSpecificsParser.class);

    public static String getLocationFromToolSpecifics(JastAddList<ToolInfo> toolInfos) {
        if (toolInfos.getNumChild() > 0) {
            try {
                Document doc = ToolSpecificsParser.parseToolSpecifics(toolInfos);
                NodeList locationList = doc.getElementsByTagName("location");
                if (locationList.getLength() > 0 && locationList.item(0) != null) {
                    return locationList.item(0).getTextContent();
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                logger.error(e.getMessage());
            }
        }
        return "";
    }

    public static String getTransitionTypeFromToolSpecifics(JastAddList<ToolInfo> toolInfos) {
        if (toolInfos.getNumChild() > 0) {
            try {
                Document doc = ToolSpecificsParser.parseToolSpecifics(toolInfos);
                NodeList typeList = doc.getElementsByTagName("type");
                if (typeList.getLength() > 0 && typeList.item(0) != null) {
                    String type = typeList.item(0).getTextContent();
                    if (type.equals("acChannelTransitionType") || type.equals("ackAcChannelTransitionType") || type.equals("notAcChannelTransitionType") || !type.equals("continuousTransitionType") || type.equals("discreteTransitionType") || type.equals("channelTransitionType") || type.equals("channelTransitionType")) {
                        return type;
                    }
                    logger.error("Error: Invalid transition type configured.");
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                logger.error(e.getMessage());
            }
        }
        return "";
    }

    public static String getPlaceTypeFromToolSpecifics(JastAddList<ToolInfo> toolInfos) {
        if (toolInfos.getNumChild() > 0) {
            try {
                Document doc = ToolSpecificsParser.parseToolSpecifics(toolInfos);
                NodeList typeList = doc.getElementsByTagName("type");
                if (typeList.getLength() > 0 && typeList.item(0) != null) {
                    String type = typeList.item(0).getTextContent();
                    if (type.equals("discretePlaceType") || type.equals("continuousPlaceType")) {
                        return type;
                    }
                    logger.error("Error: Invalid transition type configured.");
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                logger.error(e.getMessage());
            }
        }
        return "";
    }

    public static Boolean isBoundedChannelTransitionType(JastAddList<ToolInfo> toolInfos) {
        if (toolInfos.getNumChild() > 0) {
            try {
                Document doc = ToolSpecificsParser.parseToolSpecifics(toolInfos);
                NodeList typeList = doc.getElementsByTagName("type");
                if (typeList.getLength() > 0 && typeList.item(0) != null) {
                    String type = typeList.item(0).getTextContent();
                    if (type.equals("channelTransitionType")) {
                        return true;
                    }
                    return false;
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                logger.error(e.getMessage());
            }
        }
        return false;
    }

    public static int getBoundedChannelTransitionValue(JastAddList<ToolInfo> toolInfos) {
        if (toolInfos.getNumChild() > 0) {
            try {
                Document doc = ToolSpecificsParser.parseToolSpecifics(toolInfos);
                NodeList typeList = doc.getElementsByTagName("type");
                if (typeList.getLength() > 0 && typeList.item(0) != null) {
                    String type = typeList.item(0).getTextContent();
                    if (type.equals("channelTransitionType")) {
                        NodeList boundList = doc.getElementsByTagName("bound");
                        return Integer.valueOf(boundList.item(0).getTextContent());
                    }
                    return -1;
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                logger.error(e.getMessage());
            }
        }
        return -1;
    }

    private static Document parseToolSpecifics(JastAddList<ToolInfo> toolInfos) throws ParserConfigurationException, SAXException, IOException {
        StringBuffer toolInfoStringBuffer = ((ToolInfo)toolInfos.getChild(0)).getFormattedXMLBuffer();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(ToolSpecificsParser.fromStringBuffer(toolInfoStringBuffer));
        doc.getDocumentElement().normalize();
        return doc;
    }

    private static InputStream fromStringBuffer(StringBuffer buf) {
        return new ByteArrayInputStream(buf.toString().getBytes());
    }
}

