/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.st.service;

import de.tudresden.inf.st.pnml.jastadd.model.EqualityOutputMapping;
import de.tudresden.inf.st.pnml.jastadd.model.InputSignalTransition;
import de.tudresden.inf.st.pnml.jastadd.model.Marking;
import de.tudresden.inf.st.pnml.jastadd.model.OutputSignalBinding;
import de.tudresden.inf.st.pnml.jastadd.model.OutputSignalPlace;
import de.tudresden.inf.st.pnml.jastadd.model.PetriNet;
import de.tudresden.inf.st.pnml.jastadd.model.Place;
import de.tudresden.inf.st.pnml.jastadd.model.RangeOutputMapping;
import de.tudresden.inf.st.pnml.jastadd.model.ThresholdOutputMapping;
import de.tudresden.inf.st.pnml.jastadd.model.Transition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PetriNetLoggingService {
    private static final Logger logger = LoggerFactory.getLogger(PetriNetLoggingService.class);

    public static void printOutputSignals(Marking markedGraph) {
        for (Place p : markedGraph.getPetriNet().allPlaces()) {
            OutputSignalPlace osp = p.asOutputSignalPlace();
            logger.info("[OPS-DEBUG] [" + p.getId() + "]");
            if (osp.getNumOutputSignalBinding() <= 0) continue;
            logger.info("[OPS-DEBUG] [" + p.getId() + "] value: " + osp.getOutputSignalBinding(0).getOutputSignalValue());
        }
    }

    public static void printInputSignals(Marking markedGraph) {
        for (Transition t : markedGraph.getPetriNet().allTransitions()) {
            InputSignalTransition ist = t.asInputSignalTransition();
            logger.info("[IST-DEBUG] [" + t.getId() + "]");
            if (ist.getNumInputSignalBinding() <= 0) continue;
            logger.info("[IST-DEBUG] [" + t.getId() + "] value: " + ist.getInputSignalBinding(0).getInputSignalValue());
        }
    }

    public static void printOutCompleteSignalData(PetriNet petriNet) {
        logger.info("-------- Transition meta ---------");
        for (Transition t : petriNet.allTransitions()) {
            logger.info("location: " + t.location());
            logger.info("type: " + t.type());
            logger.info("isb: " + t.asInputSignalTransition());
            logger.info("isb is bounded: " + t.isBoundedChannelTransition());
            if (t.asInputSignalTransition().getNumInputSignalBinding() <= 0) continue;
            logger.info("is id: " + t.asInputSignalTransition().getInputSignalBinding(0).getInputSignalID());
            logger.info("isb cv: " + t.asInputSignalTransition().getInputSignalBinding(0).getInputSignalValue());
            logger.info("isb tid: " + t.asInputSignalTransition().getInputSignalBinding(0).getTransitionID());
        }
        logger.info("---------- Place meta ------------");
        for (Place p : petriNet.allPlaces()) {
            logger.info("location: " + p.location());
            logger.info("type: " + p.type());
            logger.info("osb: " + p.asOutputSignalPlace());
            for (OutputSignalBinding osb : p.asOutputSignalPlace().getOutputSignalBindingList()) {
                if (p.asOutputSignalPlace().getNumOutputSignalBinding() <= 0) continue;
                logger.info("osb cv: " + osb.getOutputSignalID());
                logger.info("osb pid: " + osb.getPlaceID());
                if (osb.getEqualityOMList().getNumChild() > 0) {
                    for (EqualityOutputMapping eom : osb.getEqualityOMList()) {
                        logger.info("EqualityOutputMapping result: " + eom.getResult());
                        logger.info("EqualityOutputMapping value: " + eom.getValue());
                    }
                }
                if (osb.getRangeOMList().getNumChild() > 0) {
                    for (RangeOutputMapping rom : osb.getRangeOMList()) {
                        logger.info("EqualityOutputMapping result: " + rom.getResult());
                        logger.info("EqualityOutputMapping value: " + rom.getLowerBound());
                        logger.info("EqualityOutputMapping value: " + rom.getUpperBound());
                    }
                }
                if (osb.getThresholdOMList().getNumChild() <= 0) continue;
                for (ThresholdOutputMapping tom : osb.getThresholdOMList()) {
                    logger.info("EqualityOutputMapping result: " + tom.getResult());
                    logger.info("EqualityOutputMapping value: " + tom.getValue());
                }
            }
        }
    }
}

