/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.st.postprocessing;

import de.tudresden.inf.st.pnml.jastadd.model.EqualityOutputMapping;
import de.tudresden.inf.st.pnml.jastadd.model.InputSignalBinding;
import de.tudresden.inf.st.pnml.jastadd.model.JastAddList;
import de.tudresden.inf.st.pnml.jastadd.model.OutputSignalBinding;
import de.tudresden.inf.st.pnml.jastadd.model.PetriNet;
import de.tudresden.inf.st.pnml.jastadd.model.RangeOutputMapping;
import de.tudresden.inf.st.pnml.jastadd.model.ThresholdOutputMapping;
import de.tudresden.inf.st.pnml.jastadd.model.ToolInfo;
import de.tudresden.inf.st.postprocessing.PostProcessor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class IoPetriNetPostProcessor
implements PostProcessor<PetriNet> {
    private static final Logger logger = LoggerFactory.getLogger(IoPetriNetPostProcessor.class);

    public static JastAddList<InputSignalBinding> parseInputSignalBindingDefinitions(JastAddList<ToolInfo> toolInfos) {
        try {
            Document doc = IoPetriNetPostProcessor.parseToolSpecifics(toolInfos);
            return IoPetriNetPostProcessor.parseInputSignalBindingDefinitionsInternal(doc);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    private static JastAddList<InputSignalBinding> parseInputSignalBindingDefinitionsInternal(Document doc) {
        Node isBindingsNode;
        NodeList isBindingDefList = doc.getElementsByTagName("inputsignalbindings");
        JastAddList<InputSignalBinding> jastAddBindingList = new JastAddList<InputSignalBinding>();
        if (isBindingDefList.getLength() > 0 && isBindingDefList.item(0) != null && (isBindingsNode = isBindingDefList.item(0)).getNodeType() == 1) {
            Element isBindingsElement = (Element)isBindingsNode;
            NodeList isBindingNodes = isBindingsElement.getElementsByTagName("inputsignalbinding");
            for (int i = 0; i < isBindingNodes.getLength(); ++i) {
                Node isBindingNode = isBindingNodes.item(i);
                Element isBindingElement = (Element)isBindingNode;
                String tID = isBindingElement.getElementsByTagName("transitionID").item(0).getTextContent();
                String isID = isBindingElement.getElementsByTagName("inputsignalID").item(0).getTextContent();
                int cVal = Integer.valueOf(isBindingElement.getElementsByTagName("initialvalue").item(0).getTextContent());
                if (cVal != 1 && cVal != 0) {
                    logger.error("[PARSER] Initial value of input signal " + isID + " is not value. Falling back to 0.");
                    cVal = 0;
                }
                InputSignalBinding isb = new InputSignalBinding();
                isb.setInputSignalValue(cVal);
                isb.setInputSignalID(isID);
                isb.setTransitionID(tID);
                jastAddBindingList.add(isb);
            }
        }
        return jastAddBindingList;
    }

    public static JastAddList<OutputSignalBinding> parseOutputSignalBindingDefinitions(JastAddList<ToolInfo> toolInfos) {
        try {
            Document doc = IoPetriNetPostProcessor.parseToolSpecifics(toolInfos);
            return IoPetriNetPostProcessor.parseOutputSignalBindingDefinitionsInternal(doc);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    private static JastAddList<OutputSignalBinding> parseOutputSignalBindingDefinitionsInternal(Document doc) {
        Node osBindingsNode;
        NodeList osBindingDefList = doc.getElementsByTagName("outputsignalbindings");
        JastAddList<OutputSignalBinding> jastAddBindingList = new JastAddList<OutputSignalBinding>();
        if (osBindingDefList.getLength() > 0 && osBindingDefList.item(0) != null && (osBindingsNode = osBindingDefList.item(0)).getNodeType() == 1) {
            Element osBindingsElement = (Element)osBindingsNode;
            NodeList osBindingNodes = osBindingsElement.getElementsByTagName("outputsignalbinding");
            for (int i = 0; i < osBindingNodes.getLength(); ++i) {
                Node osBindingNode = osBindingNodes.item(i);
                Element osBindingElement = (Element)osBindingNode;
                String pID = osBindingElement.getElementsByTagName("placeID").item(0).getTextContent();
                String osID = osBindingElement.getElementsByTagName("outputsignalID").item(0).getTextContent();
                String cVal = String.valueOf(osBindingElement.getElementsByTagName("initialvalue").item(0).getTextContent());
                OutputSignalBinding osb = new OutputSignalBinding();
                IoPetriNetPostProcessor.parseOutputMappings(osBindingElement, pID, osID, cVal, osb);
                jastAddBindingList.add(osb);
            }
        }
        return jastAddBindingList;
    }

    private static void parseOutputMappings(Element osBindingElement, String pID, String osID, String cVal, OutputSignalBinding osb) {
        Element eqElement;
        osb.setOutputSignalID(osID);
        osb.setPlaceID(pID);
        NodeList eqMappingNodeList = osBindingElement.getElementsByTagName("equal");
        NodeList thresholdMappingNodeList = osBindingElement.getElementsByTagName("threshold");
        NodeList rangeMappingNodeList = osBindingElement.getElementsByTagName("range");
        for (int j = 0; j < eqMappingNodeList.getLength(); ++j) {
            eqElement = (Element)eqMappingNodeList.item(j);
            EqualityOutputMapping eom = new EqualityOutputMapping();
            eom.setValue(Integer.valueOf(eqElement.getElementsByTagName("value").item(0).getTextContent()));
            eom.setResult(Integer.valueOf(eqElement.getElementsByTagName("result").item(0).getTextContent()));
            osb.addEqualityOM(eom);
        }
        for (int k = 0; k < thresholdMappingNodeList.getLength(); ++k) {
            eqElement = (Element)thresholdMappingNodeList.item(k);
            ThresholdOutputMapping tom = new ThresholdOutputMapping();
            tom.setValue(Integer.valueOf(eqElement.getElementsByTagName("value").item(0).getTextContent()));
            tom.setResult(Integer.valueOf(eqElement.getElementsByTagName("result").item(0).getTextContent()));
            osb.addThresholdOM(tom);
        }
        for (int l = 0; l < rangeMappingNodeList.getLength(); ++l) {
            eqElement = (Element)rangeMappingNodeList.item(l);
            RangeOutputMapping rom = new RangeOutputMapping();
            rom.setLowerBound(Integer.valueOf(eqElement.getElementsByTagName("lowerbound").item(0).getTextContent()));
            rom.setUpperBound(Integer.valueOf(eqElement.getElementsByTagName("upperbound").item(0).getTextContent()));
            rom.setResult(Integer.valueOf(eqElement.getElementsByTagName("result").item(0).getTextContent()));
            osb.addRangeOM(rom);
        }
    }

    private static Document parseToolSpecifics(JastAddList<ToolInfo> toolInfos) throws ParserConfigurationException, SAXException, IOException {
        StringBuffer toolInfoStringBuffer = ((ToolInfo)toolInfos.getChild(0)).getFormattedXMLBuffer();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(IoPetriNetPostProcessor.fromStringBuffer(toolInfoStringBuffer));
        doc.getDocumentElement().normalize();
        return doc;
    }

    private static InputStream fromStringBuffer(StringBuffer buf) {
        return new ByteArrayInputStream(buf.toString().getBytes());
    }
}

