/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.st.pnml.jastadd.model;

import de.tudresden.inf.st.pnml.jastadd.model.ASTNode;
import de.tudresden.inf.st.pnml.jastadd.model.ASTNodeAnnotation;
import de.tudresden.inf.st.pnml.jastadd.model.ASTState;
import de.tudresden.inf.st.pnml.jastadd.model.JastAddList;
import de.tudresden.inf.st.pnml.jastadd.model.MarkedPlace;
import de.tudresden.inf.st.pnml.jastadd.model.PetriNet;
import de.tudresden.inf.st.pnml.jastadd.model.Place;
import de.tudresden.inf.st.pnml.jastadd.model.Transition;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;

public class Marking
extends ASTNode<ASTNode>
implements Cloneable {
    protected ASTState.Cycle placeMap_computed = null;
    protected Map<Place, MarkedPlace> placeMap_value;

    public boolean fireInPlace() {
        return this.fireInPlace(new Random());
    }

    public boolean fireInPlace(Random random) {
        return this.fireInPlace(random, true).isPresent();
    }

    public Optional<Marking> fireTransition(Transition transition, boolean requireFlush) {
        transition.incomingPlaces().forEach(place -> this.resolvePlace((Place)place).setMarking(this.resolvePlace((Place)place).getMarking() - 1));
        transition.outgoingPlaces().forEach(place -> this.resolvePlace((Place)place).setMarking(this.resolvePlace((Place)place).getMarking() + 1));
        if (requireFlush) {
            this.flushTreeCache();
        }
        return Optional.of(this);
    }

    private Optional<Marking> fireInPlace(Random random, boolean requireFlush) {
        if (this.enabledTransitions().isEmpty()) {
            return Optional.empty();
        }
        Transition transition = (Transition)this.enabledTransitions().stream().sorted((t1, t2) -> t1.getId().compareTo(t2.getId())).skip(random.nextInt(this.enabledTransitions().size())).findFirst().get();
        transition.incomingPlaces().forEach(place -> this.resolvePlace((Place)place).setMarking(this.resolvePlace((Place)place).getMarking() - 1));
        transition.outgoingPlaces().forEach(place -> this.resolvePlace((Place)place).setMarking(this.resolvePlace((Place)place).getMarking() + 1));
        if (requireFlush) {
            this.flushTreeCache();
        }
        return Optional.of(this);
    }

    public Collection<Place> collectIncomingPlace(Transition transition) {
        return transition.incomingPlaces();
    }

    public Collection<Place> collectOutgoingPlace(Transition transition) {
        return transition.outgoingPlaces();
    }

    public Optional<Marking> fire() {
        return this.fire(new Random());
    }

    public Optional<Marking> fire(Random random) {
        return this.treeCopyNoTransform().fireInPlace(random, false);
    }

    @Override
    public void resolveAll() {
        super.resolveAll();
    }

    public Marking() {
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[2];
        this.setChild(new JastAddList(), 1);
    }

    @ASTNodeAnnotation.Constructor(name={"PetriNet", "Place"}, type={"PetriNet", "JastAddList<MarkedPlace>"}, kind={"Child", "List"})
    public Marking(PetriNet p0, JastAddList<MarkedPlace> p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    @Override
    protected int numChildren() {
        return 2;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void flushAttrCache() {
        super.flushAttrCache();
        this.placeMap_reset();
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public Marking clone() throws CloneNotSupportedException {
        Marking node = (Marking)super.clone();
        return node;
    }

    public Marking copy() {
        try {
            Marking node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    @Deprecated
    public Marking fullCopy() {
        return this.treeCopyNoTransform();
    }

    public Marking treeCopyNoTransform() {
        Marking tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = this.children[i];
                if (child == null) continue;
                child = child.treeCopyNoTransform();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    public Marking treeCopy() {
        Marking tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                Object child = this.getChild(i);
                if (child == null) continue;
                child = ((ASTNode)child).treeCopy();
                tree.setChild((ASTNode)child, i);
            }
        }
        return tree;
    }

    public Marking setPetriNet(PetriNet node) {
        this.setChild(node, 0);
        return this;
    }

    @ASTNodeAnnotation.Child(name="PetriNet")
    public PetriNet getPetriNet() {
        return (PetriNet)this.getChild(0);
    }

    public PetriNet getPetriNetNoTransform() {
        return (PetriNet)this.getChildNoTransform(0);
    }

    public Marking setPlaceList(JastAddList<MarkedPlace> list) {
        this.setChild(list, 1);
        return this;
    }

    public int getNumPlace() {
        return this.getPlaceList().getNumChild();
    }

    public int getNumPlaceNoTransform() {
        return this.getPlaceListNoTransform().getNumChildNoTransform();
    }

    public MarkedPlace getPlace(int i) {
        return (MarkedPlace)this.getPlaceList().getChild(i);
    }

    public boolean hasPlace() {
        return this.getPlaceList().getNumChild() != 0;
    }

    public Marking addPlace(MarkedPlace node) {
        JastAddList<MarkedPlace> list = this.parent == null ? this.getPlaceListNoTransform() : this.getPlaceList();
        list.addChild((ASTNode)node);
        return this;
    }

    public Marking addPlaceNoTransform(MarkedPlace node) {
        JastAddList<MarkedPlace> list = this.getPlaceListNoTransform();
        list.addChild((ASTNode)node);
        return this;
    }

    public Marking setPlace(MarkedPlace node, int i) {
        JastAddList<MarkedPlace> list = this.getPlaceList();
        list.setChild(node, i);
        return this;
    }

    @ASTNodeAnnotation.ListChild(name="Place")
    public JastAddList<MarkedPlace> getPlaceList() {
        JastAddList list = (JastAddList)this.getChild(1);
        return list;
    }

    public JastAddList<MarkedPlace> getPlaceListNoTransform() {
        return (JastAddList)this.getChildNoTransform(1);
    }

    public MarkedPlace getPlaceNoTransform(int i) {
        return (MarkedPlace)this.getPlaceListNoTransform().getChildNoTransform(i);
    }

    public JastAddList<MarkedPlace> getPlaces() {
        return this.getPlaceList();
    }

    public JastAddList<MarkedPlace> getPlacesNoTransform() {
        return this.getPlaceListNoTransform();
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Printing", declaredAt="/home/sebastian/jastadd-ceti-workspaces-2/pnml-relast/src/main/jastadd/marking/Printing.jrag:2")
    public String print() {
        StringBuilder b = new StringBuilder();
        b.append("Marking for Petri net '").append(this.getPetriNet().name()).append("':\n");
        for (MarkedPlace place : this.getPlaceList()) {
            b.append("  ").append(place.getPlace().name()).append(": ").append(place.getMarking()).append("\n");
        }
        b.append("Transitions for Petri net '").append(this.getPetriNet().name()).append("':\n");
        for (Transition trans : this.getPetriNet().allTransitions()) {
            b.append("  ").append(trans.name()).append(": ").append(this.isEnabled(trans) ? "true" : "false").append("\n");
        }
        return b.toString();
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Marking", declaredAt="/home/sebastian/jastadd-ceti-workspaces-2/pnml-relast/src/main/jastadd/marking/Marking.jrag:34")
    public MarkedPlace resolvePlace(Place place) {
        MarkedPlace resolvePlace_Place_value = this.placeMap().get(place);
        return resolvePlace_Place_value;
    }

    private void placeMap_reset() {
        this.placeMap_computed = null;
        this.placeMap_value = null;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Marking", declaredAt="/home/sebastian/jastadd-ceti-workspaces-2/pnml-relast/src/main/jastadd/marking/Marking.jrag:36")
    public Map<Place, MarkedPlace> placeMap() {
        ASTState state = this.state();
        if (this.placeMap_computed == ASTState.NON_CYCLE || this.placeMap_computed == this.state().cycle()) {
            return this.placeMap_value;
        }
        this.placeMap_value = this.placeMap_compute();
        this.placeMap_computed = this.state().inCircle() ? this.state().cycle() : ASTState.NON_CYCLE;
        return this.placeMap_value;
    }

    private Map<Place, MarkedPlace> placeMap_compute() {
        HashMap<Place, MarkedPlace> map = new HashMap<Place, MarkedPlace>();
        for (MarkedPlace markedPlace : this.getPlaceList()) {
            map.put(markedPlace.getPlace(), markedPlace);
        }
        return map;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Marking", declaredAt="/home/sebastian/jastadd-ceti-workspaces-2/pnml-relast/src/main/jastadd/marking/Marking.jrag:44")
    public MarkedPlace resolvePlaceById(String placeID) {
        for (MarkedPlace markedPlace : this.getPlaceList()) {
            if (!markedPlace.getPlace().getId().equals(placeID)) continue;
            return markedPlace;
        }
        return null;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Marking", declaredAt="/home/sebastian/jastadd-ceti-workspaces-2/pnml-relast/src/main/jastadd/marking/Marking.jrag:54")
    public int marking(Place place) {
        int marking_Place_value = this.resolvePlace(place).getMarking();
        return marking_Place_value;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Marking", declaredAt="/home/sebastian/jastadd-ceti-workspaces-2/pnml-relast/src/main/jastadd/marking/Marking.jrag:56")
    public boolean isEnabled(Transition t) {
        for (Place place : t.incomingPlaces()) {
            if (this.marking(place) != 0) continue;
            return false;
        }
        return true;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Marking", declaredAt="/home/sebastian/jastadd-ceti-workspaces-2/pnml-relast/src/main/jastadd/marking/Marking.jrag:63")
    public boolean isDead() {
        for (Transition transition : this.getPetriNet().allTransitions()) {
            if (!this.isEnabled(transition)) continue;
            return false;
        }
        return true;
    }

    @ASTNodeAnnotation.Attribute(kind=ASTNodeAnnotation.Kind.SYN)
    @ASTNodeAnnotation.Source(aspect="Marking", declaredAt="/home/sebastian/jastadd-ceti-workspaces-2/pnml-relast/src/main/jastadd/marking/Marking.jrag:70")
    public Set<Transition> enabledTransitions() {
        Set<Transition> enabledTransitions_value = this.getPetriNet().allTransitions().stream().filter(t -> this.isEnabled((Transition)t)).collect(Collectors.toSet());
        return enabledTransitions_value;
    }

    @Override
    public Marking Define_marking(ASTNode _callerNode, ASTNode _childNode) {
        if (this.getPetriNetNoTransform() != null && _callerNode == this.getPetriNet()) {
            return this;
        }
        return this.getParent().Define_marking(this, _callerNode);
    }

    @Override
    protected boolean canDefine_marking(ASTNode _callerNode, ASTNode _childNode) {
        return true;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    @Override
    public boolean canRewrite() {
        return false;
    }
}

