/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.st.pnml.jastadd.model;

import de.tudresden.inf.st.pnml.jastadd.model.ASTNode;
import java.util.Iterator;

public class JastAddList<T extends ASTNode>
extends ASTNode<T>
implements Cloneable,
Iterable<T> {
    public JastAddList() {
    }

    @Override
    public void init$Children() {
    }

    public JastAddList(T ... initialChildren) {
        this.children = new ASTNode[initialChildren.length];
        for (int i = 0; i < this.children.length; ++i) {
            this.addChild((ASTNode)initialChildren[i]);
        }
    }

    public JastAddList<T> add(T node) {
        this.addChild((ASTNode)node);
        return this;
    }

    public JastAddList<T> addAll(Iterable<? extends T> c) {
        for (ASTNode node : c) {
            this.addChild(node);
        }
        return this;
    }

    @Override
    public JastAddList<T> insertChild(ASTNode node, int i) {
        super.insertChild(node, i);
        return this;
    }

    @Override
    public JastAddList<T> addChild(T node) {
        super.addChild(node);
        return this;
    }

    @Override
    public void removeChild(int i) {
        super.removeChild(i);
    }

    @Override
    public int getNumChild() {
        return this.getNumChildNoTransform();
    }

    @Override
    public Iterator<T> iterator() {
        return this.astChildIterator();
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void flushAttrCache() {
        super.flushAttrCache();
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public JastAddList<T> clone() throws CloneNotSupportedException {
        JastAddList node = (JastAddList)super.clone();
        return node;
    }

    @Override
    public JastAddList<T> copy() {
        try {
            ASTNode node = this.clone();
            ((JastAddList)node).parent = null;
            if (this.children != null) {
                ((JastAddList)node).children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    @Override
    @Deprecated
    public JastAddList<T> fullCopy() {
        return this.treeCopyNoTransform();
    }

    @Override
    public JastAddList<T> treeCopyNoTransform() {
        ASTNode tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = this.children[i];
                if (child == null) continue;
                child = child.treeCopyNoTransform();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    @Override
    public JastAddList<T> treeCopy() {
        ASTNode tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                Object child = this.getChild(i);
                if (child == null) continue;
                child = ((ASTNode)child).treeCopy();
                tree.setChild((ASTNode)child, i);
            }
        }
        return tree;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }

    @Override
    public boolean canRewrite() {
        return false;
    }
}

