/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.st.pnml;

import de.tudresden.inf.st.pnml.PnmlParseException;
import de.tudresden.inf.st.pnml.jastadd.model.Annotation;
import de.tudresden.inf.st.pnml.jastadd.model.AnnotationGraphics;
import de.tudresden.inf.st.pnml.jastadd.model.Arc;
import de.tudresden.inf.st.pnml.jastadd.model.ArcGraphics;
import de.tudresden.inf.st.pnml.jastadd.model.CSS2Color;
import de.tudresden.inf.st.pnml.jastadd.model.CSS2FontFamily;
import de.tudresden.inf.st.pnml.jastadd.model.CSS2FontSize;
import de.tudresden.inf.st.pnml.jastadd.model.CSS2FontStyle;
import de.tudresden.inf.st.pnml.jastadd.model.CSS2FontWeight;
import de.tudresden.inf.st.pnml.jastadd.model.Coordinate;
import de.tudresden.inf.st.pnml.jastadd.model.Dimension;
import de.tudresden.inf.st.pnml.jastadd.model.Fill;
import de.tudresden.inf.st.pnml.jastadd.model.Font;
import de.tudresden.inf.st.pnml.jastadd.model.FontAlign;
import de.tudresden.inf.st.pnml.jastadd.model.FontDecoration;
import de.tudresden.inf.st.pnml.jastadd.model.Gradient;
import de.tudresden.inf.st.pnml.jastadd.model.InputSignalTransition;
import de.tudresden.inf.st.pnml.jastadd.model.Line;
import de.tudresden.inf.st.pnml.jastadd.model.LineShape;
import de.tudresden.inf.st.pnml.jastadd.model.LineStyle;
import de.tudresden.inf.st.pnml.jastadd.model.Name;
import de.tudresden.inf.st.pnml.jastadd.model.Node;
import de.tudresden.inf.st.pnml.jastadd.model.NodeGraphics;
import de.tudresden.inf.st.pnml.jastadd.model.Offset;
import de.tudresden.inf.st.pnml.jastadd.model.OutputSignalPlace;
import de.tudresden.inf.st.pnml.jastadd.model.PNType;
import de.tudresden.inf.st.pnml.jastadd.model.PTArcAnnotation;
import de.tudresden.inf.st.pnml.jastadd.model.PTMarking;
import de.tudresden.inf.st.pnml.jastadd.model.Page;
import de.tudresden.inf.st.pnml.jastadd.model.PetriNet;
import de.tudresden.inf.st.pnml.jastadd.model.Place;
import de.tudresden.inf.st.pnml.jastadd.model.PlaceNode;
import de.tudresden.inf.st.pnml.jastadd.model.PnObject;
import de.tudresden.inf.st.pnml.jastadd.model.Position;
import de.tudresden.inf.st.pnml.jastadd.model.RefPlace;
import de.tudresden.inf.st.pnml.jastadd.model.RefTransition;
import de.tudresden.inf.st.pnml.jastadd.model.ToolInfo;
import de.tudresden.inf.st.pnml.jastadd.model.Transition;
import de.tudresden.inf.st.pnml.jastadd.model.TransitionNode;

public class PnmlParser {
    private final PetriNet petriNet;

    public PnmlParser(fr.lip6.move.pnml.ptnet.PetriNet source) throws PnmlParseException {
        this.petriNet = this.getPetriNet(source);
        this.petriNet.treeResolveAll();
    }

    public PetriNet getPetriNet() {
        return this.petriNet;
    }

    private PetriNet getPetriNet(fr.lip6.move.pnml.ptnet.PetriNet source) throws PnmlParseException {
        PetriNet result = new PetriNet();
        this.fillPetriNet(source, result);
        return result;
    }

    private Page getPage(fr.lip6.move.pnml.ptnet.Page source) throws PnmlParseException {
        Page result = new Page();
        this.fillPage(source, result);
        return result;
    }

    private NodeGraphics getNodeGraphics(fr.lip6.move.pnml.ptnet.NodeGraphics source) {
        NodeGraphics result = new NodeGraphics();
        this.fillNodeGraphics(source, result);
        return result;
    }

    private Line getLine(fr.lip6.move.pnml.ptnet.Line source) {
        Line result = new Line();
        this.fillLine(source, result);
        return result;
    }

    private Fill getFill(fr.lip6.move.pnml.ptnet.Fill source) {
        Fill result = new Fill();
        this.fillFill(source, result);
        return result;
    }

    private Dimension getDimension(fr.lip6.move.pnml.ptnet.Dimension source) {
        Dimension result = new Dimension();
        this.fillDimension(source, result);
        return result;
    }

    private Offset getOffset(fr.lip6.move.pnml.ptnet.Offset source) {
        Offset result = new Offset();
        this.fillOffset(source, result);
        return result;
    }

    private Position getPosition(fr.lip6.move.pnml.ptnet.Position source) {
        Position result = new Position();
        this.fillPosition(source, result);
        return result;
    }

    private Name getName(fr.lip6.move.pnml.ptnet.Name source) {
        Name result = new Name();
        this.fillName(source, result);
        return result;
    }

    private AnnotationGraphics getAnnotationGraphics(fr.lip6.move.pnml.ptnet.AnnotationGraphics source) {
        AnnotationGraphics result = new AnnotationGraphics();
        this.fillAnnotationGraphics(source, result);
        return result;
    }

    private Font getFont(fr.lip6.move.pnml.ptnet.Font source) {
        Font result = new Font();
        this.fillFont(source, result);
        return result;
    }

    private ToolInfo getToolInfo(fr.lip6.move.pnml.ptnet.ToolInfo source) {
        ToolInfo result = new ToolInfo();
        this.fillToolInfo(source, result);
        return result;
    }

    private Node getNode(fr.lip6.move.pnml.ptnet.Node source) throws PnmlParseException {
        if (source instanceof fr.lip6.move.pnml.ptnet.PlaceNode) {
            return this.getPlaceNode((fr.lip6.move.pnml.ptnet.PlaceNode)source);
        }
        if (source instanceof fr.lip6.move.pnml.ptnet.TransitionNode) {
            return this.getTransitionNode((fr.lip6.move.pnml.ptnet.TransitionNode)source);
        }
        throw new PnmlParseException("Encountered illegal unknown subtype of Node " + source.getClass().getCanonicalName());
    }

    private PlaceNode getPlaceNode(fr.lip6.move.pnml.ptnet.PlaceNode source) throws PnmlParseException {
        if (source instanceof fr.lip6.move.pnml.ptnet.Place) {
            return this.getPlace((fr.lip6.move.pnml.ptnet.Place)source);
        }
        if (source instanceof fr.lip6.move.pnml.ptnet.RefPlace) {
            return this.getRefPlace((fr.lip6.move.pnml.ptnet.RefPlace)source);
        }
        throw new PnmlParseException("Encountered illegal unknown subtype of PlaceNode " + source.getClass().getCanonicalName());
    }

    private Place getPlace(fr.lip6.move.pnml.ptnet.Place source) {
        OutputSignalPlace result = new OutputSignalPlace();
        this.fillPlace(source, result);
        return result;
    }

    private PTMarking getPTMarking(fr.lip6.move.pnml.ptnet.PTMarking source) {
        PTMarking result = new PTMarking();
        this.fillPTMarking(source, result);
        return result;
    }

    private RefPlace getRefPlace(fr.lip6.move.pnml.ptnet.RefPlace source) {
        RefPlace result = new RefPlace();
        this.fillRefPlace(source, result);
        return result;
    }

    private TransitionNode getTransitionNode(fr.lip6.move.pnml.ptnet.TransitionNode source) throws PnmlParseException {
        if (source instanceof fr.lip6.move.pnml.ptnet.Transition) {
            return this.getTransition((fr.lip6.move.pnml.ptnet.Transition)source);
        }
        if (source instanceof fr.lip6.move.pnml.ptnet.RefTransition) {
            return this.getRefTransition((fr.lip6.move.pnml.ptnet.RefTransition)source);
        }
        throw new PnmlParseException("Encountered illegal unknown subtype of TransitionNode " + source.getClass().getCanonicalName());
    }

    private RefTransition getRefTransition(fr.lip6.move.pnml.ptnet.RefTransition source) {
        RefTransition result = new RefTransition();
        this.fillRefTransition(source, result);
        return result;
    }

    private Transition getTransition(fr.lip6.move.pnml.ptnet.Transition source) {
        InputSignalTransition result = new InputSignalTransition();
        this.fillTransition(source, result);
        return result;
    }

    private Arc getArc(fr.lip6.move.pnml.ptnet.Arc source) {
        Arc result = new Arc();
        this.fillArc(source, result);
        return result;
    }

    private PTArcAnnotation getPTArcannotation(fr.lip6.move.pnml.ptnet.PTArcAnnotation source) {
        PTArcAnnotation result = new PTArcAnnotation();
        this.fillPTAnnotation(source, result);
        return result;
    }

    private ArcGraphics getArcGraphics(fr.lip6.move.pnml.ptnet.ArcGraphics source) {
        ArcGraphics result = new ArcGraphics();
        this.fillArcGraphics(source, result);
        return result;
    }

    private PnObject getPnObject(fr.lip6.move.pnml.ptnet.PnObject source) throws PnmlParseException {
        if (source instanceof fr.lip6.move.pnml.ptnet.Page) {
            return this.getPage((fr.lip6.move.pnml.ptnet.Page)source);
        }
        if (source instanceof Node) {
            return this.getNode((fr.lip6.move.pnml.ptnet.Node)source);
        }
        if (source instanceof fr.lip6.move.pnml.ptnet.Arc) {
            return this.getArc((fr.lip6.move.pnml.ptnet.Arc)source);
        }
        if (source instanceof fr.lip6.move.pnml.ptnet.Node) {
            return this.getNode((fr.lip6.move.pnml.ptnet.Node)source);
        }
        throw new PnmlParseException("Encountered illegal unknown subtype of PnObject " + source.getClass().getCanonicalName());
    }

    private void fillPetriNet(fr.lip6.move.pnml.ptnet.PetriNet source, PetriNet result) throws PnmlParseException {
        for (fr.lip6.move.pnml.ptnet.Page page : source.getPages()) {
            result.addPage(this.getPage(page));
        }
        if (source.getName() != null) {
            result.setName(this.getName(source.getName()));
        }
        for (fr.lip6.move.pnml.ptnet.ToolInfo toolInfo : source.getToolspecifics()) {
            result.addToolspecific(this.getToolInfo(toolInfo));
        }
        result.setId(source.getId());
        if (source.getType() != fr.lip6.move.pnml.ptnet.PNType.PTNET) {
            throw new PnmlParseException("Illegal Petri Net type '" + source.getType().getLiteral() + "' encountered.");
        }
        result.setType(PNType.PTNET);
    }

    private void fillPage(fr.lip6.move.pnml.ptnet.Page source, Page result) throws PnmlParseException {
        this.fillPnObject((fr.lip6.move.pnml.ptnet.PnObject)source, result);
        for (fr.lip6.move.pnml.ptnet.PnObject object : source.getObjects()) {
            result.addObject(this.getPnObject(object));
        }
        if (source.getNodegraphics() != null) {
            result.setNodeGraphics(this.getNodeGraphics(source.getNodegraphics()));
        }
    }

    private void fillPnObject(fr.lip6.move.pnml.ptnet.PnObject source, PnObject result) {
        if (source.getName() != null) {
            result.setName(this.getName(source.getName()));
        }
        for (fr.lip6.move.pnml.ptnet.ToolInfo toolInfo : source.getToolspecifics()) {
            result.addToolspecific(this.getToolInfo(toolInfo));
        }
        result.setId(source.getId());
    }

    private void fillNodeGraphics(fr.lip6.move.pnml.ptnet.NodeGraphics source, NodeGraphics result) {
        if (source.getPosition() != null) {
            result.setPosition(this.getPosition(source.getPosition()));
        }
        if (source.getDimension() != null) {
            result.setDimension(this.getDimension(source.getDimension()));
        }
        if (source.getFill() != null) {
            result.setFill(this.getFill(source.getFill()));
        }
        if (source.getLine() != null) {
            result.setLine(this.getLine(source.getLine()));
        }
    }

    private void fillLine(fr.lip6.move.pnml.ptnet.Line source, Line result) {
        result.setColor(CSS2Color.valueOf(source.getColor().getName()));
        result.setShape(LineShape.valueOf(source.getShape().getName()));
        result.setWidth(source.getWidth());
        result.setStyle(LineStyle.valueOf(source.getStyle().getName()));
    }

    private void fillFill(fr.lip6.move.pnml.ptnet.Fill source, Fill result) {
        result.setColor(CSS2Color.valueOf(source.getColor().getName()));
        result.setGradientcolor(CSS2Color.valueOf(source.getGradientcolor().getName()));
        result.setGradientrotation(Gradient.valueOf(source.getGradientrotation().getName()));
        result.setImage(source.getImage());
    }

    private void fillDimension(fr.lip6.move.pnml.ptnet.Dimension source, Dimension result) {
        this.fillCoordinate((fr.lip6.move.pnml.ptnet.Coordinate)source, result);
    }

    private void fillCoordinate(fr.lip6.move.pnml.ptnet.Coordinate source, Coordinate result) {
        result.setX(source.getX());
        result.setY(source.getY());
    }

    private void fillOffset(fr.lip6.move.pnml.ptnet.Offset source, Offset result) {
        this.fillCoordinate((fr.lip6.move.pnml.ptnet.Coordinate)source, result);
    }

    private void fillPosition(fr.lip6.move.pnml.ptnet.Position source, Position result) {
        this.fillCoordinate((fr.lip6.move.pnml.ptnet.Coordinate)source, result);
    }

    private void fillName(fr.lip6.move.pnml.ptnet.Name source, Name result) {
        this.fillAnnotation((fr.lip6.move.pnml.ptnet.Annotation)source, result);
        result.setText(source.getText());
    }

    private void fillAnnotation(fr.lip6.move.pnml.ptnet.Annotation source, Annotation result) {
        if (source.getAnnotationgraphics() != null) {
            result.setAnnotationGraphics(this.getAnnotationGraphics(source.getAnnotationgraphics()));
        }
        this.fillLabel(source, result);
    }

    private void fillLabel(fr.lip6.move.pnml.ptnet.Annotation source, Annotation result) {
        for (fr.lip6.move.pnml.ptnet.ToolInfo info : source.getToolspecifics()) {
            result.addToolspecific(this.getToolInfo(info));
        }
    }

    private void fillAnnotationGraphics(fr.lip6.move.pnml.ptnet.AnnotationGraphics source, AnnotationGraphics result) {
        if (source.getOffset() != null) {
            result.setOffset(this.getOffset(source.getOffset()));
        }
        if (source.getFill() != null) {
            result.setFill(this.getFill(source.getFill()));
        }
        if (source.getLine() != null) {
            result.setLine(this.getLine(source.getLine()));
        }
        if (source.getFont() != null) {
            result.setFont(this.getFont(source.getFont()));
        }
    }

    private void fillFont(fr.lip6.move.pnml.ptnet.Font source, Font result) {
        result.setAlign(FontAlign.valueOf(source.getAlign().getName()));
        result.setDecoration(FontDecoration.valueOf(source.getDecoration().getName()));
        result.setFamily(CSS2FontFamily.valueOf(source.getFamily().getName()));
        result.setRotation(source.getRotation());
        result.setSize(CSS2FontSize.valueOf(source.getSize().getName()));
        result.setStyle(CSS2FontStyle.valueOf(source.getStyle().getName()));
        result.setWeight(CSS2FontWeight.valueOf(source.getWeight().getName()));
    }

    private void fillToolInfo(fr.lip6.move.pnml.ptnet.ToolInfo source, ToolInfo result) {
        result.setTool(source.getTool());
        result.setVersion(source.getVersion());
        result.setFormattedXMLBuffer(source.getFormattedXMLBuffer());
        result.setToolInfoGrammarURI(source.getToolInfoGrammarURI());
    }

    private void fillPlace(fr.lip6.move.pnml.ptnet.Place source, Place result) {
        this.fillPlaceNode((fr.lip6.move.pnml.ptnet.PlaceNode)source, result);
        if (source.getInitialMarking() != null) {
            result.setInitialMarking(this.getPTMarking(source.getInitialMarking()));
        }
    }

    private void fillPTMarking(fr.lip6.move.pnml.ptnet.PTMarking source, PTMarking result) {
        this.fillAnnotation((fr.lip6.move.pnml.ptnet.Annotation)source, result);
        result.setText(Math.toIntExact(source.getText()));
    }

    private void fillRefPlace(fr.lip6.move.pnml.ptnet.RefPlace source, RefPlace result) {
        this.fillPlaceNode((fr.lip6.move.pnml.ptnet.PlaceNode)source, result);
        result.setRef(PlaceNode.createRefDirection(source.getRef().getId()));
    }

    private void fillPlaceNode(fr.lip6.move.pnml.ptnet.PlaceNode source, PlaceNode result) {
        this.fillNode((fr.lip6.move.pnml.ptnet.Node)source, result);
        for (fr.lip6.move.pnml.ptnet.RefPlace referencingPlace : source.getReferencingPlaces()) {
            result.addReferencingPlace(RefPlace.createRefDirection(referencingPlace.getId()));
        }
    }

    private void fillRefTransition(fr.lip6.move.pnml.ptnet.RefTransition source, RefTransition result) {
        this.fillTransitionNode((fr.lip6.move.pnml.ptnet.TransitionNode)source, result);
        result.setRef(TransitionNode.createRefDirection(source.getRef().getId()));
    }

    private void fillTransitionNode(fr.lip6.move.pnml.ptnet.TransitionNode source, TransitionNode result) {
        this.fillNode((fr.lip6.move.pnml.ptnet.Node)source, result);
        for (fr.lip6.move.pnml.ptnet.RefTransition refTransition : source.getReferencingTransitions()) {
            result.addReferencingTransition(RefTransition.createRefDirection(refTransition.getId()));
        }
    }

    private void fillTransition(fr.lip6.move.pnml.ptnet.Transition source, Transition result) {
        this.fillTransitionNode((fr.lip6.move.pnml.ptnet.TransitionNode)source, result);
    }

    private void fillNode(fr.lip6.move.pnml.ptnet.Node source, Node result) {
        this.fillPnObject((fr.lip6.move.pnml.ptnet.PnObject)source, result);
        if (source.getNodegraphics() != null) {
            result.setNodeGraphics(this.getNodeGraphics(source.getNodegraphics()));
        }
        for (fr.lip6.move.pnml.ptnet.Arc outArc : source.getOutArcs()) {
            result.addOutArc(Arc.createRefDirection(outArc.getId()));
        }
        for (fr.lip6.move.pnml.ptnet.Arc inArc : source.getInArcs()) {
            result.addInArc(Arc.createRefDirection(inArc.getId()));
        }
    }

    private void fillArc(fr.lip6.move.pnml.ptnet.Arc source, Arc result) {
        this.fillPnObject((fr.lip6.move.pnml.ptnet.PnObject)source, result);
        if (source.getArcgraphics() != null) {
            result.setArcGraphics(this.getArcGraphics(source.getArcgraphics()));
        }
        if (source.getInscription() != null) {
            result.setInscription(this.getPTArcannotation(source.getInscription()));
        }
        result.setSource(Node.createRefDirection(source.getSource().getId()));
        result.setTarget(Node.createRefDirection(source.getTarget().getId()));
    }

    private void fillPTAnnotation(fr.lip6.move.pnml.ptnet.PTArcAnnotation source, PTArcAnnotation result) {
        this.fillAnnotation((fr.lip6.move.pnml.ptnet.Annotation)source, result);
        result.setText(Math.toIntExact(source.getText()));
    }

    private void fillArcGraphics(fr.lip6.move.pnml.ptnet.ArcGraphics source, ArcGraphics result) {
        for (fr.lip6.move.pnml.ptnet.Position position : source.getPositions()) {
            result.addPosition(this.getPosition(position));
        }
        if (source.getLine() != null) {
            result.setLine(this.getLine(source.getLine()));
        }
    }
}

