/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.st.pnml;

import de.tudresden.inf.st.pnml.PnmlParseException;
import de.tudresden.inf.st.pnml.PnmlParser;
import de.tudresden.inf.st.pnml.jastadd.model.JavaHandler;
import de.tudresden.inf.st.pnml.jastadd.model.Marking;
import de.tudresden.inf.st.pnml.jastadd.model.OutputSignalPlace;
import de.tudresden.inf.st.pnml.jastadd.model.PetriNet;
import de.tudresden.inf.st.pnml.jastadd.model.Place;
import de.tudresden.inf.st.pnml.jastadd.model.Transition;
import de.tudresden.inf.st.service.PetriNetExecutionService;
import de.tudresden.inf.st.service.PetriNetInitService;
import de.tudresden.inf.st.service.PetriNetLoggingService;
import fr.lip6.move.pnml.framework.general.PNType;
import fr.lip6.move.pnml.framework.hlapi.HLAPIRootClass;
import fr.lip6.move.pnml.framework.utils.ModelRepository;
import fr.lip6.move.pnml.framework.utils.PNMLUtils;
import fr.lip6.move.pnml.framework.utils.exception.ImportException;
import fr.lip6.move.pnml.framework.utils.exception.InvalidIDException;
import fr.lip6.move.pnml.ptnet.hlapi.PetriNetDocHLAPI;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) {
        List<Marking> markedGraphs = PetriNetInitService.initMarkedGraphs(args[0]);
        PetriNetLoggingService.printInputSignals(markedGraphs.get(0));
        PetriNetLoggingService.printOutputSignals(markedGraphs.get(0));
    }

    private static void testTransitionFiring() {
        JavaHandler jh = JavaHandler.getInstance();
        jh.registerCallback("/outputsignal/os1", bytes -> System.out.println("TEST OS1 CALLBACK"));
        jh.registerCallback("/outputsignal/os2", bytes -> System.out.println("TEST OS2 CALLBACK"));
        List<Marking> markedGraphs = PetriNetInitService.initMarkedGraphs("src/main/resources/minimal.pnml");
        System.out.println("1--------------------------------------");
        PetriNetLoggingService.printOutputSignals(markedGraphs.get(0));
        int newIs1Val = 0;
        int newIs2Val = 0;
        jh.push("/inputsignal/is1", ByteBuffer.allocate(4).putInt(newIs1Val).array());
        jh.push("/inputsignal/is2", ByteBuffer.allocate(4).putInt(newIs2Val).array());
        PetriNetLoggingService.printInputSignals(markedGraphs.get(0));
        logger.info("Init Marking: {}", (Object)markedGraphs.get(0).print());
        PetriNetExecutionService execService = PetriNetExecutionService.getInstance();
        for (Transition t : markedGraphs.get(0).getPetriNet().allTransitions()) {
            execService.addSuccessCallbackToTransitionFiring(t, transition -> System.out.println("SUCCESS"));
            execService.addFailureCallbackToTransitionFiring(t, transition -> System.out.println("FAILURE"));
        }
        Iterator<Transition> iterator = markedGraphs.get(0).getPetriNet().allTransitions().iterator();
        if (iterator.hasNext()) {
            Transition t;
            t = iterator.next();
            execService.fireLocalTransition(t, markedGraphs.get(0));
        }
        logger.info("Marking after firing: {}", (Object)markedGraphs.get(0).print());
        PetriNetLoggingService.printOutputSignals(markedGraphs.get(0));
    }

    private static void testPetriNetProgramm(String[] args) {
        String fileName = "src/main/resources/minimal.pnml";
        List<PetriNet> petriNets = Main.parsePnml(fileName);
        for (PetriNet petriNet : petriNets) {
            PetriNetLoggingService.printOutCompleteSignalData(petriNet);
            Marking originalMarking = petriNet.initialMarking(petriNet);
            originalMarking.setPetriNet(petriNet);
            for (Place p : petriNet.allPlaces()) {
                OutputSignalPlace osp = p.asOutputSignalPlace();
                if (osp.getOutputSignalBindingList().getNumChild() <= 0) continue;
                osp.getOutputSignalBinding(0).getOutputSignalValue();
            }
            Marking currentMarking = originalMarking;
            logger.info("initial marking:\n{}", (Object)originalMarking.print());
            Random random1 = new Random(0L);
            Random random2 = new Random(0L);
            for (int i = 1; i <= 5 && !originalMarking.isDead() && !currentMarking.isDead(); ++i) {
                Optional<Marking> optionalCurrentMarking = currentMarking.fire(random1);
                if (!optionalCurrentMarking.isPresent()) {
                    throw new RuntimeException("Unable to get successor marking, even though the marking is not dead!");
                }
                currentMarking = optionalCurrentMarking.get();
                originalMarking.fireInPlace(random2);
                logger.info("Original marking after {} firings: {}", (Object)i, (Object)originalMarking.print());
                logger.info("Current marking after {} firings: {}", (Object)i, (Object)currentMarking.print());
            }
            logger.info("DOT file:\n\n{}", (Object)petriNet.toDot());
        }
    }

    private static List<PetriNet> parsePnml(String fileName) {
        Path file = Paths.get(fileName, new String[0]);
        HLAPIRootClass document = null;
        try {
            document = PNMLUtils.importPnmlDocument((File)file.toFile(), (boolean)false);
            logger.info(document.toPNML());
        }
        catch (ImportException | InvalidIDException e) {
            logger.error("Unable to import PNML document from file '{}'", (Object)fileName);
            logger.error("Exception was thrown!", e);
            System.exit(-1);
        }
        logger.info("Imported document workspace ID: {}", (Object)ModelRepository.getInstance().getCurrentDocWSId());
        ArrayList<PetriNet> petriNets = new ArrayList<PetriNet>();
        PNType type = PNMLUtils.determinePNType((HLAPIRootClass)document);
        switch (type) {
            case PTNET: {
                PetriNetDocHLAPI ptDoc = (PetriNetDocHLAPI)document;
                for (fr.lip6.move.pnml.ptnet.PetriNet pmnlNet : ptDoc.getNets()) {
                    try {
                        PnmlParser parser = new PnmlParser(pmnlNet);
                        petriNets.add(parser.getPetriNet());
                    }
                    catch (PnmlParseException e) {
                        logger.error("Parsing the Petri net using the PNML framawork failed.", (Throwable)e);
                    }
                }
                break;
            }
            default: {
                logger.error("Petri net is of unsupported type {}.", (Object)type.getLiteral());
                System.exit(-1);
            }
        }
        return petriNets;
    }
}

