#include "reader/cuboid_reader.h"

void Cuboid_reader::read(){
    ROS_INFO("--- CUBOID_READER ---");
    XmlRpc::XmlRpcValue resources;
    nh_->getParam("/objects", resources);

    for (int i = 0; i < resources.size(); i++){
        std::string id = resources[i]["id"];
        if(resources[i]["type"] == "BOX"){
            tf2::Vector3 pos;
            tf2::Vector3 size;
            tf2::Quaternion rot;

            (resources[i]["size"].hasMember("length")) ? size.setX(float_of(resources[i]["size"]["length"])) :size.setX(0);
            (resources[i]["size"].hasMember("width")) ? size.setY(float_of(resources[i]["size"]["width"])) :size.setY(0);
            (resources[i]["size"].hasMember("height")) ? size.setZ(float_of(resources[i]["size"]["height"])) :size.setZ(0);

            (resources[i]["pos"].hasMember("x")) ? pos.setX(float_of(resources[i]["pos"]["x"])) :pos.setX(0);
            (resources[i]["pos"].hasMember("y")) ? pos.setY(float_of(resources[i]["pos"]["y"])) :pos.setY(0);
            (resources[i]["pos"].hasMember("z")) ? pos.setZ(float_of(resources[i]["pos"]["z"])) :pos.setZ(0);
            (resources[i]["orientation"].hasMember("x")) ? rot.setX(float_of(resources[i]["orientation"]["x"])) :rot.setX(0);
            (resources[i]["orientation"].hasMember("y")) ? rot.setY(float_of(resources[i]["orientation"]["y"])) :rot.setY(0);
            (resources[i]["orientation"].hasMember("z")) ? rot.setZ(float_of(resources[i]["orientation"]["z"])) :rot.setZ(0);
            (resources[i]["orientation"].hasMember("w")) ? rot.setW(float_of(resources[i]["orientation"]["w"])) :rot.setW(0);

            Cuboid o;
            o.Name = id.c_str();
            o.Pose.position.x = pos.getX();
            o.Pose.position.y = pos.getY();
            o.Pose.position.z = pos.getZ();
            o.Pose.orientation.x = rot.getX();
            o.Pose.orientation.y = rot.getY();
            o.Pose.orientation.z = rot.getZ();
            o.Pose.orientation.w = rot.getW();
            o.x_depth = size.getX();
            o.y_width = size.getY();
            o.z_heigth = size.getZ();

            
            cuboid_box_.push_back(o);
            ROS_INFO("--- Object: %s  --- Type: BOX  ---", o.Name.c_str());
            ROS_INFO("=> Object: pos('%f', '%f', '%f')", pos.getX(), pos.getY(), pos.getZ());
            ROS_INFO("=> Object: orientation('%f', '%f', '%f', '%f')", rot.getX(), rot.getY(), rot.getZ(), rot.getW());
            ROS_INFO("=> Object: size('%f', '%f', '%f')", size.getX(), size.getY(), size.getZ());
        }

        if(resources[i]["type"] == "BIN"){
            tf2::Vector3 pos;
            tf2::Vector3 size;
            tf2::Quaternion rot;

            (resources[i]["size"].hasMember("length")) ? size.setX(float_of(resources[i]["size"]["length"])) :size.setX(0);
            (resources[i]["size"].hasMember("width")) ? size.setY(float_of(resources[i]["size"]["width"])) :size.setY(0);
            (resources[i]["size"].hasMember("height")) ? size.setZ(float_of(resources[i]["size"]["height"])) :size.setZ(0);

            (resources[i]["pos"].hasMember("x")) ? pos.setX(float_of(resources[i]["pos"]["x"])) :pos.setX(0);
            (resources[i]["pos"].hasMember("y")) ? pos.setY(float_of(resources[i]["pos"]["y"])) :pos.setY(0);
            (resources[i]["pos"].hasMember("z")) ? pos.setZ(float_of(resources[i]["pos"]["z"])) :pos.setZ(0);
            (resources[i]["orientation"].hasMember("x")) ? rot.setX(float_of(resources[i]["orientation"]["x"])) :rot.setX(0);
            (resources[i]["orientation"].hasMember("y")) ? rot.setY(float_of(resources[i]["orientation"]["y"])) :rot.setY(0);
            (resources[i]["orientation"].hasMember("z")) ? rot.setZ(float_of(resources[i]["orientation"]["z"])) :rot.setZ(0);
            (resources[i]["orientation"].hasMember("w")) ? rot.setW(float_of(resources[i]["orientation"]["w"])) :rot.setW(0);

            Cuboid o;
            o.Name = id.c_str();
            o.Pose.position.x = pos.getX();
            o.Pose.position.y = pos.getY();
            o.Pose.position.z = pos.getZ();
            o.Pose.orientation.x = rot.getX();
            o.Pose.orientation.y = rot.getY();
            o.Pose.orientation.z = rot.getZ();
            o.Pose.orientation.w = rot.getW();
            o.x_depth = size.getX();
            o.y_width = size.getY();
            o.z_heigth = size.getZ();

            cuboid_obstacle_.push_back(o);
            ROS_INFO("--- Object: %s  --- Type: BIN  ---", o.Name.c_str());
            ROS_INFO("=> Object: pos('%f', '%f', '%f')", pos.getX(), pos.getY(), pos.getZ());
            ROS_INFO("=> Object: orientation('%f', '%f', '%f', '%f')", rot.getX(), rot.getY(), rot.getZ(), rot.getW());
            ROS_INFO("=> Object: size('%f', '%f', '%f')", size.getX(), size.getY(), size.getZ());

        }
    }
}